/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea.folding;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rsyntaxtextarea.parser.Parser;
import org.fife.ui.rtextarea.RDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FoldManager {
    private RSyntaxTextArea textArea;
    private FoldParser parser;
    private List<Fold> folds;
    private boolean codeFoldingEnabled;
    private PropertyChangeSupport support;
    private Listener l;
    public static final String PROPERTY_FOLDS_UPDATED = "FoldsUpdated";
    private Parser tempParser;

    public FoldManager(RSyntaxTextArea textArea) {
        this.textArea = textArea;
        this.support = new PropertyChangeSupport(this);
        this.l = new Listener();
        textArea.getDocument().addDocumentListener(this.l);
        textArea.addPropertyChangeListener("RSTA.syntaxStyle", this.l);
        textArea.addPropertyChangeListener("document", this.l);
        this.folds = new ArrayList<Fold>();
        this.updateFoldParser();
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.support.addPropertyChangeListener(l);
    }

    public void clear() {
        this.folds.clear();
    }

    public boolean ensureOffsetNotInClosedFold(int offs) {
        boolean foldsOpened = false;
        for (Fold fold = this.getDeepestFoldContaining(offs); fold != null; fold = fold.getParent()) {
            if (!fold.isCollapsed()) continue;
            fold.setCollapsed(false);
            foldsOpened = true;
        }
        return foldsOpened;
    }

    public Fold getDeepestFoldContaining(int offs) {
        Fold deepestFold = null;
        if (offs > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold = this.getFold(i);
                if (!fold.containsOffset(offs)) continue;
                deepestFold = fold.getDeepestFoldContaining(offs);
                break;
            }
        }
        return deepestFold;
    }

    public Fold getDeepestOpenFoldContaining(int offs) {
        Fold deepestFold = null;
        if (offs > -1) {
            for (int i = 0; i < this.folds.size(); ++i) {
                Fold fold = this.getFold(i);
                if (!fold.containsOffset(offs)) continue;
                if (fold.isCollapsed()) {
                    return null;
                }
                deepestFold = fold.getDeepestOpenFoldContaining(offs);
                break;
            }
        }
        return deepestFold;
    }

    public Fold getFold(int index) {
        return this.folds.get(index);
    }

    public int getFoldCount() {
        return this.folds.size();
    }

    public Fold getFoldForLine(int line) {
        return this.getFoldForLineImpl(null, this.folds, line);
    }

    private Fold getFoldForLineImpl(Fold parent, List<Fold> folds, int line) {
        int low = 0;
        int high = folds.size() - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Fold midFold = folds.get(mid);
            int startLine = midFold.getStartLine();
            if (line == startLine) {
                return midFold;
            }
            if (line < startLine) {
                high = mid - 1;
                continue;
            }
            int endLine = midFold.getEndLine();
            if (line >= endLine) {
                low = mid + 1;
                continue;
            }
            List<Fold> children = midFold.getChildren();
            return children != null ? this.getFoldForLineImpl(midFold, children, line) : null;
        }
        return null;
    }

    public int getHiddenLineCount() {
        int count = 0;
        for (Fold fold : this.folds) {
            count += fold.getCollapsedLineCount();
        }
        return count;
    }

    public int getHiddenLineCountAbove(int line) {
        return this.getHiddenLineCountAbove(line, false);
    }

    public int getHiddenLineCountAbove(int line, boolean physical) {
        int count = 0;
        for (Fold fold : this.folds) {
            int comp;
            int n = comp = physical ? line + count : line;
            if (fold.getStartLine() >= comp) break;
            count += this.getHiddenLineCountAboveImpl(fold, comp, physical);
        }
        return count;
    }

    private int getHiddenLineCountAboveImpl(Fold fold, int line, boolean physical) {
        int count = 0;
        if (fold.getEndLine() < line || fold.isCollapsed() && fold.getStartLine() < line) {
            count = fold.getCollapsedLineCount();
        } else {
            int childCount = fold.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                int comp;
                Fold child = fold.getChild(i);
                int n = comp = physical ? line + count : line;
                if (child.getStartLine() >= comp) break;
                count += this.getHiddenLineCountAboveImpl(child, comp, physical);
            }
        }
        return count;
    }

    public int getLastVisibleLine() {
        Fold lastFold;
        int foldCount;
        int lastLine = this.textArea.getLineCount() - 1;
        if (this.isCodeFoldingSupportedAndEnabled() && (foldCount = this.getFoldCount()) > 0 && (lastFold = this.getFold(foldCount - 1)).containsLine(lastLine)) {
            if (lastFold.isCollapsed()) {
                lastLine = lastFold.getStartLine();
            } else {
                while (lastFold.getHasChildFolds() && (lastFold = lastFold.getLastChild()).containsLine(lastLine)) {
                    if (!lastFold.isCollapsed()) continue;
                    lastLine = lastFold.getStartLine();
                    break;
                }
            }
        }
        return lastLine;
    }

    public int getVisibleLineAbove(int line) {
        if (line <= 0 || line >= this.textArea.getLineCount()) {
            return -1;
        }
        while (--line >= 0 && this.isLineHidden(line)) {
        }
        return line;
    }

    public int getVisibleLineBelow(int line) {
        int lineCount = this.textArea.getLineCount();
        if (line < 0 || line >= lineCount - 1) {
            return -1;
        }
        while (++line < lineCount && this.isLineHidden(line)) {
        }
        return line == lineCount ? -1 : line;
    }

    public boolean isCodeFoldingEnabled() {
        return this.codeFoldingEnabled;
    }

    public boolean isCodeFoldingSupportedAndEnabled() {
        return this.codeFoldingEnabled && this.parser != null;
    }

    public boolean isFoldStartLine(int line) {
        return this.getFoldForLine(line) != null;
    }

    public boolean isLineHidden(int line) {
        for (Fold fold : this.folds) {
            if (!fold.containsLine(line)) continue;
            if (fold.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(fold, line);
        }
        return false;
    }

    private boolean isLineHiddenImpl(Fold parent, int line) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            Fold child = parent.getChild(i);
            if (!child.containsLine(line)) continue;
            if (child.isCollapsed()) {
                return true;
            }
            return this.isLineHiddenImpl(child, line);
        }
        return false;
    }

    private void keepFoldState(Fold newFold, List<Fold> oldFolds) {
        int previousLoc = Collections.binarySearch(oldFolds, newFold);
        if (previousLoc >= 0) {
            Fold prevFold = oldFolds.get(previousLoc);
            newFold.setCollapsed(prevFold.isCollapsed());
        } else {
            List<Fold> children;
            Fold possibleParentFold;
            int insertionPoint = -(previousLoc + 1);
            if (insertionPoint > 0 && (possibleParentFold = oldFolds.get(insertionPoint - 1)).containsOffset(newFold.getStartOffset()) && (children = possibleParentFold.getChildren()) != null) {
                this.keepFoldState(newFold, children);
            }
        }
    }

    private void keepFoldStates(List<Fold> newFolds, List<Fold> oldFolds) {
        for (Fold newFold : newFolds) {
            this.keepFoldState(newFold, this.folds);
            List<Fold> newChildFolds = newFold.getChildren();
            if (newChildFolds == null) continue;
            this.keepFoldStates(newChildFolds, oldFolds);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.support.removePropertyChangeListener(l);
    }

    public void reparse() {
        if (this.codeFoldingEnabled && this.parser != null) {
            List<Fold> newFolds = this.parser.getFolds(this.textArea);
            if (newFolds == null) {
                newFolds = Collections.emptyList();
            } else {
                this.keepFoldStates(newFolds, this.folds);
            }
            this.folds = newFolds;
            this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, this.folds);
            this.textArea.repaint();
        } else {
            this.folds.clear();
        }
    }

    public void setCodeFoldingEnabled(boolean enabled) {
        if (enabled != this.codeFoldingEnabled) {
            this.codeFoldingEnabled = enabled;
            if (this.tempParser != null) {
                this.textArea.removeParser(this.tempParser);
            }
            if (enabled) {
                this.tempParser = new AbstractParser(){

                    public ParseResult parse(RSyntaxDocument doc, String style) {
                        FoldManager.this.reparse();
                        return new DefaultParseResult(this);
                    }
                };
                this.textArea.addParser(this.tempParser);
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            } else {
                this.folds = Collections.emptyList();
                this.textArea.repaint();
                this.support.firePropertyChange(PROPERTY_FOLDS_UPDATED, null, null);
            }
        }
    }

    public void setFolds(List<Fold> folds) {
        this.folds = folds;
    }

    private void updateFoldParser() {
        this.parser = FoldParserManager.get().getFoldParser(this.textArea.getSyntaxEditingStyle());
    }

    private class Listener
    implements DocumentListener,
    PropertyChangeListener {
        private Listener() {
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            Fold fold;
            int endLine;
            int startOffs = e.getOffset();
            int endOffs = startOffs + e.getLength();
            Document doc = e.getDocument();
            Element root = doc.getDefaultRootElement();
            int startLine = root.getElementIndex(startOffs);
            if (startLine != (endLine = root.getElementIndex(endOffs)) && (fold = FoldManager.this.getFoldForLine(startLine)) != null && fold.isCollapsed()) {
                fold.toggleCollapsedState();
            }
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if ("RSTA.syntaxStyle".equals(name)) {
                FoldManager.this.updateFoldParser();
                FoldManager.this.reparse();
            } else if ("document".equals(name)) {
                RDocument newDoc;
                RDocument old = (RDocument)e.getOldValue();
                if (old != null) {
                    old.removeDocumentListener(this);
                }
                if ((newDoc = (RDocument)e.getNewValue()) != null) {
                    newDoc.addDocumentListener(this);
                }
                FoldManager.this.reparse();
            }
        }

        public void removeUpdate(DocumentEvent e) {
            int offs = e.getOffset();
            try {
                int lastLineModified = FoldManager.this.textArea.getLineOfOffset(offs);
                Fold fold = FoldManager.this.getFoldForLine(lastLineModified);
                if (fold != null && fold.isCollapsed()) {
                    fold.toggleCollapsedState();
                }
            }
            catch (BadLocationException ble) {
                ble.printStackTrace();
            }
        }
    }
}

