win32k_types = {
'_HANDLEENTRY': [0xc, {
    'pOwner': [4, ['pointer', ['void']]],
    'phead': [0, ['pointer', ['_HEAD']]],
    'bFlags': [9, ['unsigned char']],
    'wUniq': [10, ['unsigned short']],
    'bType': [8, ['unsigned char']],
    }],
'tagTOUCHINPUTINFO': [0x3c, {
    'dwcInputs': [12, ['unsigned long']],
    'head': [0, ['_THROBJHEAD']],
    'uFlags': [16, ['unsigned long']],
    'TouchInput': [20, ['array', 1, ['tagTOUCHINPUT']]],
    }],
'tagHOOK': [0x34, {
    'head': [0, ['_THRDESKHEAD']],
    'offPfn': [28, ['unsigned long']],
    'flags': [32, ['unsigned long']],
    'fLastHookHung': [48, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'nTimeout': [48, ['BitField', {'end_bit': 7, 'start_bit': 0}]],
    'ihmod': [36, ['long']],
    'iHook': [24, ['long']],
    'ptiHooked': [40, ['pointer', ['tagTHREADINFO']]],
    'phkNext': [20, ['pointer', ['tagHOOK']]],
    'rpdesk': [44, ['pointer', ['tagDESKTOP']]],
    }],
'DEADKEY': [0x8, {
    'wchComposed': [4, ['wchar']],
    'dwBoth': [0, ['unsigned long']],
    'uFlags': [6, ['unsigned short']],
    }],
'__unnamed_179f': [0x4, {
    'pRgb256x3x16': [0, ['pointer', ['_D3DDDI_GAMMA_RAMP_RGB256x3x16']]],
    'pRaw': [0, ['pointer', ['void']]],
    'pDxgi1': [0, ['pointer', ['_D3DDDI_GAMMA_RAMP_DXGI_1']]],
    }],
'_W32THREAD': [0xb4, {
    'pRBRecursionCount': [40, ['unsigned long']],
    'iVisRgnUniqueness': [176, ['unsigned long']],
    'RefCount': [4, ['unsigned long']],
    'pDevHTInfo': [148, ['pointer', ['void']]],
    'pUMPDHeap': [24, ['pointer', ['void']]],
    'pgdiBrushAttr': [16, ['pointer', ['void']]],
    'ulWindowSystemRendering': [172, ['unsigned long']],
    'tlSpriteState': [48, ['_TLSPRITESTATE']],
    'pdcoRender': [160, ['pointer', ['void']]],
    'bEnableEngUpdateDeviceSurface': [168, ['unsigned char']],
    'pdcoAA': [156, ['pointer', ['void']]],
    'pNonRBRecursionCount': [44, ['unsigned long']],
    'ptlW32': [8, ['pointer', ['_TL']]],
    'GdiTmpTgoList': [32, ['_LIST_ENTRY']],
    'pUMPDObjs': [20, ['pointer', ['void']]],
    'pgdiDcattr': [12, ['pointer', ['void']]],
    'bIncludeSprites': [169, ['unsigned char']],
    'pEThread': [0, ['pointer', ['_ETHREAD']]],
    'pSpriteState': [144, ['pointer', ['void']]],
    'ulDevHTInfoUniqueness': [152, ['unsigned long']],
    'pdcoSrc': [164, ['pointer', ['void']]],
    'pUMPDObj': [28, ['pointer', ['void']]],
    }],
'tagPROPLIST': [0x10, {
    'aprop': [8, ['array', 1, ['tagPROP']]],
    'cEntries': [0, ['unsigned long']],
    'iFirstFree': [4, ['unsigned long']],
    }],
'tagDESKTOPINFO': [0x78, {
    'spwndProgman': [96, ['pointer', ['tagWND']]],
    'pvwplMessagePPHandler': [112, ['pointer', ['VWPL']]],
    'pvDesktopLimit': [4, ['pointer', ['void']]],
    'fComposited': [116, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'spwndGestureEngine': [108, ['pointer', ['tagWND']]],
    'pvDesktopBase': [0, ['pointer', ['void']]],
    'spwndShell': [80, ['pointer', ['tagWND']]],
    'ppiShellProcess': [84, ['pointer', ['tagPROCESSINFO']]],
    'pvwplShellHook': [100, ['pointer', ['VWPL']]],
    'fIsDwmDesktop': [116, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'spwndTaskman': [92, ['pointer', ['tagWND']]],
    'aphkStart': [16, ['array', 16, ['pointer', ['tagHOOK']]]],
    'fsHooks': [12, ['unsigned long']],
    'cntMBox': [104, ['long']],
    'spwndBkGnd': [88, ['pointer', ['tagWND']]],
    'spwnd': [8, ['pointer', ['tagWND']]],
    }],
'tagDISPLAYINFO': [0x64, {
    'hDev': [0, ['pointer', ['void']]],
    'SpatialListHead': [88, ['_KLIST_ENTRY']],
    'BitCountMax': [78, ['unsigned short']],
    'cyGray': [32, ['long']],
    'hdcBits': [16, ['pointer', ['HDC__']]],
    'fDesktopIsRect': [80, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'hbmGray': [24, ['pointer', ['HBITMAP__']]],
    'pmdev': [4, ['pointer', ['void']]],
    'cFullScreen': [96, ['short']],
    'cxGray': [28, ['long']],
    'dmLogPixels': [76, ['unsigned short']],
    'hDevInfo': [8, ['pointer', ['void']]],
    'fAnyPalette': [80, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'pspbFirst': [40, ['pointer', ['tagSPB']]],
    'pMonitorPrimary': [48, ['pointer', ['tagMONITOR']]],
    'Spare0': [98, ['short']],
    'pMonitorFirst': [52, ['pointer', ['tagMONITOR']]],
    'hdcGray': [20, ['pointer', ['HDC__']]],
    'hrgnScreenReal': [72, ['pointer', ['HRGN__']]],
    'cMonitors': [44, ['unsigned long']],
    'hdcScreen': [12, ['pointer', ['HDC__']]],
    'DockThresholdMax': [84, ['unsigned long']],
    'rcScreenReal': [56, ['tagRECT']],
    'pdceFirst': [36, ['pointer', ['tagDCE']]],
    }],
'tagTHREADINFO': [0x208, {
    'pstrAppName': [220, ['pointer', ['_UNICODE_STRING']]],
    'ForceLegacyResizeNCMetr': [280, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'ptl': [180, ['pointer', ['_TL']]],
    'timeLast': [236, ['long']],
    'DontJournalAttach': [276, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'ppi': [184, ['pointer', ['tagPROCESSINFO']]],
    'SendMnuDblClk': [276, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'DDENoSync': [280, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'EditNoMouseHide': [280, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'pDevHTInfo': [148, ['pointer', ['void']]],
    'OpenGLEMF': [280, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'dwCompatFlags': [276, ['unsigned long']],
    'hTouchInputCurrent': [492, ['pointer', ['HTOUCHINPUT__']]],
    'psmsSent': [224, ['pointer', ['tagSMS']]],
    'cVisWindows': [404, ['unsigned long']],
    'hPrevHidData': [488, ['pointer', ['void']]],
    'fsHooks': [300, ['unsigned long']],
    'qwCompatFlags2': [280, ['unsigned long long']],
    'NoPaddedBorder': [280, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'NoDrawPatRect': [280, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'ForceTTGrapchis': [276, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'GetDeviceCaps': [276, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'pgdiBrushAttr': [16, ['pointer', ['void']]],
    'pq': [188, ['pointer', ['tagQ']]],
    'ulWindowSystemRendering': [172, ['unsigned long']],
    'dwExpWinVer': [272, ['unsigned long']],
    'NoSoftCursOnMoveSize': [280, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'psmsReceiveList': [232, ['pointer', ['tagSMS']]],
    'sphkCurrent': [304, ['pointer', ['tagHOOK']]],
    'No50ExStyles': [280, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'IgnoreFaults': [276, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'pClientInfo': [212, ['pointer', ['tagCLIENTINFO']]],
    'pdcoSrc': [164, ['pointer', ['void']]],
    'pEventQueueServer': [324, ['pointer', ['_KEVENT']]],
    'DealyHwndShakeChk': [276, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'amdesk': [396, ['unsigned long']],
    'fsChangeBitsRemoved': [384, ['unsigned short']],
    'psmsCurrent': [228, ['pointer', ['tagSMS']]],
    'NoBatching': [280, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'StrictLLHook': [280, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'pdcoRender': [160, ['pointer', ['void']]],
    'NoShadow': [280, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'EnumHelv': [276, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'fPack': [516, ['BitField', {'end_bit': 28, 'start_bit': 2}]],
    'CallTTDevice': [276, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'fsReserveKeys': [388, ['unsigned long']],
    'Winver31': [276, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'DisableDBCSProp': [276, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'Win30AvgWidth': [276, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'ptlW32': [8, ['pointer', ['_TL']]],
    'AlwaysSendSyncPaint': [276, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'IgnoreNoDiscard': [276, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'NoTimeCbProtect': [280, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'MsShellDlg': [280, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'hEventQueueClient': [320, ['pointer', ['void']]],
    'cPaintsReady': [252, ['long']],
    'SubtractClips': [276, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'PtiLink': [328, ['_LIST_ENTRY']],
    'DpiAware': [280, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'spklActive': [192, ['pointer', ['tagKL']]],
    'bIncludeSprites': [169, ['unsigned char']],
    'mlPost': [372, ['tagMLIST']],
    'ptLastReal': [348, ['tagPOINT']],
    'fThreadCleanupFinished': [516, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'MultipleBands': [276, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'Random31Ux': [276, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'HackWinFlags': [276, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'cti': [472, ['tagCLIENTTHREADINFO']],
    'KCOff': [280, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'wParamHkCurrent': [312, ['unsigned long']],
    'readyHead': [508, ['_LIST_ENTRY']],
    'UsePrintingEscape': [276, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'NoInitFlagsOnFocus': [280, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'ForceTextBand': [276, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'pEThread': [0, ['pointer', ['_ETHREAD']]],
    'ptdb': [264, ['pointer', ['tagTDB']]],
    'SpareCompatFlags2': [280, ['BitField', {'end_bit': 64, 'start_bit': 33}]],
    'cWindows': [400, ['unsigned long']],
    'cEnterCount': [368, ['long']],
    'fETWReserved': [516, ['BitField', {'end_bit': 32, 'start_bit': 29}]],
    'dwCompatFlags2': [280, ['unsigned long']],
    'NoEMFSpooling': [276, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'pMenuState': [260, ['pointer', ['tagMENUSTATE']]],
    'pRBRecursionCount': [40, ['unsigned long']],
    'SmoothScrolling': [276, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'iVisRgnUniqueness': [176, ['unsigned long']],
    'RefCount': [4, ['unsigned long']],
    'Win31DevModeSize': [276, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'pwinsta': [264, ['pointer', ['tagWINDOWSTATION']]],
    'pSBTrack': [316, ['pointer', ['tagSBTRACK']]],
    'ActiveMenus': [280, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'spwndDefaultIme': [356, ['pointer', ['tagWND']]],
    'NoCustomPaperSize': [280, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'wchInjected': [386, ['wchar']],
    'cTimersReady': [256, ['unsigned long']],
    'EditSetTextMunge': [276, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'pUMPDHeap': [24, ['pointer', ['void']]],
    'fgfSwitchInProgressSetter': [516, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'iCursorLevel': [336, ['long']],
    'NoScrollBarCtxMenu': [276, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'ulClientDelta': [208, ['unsigned long']],
    'pdcoAA': [156, ['pointer', ['void']]],
    'cNestedStableVisRgn': [504, ['unsigned long']],
    'TryExceptCallWndProc': [280, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'NcCalcSizeOnMove': [276, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'DisableFontAssoc': [276, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'pcti': [196, ['pointer', ['tagCLIENTTHREADINFO']]],
    'MsgPPInfo': [500, ['tagMSGPPINFO']],
    'DDE': [280, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'ulThreadFlags2': [516, ['unsigned long']],
    'tlSpriteState': [48, ['_TLSPRITESTATE']],
    'NoCharDeadKey': [280, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'pqAttach': [288, ['pointer', ['tagQ']]],
    'TTIgnoreRasterDupe': [276, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'aphkStart': [408, ['array', 16, ['pointer', ['tagHOOK']]]],
    'DefaultCharset': [280, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'idLast': [240, ['unsigned long']],
    'rpdesk': [200, ['pointer', ['tagDESKTOP']]],
    'NoWindowArrangement': [280, ['BitField', {'end_bit': 33, 'start_bit': 32}]],
    'AnimationOff': [280, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'No50ExStyleBits': [280, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'TransparentBltMirror': [280, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'DDENoAsyncReg': [280, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'bEnableEngUpdateDeviceSurface': [168, ['unsigned char']],
    'pDeskInfo': [204, ['pointer', ['tagDESKTOPINFO']]],
    'hdesk': [248, ['pointer', ['HDESK__']]],
    'pNonRBRecursionCount': [44, ['unsigned long']],
    'MoreExtraWndWords': [276, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'hklPrev': [364, ['pointer', ['HKL__']]],
    'NoGhost': [280, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'IgnoreTopMost': [276, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'pmsd': [296, ['pointer', ['_MOVESIZEDATA']]],
    'NoHRGN1': [276, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'exitCode': [244, ['long']],
    'NoDDETrackDying': [280, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'ptLast': [340, ['tagPOINT']],
    'hGestureInfoCurrent': [496, ['pointer', ['HGESTUREINFO__']]],
    'GdiTmpTgoList': [32, ['_LIST_ENTRY']],
    'pUMPDObjs': [20, ['pointer', ['void']]],
    'FontSubs': [280, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'GiveUpForegound': [280, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'spDefaultImc': [360, ['pointer', ['tagIMC']]],
    'pgdiDcattr': [12, ['pointer', ['void']]],
    'TIF_flags': [216, ['unsigned long']],
    'apEvent': [392, ['pointer', ['pointer', ['_KEVENT']]]],
    'HardwareMixer': [280, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'pUMPDObj': [28, ['pointer', ['void']]],
    'pSpriteState': [144, ['pointer', ['void']]],
    'EnumTTNotDevice': [276, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'lParamHkCurrent': [308, ['long']],
    'ulDevHTInfoUniqueness': [152, ['unsigned long']],
    'ptiSibling': [292, ['pointer', ['tagTHREADINFO']]],
    'psiiList': [268, ['pointer', ['tagSVR_INSTANCE_INFO']]],
    'ForceFusion': [280, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'fSpecialInitialization': [516, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'IncreaseStack': [276, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    }],
'__unnamed_1262': [0x2c, {
    'InitialPrivilegeSet': [0, ['_INITIAL_PRIVILEGE_SET']],
    'PrivilegeSet': [0, ['_PRIVILEGE_SET']],
    }],
'_D3DKMDT_2DREGION': [0x8, {
    'cy': [4, ['unsigned long']],
    'cx': [0, ['unsigned long']],
    }],
'tagMONITOR': [0x64, {
    'hDev': [56, ['pointer', ['void']]],
    'head': [0, ['_HEAD']],
    'hDevReal': [60, ['pointer', ['void']]],
    'rcWorkReal': [32, ['tagRECT']],
    'dwMONFlags': [12, ['unsigned long']],
    'Spare0': [52, ['short']],
    'rcMonitorReal': [16, ['tagRECT']],
    'pMonitorNext': [8, ['pointer', ['tagMONITOR']]],
    'Flink': [92, ['pointer', ['tagMONITOR']]],
    'Blink': [96, ['pointer', ['tagMONITOR']]],
    'hrgnMonitorReal': [48, ['pointer', ['HRGN__']]],
    'cWndStack': [54, ['short']],
    'DockTargets': [64, ['array', 7, ['array', 4, ['unsigned char']]]],
    }],
'__unnamed_18b4': [0x18, {
    'Dma': [0, ['__unnamed_18a8']],
    'Generic': [0, ['__unnamed_18a2']],
    'Memory': [0, ['__unnamed_18a2']],
    'BusNumber': [0, ['__unnamed_18aa']],
    'Memory48': [0, ['__unnamed_18b0']],
    'Memory40': [0, ['__unnamed_18ae']],
    'DevicePrivate': [0, ['__unnamed_177b']],
    'ConfigData': [0, ['__unnamed_18ac']],
    'Memory64': [0, ['__unnamed_18b2']],
    'Interrupt': [0, ['__unnamed_18a6']],
    'Port': [0, ['__unnamed_18a2']],
    }],
'__unnamed_18b0': [0x18, {
    'Length48': [0, ['unsigned long']],
    'Alignment48': [4, ['unsigned long']],
    'MinimumAddress': [8, ['_LARGE_INTEGER']],
    'MaximumAddress': [16, ['_LARGE_INTEGER']],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION': [0x10c, {
    'APSTriggerBits': [4, ['unsigned long']],
    'CopyProtectionType': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VPPMT_UNINITIALIZED', 1: 'D3DKMDT_VPPMT_NOPROTECTION', 2: 'D3DKMDT_VPPMT_MACROVISION_APSTRIGGER', 3: 'D3DKMDT_VPPMT_MACROVISION_FULLSUPPORT', 255: 'D3DKMDT_VPPMT_NOTSPECIFIED'}}]],
    'CopyProtectionSupport': [264, ['_D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_SUPPORT']],
    'OEMCopyProtection': [8, ['array', 256, ['unsigned char']]],
    }],
'tagHID_TLC_INFO': [0x20, {
    'cExcludeRequest': [24, ['unsigned long']],
    'link': [0, ['_LIST_ENTRY']],
    'cExcludeOrphaned': [28, ['unsigned long']],
    'cUsagePageRequest': [20, ['unsigned long']],
    'usUsagePage': [8, ['unsigned short']],
    'cDevices': [12, ['unsigned long']],
    'cDirectRequest': [16, ['unsigned long']],
    'usUsage': [10, ['unsigned short']],
    }],
'__unnamed_1777': [0xc, {
    'Translated': [0, ['__unnamed_1773']],
    'Raw': [0, ['__unnamed_1775']],
    }],
'HWND__': [0x4, {
    'unused': [0, ['long']],
    }],
'_DMM_VIDPNPATHANDTARGETMODE_SERIALIZATION': [0x190, {
    'TargetMode': [348, ['_D3DKMDT_VIDPN_TARGET_MODE']],
    'PathInfo': [0, ['_D3DKMDT_VIDPN_PRESENT_PATH']],
    }],
'tagQ': [0x108, {
    'hwndDblClk': [64, ['pointer', ['HWND__']]],
    'timeDblClk': [60, ['unsigned long']],
    'spwndFocus': [36, ['pointer', ['tagWND']]],
    'ExtraInfo': [256, ['long']],
    'cLockCount': [250, ['unsigned short']],
    'iCursorLevel': [240, ['long']],
    'ptiSysLock': [12, ['pointer', ['tagTHREADINFO']]],
    'caret': [180, ['tagCARET']],
    'ptiMouse': [24, ['pointer', ['tagTHREADINFO']]],
    'spwndActivePrev': [44, ['pointer', ['tagWND']]],
    'ptMouseMove': [76, ['tagPOINT']],
    'msgDblClk': [52, ['unsigned long']],
    'msgJournal': [252, ['unsigned long']],
    'ptiKeyboard': [28, ['pointer', ['tagTHREADINFO']]],
    'cThreads': [248, ['unsigned short']],
    'QF_flags': [244, ['unsigned long']],
    'mlInput': [0, ['tagMLIST']],
    'spwndActive': [40, ['pointer', ['tagWND']]],
    'codeCapture': [48, ['unsigned long']],
    'idSysLock': [16, ['unsigned long']],
    'spcurCurrent': [236, ['pointer', ['tagCURSOR']]],
    'ulEtwReserved1': [260, ['unsigned long']],
    'ptDblClk': [68, ['tagPOINT']],
    'xbtnDblClk': [56, ['unsigned short']],
    'afKeyRecentDown': [84, ['array', 32, ['unsigned char']]],
    'afKeyState': [116, ['array', 64, ['unsigned char']]],
    'spwndCapture': [32, ['pointer', ['tagWND']]],
    'idSysPeek': [20, ['unsigned long']],
    }],
'tagUSERSTARTUPINFO': [0x1c, {
    'wShowWindow': [24, ['unsigned short']],
    'dwYSize': [16, ['unsigned long']],
    'dwXSize': [12, ['unsigned long']],
    'cbReserved2': [26, ['unsigned short']],
    'cb': [0, ['unsigned long']],
    'dwX': [4, ['unsigned long']],
    'dwY': [8, ['unsigned long']],
    'dwFlags': [20, ['unsigned long']],
    }],
'_DMM_COMMITVIDPNREQUESTSET_SERIALIZATION': [0x8, {
    'CommitVidPnRequestOffset': [4, ['array', 1, ['unsigned long']]],
    'NumCommitVidPnRequests': [0, ['unsigned char']],
    }],
'_DMM_MONITORDESCRIPTORSET_SERIALIZATION': [0x90, {
    'NumDescriptors': [0, ['unsigned char']],
    'DescriptorSerialization': [4, ['array', 1, ['_DMM_MONITORDESCRIPTOR_SERIALIZATION']]],
    }],
'_DMM_MONITORSOURCEMODESET_SERIALIZATION': [0x54, {
    'NumModes': [0, ['unsigned char']],
    'ModeSerialization': [4, ['array', 1, ['_DMM_MONITOR_SOURCE_MODE_SERIALIZATION']]],
    }],
'_VK_FUNCTION_PARAM': [0x8, {
    'NLSFEProcIndex': [0, ['unsigned char']],
    'NLSFEProcParam': [4, ['unsigned long']],
    }],
'_D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES': [0x10, {
    'SecondChannel': [4, ['unsigned long']],
    'FourthChannel': [12, ['unsigned long']],
    'ThirdChannel': [8, ['unsigned long']],
    'FirstChannel': [0, ['unsigned long']],
    }],
'tagMLIST': [0xc, {
    'cMsgs': [8, ['unsigned long']],
    'pqmsgRead': [0, ['pointer', ['tagQMSG']]],
    'pqmsgWriteLast': [4, ['pointer', ['tagQMSG']]],
    }],
'__unnamed_122d': [0x10, {
    'DeviceIoControl': [0, ['__unnamed_11e4']],
    'QuerySecurity': [0, ['__unnamed_11e6']],
    'ReadWriteConfig': [0, ['__unnamed_1204']],
    'Create': [0, ['__unnamed_11c5']],
    'SetSecurity': [0, ['__unnamed_11e8']],
    'Write': [0, ['__unnamed_11cf']],
    'VerifyVolume': [0, ['__unnamed_11ec']],
    'WMI': [0, ['__unnamed_1229']],
    'CreateMailslot': [0, ['__unnamed_11cd']],
    'FilterResourceRequirements': [0, ['__unnamed_1202']],
    'SetFile': [0, ['__unnamed_11d9']],
    'MountVolume': [0, ['__unnamed_11ec']],
    'FileSystemControl': [0, ['__unnamed_11df']],
    'UsageNotification': [0, ['__unnamed_1213']],
    'Scsi': [0, ['__unnamed_11f0']],
    'WaitWake': [0, ['__unnamed_1217']],
    'QueryFile': [0, ['__unnamed_11d7']],
    'QueryDeviceText': [0, ['__unnamed_120e']],
    'CreatePipe': [0, ['__unnamed_11c9']],
    'Power': [0, ['__unnamed_1223']],
    'QueryDeviceRelations': [0, ['__unnamed_11f4']],
    'Read': [0, ['__unnamed_11cf']],
    'StartDevice': [0, ['__unnamed_1227']],
    'QueryDirectory': [0, ['__unnamed_11d3']],
    'PowerSequence': [0, ['__unnamed_121b']],
    'QueryId': [0, ['__unnamed_120a']],
    'LockControl': [0, ['__unnamed_11e2']],
    'NotifyDirectory': [0, ['__unnamed_11d5']],
    'QueryInterface': [0, ['__unnamed_11fa']],
    'Others': [0, ['__unnamed_122b']],
    'QueryVolume': [0, ['__unnamed_11dd']],
    'SetLock': [0, ['__unnamed_1206']],
    'DeviceCapabilities': [0, ['__unnamed_11fe']],
    }],
'__unnamed_122b': [0x10, {
    'Argument4': [12, ['pointer', ['void']]],
    'Argument2': [4, ['pointer', ['void']]],
    'Argument3': [8, ['pointer', ['void']]],
    'Argument1': [0, ['pointer', ['void']]],
    }],
'tagMENUSTATE': [0x64, {
    'fDragAndDrop': [4, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'fInsideMenuLoop': [4, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'cxAni': [84, ['long']],
    'pGlobalPopupMenu': [0, ['pointer', ['tagPOPUPMENU']]],
    'uDraggingIndex': [60, ['unsigned long']],
    'uDraggingHitArea': [56, ['unsigned long']],
    'fNotifyByPos': [4, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'fButtonDown': [4, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'ixAni': [76, ['long']],
    'fInCallHandleMenuMessages': [4, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'mnFocus': [16, ['long']],
    'iyAni': [80, ['long']],
    'dwLockCount': [28, ['unsigned long']],
    'fAutoDismiss': [4, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'fIsSysMenu': [4, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'dwAniStartTime': [72, ['unsigned long']],
    'pmnsPrev': [32, ['pointer', ['tagMENUSTATE']]],
    'fInEndMenu': [4, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'hbmAni': [92, ['pointer', ['HBITMAP__']]],
    'fIgnoreButtonUp': [4, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'ptButtonDown': [36, ['tagPOINT']],
    'hdcWndAni': [68, ['pointer', ['HDC__']]],
    'fAboutToAutoDismiss': [4, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'fMenuStarted': [4, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'uDraggingFlags': [64, ['unsigned long']],
    'fUnderline': [4, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'fInDoDragDrop': [4, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'ptiMenuStateOwner': [24, ['pointer', ['tagTHREADINFO']]],
    'uButtonDownIndex': [48, ['unsigned long']],
    'fModelessMenu': [4, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'cyAni': [88, ['long']],
    'uButtonDownHitArea': [44, ['unsigned long']],
    'fButtonAlwaysDown': [4, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'iAniDropDir': [4, ['BitField', {'end_bit': 24, 'start_bit': 19}]],
    'ptMouseLast': [8, ['tagPOINT']],
    'hdcAni': [96, ['pointer', ['HDC__']]],
    'vkButtonDown': [52, ['long']],
    'fSetCapture': [4, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'fDragging': [4, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'fActiveNoForeground': [4, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'fMouseOffMenu': [4, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'cmdLast': [20, ['long']],
    }],
'tagMSGPPINFO': [0x4, {
    'dwIndexMsgPP': [0, ['unsigned long']],
    }],
'VWPLELEMENT': [0x8, {
    'DataOrTag': [0, ['unsigned long']],
    'pwnd': [4, ['pointer', ['tagWND']]],
    }],
'_WM_VALUES_STRINGS': [0x8, {
    'pszName': [0, ['pointer', ['unsigned char']]],
    'fInternal': [4, ['unsigned char']],
    'fDefined': [5, ['unsigned char']],
    }],
'tagCLIP': [0xc, {
    'fmt': [0, ['unsigned long']],
    'fGlobalHandle': [8, ['long']],
    'hData': [4, ['pointer', ['void']]],
    }],
'__unnamed_1229': [0x10, {
    'Buffer': [12, ['pointer', ['void']]],
    'ProviderId': [0, ['unsigned long']],
    'BufferSize': [8, ['unsigned long']],
    'DataPath': [4, ['pointer', ['void']]],
    }],
'__unnamed_1227': [0x8, {
    'AllocatedResources': [0, ['pointer', ['_CM_RESOURCE_LIST']]],
    'AllocatedResourcesTranslated': [4, ['pointer', ['_CM_RESOURCE_LIST']]],
    }],
'_HEAD': [0x8, {
    'h': [0, ['pointer', ['void']]],
    'cLockObj': [4, ['unsigned long']],
    }],
'__unnamed_1223': [0x10, {
    'State': [8, ['_POWER_STATE']],
    'Type': [4, ['Enumeration', {'target': 'long', 'choices': {0: 'SystemPowerState', 1: 'DevicePowerState'}}]],
    'SystemContext': [0, ['unsigned long']],
    'ShutdownType': [12, ['Enumeration', {'target': 'long', 'choices': {0: 'PowerActionNone', 1: 'PowerActionReserved', 2: 'PowerActionSleep', 3: 'PowerActionHibernate', 4: 'PowerActionShutdown', 5: 'PowerActionShutdownReset', 6: 'PowerActionShutdownOff', 7: 'PowerActionWarmEject'}}]],
    'SystemPowerStateContext': [0, ['_SYSTEM_POWER_STATE_CONTEXT']],
    }],
'__unnamed_11e6': [0x8, {
    'Length': [4, ['unsigned long']],
    'SecurityInformation': [0, ['unsigned long']],
    }],
'tagQMSG': [0x40, {
    'FromPen': [52, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'pti': [56, ['pointer', ['tagTHREADINFO']]],
    'ExtraInfo': [36, ['long']],
    'Wow64Message': [52, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'pqmsgPrev': [4, ['pointer', ['tagQMSG']]],
    'NoCoalesce': [52, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'Padding': [48, ['BitField', {'end_bit': 32, 'start_bit': 30}]],
    'ptMouseReal': [40, ['tagPOINT']],
    'pqmsgNext': [0, ['pointer', ['tagQMSG']]],
    'dwQEvent': [48, ['BitField', {'end_bit': 30, 'start_bit': 0}]],
    'MsgPPInfo': [60, ['tagMSGPPINFO']],
    'FromTouch': [52, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'msg': [8, ['tagMSG']],
    }],
'HWINSTA__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagWin32PoolHead': [0x10, {
    'pPrev': [4, ['pointer', ['tagWin32PoolHead']]],
    'pTrace': [12, ['pointer', ['pointer', ['void']]]],
    'pNext': [8, ['pointer', ['tagWin32PoolHead']]],
    'size': [0, ['unsigned long']],
    }],
'tagTOUCHINPUT': [0x28, {
    'hSource': [8, ['pointer', ['void']]],
    'dwExtraInfo': [28, ['unsigned long']],
    'cxContact': [32, ['unsigned long']],
    'dwMask': [20, ['unsigned long']],
    'y': [4, ['long']],
    'x': [0, ['long']],
    'dwID': [12, ['unsigned long']],
    'cyContact': [36, ['unsigned long']],
    'dwTime': [24, ['unsigned long']],
    'dwFlags': [16, ['unsigned long']],
    }],
'_CALLBACKWND': [0xc, {
    'hwnd': [0, ['pointer', ['HWND__']]],
    'pActCtx': [8, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'pwnd': [4, ['pointer', ['tagWND']]],
    }],
'HMONITOR__': [0x4, {
    'unused': [0, ['long']],
    }],
'_D3DKMDT_GRAPHICS_RENDERING_FORMAT': [0x20, {
    'VisibleRegionSize': [8, ['_D3DKMDT_2DREGION']],
    'Stride': [16, ['unsigned long']],
    'PixelFormat': [20, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DDDIFMT_UNKNOWN', 20: 'D3DDDIFMT_R8G8B8', 21: 'D3DDDIFMT_A8R8G8B8', 22: 'D3DDDIFMT_X8R8G8B8', 23: 'D3DDDIFMT_R5G6B5', 24: 'D3DDDIFMT_X1R5G5B5', 25: 'D3DDDIFMT_A1R5G5B5', 26: 'D3DDDIFMT_A4R4G4B4', 27: 'D3DDDIFMT_R3G3B2', 28: 'D3DDDIFMT_A8', 29: 'D3DDDIFMT_A8R3G3B2', 30: 'D3DDDIFMT_X4R4G4B4', 31: 'D3DDDIFMT_A2B10G10R10', 32: 'D3DDDIFMT_A8B8G8R8', 33: 'D3DDDIFMT_X8B8G8R8', 34: 'D3DDDIFMT_G16R16', 35: 'D3DDDIFMT_A2R10G10B10', 36: 'D3DDDIFMT_A16B16G16R16', 40: 'D3DDDIFMT_A8P8', 41: 'D3DDDIFMT_P8', 50: 'D3DDDIFMT_L8', 51: 'D3DDDIFMT_A8L8', 52: 'D3DDDIFMT_A4L4', 60: 'D3DDDIFMT_V8U8', 61: 'D3DDDIFMT_L6V5U5', 62: 'D3DDDIFMT_X8L8V8U8', 63: 'D3DDDIFMT_Q8W8V8U8', 64: 'D3DDDIFMT_V16U16', 65: 'D3DDDIFMT_W11V11U10', 67: 'D3DDDIFMT_A2W10V10U10', 877942852: 'D3DDDIFMT_DXT4', 70: 'D3DDDIFMT_D16_LOCKABLE', 71: 'D3DDDIFMT_D32', 72: 'D3DDDIFMT_S1D15', 73: 'D3DDDIFMT_D15S1', 74: 'D3DDDIFMT_S8D24', 75: 'D3DDDIFMT_D24S8', 76: 'D3DDDIFMT_X8D24', 77: 'D3DDDIFMT_D24X8', 78: 'D3DDDIFMT_X4S4D24', 79: 'D3DDDIFMT_D24X4S4', 80: 'D3DDDIFMT_D16', 81: 'D3DDDIFMT_L16', 82: 'D3DDDIFMT_D32F_LOCKABLE', 83: 'D3DDDIFMT_D24FS8', 84: 'D3DDDIFMT_D32_LOCKABLE', 85: 'D3DDDIFMT_S8_LOCKABLE', 100: 'D3DDDIFMT_VERTEXDATA', 101: 'D3DDDIFMT_INDEX16', 102: 'D3DDDIFMT_INDEX32', 110: 'D3DDDIFMT_Q16W16V16U16', 111: 'D3DDDIFMT_R16F', 112: 'D3DDDIFMT_G16R16F', 113: 'D3DDDIFMT_A16B16G16R16F', 114: 'D3DDDIFMT_R32F', 115: 'D3DDDIFMT_G32R32F', 116: 'D3DDDIFMT_A32B32G32R32F', 117: 'D3DDDIFMT_CxV8U8', 118: 'D3DDDIFMT_A1', 119: 'D3DDDIFMT_A2B10G10R10_XR_BIAS', 150: 'D3DDDIFMT_PICTUREPARAMSDATA', 151: 'D3DDDIFMT_MACROBLOCKDATA', 152: 'D3DDDIFMT_RESIDUALDIFFERENCEDATA', 153: 'D3DDDIFMT_DEBLOCKINGDATA', 154: 'D3DDDIFMT_INVERSEQUANTIZATIONDATA', 155: 'D3DDDIFMT_SLICECONTROLDATA', 156: 'D3DDDIFMT_BITSTREAMDATA', 157: 'D3DDDIFMT_MOTIONVECTORBUFFER', 158: 'D3DDDIFMT_FILMGRAINBUFFER', 159: 'D3DDDIFMT_DXVA_RESERVED9', 160: 'D3DDDIFMT_DXVA_RESERVED10', 161: 'D3DDDIFMT_DXVA_RESERVED11', 162: 'D3DDDIFMT_DXVA_RESERVED12', 163: 'D3DDDIFMT_DXVA_RESERVED13', 164: 'D3DDDIFMT_DXVA_RESERVED14', 165: 'D3DDDIFMT_DXVA_RESERVED15', 166: 'D3DDDIFMT_DXVA_RESERVED16', 167: 'D3DDDIFMT_DXVA_RESERVED17', 168: 'D3DDDIFMT_DXVA_RESERVED18', 169: 'D3DDDIFMT_DXVA_RESERVED19', 170: 'D3DDDIFMT_DXVA_RESERVED20', 171: 'D3DDDIFMT_DXVA_RESERVED21', 172: 'D3DDDIFMT_DXVA_RESERVED22', 173: 'D3DDDIFMT_DXVA_RESERVED23', 174: 'D3DDDIFMT_DXVA_RESERVED24', 175: 'D3DDDIFMT_DXVA_RESERVED25', 176: 'D3DDDIFMT_DXVA_RESERVED26', 177: 'D3DDDIFMT_DXVA_RESERVED27', 178: 'D3DDDIFMT_DXVA_RESERVED28', 179: 'D3DDDIFMT_DXVA_RESERVED29', 180: 'D3DDDIFMT_DXVA_RESERVED30', 181: 'D3DDDIFMT_DXVACOMPBUFFER_MAX', 844388420: 'D3DDDIFMT_DXT2', 199: 'D3DDDIFMT_BINARYBUFFER', 861165636: 'D3DDDIFMT_DXT3', 827611204: 'D3DDDIFMT_DXT1', 827606349: 'D3DDDIFMT_MULTI2_ARGB8', 1195525970: 'D3DDDIFMT_R8G8_B8G8', 1498831189: 'D3DDDIFMT_UYVY', 844715353: 'D3DDDIFMT_YUY2', 894720068: 'D3DDDIFMT_DXT5', 1111970375: 'D3DDDIFMT_G8R8_G8B8', 2147483647: 'D3DDDIFMT_FORCE_UINT'}}]],
    'PixelValueAccessMode': [28, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_PVAM_UNINITIALIZED', 1: 'D3DKMDT_PVAM_DIRECT', 2: 'D3DKMDT_PVAM_PRESETPALETTE', 3: 'D3DKMDT_PVAM_MAXVALID'}}]],
    'PrimSurfSize': [0, ['_D3DKMDT_2DREGION']],
    'ColorBasis': [24, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_CB_UNINITIALIZED', 1: 'D3DKMDT_CB_INTENSITY', 2: 'D3DKMDT_CB_SRGB', 3: 'D3DKMDT_CB_SCRGB', 4: 'D3DKMDT_CB_YCBCR', 5: 'D3DKMDT_CB_MAXVALID'}}]],
    }],
'_VK_TO_WCHAR_TABLE': [0x8, {
    'pVkToWchars': [0, ['pointer', ['_VK_TO_WCHARS1']]],
    'cbSize': [5, ['unsigned char']],
    'nModifications': [4, ['unsigned char']],
    }],
'_TL': [0xc, {
    'pfnFree': [8, ['pointer', ['void']]],
    'pobj': [4, ['pointer', ['void']]],
    'next': [0, ['pointer', ['_TL']]],
    }],
'_MOVESIZEDATA': [0xdc, {
    'fmsKbd': [160, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'fMoveFromMax': [160, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'fSnapMoving': [160, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'ptRestore': [152, ['tagPOINT']],
    'fUsePreviewRect': [160, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'ptStartHitWindowRelative': [192, ['tagPOINT']],
    'CurrentHitTarget': [176, ['Enumeration', {'target': 'long', 'choices': {0: 'ThresholdMarginTop', 1: 'ThresholdMarginLeft', 2: 'ThresholdMarginRight', 3: 'ThresholdMarginBottom', 4: 'ThresholdMarginMax'}}]],
    'fHasSoftwareCursor': [160, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'fCheckPtForcefullyRestored': [160, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'fSnapMovingTemporaryAllowed': [160, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'Unused': [160, ['BitField', {'end_bit': 32, 'start_bit': 28}]],
    'fOffScreen': [160, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'fWindowWasSuperMaximized': [160, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'StartCurrentHitTarget': [168, ['Enumeration', {'target': 'long', 'choices': {0: 'ThresholdMarginTop', 1: 'ThresholdMarginLeft', 2: 'ThresholdMarginRight', 3: 'ThresholdMarginBottom', 4: 'ThresholdMarginMax'}}]],
    'fSnapSizing': [160, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'fIsMoveSizeLoop': [160, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'rcPreviewCursor': [52, ['tagRECT']],
    'dyMouse': [136, ['long']],
    'fVerticallyMaximizedRight': [160, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'fTrackCancelled': [160, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'impx': [144, ['long']],
    'impy': [148, ['long']],
    'fLockWindowUpdate': [160, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'fStartVerticallyMaximizedLeft': [160, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'ptMinTrack': [84, ['tagPOINT']],
    'pMonitorCurrentHitTarget': [172, ['pointer', ['tagMONITOR']]],
    'rcWindow': [100, ['tagRECT']],
    'pStartMonitorCurrentHitTarget': [164, ['pointer', ['tagMONITOR']]],
    'cmd': [140, ['long']],
    'ptMaxTrack': [92, ['tagPOINT']],
    'fForceSizing': [160, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'fThresholdSelector': [160, ['BitField', {'end_bit': 18, 'start_bit': 15}]],
    'MoveRectStyle': [180, ['Enumeration', {'target': 'long', 'choices': {0: 'MoveRectKeepPositionAtCursor', 1: 'MoveRectMidTopAtCursor', 2: 'MoveRectKeepAspectRatioAtCursor', 3: 'MoveRectSidewiseKeepPositionAtCursor'}}]],
    'fDragFullWindows': [160, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'fForeground': [160, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'ulCountDragOutOfLeftRightTarget': [212, ['unsigned long']],
    'ptLastTrack': [200, ['tagPOINT']],
    'frcNormalCheckPtValid': [160, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'fIsHitPtOffScreen': [160, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'fSnapSizingTemporaryAllowed': [160, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'fInitSize': [160, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'dxMouse': [132, ['long']],
    'fStartVerticallyMaximizedRight': [160, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'ulCountDragOutOfTopTarget': [208, ['unsigned long']],
    'fVerticallyMaximizedLeft': [160, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'spwnd': [0, ['pointer', ['tagWND']]],
    'fHasPreviewRect': [160, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'rcPreview': [36, ['tagRECT']],
    'rcDragCursor': [20, ['tagRECT']],
    'Flags': [160, ['unsigned long']],
    'ptHitWindowRelative': [184, ['tagPOINT']],
    'rcParent': [68, ['tagRECT']],
    'ulCountSizeOutOfTopBottomTarget': [216, ['unsigned long']],
    'rcNormalStartCheckPt': [116, ['tagRECT']],
    'rcDrag': [4, ['tagRECT']],
    }],
'_LARGE_UNICODE_STRING': [0xc, {
    'Buffer': [8, ['pointer', ['unsigned short']]],
    'Length': [0, ['unsigned long']],
    'MaximumLength': [4, ['BitField', {'end_bit': 31, 'start_bit': 0}]],
    'bAnsi': [4, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    }],
'VSC_LPWSTR': [0x8, {
    'vsc': [0, ['unsigned char']],
    'pwsz': [4, ['pointer', ['unsigned short']]],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH_TRANSFORMATION': [0x10, {
    'Scaling': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VPPS_UNINITIALIZED', 1: 'D3DKMDT_VPPS_IDENTITY', 2: 'D3DKMDT_VPPS_CENTERED', 3: 'D3DKMDT_VPPS_STRETCHED', 4: 'D3DKMDT_VPPS_ASPECTRATIOCENTEREDMAX', 5: 'D3DKMDT_VPPS_CUSTOM', 253: 'D3DKMDT_VPPS_RESERVED1', 254: 'D3DKMDT_VPPS_UNPINNED', 255: 'D3DKMDT_VPPS_NOTSPECIFIED'}}]],
    'RotationSupport': [12, ['_D3DKMDT_VIDPN_PRESENT_PATH_ROTATION_SUPPORT']],
    'Rotation': [8, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VPPR_UNINITIALIZED', 1: 'D3DKMDT_VPPR_IDENTITY', 2: 'D3DKMDT_VPPR_ROTATE90', 3: 'D3DKMDT_VPPR_ROTATE180', 4: 'D3DKMDT_VPPR_ROTATE270', 254: 'D3DKMDT_VPPR_UNPINNED', 255: 'D3DKMDT_VPPR_NOTSPECIFIED'}}]],
    'ScalingSupport': [4, ['_D3DKMDT_VIDPN_PRESENT_PATH_SCALING_SUPPORT']],
    }],
'tagUAHMENUPOPUPMETRICS': [0x14, {
    'rgcx': [0, ['array', 4, ['long']]],
    'fUpdateMaxWidths': [16, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    }],
'_THROBJHEAD': [0xc, {
    'h': [0, ['pointer', ['void']]],
    'pti': [8, ['pointer', ['tagTHREADINFO']]],
    'cLockObj': [4, ['unsigned long']],
    }],
'_DMM_COFUNCPATHSMODALITY_SERIALIZATION': [0x8, {
    'NumPathsFromSource': [0, ['unsigned char']],
    'PathAndTargetModeSetOffset': [4, ['array', 1, ['unsigned long']]],
    }],
'tagSBTRACK': [0x44, {
    'spwndSBNotify': [12, ['pointer', ['tagWND']]],
    'hTimerSB': [40, ['unsigned long']],
    'cmdSB': [36, ['unsigned long']],
    'xxxpfnSB': [32, ['pointer', ['void']]],
    'fTrackVert': [0, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'posNew': [56, ['long']],
    'posOld': [52, ['long']],
    'fCtlSB': [0, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'rcTrack': [16, ['tagRECT']],
    'fTrackRecalc': [0, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'spwndSB': [8, ['pointer', ['tagWND']]],
    'spwndTrack': [4, ['pointer', ['tagWND']]],
    'dpxThumb': [44, ['long']],
    'pxOld': [48, ['long']],
    'fHitOld': [0, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'pSBCalc': [64, ['pointer', ['tagSBCALC']]],
    'nBar': [60, ['long']],
    }],
'__unnamed_18ae': [0x18, {
    'Length40': [0, ['unsigned long']],
    'Alignment40': [4, ['unsigned long']],
    'MinimumAddress': [8, ['_LARGE_INTEGER']],
    'MaximumAddress': [16, ['_LARGE_INTEGER']],
    }],
'__unnamed_18ac': [0xc, {
    'Priority': [0, ['unsigned long']],
    'Reserved1': [4, ['unsigned long']],
    'Reserved2': [8, ['unsigned long']],
    }],
'__unnamed_1217': [0x4, {
    'PowerState': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'PowerSystemUnspecified', 1: 'PowerSystemWorking', 2: 'PowerSystemSleeping1', 3: 'PowerSystemSleeping2', 4: 'PowerSystemSleeping3', 5: 'PowerSystemHibernate', 6: 'PowerSystemShutdown', 7: 'PowerSystemMaximum'}}]],
    }],
'__unnamed_18aa': [0x10, {
    'MinBusNumber': [4, ['unsigned long']],
    'Length': [0, ['unsigned long']],
    'Reserved': [12, ['unsigned long']],
    'MaxBusNumber': [8, ['unsigned long']],
    }],
'tagDPISERVERINFO': [0x18, {
    'hMsgFont': [8, ['pointer', ['HFONT__']]],
    'hCaptionFont': [4, ['pointer', ['HFONT__']]],
    'gclBorder': [0, ['long']],
    'cxMsgFontChar': [12, ['long']],
    'wMaxBtnSize': [20, ['unsigned long']],
    'cyMsgFontChar': [16, ['long']],
    }],
'tagOEMBITMAPINFO': [0x10, {
    'y': [4, ['long']],
    'x': [0, ['long']],
    'cy': [12, ['long']],
    'cx': [8, ['long']],
    }],
'__unnamed_1787': [0xc, {
    'Dma': [0, ['__unnamed_1779']],
    'MessageInterrupt': [0, ['__unnamed_1777']],
    'Generic': [0, ['__unnamed_1771']],
    'Memory': [0, ['__unnamed_1771']],
    'BusNumber': [0, ['__unnamed_177d']],
    'DeviceSpecificData': [0, ['__unnamed_177f']],
    'Memory48': [0, ['__unnamed_1783']],
    'Memory40': [0, ['__unnamed_1781']],
    'DevicePrivate': [0, ['__unnamed_177b']],
    'Memory64': [0, ['__unnamed_1785']],
    'Interrupt': [0, ['__unnamed_1773']],
    'Port': [0, ['__unnamed_1771']],
    }],
'__unnamed_1785': [0xc, {
    'Start': [0, ['_LARGE_INTEGER']],
    'Length64': [8, ['unsigned long']],
    }],
'__unnamed_1783': [0xc, {
    'Length48': [8, ['unsigned long']],
    'Start': [0, ['_LARGE_INTEGER']],
    }],
'__unnamed_1781': [0xc, {
    'Length40': [8, ['unsigned long']],
    'Start': [0, ['_LARGE_INTEGER']],
    }],
'HICON__': [0x4, {
    'unused': [0, ['long']],
    }],
'_DMM_VIDPNTARGETMODESET_SERIALIZATION': [0x38, {
    'NumModes': [0, ['unsigned char']],
    'ModeSerialization': [4, ['array', 1, ['_D3DKMDT_VIDPN_TARGET_MODE']]],
    }],
'_D3DMATRIX': [0x40, {
    '_33': [40, ['float']],
    '_42': [52, ['float']],
    '_43': [56, ['float']],
    '_44': [60, ['float']],
    '_34': [44, ['float']],
    '_14': [12, ['float']],
    '_13': [8, ['float']],
    '_12': [4, ['float']],
    '_11': [0, ['float']],
    '_41': [48, ['float']],
    '_31': [32, ['float']],
    '_24': [28, ['float']],
    '_32': [36, ['float']],
    '_22': [20, ['float']],
    '_23': [24, ['float']],
    '_21': [16, ['float']],
    }],
'__unnamed_18a6': [0x14, {
    'AffinityPolicy': [8, ['unsigned short']],
    'Group': [10, ['unsigned short']],
    'PriorityPolicy': [12, ['Enumeration', {'target': 'long', 'choices': {0: 'IrqPriorityUndefined', 1: 'IrqPriorityLow', 2: 'IrqPriorityNormal', 3: 'IrqPriorityHigh'}}]],
    'MinimumVector': [0, ['unsigned long']],
    'MaximumVector': [4, ['unsigned long']],
    'TargetedProcessors': [16, ['unsigned long']],
    }],
'__unnamed_18a2': [0x18, {
    'Length': [0, ['unsigned long']],
    'MaximumAddress': [16, ['_LARGE_INTEGER']],
    'MinimumAddress': [8, ['_LARGE_INTEGER']],
    'Alignment': [4, ['unsigned long']],
    }],
'__unnamed_18a8': [0x8, {
    'MinimumChannel': [0, ['unsigned long']],
    'MaximumChannel': [4, ['unsigned long']],
    }],
'HGESTUREINFO__': [0x4, {
    'unused': [0, ['long']],
    }],
'_VK_TO_FUNCTION_TABLE': [0x84, {
    'NLSFEProcType': [1, ['unsigned char']],
    'NLSFEProcSwitch': [3, ['unsigned char']],
    'Vk': [0, ['unsigned char']],
    'NLSFEProcCurrent': [2, ['unsigned char']],
    'NLSFEProcAlt': [68, ['array', 8, ['_VK_FUNCTION_PARAM']]],
    'NLSFEProc': [4, ['array', 8, ['_VK_FUNCTION_PARAM']]],
    }],
'_DMM_VIDPNPATHANDTARGETMODESET_SERIALIZATION': [0x194, {
    'PathInfo': [0, ['_D3DKMDT_VIDPN_PRESENT_PATH']],
    'TargetModeSet': [348, ['_DMM_VIDPNTARGETMODESET_SERIALIZATION']],
    }],
'__unnamed_11c5': [0x10, {
    'ShareAccess': [10, ['unsigned short']],
    'EaLength': [12, ['unsigned long']],
    'SecurityContext': [0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options': [4, ['unsigned long']],
    'FileAttributes': [8, ['unsigned short']],
    }],
'HDESK__': [0x4, {
    'unused': [0, ['long']],
    }],
'VK_TO_BIT': [0x2, {
    'Vk': [0, ['unsigned char']],
    'ModBits': [1, ['unsigned char']],
    }],
'__unnamed_11c9': [0x10, {
    'ShareAccess': [10, ['unsigned short']],
    'Reserved': [8, ['unsigned short']],
    'SecurityContext': [0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options': [4, ['unsigned long']],
    'Parameters': [12, ['pointer', ['_NAMED_PIPE_CREATE_PARAMETERS']]],
    }],
'MODIFIERS': [0x8, {
    'wMaxModBits': [4, ['unsigned short']],
    'pVkToBit': [0, ['pointer', ['VK_TO_BIT']]],
    'ModNumber': [6, ['array', 0, ['unsigned char']]],
    }],
'tagIMEINFOEX': [0x15c, {
    'fSysWow64Only': [344, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'wszImeFile': [184, ['array', 80, ['wchar']]],
    'fLoadFlag': [72, ['long']],
    'hkl': [0, ['pointer', ['HKL__']]],
    'dwImeWinVersion': [80, ['unsigned long']],
    'dwProdVersion': [76, ['unsigned long']],
    'wszImeDescription': [84, ['array', 50, ['wchar']]],
    'fCUASLayer': [344, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'ImeInfo': [4, ['tagIMEINFO']],
    'wszUIClass': [32, ['array', 16, ['wchar']]],
    'fInitOpen': [68, ['long']],
    'fdwInitConvMode': [64, ['unsigned long']],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION_SUPPORT': [0x4, {
    'MacroVisionFull': [0, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'MacroVisionApsTrigger': [0, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'NoProtection': [0, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'Reserved': [0, ['BitField', {'end_bit': 32, 'start_bit': 3}]],
    }],
'tagWND': [0xb0, {
    'bEraseBackground': [20, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'spwndOwner': [60, ['pointer', ['tagWND']]],
    'bWS_EX_LAYERED': [28, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'bWS_CLIPCHILDREN': [32, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'bMaximizeButtonDown': [24, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'cbwndExtra': [144, ['long']],
    'bMakeVisibleWhenUnghosted': [28, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'bUIStateActive': [28, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'hMod16': [40, ['unsigned short']],
    'bWS_TABSTOP': [32, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bUnused8': [32, ['BitField', {'end_bit': 18, 'start_bit': 16}]],
    'bWS_EX_NOPARENTNOTIFY': [28, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'bForceFullNCPaintClipRgn': [24, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'bDialogWindow': [20, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'lpfnWndProc': [96, ['pointer', ['void']]],
    'bWS_EX_RTLREADING': [28, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'bMinimizeButtonDown': [24, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'bUnused2': [28, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'bUnused3': [28, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'bUnused4': [28, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'bHasMeun': [20, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'bUnused6': [32, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bUnused7': [32, ['BitField', {'end_bit': 18, 'start_bit': 16}]],
    'bWS_SIZEBOX': [32, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'style': [32, ['unsigned long']],
    'ppropList': [108, ['pointer', ['tagPROPLIST']]],
    'hrgnNewFrame': [128, ['pointer', ['HRGN__']]],
    'bHasOverlay': [172, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'bUnused9': [32, ['BitField', {'end_bit': 19, 'start_bit': 16}]],
    'bClipboardListener': [172, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'bScrollBarLineDownBtnDown': [24, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'bReserved3': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bRedirectedForPrint': [172, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'bWS_EX_RIGHT': [28, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'bStartPaint': [24, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'bHasCreatestructName': [20, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'bWS_EX_COMPOSITED': [28, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'bFullScreen': [24, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'spwndLastActive': [148, ['pointer', ['tagWND']]],
    'hrgnUpdate': [104, ['pointer', ['HRGN__']]],
    'head': [0, ['_THRDESKHEAD']],
    'bConsoleWindow': [172, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'bHiddenPopup': [20, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'hrgnClip': [124, ['pointer', ['HRGN__']]],
    'bWS_EX_CONTROLPARENT': [28, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bWS_EX_TOPMOST': [28, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'bSendEraseBackground': [20, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'bScrollBarLineUpBtnDown': [24, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bWin50Compat': [24, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'bRecievedQuerySuspendMsg': [20, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'bMaximizeMonitorRegion': [24, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'bLayeredLimbo': [172, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'bRedrawIfHung': [20, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'FullScreenMode': [24, ['BitField', {'end_bit': 27, 'start_bit': 24}]],
    'bLayeredInvalidate': [172, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'bVerticallyMaximizedLeft': [172, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'bWS_POPUP': [32, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'bWS_EX_CONTEXTHELP': [28, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'dwUserData': [156, ['unsigned long']],
    'bDisabled': [32, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'bAnsiWindowProc': [20, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'bWin40Compat': [24, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'bWS_EX_NOINHERITLAYOUT': [28, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'rcClient': [80, ['tagRECT']],
    'bAnsiCreator': [20, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'bAnyScrollButtonDown': [24, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'bWS_EX_LAYOUTRTL': [28, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'bUIStateKbdAccelHidden': [28, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'bSendSizeMoveMsgs': [20, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'spwndParent': [52, ['pointer', ['tagWND']]],
    'bLinked': [172, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'bSendNCPaint': [20, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'bToggleTopmost': [20, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'bInternalPaint': [20, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'bDestroyed': [20, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'bHasClientEdge': [24, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'bServerSideWindowProc': [20, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'bCaptionTextTruncated': [24, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'rcWindow': [64, ['tagRECT']],
    'bEndPaintInvalidate': [24, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'bHasPalette': [20, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'bHasHorizontalScrollbar': [20, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'bUIStateFocusRectHidden': [28, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'bReserved1': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bWS_EX_COMPOSITEDCompositing': [28, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'bWS_EX_MDICHILD': [28, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'bHasVerticalScrollbar': [20, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'bReserved2': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bWMCreateMsgProcessed': [24, ['BitField', {'end_bit': 32, 'start_bit': 31}]],
    'bMinimized': [32, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'bWS_EX_NOACTIVATE': [28, ['BitField', {'end_bit': 28, 'start_bit': 27}]],
    'bWS_EX_APPWINDOW': [28, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'pSBInfo': [112, ['pointer', ['tagSBINFO']]],
    'bSmallIconFromWMQueryDrag': [24, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'bNoNCPaint': [20, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'bCloseButtonDown': [24, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    'bUnused1': [28, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'bHasSPB': [20, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'bWS_MINIMIZEBOX': [32, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'bMaximized': [32, ['BitField', {'end_bit': 25, 'start_bit': 24}]],
    'bScrollBarVerticalTracking': [24, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'bWS_CHILD': [32, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'bReserved5': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bWS_EX_DLGMODALFRAME': [28, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'bWS_EX_TRANSPARENT': [28, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'spmenu': [120, ['pointer', ['tagMENU']]],
    'bWS_THICKFRAME': [32, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'bPaintNotProcessed': [20, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'bSyncPaintPending': [20, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'pcls': [100, ['pointer', ['tagCLS']]],
    'bLayeredForDWM': [172, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'bMsgBox': [20, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'bShellHookRegistered': [24, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'spwndChild': [56, ['pointer', ['tagWND']]],
    'bUnused5': [32, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bHelpButtonDown': [24, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'bInDestroy': [24, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'state': [20, ['unsigned long']],
    'strName': [132, ['_LARGE_UNICODE_STRING']],
    'spwndPrev': [48, ['pointer', ['tagWND']]],
    'bRedrawFrameIfHung': [20, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'bWS_EX_LEFTSCROLLBAR': [28, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'bWS_EX_TOOLWINDOW': [28, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'bWS_VSCROLL': [32, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'bMaximizesToMonitor': [20, ['BitField', {'end_bit': 31, 'start_bit': 30}]],
    'bNoMinmaxAnimatedRects': [24, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'fnid': [42, ['unsigned short']],
    'ExStyle': [28, ['unsigned long']],
    'bRedirected': [28, ['BitField', {'end_bit': 30, 'start_bit': 29}]],
    'bActiveFrame': [20, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'bReserved4': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bWS_EX_WINDOWEDGE': [28, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'bReserved6': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bReserved7': [32, ['BitField', {'end_bit': 16, 'start_bit': 0}]],
    'bWS_CLIPSIBLINGS': [32, ['BitField', {'end_bit': 27, 'start_bit': 26}]],
    'bWS_EX_ACCEPTFILE': [28, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'bWS_HSCROLL': [32, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'bUpdateDirty': [20, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'bBeingActivated': [20, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'state2': [24, ['unsigned long']],
    'spwndNext': [44, ['pointer', ['tagWND']]],
    'bScrollBarPageDownBtnDown': [24, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'bWS_BORDER': [32, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'bWMPaintSent': [24, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'bScrollBarPageUpBtnDown': [24, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'pTransform': [164, ['pointer', ['_D3DMATRIX']]],
    'bWS_MAXIMIZEBOX': [32, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'bVisible': [32, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'bVerticallyMaximizedRight': [172, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'bWin31Compat': [24, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'bWS_EX_STATICEDGE': [28, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'bForceMenuDraw': [20, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'bForceNCPaint': [24, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'ExStyle2': [172, ['unsigned long']],
    'bOldUI': [24, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'bWS_DLGFRAME': [32, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'bHIGHDPI_UNAWARE_Unused': [172, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'bWS_SYSMENU': [32, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'spwndClipboardListenerNext': [168, ['pointer', ['tagWND']]],
    'hModule': [36, ['pointer', ['void']]],
    'bWS_EX_NOPADDEDBORDER': [28, ['BitField', {'end_bit': 24, 'start_bit': 23}]],
    'pActCtx': [160, ['pointer', ['_ACTIVATION_CONTEXT']]],
    'bBottomMost': [24, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'spmenuSys': [116, ['pointer', ['tagMENU']]],
    'bRecievedSuspendMsg': [20, ['BitField', {'end_bit': 26, 'start_bit': 25}]],
    'bWS_EX_CLIENTEDGE': [28, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'bHasCaption': [20, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'hImc': [152, ['pointer', ['HIMC__']]],
    'bChildNoActivate': [172, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'bWS_GROUP': [32, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    }],
'tagUAHMENUITEMMETRICS': [0x20, {
    'rgsizeBar': [0, ['array', 2, ['tagSIZE']]],
    'rgsizePopup': [0, ['array', 4, ['tagSIZE']]],
    }],
'__unnamed_11cd': [0x10, {
    'ShareAccess': [10, ['unsigned short']],
    'Reserved': [8, ['unsigned short']],
    'SecurityContext': [0, ['pointer', ['_IO_SECURITY_CONTEXT']]],
    'Options': [4, ['unsigned long']],
    'Parameters': [12, ['pointer', ['_MAILSLOT_CREATE_PARAMETERS']]],
    }],
'__unnamed_11cf': [0x10, {
    'Length': [0, ['unsigned long']],
    'ByteOffset': [8, ['_LARGE_INTEGER']],
    'Key': [4, ['unsigned long']],
    }],
'_DXGK_DIAG_CODE_POINT_PACKET': [0x40, {
    'Header': [0, ['_DXGK_DIAG_HEADER']],
    'Param3': [60, ['unsigned long']],
    'Param1': [52, ['unsigned long']],
    'CodePointType': [48, ['Enumeration', {'target': 'long', 'choices': {0: 'DXGK_DIAG_CODE_POINT_TYPE_NONE', 1: 'DXGK_DIAG_CODE_POINT_TYPE_RECOMMEND_FUNC_VIDPN', 2: 'DXGK_DIAG_CODE_POINT_TYPE_OS_RECOMMENDED_VIDPN', 3: 'DXGK_DIAG_CODE_POINT_TYPE_SDC_LOG_FAILURE', 4: 'DXGK_DIAG_CODE_POINT_TYPE_SDC_INVALIDATE_ERROR', 5: 'DXGK_DIAG_CODE_POINT_TYPE_CDS_LOG_FAILURE', 7: 'DXGK_DIAG_CODE_POINT_TYPE_CDS_FAILURE_DB', 8: 'DXGK_DIAG_CODE_POINT_TYPE_RETRIEVE_BTL', 9: 'DXGK_DIAG_CODE_POINT_TYPE_RETRIEVE_DB', 10: 'DXGK_DIAG_CODE_POINT_TYPE_QDC_LOG_FAILURE', 11: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_ON_GDI', 12: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_OFF_GDI', 13: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_ON_MONITOR', 14: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_OFF_MONITOR', 15: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_DIM_MONITOR', 16: 'DXGK_DIAG_CODE_POINT_TYPE_POWER_UNDIM_MONITOR', 17: 'DXGK_DIAG_CODE_POINT_TYPE_BML_BACKTRACK', 18: 'DXGK_DIAG_CODE_POINT_TYPE_BML_CLOSEST_TARGET_MODE', 19: 'DXGK_DIAG_CODE_POINT_TYPE_BML_NO_EXACT_SOURCE_MODE', 20: 'DXGK_DIAG_CODE_POINT_TYPE_BML_NO_EXACT_TARGET_MODE', 21: 'DXGK_DIAG_CODE_POINT_TYPE_BML_SOURCE_MODE_NOT_PINNED', 22: 'DXGK_DIAG_CODE_POINT_TYPE_BML_TARGET_MODE_NOT_PINNED', 23: 'DXGK_DIAG_CODE_POINT_TYPE_BML_RESTARTED', 24: 'DXGK_DIAG_CODE_POINT_TYPE_TDR', 25: 'DXGK_DIAG_CODE_POINT_TYPE_ACPI_EVENT_NOTIFICATION', 26: 'DXGK_DIAG_CODE_POINT_TYPE_CREATEMDEV_USE_DEFAULT_MODE', 27: 'DXGK_DIAG_CODE_POINT_TYPE_CONNECTED_SET_LOG_FAILURE', 28: 'DXGK_DIAG_CODE_POINT_TYPE_INVALIDATE_DXGK_MODE_CACHE', 29: 'DXGK_DIAG_CODE_POINT_TYPE_REBUILD_DXGK_MODE_CACHE', 30: 'DXGK_DIAG_CODE_POINT_TYPE_CREATEFUNVIDPN_RELAX_REFRESH_MATCH', 31: 'DXGK_DIAG_CODE_POINT_TYPE_CREATEFUNVIDPN_CCDBML_FAIL_VISTABML_SUCCESSED', 32: 'DXGK_DIAG_CODE_POINT_TYPE_BML_BEST_SOURCE_MODE', 33: 'DXGK_DIAG_CODE_POINT_TYPE_BML_BEST_TARGET_MODE', 34: 'DXGK_DIAG_CODE_POINT_TYPE_ADD_DEVICE', 35: 'DXGK_DIAG_CODE_POINT_TYPE_START_ADAPTER', 36: 'DXGK_DIAG_CODE_POINT_TYPE_STOP_ADAPTER', 37: 'DXGK_DIAG_CODE_POINT_TYPE_CHILD_POLLING', 38: 'DXGK_DIAG_CODE_POINT_TYPE_CHILD_POLLING_TARGET', 39: 'DXGK_DIAG_CODE_POINT_TYPE_INDICATE_CHILD_STATUS', 40: 'DXGK_DIAG_CODE_POINT_TYPE_HANDLE_IRP', 41: 'DXGK_DIAG_CODE_POINT_TYPE_CHANGE_UNSUPPORTED_MONITOR_MODE_FLAG', 42: 'DXGK_DIAG_CODE_POINT_TYPE_ACPI_NOTIFY_CALLBACK', 43: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_EVICTALL_DISABLEGDI', 44: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_EVICTALL_ENABLEGDI', 45: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_EXCLUDE_MODESWITCH', 46: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_SYNC_MONITOR_EVENT', 47: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_PNP_NOTIFY_GDI', 48: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_PNP_ENABLE_VGA', 49: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_TDR_SWITCH_GDI', 50: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_CREATE_DEVICE_FAILED', 51: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_DEVICE_REMOVED', 52: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_DRVASSERTMODE_TRUE_FAILED', 53: 'DXGK_DIAG_CODE_POINT_TYPE_VIDEOPORTCALLOUT_CDD_RECREATE_DEVICE_FAILED', 54: 'DXGK_DIAG_CODE_POINT_TYPE_CDD_MAPSHADOWBUFFER_FAILED', 55: 'DXGK_DIAG_CODE_POINT_TYPE_COMMIT_VIDPN_LOG_FAILURE', 56: 'DXGK_DIAG_CODE_POINT_TYPE_DRIVER_RECOMMEND_LOG_FAILURE', 57: 'DXGK_DIAG_CODE_POINT_TYPE_SDC_ENFORCED_CLONE_PATH_INVALID_SOURCE_IDX', 58: 'DXGK_DIAG_CODE_POINT_TYPE_DRVPROBEANDCAPTURE_FAILED', 59: 'DXGK_DIAG_CODE_POINT_TYPE_DXGKCDDENABLE_OPTIMIZED_MODE_CHANGE', 60: 'DXGK_DIAG_CODE_POINT_TYPE_DXGKSETDISPLAYMODE_OPTIMIZED_MODE_CHANGE', 61: 'DXGK_DIAG_CODE_POINT_TYPE_MON_DEPART_GETRECENTTOP_FAIL', 62: 'DXGK_DIAG_CODE_POINT_TYPE_MON_ARRIVE_INC_ADD_FAIL', 63: 'DXGK_DIAG_CODE_POINT_TYPE_CCD_DATABASE_PERSIST', 64: 'DXGK_DIAG_CODE_POINT_TYPE_MAX', -1: 'DXGK_DIAG_CODE_POINT_TYPE_FORCE_UINT32'}}]],
    'Param2': [56, ['unsigned long']],
    }],
'tagW32JOB': [0x28, {
    'restrictions': [12, ['unsigned long']],
    'Job': [4, ['pointer', ['_EJOB']]],
    'ughCrt': [28, ['unsigned long']],
    'pgh': [36, ['pointer', ['unsigned long']]],
    'ppiTable': [24, ['pointer', ['pointer', ['tagPROCESSINFO']]]],
    'ughMax': [32, ['unsigned long']],
    'pAtomTable': [8, ['pointer', ['void']]],
    'uProcessCount': [16, ['unsigned long']],
    'uMaxProcesses': [20, ['unsigned long']],
    'pNext': [0, ['pointer', ['tagW32JOB']]],
    }],
'tagMBSTRING': [0x28, {
    'szName': [0, ['array', 15, ['wchar']]],
    'uID': [32, ['unsigned long']],
    'uStr': [36, ['unsigned long']],
    }],
'_D3DKMDT_VIDPN_TARGET_MODE': [0x34, {
    'VideoSignalInfo': [4, ['_D3DKMDT_VIDEO_SIGNAL_INFO']],
    'Id': [0, ['unsigned long']],
    'Preference': [48, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MP_UNINITIALIZED', 1: 'D3DKMDT_MP_PREFERRED', 2: 'D3DKMDT_MP_MAXVALID'}}]],
    }],
'tagDESKTOP': [0x84, {
    'spmenuVScroll': [40, ['pointer', ['tagMENU']]],
    'dwMouseHoverTime': [124, ['unsigned long']],
    'rpwinstaParent': [16, ['pointer', ['tagWINDOWSTATION']]],
    'spmenuDialogSys': [32, ['pointer', ['tagMENU']]],
    'spwndForeground': [44, ['pointer', ['tagWND']]],
    'spmenuHScroll': [36, ['pointer', ['tagMENU']]],
    'spwndTooltip': [56, ['pointer', ['tagWND']]],
    'dwSessionId': [0, ['unsigned long']],
    'pDeskInfo': [4, ['pointer', ['tagDESKTOPINFO']]],
    'spwndMessage': [52, ['pointer', ['tagWND']]],
    'cciConsole': [72, ['_CONSOLE_CARET_INFO']],
    'PtiList': [92, ['_LIST_ENTRY']],
    'spwndTray': [48, ['pointer', ['tagWND']]],
    'rpdeskNext': [12, ['pointer', ['tagDESKTOP']]],
    'dwDTFlags': [20, ['unsigned long']],
    'pMagInputTransform': [128, ['pointer', ['_MAGNIFICATION_INPUT_TRANSFORM']]],
    'spwndTrack': [100, ['pointer', ['tagWND']]],
    'htEx': [104, ['long']],
    'ulHeapSize': [68, ['unsigned long']],
    'pheapDesktop': [64, ['pointer', ['tagWIN32HEAP']]],
    'hsectionDesktop': [60, ['pointer', ['void']]],
    'rcMouseHover': [108, ['tagRECT']],
    'dwDesktopId': [24, ['unsigned long']],
    'spmenuSys': [28, ['pointer', ['tagMENU']]],
    'pDispInfo': [8, ['pointer', ['tagDISPLAYINFO']]],
    }],
'tagPOOLRECORD': [0x20, {
    'ExtraData': [0, ['pointer', ['void']]],
    'trace': [8, ['array', 6, ['pointer', ['void']]]],
    'size': [4, ['unsigned long']],
    }],
'tagSPB': [0x28, {
    'hbm': [8, ['pointer', ['HBITMAP__']]],
    'hrgn': [28, ['pointer', ['HRGN__']]],
    'ulSaveId': [36, ['unsigned long']],
    'flags': [32, ['unsigned long']],
    'rc': [12, ['tagRECT']],
    'pspbNext': [0, ['pointer', ['tagSPB']]],
    'spwnd': [4, ['pointer', ['tagWND']]],
    }],
'_DMM_COMMITVIDPNREQUEST_DIAGINFO': [0xc, {
    'ForceAllActiveVidPnModeListInvalidation': [4, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'ClientType': [0, ['BitField', {'end_bit': 4, 'start_bit': 0}]],
    'VidPnChange': [0, ['BitField', {'end_bit': 8, 'start_bit': 4}]],
    'ModeChangeRequestId': [8, ['unsigned long']],
    'ReclaimClonedTarget': [4, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'CleanupAfterFailedCommitVidPn': [4, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    }],
'HFONT__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagTEXTMETRICW': [0x3c, {
    'tmCharSet': [56, ['unsigned char']],
    'tmDigitizedAspectY': [40, ['long']],
    'tmStruckOut': [54, ['unsigned char']],
    'tmItalic': [52, ['unsigned char']],
    'tmDigitizedAspectX': [36, ['long']],
    'tmWeight': [28, ['long']],
    'tmFirstChar': [44, ['wchar']],
    'tmOverhang': [32, ['long']],
    'tmDescent': [8, ['long']],
    'tmPitchAndFamily': [55, ['unsigned char']],
    'tmDefaultChar': [48, ['wchar']],
    'tmLastChar': [46, ['wchar']],
    'tmBreakChar': [50, ['wchar']],
    'tmMaxCharWidth': [24, ['long']],
    'tmUnderlined': [53, ['unsigned char']],
    'tmInternalLeading': [12, ['long']],
    'tmAscent': [4, ['long']],
    'tmHeight': [0, ['long']],
    'tmAveCharWidth': [20, ['long']],
    'tmExternalLeading': [16, ['long']],
    }],
'_KLIST_ENTRY': [0x8, {
    'Flink': [0, ['pointer', ['_KLIST_ENTRY']]],
    'Blink': [4, ['pointer', ['_KLIST_ENTRY']]],
    }],
'__unnamed_1244': [0x28, {
    'Wcb': [0, ['_WAIT_CONTEXT_BLOCK']],
    'ListEntry': [0, ['_LIST_ENTRY']],
    }],
'tagPROP': [0x8, {
    'fs': [6, ['unsigned short']],
    'hData': [0, ['pointer', ['void']]],
    'atomKey': [4, ['unsigned short']],
    }],
'tagCLIENTTHREADINFO': [0x10, {
    'fsWakeMask': [10, ['unsigned short']],
    'CTIF_flags': [0, ['unsigned long']],
    'fsWakeBits': [6, ['unsigned short']],
    'fsWakeBitsJournal': [8, ['unsigned short']],
    'fsChangeBits': [4, ['unsigned short']],
    'tickLastMsgChecked': [12, ['unsigned long']],
    }],
'tagKbdNlsLayer': [0x14, {
    'OEMIdentifier': [0, ['unsigned short']],
    'NumOfVkToF': [4, ['unsigned long']],
    'pusMouseVKey': [16, ['pointer', ['unsigned short']]],
    'NumOfMouseVKey': [12, ['long']],
    'pVkToF': [8, ['pointer', ['_VK_TO_FUNCTION_TABLE']]],
    'LayoutInformation': [2, ['unsigned short']],
    }],
'HBITMAP__': [0x4, {
    'unused': [0, ['long']],
    }],
'__unnamed_11fe': [0x4, {
    'Capabilities': [0, ['pointer', ['_DEVICE_CAPABILITIES']]],
    }],
'__unnamed_18b2': [0x18, {
    'Length64': [0, ['unsigned long']],
    'MaximumAddress': [16, ['_LARGE_INTEGER']],
    'MinimumAddress': [8, ['_LARGE_INTEGER']],
    'Alignment64': [4, ['unsigned long']],
    }],
'__unnamed_11fa': [0x10, {
    'Interface': [8, ['pointer', ['_INTERFACE']]],
    'InterfaceSpecificData': [12, ['pointer', ['void']]],
    'Version': [6, ['unsigned short']],
    'InterfaceType': [0, ['pointer', ['_GUID']]],
    'Size': [4, ['unsigned short']],
    }],
'tagPROCESS_HID_TABLE': [0x38, {
    'UsagePageLast': [48, ['unsigned short']],
    'fExclusiveMouseSink': [52, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'fRawKeyboardSink': [52, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'fAppKeys': [52, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'fCaptureMouse': [52, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'fNoLegacyMouse': [52, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'UsageLast': [50, ['unsigned short']],
    'fRawKeyboard': [52, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'fNoLegacyKeyboard': [52, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'nSinks': [40, ['long']],
    'fNoHotKeys': [52, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'spwndTargetMouse': [32, ['pointer', ['tagWND']]],
    'spwndTargetKbd': [36, ['pointer', ['tagWND']]],
    'UsagePageList': [16, ['_LIST_ENTRY']],
    'link': [0, ['_LIST_ENTRY']],
    'fExclusiveKeyboardSink': [52, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'pLastRequest': [44, ['pointer', ['tagPROCESS_HID_REQUEST']]],
    'ExclusionList': [24, ['_LIST_ENTRY']],
    'fRawMouse': [52, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'fRawMouseSink': [52, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'InclusionList': [8, ['_LIST_ENTRY']],
    }],
'_KFLOATING_SAVE': [0x20, {
    'ErrorOffset': [8, ['unsigned long']],
    'DataOffset': [16, ['unsigned long']],
    'ControlWord': [0, ['unsigned long']],
    'DataSelector': [20, ['unsigned long']],
    'Cr0NpxState': [24, ['unsigned long']],
    'StatusWord': [4, ['unsigned long']],
    'Spare1': [28, ['unsigned long']],
    'ErrorSelector': [12, ['unsigned long']],
    }],
'tagRECT': [0x10, {
    'top': [4, ['long']],
    'right': [8, ['long']],
    'bottom': [12, ['long']],
    'left': [0, ['long']],
    }],
'__unnamed_17ff': [0x20, {
    'Text': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_TRF_UNINITIALIZED'}}]],
    'Graphics': [0, ['_D3DKMDT_GRAPHICS_RENDERING_FORMAT']],
    }],
'HBRUSH__': [0x4, {
    'unused': [0, ['long']],
    }],
'_TLSPRITESTATE': [0x60, {
    'flOriginalSurfFlags': [4, ['unsigned long']],
    'iSpriteType': [16, ['unsigned long']],
    'pfnSaveScreenBits': [84, ['pointer', ['void']]],
    'bInsideDriverCall': [0, ['unsigned char']],
    'pfnStrokePath': [36, ['pointer', ['void']]],
    'pfnTransparentBlt': [68, ['pointer', ['void']]],
    'pfnPaint': [44, ['pointer', ['void']]],
    'pfnFillPath': [40, ['pointer', ['void']]],
    'pfnStretchBltROP': [88, ['pointer', ['void']]],
    'iType': [24, ['unsigned long']],
    'pfnPlgBlt': [76, ['pointer', ['void']]],
    'pfnCopyBits': [52, ['pointer', ['void']]],
    'pState': [28, ['pointer', ['void']]],
    'iOriginalType': [8, ['unsigned long']],
    'pfnTextOut': [60, ['pointer', ['void']]],
    'pfnDrawStream': [92, ['pointer', ['void']]],
    'pfnStrokeAndFillPath': [32, ['pointer', ['void']]],
    'pfnLineTo': [64, ['pointer', ['void']]],
    'pfnStretchBlt': [56, ['pointer', ['void']]],
    'pfnGradientFill': [80, ['pointer', ['void']]],
    'pfnAlphaBlend': [72, ['pointer', ['void']]],
    'flags': [20, ['unsigned long']],
    'flSpriteSurfFlags': [12, ['unsigned long']],
    'pfnBitBlt': [48, ['pointer', ['void']]],
    }],
'tagSMS': [0x3c, {
    'wParam': [40, ['unsigned long']],
    'lParam': [44, ['long']],
    'lRet': [28, ['long']],
    'psmsReceiveNext': [4, ['pointer', ['tagSMS']]],
    'tSent': [32, ['unsigned long']],
    'psmsNext': [0, ['pointer', ['tagSMS']]],
    'ptiCallBackSender': [24, ['pointer', ['tagTHREADINFO']]],
    'ptiReceiver': [12, ['pointer', ['tagTHREADINFO']]],
    'lpResultCallBack': [16, ['pointer', ['void']]],
    'message': [48, ['unsigned long']],
    'dwData': [20, ['unsigned long']],
    'ptiSender': [8, ['pointer', ['tagTHREADINFO']]],
    'flags': [36, ['unsigned long']],
    'pvCapture': [56, ['pointer', ['void']]],
    'spwnd': [52, ['pointer', ['tagWND']]],
    }],
'_D3DKMDT_FREQUENCY_RANGE': [0x20, {
    'MinVSyncFreq': [0, ['_D3DDDI_RATIONAL']],
    'MaxVSyncFreq': [8, ['_D3DDDI_RATIONAL']],
    'MaxHSyncFreq': [24, ['_D3DDDI_RATIONAL']],
    'MinHSyncFreq': [16, ['_D3DDDI_RATIONAL']],
    }],
'__unnamed_11f4': [0x4, {
    'Type': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'BusRelations', 1: 'EjectionRelations', 2: 'PowerRelations', 3: 'RemovalRelations', 4: 'TargetDeviceRelation', 5: 'SingleBusRelations', 6: 'TransportRelations'}}]],
    }],
'__unnamed_11f0': [0x4, {
    'Srb': [0, ['pointer', ['_SCSI_REQUEST_BLOCK']]],
    }],
'HRGN__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagSIZE': [0x8, {
    'cy': [4, ['long']],
    'cx': [0, ['long']],
    }],
'tagDESKTOPVIEW': [0xc, {
    'ulClientDelta': [8, ['unsigned long']],
    'pdesk': [4, ['pointer', ['tagDESKTOP']]],
    'pdvNext': [0, ['pointer', ['tagDESKTOPVIEW']]],
    }],
'__unnamed_120a': [0x4, {
    'IdType': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'BusQueryDeviceID', 1: 'BusQueryHardwareIDs', 2: 'BusQueryCompatibleIDs', 3: 'BusQueryInstanceID', 4: 'BusQueryDeviceSerialNumber', 5: 'BusQueryContainerID'}}]],
    }],
'__unnamed_120e': [0x8, {
    'DeviceTextType': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'DeviceTextDescription', 1: 'DeviceTextLocationInformation'}}]],
    'LocaleId': [4, ['unsigned long']],
    }],
'_DMM_VIDPNPATHSFROMSOURCE_SERIALIZATION': [0x1bc, {
    'PathAndTargetModeSerialization': [44, ['array', 1, ['_DMM_VIDPNPATHANDTARGETMODE_SERIALIZATION']]],
    'NumPathsFromSource': [40, ['unsigned char']],
    'SourceMode': [0, ['_D3DKMDT_VIDPN_SOURCE_MODE']],
    }],
'_D3DDDI_GAMMA_RAMP_RGB256x3x16': [0x600, {
    'Blue': [1024, ['array', 256, ['unsigned short']]],
    'Green': [512, ['array', 256, ['unsigned short']]],
    'Red': [0, ['array', 256, ['unsigned short']]],
    }],
'_CALLPROCDATA': [0x20, {
    'head': [0, ['_PROCDESKHEAD']],
    'pfnClientPrevious': [24, ['unsigned long']],
    'wType': [28, ['unsigned short']],
    'spcpdNext': [20, ['pointer', ['_CALLPROCDATA']]],
    }],
'_D3DDDI_RATIONAL': [0x8, {
    'Denominator': [4, ['unsigned long']],
    'Numerator': [0, ['unsigned long']],
    }],
'_PFNCLIENT': [0x5c, {
    'pfnDispatchDefWindowProc': [80, ['pointer', ['void']]],
    'pfnStaticWndProc': [56, ['pointer', ['void']]],
    'pfnDispatchHook': [76, ['pointer', ['void']]],
    'pfnDesktopWndProc': [12, ['pointer', ['void']]],
    'pfnImeWndProc': [60, ['pointer', ['void']]],
    'pfnScrollBarWndProc': [0, ['pointer', ['void']]],
    'pfnEditWndProc': [44, ['pointer', ['void']]],
    'pfnGhostWndProc': [64, ['pointer', ['void']]],
    'pfnMessageWindowProc': [20, ['pointer', ['void']]],
    'pfnSwitchWindowProc': [24, ['pointer', ['void']]],
    'pfnComboListBoxProc': [36, ['pointer', ['void']]],
    'pfnComboBoxWndProc': [32, ['pointer', ['void']]],
    'pfnMDIClientWndProc': [52, ['pointer', ['void']]],
    'pfnDialogWndProc': [40, ['pointer', ['void']]],
    'pfnHkINLPCWPSTRUCT': [68, ['pointer', ['void']]],
    'pfnTitleWndProc': [4, ['pointer', ['void']]],
    'pfnHkINLPCWPRETSTRUCT': [72, ['pointer', ['void']]],
    'pfnButtonWndProc': [28, ['pointer', ['void']]],
    'pfnMenuWndProc': [8, ['pointer', ['void']]],
    'pfnListBoxWndProc': [48, ['pointer', ['void']]],
    'pfnDispatchMessage': [84, ['pointer', ['void']]],
    'pfnDefWindowProc': [16, ['pointer', ['void']]],
    'pfnMDIActivateDlgProc': [88, ['pointer', ['void']]],
    }],
'_THRDESKHEAD': [0x14, {
    'h': [0, ['pointer', ['void']]],
    'pSelf': [16, ['pointer', ['unsigned char']]],
    'rpdesk': [12, ['pointer', ['tagDESKTOP']]],
    'pti': [8, ['pointer', ['tagTHREADINFO']]],
    'cLockObj': [4, ['unsigned long']],
    }],
'tagSVR_INSTANCE_INFO': [0x20, {
    'head': [0, ['_THROBJHEAD']],
    'next': [12, ['pointer', ['tagSVR_INSTANCE_INFO']]],
    'nextInThisThread': [16, ['pointer', ['tagSVR_INSTANCE_INFO']]],
    'spwndEvent': [24, ['pointer', ['tagWND']]],
    'afCmd': [20, ['unsigned long']],
    'pcii': [28, ['pointer', ['void']]],
    }],
'_D3DKMDT_MONITOR_SOURCE_MODE': [0x4c, {
    'Origin': [68, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MCO_UNINITIALIZED', 1: 'D3DKMDT_MCO_DEFAULTMONITORPROFILE', 2: 'D3DKMDT_MCO_MONITORDESCRIPTOR', 3: 'D3DKMDT_MCO_MONITORDESCRIPTOR_REGISTRYOVERRIDE', 4: 'D3DKMDT_MCO_SPECIFICCAP_REGISTRYOVERRIDE', 5: 'D3DKMDT_MCO_MAXVALID'}}]],
    'VideoSignalInfo': [4, ['_D3DKMDT_VIDEO_SIGNAL_INFO']],
    'ColorCoeffDynamicRanges': [52, ['_D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES']],
    'Preference': [72, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MP_UNINITIALIZED', 1: 'D3DKMDT_MP_PREFERRED', 2: 'D3DKMDT_MP_MAXVALID'}}]],
    'Id': [0, ['unsigned long']],
    'ColorBasis': [48, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_CB_UNINITIALIZED', 1: 'D3DKMDT_CB_INTENSITY', 2: 'D3DKMDT_CB_SRGB', 3: 'D3DKMDT_CB_SCRGB', 4: 'D3DKMDT_CB_YCBCR', 5: 'D3DKMDT_CB_MAXVALID'}}]],
    }],
'VWPL': [0x10, {
    'fTagged': [12, ['long']],
    'cElem': [4, ['unsigned long']],
    'cThreshhold': [8, ['unsigned long']],
    'aElement': [16, ['array', 0, ['VWPLELEMENT']]],
    'cPwnd': [0, ['unsigned long']],
    }],
'tagCURSOR': [0x54, {
    'rt': [30, ['unsigned short']],
    'head': [0, ['_PROCMARKHEAD']],
    'hbmUserAlpha': [68, ['pointer', ['HBITMAP__']]],
    'cx': [76, ['unsigned long']],
    'xHotspot': [36, ['short']],
    'hbmColor': [44, ['pointer', ['HBITMAP__']]],
    'pcurNext': [16, ['pointer', ['tagCURSOR']]],
    'CURSORF_flags': [32, ['unsigned long']],
    'hbmMask': [40, ['pointer', ['HBITMAP__']]],
    'bpp': [72, ['unsigned long']],
    'cy': [80, ['unsigned long']],
    'strName': [20, ['_UNICODE_STRING']],
    'rcBounds': [52, ['tagRECT']],
    'atomModName': [28, ['unsigned short']],
    'hbmAlpha': [48, ['pointer', ['HBITMAP__']]],
    'yHotspot': [38, ['short']],
    }],
'__unnamed_1202': [0x4, {
    'IoResourceRequirementList': [0, ['pointer', ['_IO_RESOURCE_REQUIREMENTS_LIST']]],
    }],
'__unnamed_1206': [0x1, {
    'Lock': [0, ['unsigned char']],
    }],
'__unnamed_1204': [0x10, {
    'Buffer': [4, ['pointer', ['void']]],
    'WhichSpace': [0, ['unsigned long']],
    'Length': [12, ['unsigned long']],
    'Offset': [8, ['unsigned long']],
    }],
'HKL__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagDCE': [0x30, {
    'hrgnClipPublic': [24, ['pointer', ['HRGN__']]],
    'pdceNext': [0, ['pointer', ['tagDCE']]],
    'hrgnSavedVis': [28, ['pointer', ['HRGN__']]],
    'pwndRedirect': [16, ['pointer', ['tagWND']]],
    'pMonitor': [44, ['pointer', ['tagMONITOR']]],
    'ppiOwner': [40, ['pointer', ['tagPROCESSINFO']]],
    'pwndOrg': [8, ['pointer', ['tagWND']]],
    'hrgnClip': [20, ['pointer', ['HRGN__']]],
    'hdc': [4, ['pointer', ['HDC__']]],
    'ptiOwner': [36, ['pointer', ['tagTHREADINFO']]],
    'DCX_flags': [32, ['unsigned long']],
    'pwndClip': [12, ['pointer', ['tagWND']]],
    }],
'tagPROCESS_HID_REQUEST': [0x18, {
    'link': [0, ['_LIST_ENTRY']],
    'fExclusiveOrphaned': [12, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'spwndTarget': [20, ['pointer', ['tagWND']]],
    'fSinkable': [12, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'pTLCInfo': [16, ['pointer', ['tagHID_TLC_INFO']]],
    'fDevNotify': [12, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'fExSinkable': [12, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'usUsage': [10, ['unsigned short']],
    'ptr': [16, ['pointer', ['void']]],
    'pPORequest': [16, ['pointer', ['tagHID_PAGEONLY_REQUEST']]],
    'usUsagePage': [8, ['unsigned short']],
    }],
'tagWOWTHREADINFO': [0x18, {
    'pwtiNext': [0, ['pointer', ['tagWOWTHREADINFO']]],
    'pIdleEvent': [16, ['pointer', ['_KEVENT']]],
    'idParentProcess': [12, ['unsigned long']],
    'fAssigned': [20, ['long']],
    'idWaitObject': [8, ['unsigned long']],
    'idTask': [4, ['unsigned long']],
    }],
'__unnamed_11bb': [0x28, {
    'AuxiliaryBuffer': [20, ['pointer', ['unsigned char']]],
    'Thread': [16, ['pointer', ['_ETHREAD']]],
    'OriginalFileObject': [36, ['pointer', ['_FILE_OBJECT']]],
    'DeviceQueueEntry': [0, ['_KDEVICE_QUEUE_ENTRY']],
    'PacketType': [32, ['unsigned long']],
    'CurrentStackLocation': [32, ['pointer', ['_IO_STACK_LOCATION']]],
    'ListEntry': [24, ['_LIST_ENTRY']],
    'DriverContext': [0, ['array', 4, ['pointer', ['void']]]],
    }],
'__unnamed_11be': [0x30, {
    'Apc': [0, ['_KAPC']],
    'CompletionKey': [0, ['pointer', ['void']]],
    'Overlay': [0, ['__unnamed_11bb']],
    }],
'tagSBDATA': [0x10, {
    'posMax': [4, ['long']],
    'posMin': [0, ['long']],
    'page': [8, ['long']],
    'pos': [12, ['long']],
    }],
'tagIMEINFO': [0x1c, {
    'fdwProperty': [4, ['unsigned long']],
    'fdwSelectCaps': [24, ['unsigned long']],
    'fdwUICaps': [16, ['unsigned long']],
    'dwPrivateDataSize': [0, ['unsigned long']],
    'fdwSCSCaps': [20, ['unsigned long']],
    'fdwSentenceCaps': [12, ['unsigned long']],
    'fdwConversionCaps': [8, ['unsigned long']],
    }],
'_D3DKMDT_VIDPN_SOURCE_MODE': [0x28, {
    'Type': [4, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_RMT_UNINITIALIZED', 1: 'D3DKMDT_RMT_GRAPHICS', 2: 'D3DKMDT_RMT_TEXT'}}]],
    'Id': [0, ['unsigned long']],
    'Format': [8, ['__unnamed_17ff']],
    }],
'_PROCMARKHEAD': [0x10, {
    'h': [0, ['pointer', ['void']]],
    'ppi': [12, ['pointer', ['tagPROCESSINFO']]],
    'hTaskWow': [8, ['unsigned long']],
    'cLockObj': [4, ['unsigned long']],
    }],
'tagKBDFILE': [0x5c, {
    'head': [0, ['_HEAD']],
    'awchDllName': [28, ['array', 32, ['wchar']]],
    'pKbdTbl': [16, ['pointer', ['tagKbdLayer']]],
    'pkfNext': [8, ['pointer', ['tagKBDFILE']]],
    'pKbdNlsTbl': [24, ['pointer', ['tagKbdNlsLayer']]],
    'hBase': [12, ['pointer', ['void']]],
    'Size': [20, ['unsigned long']],
    }],
'tagCLIENTINFO': [0x8c, {
    'msgDbcsCB': [108, ['tagMSG']],
    'dwCompatFlags': [12, ['unsigned long']],
    'achDbcsCF': [106, ['array', 2, ['unsigned char']]],
    'dwTIFlags': [20, ['unsigned long']],
    'pClientThreadInfo': [60, ['pointer', ['tagCLIENTTHREADINFO']]],
    'CodePage': [104, ['unsigned short']],
    'dwKeyCache': [68, ['unsigned long']],
    'dwHookCurrent': [52, ['unsigned long']],
    'afAsyncKeyStateRecentDown': [92, ['array', 8, ['unsigned char']]],
    'dwCompatFlags2': [16, ['unsigned long']],
    'fsHooks': [36, ['unsigned long']],
    'ulClientDelta': [28, ['unsigned long']],
    'pDeskInfo': [24, ['pointer', ['tagDESKTOPINFO']]],
    'dwExpWinVer': [8, ['unsigned long']],
    'dwHookData': [64, ['unsigned long']],
    'afAsyncKeyState': [84, ['array', 8, ['unsigned char']]],
    'CallbackWnd': [40, ['_CALLBACKWND']],
    'lpdwRegisteredClasses': [136, ['pointer', ['unsigned long']]],
    'cInDDEMLCallback': [56, ['long']],
    'cSpins': [4, ['unsigned long']],
    'hKL': [100, ['pointer', ['HKL__']]],
    'dwAsyncKeyCache': [80, ['unsigned long']],
    'afKeyState': [72, ['array', 8, ['unsigned char']]],
    'CI_flags': [0, ['unsigned long']],
    'phkCurrent': [32, ['pointer', ['tagHOOK']]],
    }],
'tagCLS': [0x5c, {
    'spcur': [72, ['pointer', ['tagCURSOR']]],
    'cbwndExtra': [60, ['long']],
    'pclsClone': [40, ['pointer', ['tagCLS']]],
    'lpszClientAnsiMenuName': [24, ['pointer', ['unsigned char']]],
    'pclsBase': [36, ['pointer', ['tagCLS']]],
    'atomNVClassName': [6, ['unsigned short']],
    'style': [48, ['unsigned long']],
    'pclsNext': [0, ['pointer', ['tagCLS']]],
    'CSF_flags': [22, ['unsigned short']],
    'lpfnWndProc': [52, ['pointer', ['void']]],
    'lpszAnsiClassName': [84, ['pointer', ['unsigned char']]],
    'spcpdFirst': [32, ['pointer', ['_CALLPROCDATA']]],
    'lpszClientUnicodeMenuName': [28, ['pointer', ['unsigned short']]],
    'cbclsExtra': [56, ['long']],
    'lpszMenuName': [80, ['pointer', ['unsigned short']]],
    'spicnSm': [88, ['pointer', ['tagCURSOR']]],
    'hTaskWow': [20, ['unsigned short']],
    'cWndReferenceCount': [44, ['long']],
    'hbrBackground': [76, ['pointer', ['HBRUSH__']]],
    'spicn': [68, ['pointer', ['tagCURSOR']]],
    'fnid': [8, ['unsigned short']],
    'pdce': [16, ['pointer', ['tagDCE']]],
    'hModule': [64, ['pointer', ['void']]],
    'rpdeskParent': [12, ['pointer', ['tagDESKTOP']]],
    'atomClassName': [4, ['unsigned short']],
    }],
'_DMM_VIDPN_SERIALIZATION': [0xc, {
    'PathsFromSourceSerializationOffsets': [8, ['array', 1, ['unsigned long']]],
    'NumActiveSources': [4, ['unsigned char']],
    'Size': [0, ['unsigned long']],
    }],
'tagHID_PAGEONLY_REQUEST': [0x10, {
    'usUsagePage': [8, ['unsigned short']],
    'link': [0, ['_LIST_ENTRY']],
    'cRefCount': [12, ['unsigned long']],
    }],
'tagWINDOWSTATION': [0x58, {
    'pClipBase': [44, ['pointer', ['tagCLIP']]],
    'dwSessionId': [0, ['unsigned long']],
    'cNumClipFormats': [48, ['unsigned long']],
    'luidUser': [76, ['_LUID']],
    'pGlobalAtomTable': [64, ['pointer', ['void']]],
    'ptiClipLock': [24, ['pointer', ['tagTHREADINFO']]],
    'dwWSF_Flags': [16, ['unsigned long']],
    'rpdeskList': [8, ['pointer', ['tagDESKTOP']]],
    'spklList': [20, ['pointer', ['tagKL']]],
    'spwndClipOpen': [32, ['pointer', ['tagWND']]],
    'luidEndSession': [68, ['_LUID']],
    'pTerm': [12, ['pointer', ['tagTERMINAL']]],
    'rpwinstaNext': [4, ['pointer', ['tagWINDOWSTATION']]],
    'spwndClipboardListener': [60, ['pointer', ['tagWND']]],
    'spwndClipViewer': [36, ['pointer', ['tagWND']]],
    'iClipSequenceNumber': [56, ['unsigned long']],
    'ptiDrawingClipboard': [28, ['pointer', ['tagTHREADINFO']]],
    'spwndClipOwner': [40, ['pointer', ['tagWND']]],
    'psidUser': [84, ['pointer', ['void']]],
    'iClipSerialNumber': [52, ['unsigned long']],
    }],
'__unnamed_11e4': [0x10, {
    'Type3InputBuffer': [12, ['pointer', ['void']]],
    'OutputBufferLength': [0, ['unsigned long']],
    'IoControlCode': [8, ['unsigned long']],
    'InputBufferLength': [4, ['unsigned long']],
    }],
'__unnamed_11e2': [0x10, {
    'Length': [0, ['pointer', ['_LARGE_INTEGER']]],
    'ByteOffset': [8, ['_LARGE_INTEGER']],
    'Key': [4, ['unsigned long']],
    }],
'__unnamed_163c': [0x8, {
    'Attrib': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'WCA_UNDEFINED', 1: 'WCA_NCRENDERING_ENABLED', 2: 'WCA_NCRENDERING_POLICY', 3: 'WCA_TRANSITIONS_FORCEDISABLED', 4: 'WCA_ALLOW_NCPAINT', 5: 'WCA_CAPTION_BUTTON_BOUNDS', 6: 'WCA_NONCLIENT_RTL_LAYOUT', 7: 'WCA_FORCE_ICONIC_REPRESENTATION', 8: 'WCA_FLIP3D_POLICY', 9: 'WCA_EXTENDED_FRAME_BOUNDS', 10: 'WCA_HAS_ICONIC_BITMAP', 11: 'WCA_THEME_ATTRIBUTES', 12: 'WCA_NCRENDERING_EXILED', 13: 'WCA_NCADORNMENTINFO', 14: 'WCA_EXCLUDED_FROM_LIVEPREVIEW', 15: 'WCA_VIDEO_OVERLAY_ACTIVE', 16: 'WCA_FORCE_ACTIVEWINDOW_APPEARANCE', 17: 'WCA_DISALLOW_PEEK', 18: 'WCA_LAST'}}]],
    'cbData': [4, ['unsigned long']],
    }],
'__unnamed_11e8': [0x8, {
    'SecurityInformation': [0, ['unsigned long']],
    'SecurityDescriptor': [4, ['pointer', ['void']]],
    }],
'tagPROFILEVALUEINFO': [0xc, {
    'dwValue': [0, ['unsigned long']],
    'uSection': [4, ['unsigned long']],
    'pwszKeyName': [8, ['pointer', ['wchar']]],
    }],
'__unnamed_11ec': [0x8, {
    'DeviceObject': [4, ['pointer', ['_DEVICE_OBJECT']]],
    'Vpb': [0, ['pointer', ['_VPB']]],
    }],
'_DMM_MONITOR_SERIALIZATION': [0x28, {
    'FrequencyRangeSetOffset': [28, ['unsigned long']],
    'ModePruningAlgorithm': [16, ['Enumeration', {'target': 'long', 'choices': {0: 'DMM_MPA_UNINITIALIZED', 1: 'DMM_MPA_GDI', 2: 'DMM_MPA_VISTA', 3: 'DMM_MPA_MAXVALID'}}]],
    'VideoPresentTargetId': [4, ['unsigned long']],
    'IsSimulatedMonitor': [12, ['unsigned char']],
    'SourceModeSetOffset': [24, ['unsigned long']],
    'Orientation': [8, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MO_UNINITIALIZED', 1: 'D3DKMDT_MO_0DEG', 2: 'D3DKMDT_MO_90DEG', 3: 'D3DKMDT_MO_180DEG', 4: 'D3DKMDT_MO_270DEG'}}]],
    'DescriptorSetOffset': [32, ['unsigned long']],
    'MonitorPowerState': [20, ['Enumeration', {'target': 'long', 'choices': {0: 'PowerDeviceUnspecified', 1: 'PowerDeviceD0', 2: 'PowerDeviceD1', 3: 'PowerDeviceD2', 4: 'PowerDeviceD3', 5: 'PowerDeviceMaximum'}}]],
    'IsUsingDefaultProfile': [13, ['unsigned char']],
    'MonitorType': [36, ['Enumeration', {'target': 'long', 'choices': {0: 'DMM_VMT_UNINITIALIZED', 1: 'DMM_VMT_PHYSICAL_MONITOR', 2: 'DMM_VMT_BOOT_PERSISTENT_MONITOR', 3: 'DMM_VMT_PERSISTENT_MONITOR', 4: 'DMM_VMT_TEMPORARY_MONITOR', 5: 'DMM_VMT_SIMULATED_MONITOR'}}]],
    'Size': [0, ['unsigned long']],
    }],
'_WNDMSG': [0x8, {
    'abMsgs': [4, ['pointer', ['unsigned char']]],
    'maxMsgs': [0, ['unsigned long']],
    }],
'tagTDB': [0x18, {
    'pti': [12, ['pointer', ['tagTHREADINFO']]],
    'TDB_Flags': [22, ['unsigned short']],
    'hTaskWow': [20, ['unsigned short']],
    'pwti': [16, ['pointer', ['tagWOWTHREADINFO']]],
    'nEvents': [4, ['long']],
    'nPriority': [8, ['long']],
    'ptdbNext': [0, ['pointer', ['tagTDB']]],
    }],
'_LIGATURE1': [0x6, {
    'wch': [4, ['array', 1, ['wchar']]],
    'VirtualKey': [0, ['unsigned char']],
    'ModificationNumber': [2, ['unsigned short']],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH': [0x15c, {
    'GammaRamp': [336, ['_D3DKMDT_GAMMA_RAMP']],
    'VidPnSourceId': [0, ['unsigned long']],
    'Content': [64, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VPPC_UNINITIALIZED', 1: 'D3DKMDT_VPPC_GRAPHICS', 2: 'D3DKMDT_VPPC_VIDEO', 255: 'D3DKMDT_VPPC_NOTSPECIFIED'}}]],
    'VisibleFromActiveBROffset': [36, ['_D3DKMDT_2DREGION']],
    'VidPnTargetColorBasis': [44, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_CB_UNINITIALIZED', 1: 'D3DKMDT_CB_INTENSITY', 2: 'D3DKMDT_CB_SRGB', 3: 'D3DKMDT_CB_SCRGB', 4: 'D3DKMDT_CB_YCBCR', 5: 'D3DKMDT_CB_MAXVALID'}}]],
    'ContentTransformation': [12, ['_D3DKMDT_VIDPN_PRESENT_PATH_TRANSFORMATION']],
    'VidPnTargetId': [4, ['unsigned long']],
    'VisibleFromActiveTLOffset': [28, ['_D3DKMDT_2DREGION']],
    'CopyProtection': [68, ['_D3DKMDT_VIDPN_PRESENT_PATH_COPYPROTECTION']],
    'VidPnTargetColorCoeffDynamicRanges': [48, ['_D3DKMDT_COLOR_COEFF_DYNAMIC_RANGES']],
    'ImportanceOrdinal': [8, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VPPI_UNINITIALIZED', 1: 'D3DKMDT_VPPI_PRIMARY', 2: 'D3DKMDT_VPPI_SECONDARY', 3: 'D3DKMDT_VPPI_TERTIARY', 4: 'D3DKMDT_VPPI_QUATERNARY', 5: 'D3DKMDT_VPPI_QUINARY', 6: 'D3DKMDT_VPPI_SENARY', 7: 'D3DKMDT_VPPI_SEPTENARY', 8: 'D3DKMDT_VPPI_OCTONARY', 9: 'D3DKMDT_VPPI_NONARY', 10: 'D3DKMDT_VPPI_DENARY', 32: 'D3DKMDT_VPPI_MAX', 255: 'D3DKMDT_VPPI_NOTSPECIFIED'}}]],
    }],
'_PROCDESKHEAD': [0x14, {
    'h': [0, ['pointer', ['void']]],
    'pSelf': [16, ['pointer', ['unsigned char']]],
    'rpdesk': [12, ['pointer', ['tagDESKTOP']]],
    'hTaskWow': [8, ['unsigned long']],
    'cLockObj': [4, ['unsigned long']],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH_ROTATION_SUPPORT': [0x4, {
    'Rotate270': [0, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'Rotate90': [0, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'Identity': [0, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'Rotate180': [0, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    }],
'_CONSOLE_CARET_INFO': [0x14, {
    'hwnd': [0, ['pointer', ['HWND__']]],
    'rc': [4, ['tagRECT']],
    }],
'tagPROCESSINFO': [0x1b0, {
    'fHasMagContext': [412, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'hwinsta': [324, ['pointer', ['HWINSTA__']]],
    'ptiList': [144, ['pointer', ['tagTHREADINFO']]],
    'pHidTable': [420, ['pointer', ['tagPROCESS_HID_TABLE']]],
    'W32PF_Flags': [8, ['unsigned long']],
    'UserHandleCount': [44, ['long']],
    'dwhmodLibLoadedMask': [188, ['unsigned long']],
    'GDIBrushAttrFreeList': [120, ['_LIST_ENTRY']],
    'hdeskStartup': [180, ['pointer', ['HDESK__']]],
    'dwImeCompatFlags': [372, ['unsigned long']],
    'dwRegisteredClasses': [424, ['unsigned long']],
    'pBrushAttrList': [28, ['pointer', ['void']]],
    'usi': [384, ['tagUSERSTARTUPINFO']],
    'InputIdleEvent': [12, ['pointer', ['_KEVENT']]],
    'W32Pid': [32, ['unsigned long']],
    'bmHandleFlags': [348, ['_RTL_BITMAP']],
    'UserHandleCountPeak': [48, ['unsigned long']],
    'GDIEngUserMemAllocTable': [56, ['_RTL_AVL_TABLE']],
    'cSysExpunge': [184, ['unsigned long']],
    'pdvList': [340, ['pointer', ['tagDESKTOPVIEW']]],
    'pwpi': [164, ['pointer', ['tagWOWPROCESSINFO']]],
    'ppiNextRunning': [172, ['pointer', ['tagPROCESSINFO']]],
    'Process': [0, ['pointer', ['_EPROCESS']]],
    'pCursorCache': [356, ['pointer', ['tagCURSOR']]],
    'pClientBase': [360, ['pointer', ['void']]],
    'dwLpkEntryPoints': [364, ['unsigned long']],
    'GDIDcAttrFreeList': [112, ['_LIST_ENTRY']],
    'DxProcess': [140, ['pointer', ['void']]],
    'NextStart': [20, ['pointer', ['_W32PROCESS']]],
    'RefCount': [4, ['unsigned long']],
    'dwLayout': [416, ['unsigned long']],
    'pclsPublicList': [160, ['pointer', ['tagCLS']]],
    'Unused': [412, ['BitField', {'end_bit': 32, 'start_bit': 1}]],
    'GDIPushLock': [52, ['_EX_PUSH_LOCK']],
    'hMonitor': [336, ['pointer', ['HMONITOR__']]],
    'ptiMainThread': [148, ['pointer', ['tagTHREADINFO']]],
    'pvwplWndGCList': [428, ['pointer', ['VWPL']]],
    'pW32Job': [368, ['pointer', ['tagW32JOB']]],
    'luidSession': [376, ['_LUID']],
    'GDIHandleCount': [36, ['long']],
    'cThreads': [176, ['unsigned long']],
    'rpdeskStartup': [152, ['pointer', ['tagDESKTOP']]],
    'hSecureGdiSharedHandleTable': [136, ['pointer', ['void']]],
    'pclsPrivateList': [156, ['pointer', ['tagCLS']]],
    'GDIHandleCountPeak': [40, ['unsigned long']],
    'StartCursorHideTime': [16, ['unsigned long']],
    'ppiNext': [168, ['pointer', ['tagPROCESSINFO']]],
    'Flags': [412, ['unsigned long']],
    'dwHotkey': [332, ['unsigned long']],
    'amwinsta': [328, ['unsigned long']],
    'rpwinsta': [320, ['pointer', ['tagWINDOWSTATION']]],
    'ahmodLibLoaded': [192, ['array', 32, ['pointer', ['void']]]],
    'iClipSerialNumber': [344, ['unsigned long']],
    'GDIW32PIDLockedBitmaps': [128, ['_LIST_ENTRY']],
    'pDCAttrList': [24, ['pointer', ['void']]],
    }],
'_DMM_COMMITVIDPNREQUEST_SERIALIZATION': [0x1c, {
    'RequestDiagInfo': [4, ['_DMM_COMMITVIDPNREQUEST_DIAGINFO']],
    'AffectedVidPnSourceId': [0, ['unsigned long']],
    'VidPnSerialization': [16, ['_DMM_VIDPN_SERIALIZATION']],
    }],
'tagKbdLayer': [0x3c, {
    'pVkToWcharTable': [4, ['pointer', ['_VK_TO_WCHAR_TABLE']]],
    'pusVSCtoVK': [24, ['pointer', ['unsigned short']]],
    'fLocaleFlags': [40, ['unsigned long']],
    'pKeyNamesExt': [16, ['pointer', ['VSC_LPWSTR']]],
    'dwSubType': [56, ['unsigned long']],
    'pDeadKey': [8, ['pointer', ['DEADKEY']]],
    'pCharModifiers': [0, ['pointer', ['MODIFIERS']]],
    'pKeyNamesDead': [20, ['pointer', ['pointer', ['unsigned short']]]],
    'bMaxVSCtoVK': [28, ['unsigned char']],
    'pKeyNames': [12, ['pointer', ['VSC_LPWSTR']]],
    'dwType': [52, ['unsigned long']],
    'pLigature': [48, ['pointer', ['_LIGATURE1']]],
    'nLgMax': [44, ['unsigned char']],
    'pVSCtoVK_E1': [36, ['pointer', ['_VSC_VK']]],
    'pVSCtoVK_E0': [32, ['pointer', ['_VSC_VK']]],
    'cbLgEntry': [45, ['unsigned char']],
    }],
'HDC__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagWin32AllocStats': [0x14, {
    'dwMaxAlloc': [8, ['unsigned long']],
    'pHead': [16, ['pointer', ['tagWin32PoolHead']]],
    'dwMaxMem': [0, ['unsigned long']],
    'dwCrtMem': [4, ['unsigned long']],
    'dwCrtAlloc': [12, ['unsigned long']],
    }],
'_D3DKMDT_VIDPN_PRESENT_PATH_SCALING_SUPPORT': [0x4, {
    'Centered': [0, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'AspectRatioCenteredMax': [0, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'Stretched': [0, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'Identity': [0, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'Custom': [0, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    }],
'tagMSG': [0x1c, {
    'wParam': [8, ['unsigned long']],
    'lParam': [12, ['long']],
    'pt': [20, ['tagPOINT']],
    'hwnd': [0, ['pointer', ['HWND__']]],
    'time': [16, ['unsigned long']],
    'message': [4, ['unsigned long']],
    }],
'__unnamed_11a5': [0x4, {
    'IrpCount': [0, ['long']],
    'SystemBuffer': [0, ['pointer', ['void']]],
    'MasterIrp': [0, ['pointer', ['_IRP']]],
    }],
'_DMM_VIDPNSET_SERIALIZATION': [0x8, {
    'VidPnOffset': [4, ['array', 1, ['unsigned long']]],
    'NumVidPns': [0, ['unsigned char']],
    }],
'tagWOWPROCESSINFO': [0x28, {
    'ptdbHead': [8, ['pointer', ['tagTDB']]],
    'lpfnWowExitTask': [12, ['pointer', ['void']]],
    'CSOwningThread': [32, ['pointer', ['tagTHREADINFO']]],
    'ptiScheduled': [4, ['pointer', ['tagTHREADINFO']]],
    'nSendLock': [24, ['unsigned long']],
    'nRecvLock': [28, ['unsigned long']],
    'CSLockCount': [36, ['long']],
    'hEventWowExecClient': [20, ['pointer', ['void']]],
    'pwpiNext': [0, ['pointer', ['tagWOWPROCESSINFO']]],
    'pEventWowExec': [16, ['pointer', ['_KEVENT']]],
    }],
'__unnamed_177b': [0xc, {
    'Data': [0, ['array', 3, ['unsigned long']]],
    }],
'tagMENU': [0x6c, {
    'iItem': [24, ['long']],
    'head': [0, ['_PROCDESKHEAD']],
    'umpm': [88, ['tagUAHMENUPOPUPMETRICS']],
    'cItems': [32, ['unsigned long']],
    'pParentMenus': [56, ['pointer', ['tagMENULIST']]],
    'fFlags': [20, ['unsigned long']],
    'cxMenu': [36, ['unsigned long']],
    'dwContextHelpId': [60, ['unsigned long']],
    'hbrBack': [72, ['pointer', ['HBRUSH__']]],
    'cxTextAlign': [44, ['unsigned long']],
    'cAlloced': [28, ['unsigned long']],
    'spwndNotify': [48, ['pointer', ['tagWND']]],
    'dwArrowsOn': [84, ['BitField', {'end_bit': 2, 'start_bit': 0}]],
    'iMaxTop': [80, ['long']],
    'dwMenuData': [68, ['unsigned long']],
    'cyMenu': [40, ['unsigned long']],
    'rgItems': [52, ['pointer', ['tagITEM']]],
    'iTop': [76, ['long']],
    'cyMax': [64, ['unsigned long']],
    }],
'__unnamed_177f': [0xc, {
    'DataSize': [0, ['unsigned long']],
    'Reserved1': [4, ['unsigned long']],
    'Reserved2': [8, ['unsigned long']],
    }],
'__unnamed_177d': [0xc, {
    'Start': [0, ['unsigned long']],
    'Length': [4, ['unsigned long']],
    'Reserved': [8, ['unsigned long']],
    }],
'tagPOPUPMENU': [0x30, {
    'fUseMonitorRect': [0, ['BitField', {'end_bit': 29, 'start_bit': 28}]],
    'fDroppedLeft': [0, ['BitField', {'end_bit': 5, 'start_bit': 4}]],
    'fHierarchyDropped': [0, ['BitField', {'end_bit': 6, 'start_bit': 5}]],
    'posDropped': [44, ['unsigned long']],
    'spwndNextPopup': [12, ['pointer', ['tagWND']]],
    'fIsMenuBar': [0, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'spwndPrevPopup': [16, ['pointer', ['tagWND']]],
    'fHasMenuBar': [0, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'spwndActivePopup': [28, ['pointer', ['tagWND']]],
    'fTrackMouseEvent': [0, ['BitField', {'end_bit': 21, 'start_bit': 20}]],
    'fNoNotify': [0, ['BitField', {'end_bit': 12, 'start_bit': 11}]],
    'posSelectedItem': [40, ['unsigned long']],
    'fIsSysMenu': [0, ['BitField', {'end_bit': 3, 'start_bit': 2}]],
    'fFlushDelayedFree': [0, ['BitField', {'end_bit': 18, 'start_bit': 17}]],
    'ppmDelayedFree': [36, ['pointer', ['tagPOPUPMENU']]],
    'fFreed': [0, ['BitField', {'end_bit': 19, 'start_bit': 18}]],
    'fSynchronous': [0, ['BitField', {'end_bit': 9, 'start_bit': 8}]],
    'fDropNextPopup': [0, ['BitField', {'end_bit': 11, 'start_bit': 10}]],
    'fRightButton': [0, ['BitField', {'end_bit': 7, 'start_bit': 6}]],
    'spmenuAlternate': [24, ['pointer', ['tagMENU']]],
    'spmenu': [20, ['pointer', ['tagMENU']]],
    'spwndPopupMenu': [8, ['pointer', ['tagWND']]],
    'fDestroyed': [0, ['BitField', {'end_bit': 16, 'start_bit': 15}]],
    'iDropDir': [0, ['BitField', {'end_bit': 28, 'start_bit': 23}]],
    'ppopupmenuRoot': [32, ['pointer', ['tagPOPUPMENU']]],
    'fFirstClick': [0, ['BitField', {'end_bit': 10, 'start_bit': 9}]],
    'spwndNotify': [4, ['pointer', ['tagWND']]],
    'fRtoL': [0, ['BitField', {'end_bit': 23, 'start_bit': 22}]],
    'fIsTrackPopup': [0, ['BitField', {'end_bit': 4, 'start_bit': 3}]],
    'fSendUninit': [0, ['BitField', {'end_bit': 22, 'start_bit': 21}]],
    'fShowTimer': [0, ['BitField', {'end_bit': 14, 'start_bit': 13}]],
    'fInCancel': [0, ['BitField', {'end_bit': 20, 'start_bit': 19}]],
    'fToggle': [0, ['BitField', {'end_bit': 8, 'start_bit': 7}]],
    'fDelayedFree': [0, ['BitField', {'end_bit': 17, 'start_bit': 16}]],
    'fHideTimer': [0, ['BitField', {'end_bit': 15, 'start_bit': 14}]],
    'fAboutToHide': [0, ['BitField', {'end_bit': 13, 'start_bit': 12}]],
    }],
'_DMM_MONITORDESCRIPTOR_SERIALIZATION': [0x8c, {
    'Origin': [8, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MCO_UNINITIALIZED', 1: 'D3DKMDT_MCO_DEFAULTMONITORPROFILE', 2: 'D3DKMDT_MCO_MONITORDESCRIPTOR', 3: 'D3DKMDT_MCO_MONITORDESCRIPTOR_REGISTRYOVERRIDE', 4: 'D3DKMDT_MCO_SPECIFICCAP_REGISTRYOVERRIDE', 5: 'D3DKMDT_MCO_MAXVALID'}}]],
    'Data': [12, ['array', 128, ['unsigned char']]],
    'Type': [4, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MDT_UNINITIALIZED', 1: 'D3DKMDT_MDT_VESA_EDID_V1_BASEBLOCK', 2: 'D3DKMDT_MDT_VESA_EDID_V1_BLOCKMAP', 255: 'D3DKMDT_MDT_OTHER'}}]],
    'Id': [0, ['unsigned long']],
    }],
'__unnamed_1779': [0xc, {
    'Reserved1': [8, ['unsigned long']],
    'Port': [4, ['unsigned long']],
    'Channel': [0, ['unsigned long']],
    }],
'HTOUCHINPUT__': [0x4, {
    'unused': [0, ['long']],
    }],
'__unnamed_1773': [0xc, {
    'Affinity': [8, ['unsigned long']],
    'Vector': [4, ['unsigned long']],
    'Group': [2, ['unsigned short']],
    'Level': [0, ['unsigned short']],
    }],
'_VK_VALUES_STRINGS': [0x8, {
    'fReserved': [4, ['unsigned char']],
    'pszMultiNames': [0, ['pointer', ['unsigned char']]],
    }],
'__unnamed_1771': [0xc, {
    'Start': [0, ['_LARGE_INTEGER']],
    'Length': [8, ['unsigned long']],
    }],
'_DMM_MONITOR_SOURCE_MODE_SERIALIZATION': [0x50, {
    'Info': [0, ['_D3DKMDT_MONITOR_SOURCE_MODE']],
    'TimingType': [76, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MTT_UNINITIALIZED', 1: 'D3DKMDT_MTT_ESTABLISHED', 2: 'D3DKMDT_MTT_STANDARD', 3: 'D3DKMDT_MTT_EXTRASTANDARD', 4: 'D3DKMDT_MTT_DETAILED', 5: 'D3DKMDT_MTT_DEFAULTMONITORPROFILE', 6: 'D3DKMDT_MTT_MAXVALID'}}]],
    }],
'__unnamed_1775': [0xc, {
    'Affinity': [8, ['unsigned long']],
    'Vector': [4, ['unsigned long']],
    'Group': [0, ['unsigned short']],
    'MessageCount': [2, ['unsigned short']],
    }],
'__unnamed_11ac': [0x8, {
    'AsynchronousParameters': [0, ['__unnamed_11aa']],
    'AllocationSize': [0, ['_LARGE_INTEGER']],
    }],
'__unnamed_11aa': [0x8, {
    'UserApcContext': [4, ['pointer', ['void']]],
    'UserApcRoutine': [0, ['pointer', ['void']]],
    'IssuingProcess': [0, ['pointer', ['void']]],
    }],
'tagSBCALC': [0x40, {
    'posMax': [4, ['long']],
    'pxThumbTop': [52, ['long']],
    'pxThumbBottom': [48, ['long']],
    'cpxThumb': [32, ['long']],
    'pxMin': [60, ['long']],
    'pxStart': [44, ['long']],
    'pxDownArrow': [40, ['long']],
    'pos': [12, ['long']],
    'cpx': [56, ['long']],
    'pxBottom': [20, ['long']],
    'pxTop': [16, ['long']],
    'pxLeft': [24, ['long']],
    'pxRight': [28, ['long']],
    'pxUpArrow': [36, ['long']],
    'posMin': [0, ['long']],
    'page': [8, ['long']],
    }],
'HIMC__': [0x4, {
    'unused': [0, ['long']],
    }],
'tagSBINFO': [0x24, {
    'WSBflags': [0, ['long']],
    'Horz': [4, ['tagSBDATA']],
    'Vert': [20, ['tagSBDATA']],
    }],
'__unnamed_1213': [0x8, {
    'Type': [4, ['Enumeration', {'target': 'long', 'choices': {0: 'DeviceUsageTypeUndefined', 1: 'DeviceUsageTypePaging', 2: 'DeviceUsageTypeHibernation', 3: 'DeviceUsageTypeDumpFile'}}]],
    'Reserved': [1, ['array', 3, ['unsigned char']]],
    'InPath': [0, ['unsigned char']],
    }],
'tagITEM': [0x6c, {
    'ulX': [56, ['unsigned long']],
    'wID': [8, ['unsigned long']],
    'dwItemData': [32, ['unsigned long']],
    'cyItem': [48, ['unsigned long']],
    'hbmpChecked': [16, ['pointer', ['void']]],
    'xItem': [36, ['unsigned long']],
    'spSubMenu': [12, ['pointer', ['tagMENU']]],
    'hbmpUnchecked': [20, ['pointer', ['void']]],
    'fState': [4, ['unsigned long']],
    'dxTab': [52, ['unsigned long']],
    'hbmp': [64, ['pointer', ['HBITMAP__']]],
    'yItem': [40, ['unsigned long']],
    'fType': [0, ['unsigned long']],
    'umim': [76, ['tagUAHMENUITEMMETRICS']],
    'cch': [28, ['unsigned long']],
    'ulWidth': [60, ['unsigned long']],
    'cyBmp': [72, ['long']],
    'cxBmp': [68, ['long']],
    'lpstr': [24, ['pointer', ['unsigned short']]],
    'cxItem': [44, ['unsigned long']],
    }],
'__unnamed_11d9': [0x10, {
    'FileInformationClass': [4, ['Enumeration', {'target': 'long', 'choices': {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileAttributeCacheInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileMaximumInformation'}}]],
    'AdvanceOnly': [13, ['unsigned char']],
    'ClusterCount': [12, ['unsigned long']],
    'Length': [0, ['unsigned long']],
    'DeleteHandle': [12, ['pointer', ['void']]],
    'ReplaceIfExists': [12, ['unsigned char']],
    'FileObject': [8, ['pointer', ['_FILE_OBJECT']]],
    }],
'_VSC_VK': [0x4, {
    'Vsc': [0, ['unsigned char']],
    'Vk': [2, ['unsigned short']],
    }],
'_VK_TO_WCHARS1': [0x4, {
    'Attributes': [1, ['unsigned char']],
    'VirtualKey': [0, ['unsigned char']],
    'wch': [2, ['array', 1, ['wchar']]],
    }],
'__unnamed_121b': [0x4, {
    'PowerSequence': [0, ['pointer', ['_POWER_SEQUENCE']]],
    }],
'_DMM_MONITORFREQUENCYRANGESET_SERIALIZATION': [0x34, {
    'NumFrequencyRanges': [0, ['unsigned char']],
    'FrequencyRangeSerialization': [4, ['array', 1, ['_D3DKMDT_MONITOR_FREQUENCY_RANGE']]],
    }],
'_D3DKMDT_GAMMA_RAMP': [0xc, {
    'Data': [8, ['__unnamed_179f']],
    'DataSize': [4, ['unsigned long']],
    'Type': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DDDI_GAMMARAMP_UNINITIALIZED', 1: 'D3DDDI_GAMMARAMP_DEFAULT', 2: 'D3DDDI_GAMMARAMP_RGB256x3x16', 3: 'D3DDDI_GAMMARAMP_DXGI_1'}}]],
    }],
'_W32PROCESS': [0x90, {
    'GDIPushLock': [52, ['_EX_PUSH_LOCK']],
    'DxProcess': [140, ['pointer', ['void']]],
    'pBrushAttrList': [28, ['pointer', ['void']]],
    'Process': [0, ['pointer', ['_EPROCESS']]],
    'NextStart': [20, ['pointer', ['_W32PROCESS']]],
    'GDIW32PIDLockedBitmaps': [128, ['_LIST_ENTRY']],
    'RefCount': [4, ['unsigned long']],
    'StartCursorHideTime': [16, ['unsigned long']],
    'GDIBrushAttrFreeList': [120, ['_LIST_ENTRY']],
    'InputIdleEvent': [12, ['pointer', ['_KEVENT']]],
    'W32PF_Flags': [8, ['unsigned long']],
    'GDIHandleCount': [36, ['long']],
    'hSecureGdiSharedHandleTable': [136, ['pointer', ['void']]],
    'UserHandleCountPeak': [48, ['unsigned long']],
    'W32Pid': [32, ['unsigned long']],
    'UserHandleCount': [44, ['long']],
    'pDCAttrList': [24, ['pointer', ['void']]],
    'GDIEngUserMemAllocTable': [56, ['_RTL_AVL_TABLE']],
    'GDIHandleCountPeak': [40, ['unsigned long']],
    'GDIDcAttrFreeList': [112, ['_LIST_ENTRY']],
    }],
'tagSERVERINFO': [0xffc, {
    'uiShellMsg': [520, ['unsigned long']],
    'atomSysClass': [460, ['array', 25, ['unsigned short']]],
    'dtScroll': [2276, ['unsigned long']],
    'dwKeyCache': [2404, ['unsigned long']],
    'atomIconSmProp': [964, ['unsigned short']],
    'argbSystemUnmatched': [1876, ['array', 31, ['unsigned long']]],
    'atomContextHelpIdProp': [968, ['unsigned short']],
    'cySysFontChar': [2308, ['long']],
    'mpFnid_serverCBWndProc': [164, ['array', 31, ['unsigned short']]],
    'PUSIFlags': [3928, ['unsigned long']],
    'dtLBSearch': [2280, ['unsigned long']],
    'tmSysFont': [2312, ['tagTEXTMETRICW']],
    'ahbrSystem': [2124, ['array', 31, ['pointer', ['HBRUSH__']]]],
    'dwDefaultHeapSize': [516, ['unsigned long']],
    'dwSRVIFlags': [0, ['unsigned long']],
    'BitsPixel': [3925, ['unsigned char']],
    'wMaxLeftOverlapChars': [2296, ['long']],
    'dwLastSystemRITEventTickCountUpdate': [3940, ['unsigned long']],
    'dpiSystem': [2372, ['tagDPISERVERINFO']],
    'hIcoWindows': [2400, ['pointer', ['HICON__']]],
    'dwAsyncKeyCache': [2408, ['unsigned long']],
    'dwTagCount': [4084, ['unsigned long']],
    'adwDBGTAGFlags': [3944, ['array', 35, ['unsigned long']]],
    'aiSysMet': [1488, ['array', 97, ['long']]],
    'acAnsiToOem': [1228, ['array', 256, ['unsigned char']]],
    'aStoCidPfn': [136, ['array', 7, ['pointer', ['void']]]],
    'dwLastRITEventTickCount': [2268, ['unsigned long']],
    'cbHandleTable': [456, ['unsigned long']],
    'atomFrostedWindowProp': [970, ['unsigned short']],
    'ucWheelScrollLines': [2288, ['unsigned long']],
    'ptCursorReal': [2260, ['tagPOINT']],
    'ucWheelScrollChars': [2292, ['unsigned long']],
    'acOemToAnsi': [972, ['array', 256, ['unsigned char']]],
    'hbrGray': [2248, ['pointer', ['HBRUSH__']]],
    'BitCount': [3920, ['unsigned short']],
    'argbSystem': [2000, ['array', 31, ['unsigned long']]],
    'dtCaretBlink': [2284, ['unsigned long']],
    'dwInstalledEventHooks': [1484, ['unsigned long']],
    'cxSysFontChar': [2304, ['long']],
    'wMaxRightOverlapChars': [2300, ['long']],
    'oembmi': [2416, ['array', 93, ['tagOEMBITMAPINFO']]],
    'apfnClientWorker': [412, ['_PFNCLIENTWORKER']],
    'dwDefaultHeapBase': [512, ['unsigned long']],
    'apfnClientA': [228, ['_PFNCLIENT']],
    'dmLogPixels': [3922, ['unsigned short']],
    'nEvents': [2272, ['long']],
    'atomIconProp': [966, ['unsigned short']],
    'Planes': [3924, ['unsigned char']],
    'apfnClientW': [320, ['_PFNCLIENT']],
    'MBStrings': [524, ['array', 11, ['tagMBSTRING']]],
    'UILangID': [3936, ['unsigned short']],
    'dwRIPFlags': [4088, ['unsigned long']],
    'uCaretWidth': [3932, ['unsigned long']],
    'cCaptures': [2412, ['unsigned long']],
    'cHandleEntries': [4, ['unsigned long']],
    'ptCursor': [2252, ['tagPOINT']],
    'hIconSmWindows': [2396, ['pointer', ['HICON__']]],
    'mpFnidPfn': [8, ['array', 32, ['pointer', ['void']]]],
    'rcScreenReal': [3904, ['tagRECT']],
    }],
'_D3DKMDT_VIDEO_SIGNAL_INFO': [0x2c, {
    'VSyncFreq': [20, ['_D3DDDI_RATIONAL']],
    'ActiveSize': [12, ['_D3DKMDT_2DREGION']],
    'PixelRate': [36, ['unsigned long']],
    'TotalSize': [4, ['_D3DKMDT_2DREGION']],
    'VideoStandard': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_VSS_UNINITIALIZED', 1: 'D3DKMDT_VSS_VESA_DMT', 2: 'D3DKMDT_VSS_VESA_GTF', 3: 'D3DKMDT_VSS_VESA_CVT', 4: 'D3DKMDT_VSS_IBM', 5: 'D3DKMDT_VSS_APPLE', 6: 'D3DKMDT_VSS_NTSC_M', 7: 'D3DKMDT_VSS_NTSC_J', 8: 'D3DKMDT_VSS_NTSC_443', 9: 'D3DKMDT_VSS_PAL_B', 10: 'D3DKMDT_VSS_PAL_B1', 11: 'D3DKMDT_VSS_PAL_G', 12: 'D3DKMDT_VSS_PAL_H', 13: 'D3DKMDT_VSS_PAL_I', 14: 'D3DKMDT_VSS_PAL_D', 15: 'D3DKMDT_VSS_PAL_N', 16: 'D3DKMDT_VSS_PAL_NC', 17: 'D3DKMDT_VSS_SECAM_B', 18: 'D3DKMDT_VSS_SECAM_D', 19: 'D3DKMDT_VSS_SECAM_G', 20: 'D3DKMDT_VSS_SECAM_H', 21: 'D3DKMDT_VSS_SECAM_K', 22: 'D3DKMDT_VSS_SECAM_K1', 23: 'D3DKMDT_VSS_SECAM_L', 24: 'D3DKMDT_VSS_SECAM_L1', 25: 'D3DKMDT_VSS_EIA_861', 26: 'D3DKMDT_VSS_EIA_861A', 27: 'D3DKMDT_VSS_EIA_861B', 28: 'D3DKMDT_VSS_PAL_K', 29: 'D3DKMDT_VSS_PAL_K1', 30: 'D3DKMDT_VSS_PAL_L', 31: 'D3DKMDT_VSS_PAL_M', 255: 'D3DKMDT_VSS_OTHER'}}]],
    'ScanLineOrdering': [40, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DDDI_VSSLO_UNINITIALIZED', 1: 'D3DDDI_VSSLO_PROGRESSIVE', 2: 'D3DDDI_VSSLO_INTERLACED_UPPERFIELDFIRST', 3: 'D3DDDI_VSSLO_INTERLACED_LOWERFIELDFIRST', 255: 'D3DDDI_VSSLO_OTHER'}}]],
    'HSyncFreq': [28, ['_D3DDDI_RATIONAL']],
    }],
'__unnamed_11dd': [0x8, {
    'FsInformationClass': [4, ['Enumeration', {'target': 'long', 'choices': {1: 'FileFsVolumeInformation', 2: 'FileFsLabelInformation', 3: 'FileFsSizeInformation', 4: 'FileFsDeviceInformation', 5: 'FileFsAttributeInformation', 6: 'FileFsControlInformation', 7: 'FileFsFullSizeInformation', 8: 'FileFsObjectIdInformation', 9: 'FileFsDriverPathInformation', 10: 'FileFsVolumeFlagsInformation', 11: 'FileFsMaximumInformation'}}]],
    'Length': [0, ['unsigned long']],
    }],
'__unnamed_11df': [0x10, {
    'Type3InputBuffer': [12, ['pointer', ['void']]],
    'OutputBufferLength': [0, ['unsigned long']],
    'FsControlCode': [8, ['unsigned long']],
    'InputBufferLength': [4, ['unsigned long']],
    }],
'D3DDDI_DXGI_RGB': [0xc, {
    'Blue': [8, ['float']],
    'Green': [4, ['float']],
    'Red': [0, ['float']],
    }],
'_MAGNIFICATION_INPUT_TRANSFORM': [0x2c, {
    'rcScreen': [16, ['tagRECT']],
    'magFactorX': [36, ['long']],
    'magFactorY': [40, ['long']],
    'ptiMagThreadInfo': [32, ['pointer', ['tagTHREADINFO']]],
    'rcSource': [0, ['tagRECT']],
    }],
'_D3DKMDT_MONITOR_FREQUENCY_RANGE': [0x30, {
    'Origin': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MCO_UNINITIALIZED', 1: 'D3DKMDT_MCO_DEFAULTMONITORPROFILE', 2: 'D3DKMDT_MCO_MONITORDESCRIPTOR', 3: 'D3DKMDT_MCO_MONITORDESCRIPTOR_REGISTRYOVERRIDE', 4: 'D3DKMDT_MCO_SPECIFICCAP_REGISTRYOVERRIDE', 5: 'D3DKMDT_MCO_MAXVALID'}}]],
    'ConstraintType': [36, ['Enumeration', {'target': 'long', 'choices': {0: 'D3DKMDT_MFRC_UNINITIALIZED', 1: 'D3DKMDT_MFRC_ACTIVESIZE', 2: 'D3DKMDT_MFRC_MAXPIXELRATE'}}]],
    'RangeLimits': [4, ['_D3DKMDT_FREQUENCY_RANGE']],
    'Constraint': [40, ['__unnamed_1633']],
    }],
'_PFNCLIENTWORKER': [0x2c, {
    'pfnComboBoxWndProc': [4, ['pointer', ['void']]],
    'pfnMDIClientWndProc': [24, ['pointer', ['void']]],
    'pfnDialogWndProc': [12, ['pointer', ['void']]],
    'pfnStaticWndProc': [28, ['pointer', ['void']]],
    'pfnCtfHookProc': [40, ['pointer', ['void']]],
    'pfnButtonWndProc': [0, ['pointer', ['void']]],
    'pfnImeWndProc': [32, ['pointer', ['void']]],
    'pfnEditWndProc': [16, ['pointer', ['void']]],
    'pfnListBoxWndProc': [20, ['pointer', ['void']]],
    'pfnGhostWndProc': [36, ['pointer', ['void']]],
    'pfnComboListBoxProc': [8, ['pointer', ['void']]],
    }],
'_D3DDDI_GAMMA_RAMP_DXGI_1': [0x3024, {
    'GammaCurve': [24, ['array', 1025, ['D3DDDI_DXGI_RGB']]],
    'Scale': [0, ['D3DDDI_DXGI_RGB']],
    'Offset': [12, ['D3DDDI_DXGI_RGB']],
    }],
'_DXGK_DIAG_HEADER': [0x30, {
    'Index': [40, ['unsigned long']],
    'ProcessName': [16, ['array', 16, ['unsigned char']]],
    'LogTimestamp': [8, ['unsigned long long']],
    'ThreadId': [32, ['unsigned long long']],
    'Type': [0, ['Enumeration', {'target': 'long', 'choices': {0: 'DXGK_DIAG_TYPE_NONE', 1: 'DXGK_DIAG_TYPE_SDC', 2: 'DXGK_DIAG_TYPE_HPD', 3: 'DXGK_DIAG_TYPE_DC_ORIGIN', 4: 'DXGK_DIAG_TYPE_USER_CDS', 5: 'DXGK_DIAG_TYPE_DRV_CDS', 6: 'DXGK_DIAG_TYPE_CODE_POINT', 7: 'DXGK_DIAG_TYPE_QDC', 8: 'DXGK_DIAG_TYPE_MONITOR_MGR', 9: 'DXGK_DIAG_TYPE_CONNECTEDSET_NOT_FOUND', 10: 'DXGK_DIAG_TYPE_DISPDIAG_COLLECTED', 11: 'DXGK_DIAG_TYPE_BML_PACKET', 12: 'DXGK_DIAG_TYPE_BML_PACKET_EX', 13: 'DXGK_DIAG_TYPE_COMMIT_VIDPN_FAILED', 14: 'DXGK_DIAG_TYPE_MAX', -1: 'DXGK_DIAG_TYPE_FORCE_UINT32'}}]],
    'WdLogIdx': [44, ['unsigned long']],
    'Size': [4, ['unsigned long']],
    }],
'_SM_VALUES_STRINGS': [0x10, {
    'StorageType': [12, ['Enumeration', {'target': 'long', 'choices': {0: 'SmStorageActual', 1: 'SmStorageNonActual'}}]],
    'pszName': [0, ['pointer', ['unsigned char']]],
    'ulValue': [4, ['unsigned long']],
    'RangeType': [8, ['Enumeration', {'target': 'long', 'choices': {0: 'SmRangeSharedInfo', 1: 'SmRangeNonSharedInfo', 2: 'SmRangeBool'}}]],
    }],
'tagTERMINAL': [0x20, {
    'spwndDesktopOwner': [4, ['pointer', ['tagWND']]],
    'dwTERMF_Flags': [0, ['unsigned long']],
    'dwNestedLevel': [16, ['unsigned long']],
    'pqDesktop': [12, ['pointer', ['tagQ']]],
    'pEventInputReady': [28, ['pointer', ['_KEVENT']]],
    'rpdeskDestroy': [24, ['pointer', ['tagDESKTOP']]],
    'ptiDesktop': [8, ['pointer', ['tagTHREADINFO']]],
    'pEventTermInit': [20, ['pointer', ['_KEVENT']]],
    }],
'tagMENULIST': [0x8, {
    'pMenu': [4, ['pointer', ['tagMENU']]],
    'pNext': [0, ['pointer', ['tagMENULIST']]],
    }],
'__unnamed_11d5': [0x8, {
    'CompletionFilter': [4, ['unsigned long']],
    'Length': [0, ['unsigned long']],
    }],
'__unnamed_11d7': [0x8, {
    'Length': [0, ['unsigned long']],
    'FileInformationClass': [4, ['Enumeration', {'target': 'long', 'choices': {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileAttributeCacheInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileMaximumInformation'}}]],
    }],
'__unnamed_11d3': [0x10, {
    'Length': [0, ['unsigned long']],
    'FileIndex': [12, ['unsigned long']],
    'FileInformationClass': [8, ['Enumeration', {'target': 'long', 'choices': {1: 'FileDirectoryInformation', 2: 'FileFullDirectoryInformation', 3: 'FileBothDirectoryInformation', 4: 'FileBasicInformation', 5: 'FileStandardInformation', 6: 'FileInternalInformation', 7: 'FileEaInformation', 8: 'FileAccessInformation', 9: 'FileNameInformation', 10: 'FileRenameInformation', 11: 'FileLinkInformation', 12: 'FileNamesInformation', 13: 'FileDispositionInformation', 14: 'FilePositionInformation', 15: 'FileFullEaInformation', 16: 'FileModeInformation', 17: 'FileAlignmentInformation', 18: 'FileAllInformation', 19: 'FileAllocationInformation', 20: 'FileEndOfFileInformation', 21: 'FileAlternateNameInformation', 22: 'FileStreamInformation', 23: 'FilePipeInformation', 24: 'FilePipeLocalInformation', 25: 'FilePipeRemoteInformation', 26: 'FileMailslotQueryInformation', 27: 'FileMailslotSetInformation', 28: 'FileCompressionInformation', 29: 'FileObjectIdInformation', 30: 'FileCompletionInformation', 31: 'FileMoveClusterInformation', 32: 'FileQuotaInformation', 33: 'FileReparsePointInformation', 34: 'FileNetworkOpenInformation', 35: 'FileAttributeTagInformation', 36: 'FileTrackingInformation', 37: 'FileIdBothDirectoryInformation', 38: 'FileIdFullDirectoryInformation', 39: 'FileValidDataLengthInformation', 40: 'FileShortNameInformation', 41: 'FileIoCompletionNotificationInformation', 42: 'FileIoStatusBlockRangeInformation', 43: 'FileIoPriorityHintInformation', 44: 'FileSfioReserveInformation', 45: 'FileSfioVolumeInformation', 46: 'FileHardLinkInformation', 47: 'FileProcessIdsUsingFileInformation', 48: 'FileNormalizedNameInformation', 49: 'FileNetworkPhysicalNameInformation', 50: 'FileIdGlobalTxDirectoryInformation', 51: 'FileIsRemoteDeviceInformation', 52: 'FileAttributeCacheInformation', 53: 'FileNumaNodeInformation', 54: 'FileStandardLinkInformation', 55: 'FileRemoteProtocolInformation', 56: 'FileMaximumInformation'}}]],
    'FileName': [4, ['pointer', ['_UNICODE_STRING']]],
    }],
'tagPOINT': [0x8, {
    'y': [4, ['long']],
    'x': [0, ['long']],
    }],
'tagSHAREDINFO': [0x11c, {
    'psi': [0, ['pointer', ['tagSERVERINFO']]],
    'DefWindowSpecMsgs': [276, ['_WNDMSG']],
    'awmControl': [20, ['array', 31, ['_WNDMSG']]],
    'ulSharedDelta': [16, ['unsigned long']],
    'pDispInfo': [12, ['pointer', ['tagDISPLAYINFO']]],
    'aheList': [4, ['pointer', ['_HANDLEENTRY']]],
    'DefWindowMsgs': [268, ['_WNDMSG']],
    'HeEntrySize': [8, ['unsigned long']],
    }],
'tagIMC': [0x20, {
    'dwClientImcData': [24, ['unsigned long']],
    'head': [0, ['_THRDESKHEAD']],
    'hImeWnd': [28, ['pointer', ['HWND__']]],
    'pImcNext': [20, ['pointer', ['tagIMC']]],
    }],
'tagKL': [0x44, {
    'uNumTbl': [48, ['unsigned long']],
    'pklPrev': [12, ['pointer', ['tagKL']]],
    'head': [0, ['_HEAD']],
    'pklNext': [8, ['pointer', ['tagKL']]],
    'spkfPrimary': [28, ['pointer', ['tagKBDFILE']]],
    'dwFontSigs': [32, ['unsigned long']],
    'dwLastKbdType': [56, ['unsigned long']],
    'CodePage': [40, ['unsigned short']],
    'dwKL_Flags': [16, ['unsigned long']],
    'iBaseCharset': [36, ['unsigned long']],
    'dwKLID': [64, ['unsigned long']],
    'spkf': [24, ['pointer', ['tagKBDFILE']]],
    'piiex': [44, ['pointer', ['tagIMEINFOEX']]],
    'hkl': [20, ['pointer', ['HKL__']]],
    'pspkfExtra': [52, ['pointer', ['pointer', ['tagKBDFILE']]]],
    'wchDiacritic': [42, ['wchar']],
    'dwLastKbdSubType': [60, ['unsigned long']],
    }],
'tagCARET': [0x38, {
    'iHideLevel': [8, ['long']],
    'yOwnDc': [44, ['long']],
    'y': [16, ['long']],
    'cy': [20, ['long']],
    'cx': [24, ['long']],
    'hBitmap': [28, ['pointer', ['HBITMAP__']]],
    'cyOwnDc': [52, ['long']],
    'fOn': [4, ['BitField', {'end_bit': 2, 'start_bit': 1}]],
    'hTimer': [32, ['unsigned long']],
    'xOwnDc': [40, ['long']],
    'fVisible': [4, ['BitField', {'end_bit': 1, 'start_bit': 0}]],
    'cxOwnDc': [48, ['long']],
    'tid': [36, ['unsigned long']],
    'x': [12, ['long']],
    'spwnd': [0, ['pointer', ['tagWND']]],
    }],
}
