package vtk;

import java.util.Properties;
import java.util.StringTokenizer;

public class vtkSettings
{
  private static String GetVTKBuildLibDir() { return "/build/vtk6/src/build/lib"; }
  private static String GetVTKInstallLibDir() { return "/opt/vtk6/"; }

  private static String[] Split(String str, String sep)
    {
    StringTokenizer st = new StringTokenizer(str, sep);
    int size = st.countTokens();
    String[] res = new String[size];
    int cnt = 0;
    while (st.hasMoreTokens())
      {
      res[cnt] = st.nextToken();
      cnt ++;
      }
    return res;
    }

  public static String GetVTKLibraryDir()
    {
    String lpath = null;
    Properties p = System.getProperties();
    String path_separator = p.getProperty("path.separator");
    String s = p.getProperty("java.class.path");
    String[] paths = vtkSettings.Split(s, path_separator);
    int cc;
    for ( cc = 0; cc < paths.length; cc ++ )
      {
      if ( paths[cc].endsWith("vtk.jar") )
        {
        lpath = paths[cc].substring(0, paths[cc].length()-"vtk.jar".length()-1);
        }
      }
    if ( lpath == null )
      {
      lpath = vtkSettings.GetVTKInstallLibDir();
      }
    return lpath;
    }

  public static String[] GetKits()
    {
    return vtkSettings.Split("CommonCore;CommonMath;CommonMisc;CommonSystem;CommonTransforms;CommonDataModel;CommonColor;CommonExecutionModel;FiltersCore;CommonComputationalGeometry;FiltersGeneral;ImagingCore;ImagingFourier;FiltersStatistics;FiltersExtraction;InfovisCore;FiltersGeometry;FiltersSources;RenderingCore;RenderingFreeType;RenderingContext2D;ChartsCore;IOCore;IOLegacy;IOGeometry;IOXMLParser;IOXML;IOInfovis;IOImage;ImagingHybrid;RenderingOpenGL;RenderingContextOpenGL;TestingRendering;ImagingSources;FiltersHybrid;FiltersModeling;ImagingGeneral;InteractionStyle;ImagingColor;RenderingAnnotation;RenderingVolume;InteractionWidgets;ViewsCore;ViewsContext2D;FiltersGeneric;DomainsChemistry;ParallelCore;FiltersAMR;IOAMR;FiltersFlowPaths;FiltersImaging;ImagingMath;RenderingLabel;ImagingStencil;FiltersHyperTree;FiltersParallel;FiltersParallelImaging;ParallelMPI;FiltersParallelMPI;RenderingParallel;FiltersParallelFlowPaths;IONetCDF;IOParallel;FiltersParallelGeometry;IOParallelXML;FiltersParallelStatistics;FiltersProgrammable;FiltersReebGraph;FiltersSMP;FiltersSelection;FiltersTexture;FiltersVerdict;IOSQL;InfovisLayout;ViewsInfovis;GeovisCore;ViewsGeovis;IOEnSight;IOExodus;RenderingGL2PS;IOExport;InteractionImage;RenderingVolumeOpenGL;IOMovie;IOFFMPEG;IOGDAL;IOGeoJSON;IOImport;IOLSDyna;IOMINC;IOMPIImage;IOMPIParallel;IOMySQL;IOODBC;IOPLY;IOParallelExodus;IOParallelLSDyna;IOParallelNetCDF;IOPostgreSQL;IOVPIC;IOVideo;IOXdmf2;IOXdmf3;ImagingStatistics;RenderingImage;ImagingMorphological;InfovisBoostGraphAlgorithms;RenderingLOD;PythonInterpreter;RenderingLIC;RenderingMatplotlib;RenderingParallelLIC;RenderingQt;RenderingVolumeAMR", ";");
    }
}
