/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.splashscreen.parts;

import net.sourceforge.jnlp.InformationDesc;
import net.sourceforge.jnlp.runtime.Translator;

public class InfoItem {
    public static final String SPLASH = "SPLASH";
    public static final String title = "title";
    public static final String vendor = "vendor";
    public static final String homepage = "homepage";
    public static final String homepageHref = "href";
    public static final String description = "description";
    public static final String descriptionKind = "kind";
    public static final String descriptionKindOneLine = (String)InformationDesc.ONE_LINE;
    public static final String descriptionKindShort = (String)InformationDesc.SHORT;
    public static final String descriptionKindToolTip = (String)InformationDesc.TOOLTIP;
    protected String type;
    protected String value;

    public InfoItem(String type, String value) {
        this.type = type;
        this.value = value;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public boolean isofSameType(InfoItem o) {
        return this.getType().equals(o.getType());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof InfoItem)) {
            return false;
        }
        InfoItem o = (InfoItem)obj;
        return this.isofSameType(o) && this.getValue().equals(o.getValue());
    }

    public String toString() {
        return this.type + ": " + this.value;
    }

    public String toNiceString() {
        String key = SPLASH + this.type;
        return InfoItem.localise(key, this.value);
    }

    public static String localise(String key, String s) {
        return Translator.R(key) + ": " + s;
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + (this.getType() != null ? this.getType().hashCode() : 0);
        hash = 59 * hash + (this.getValue() != null ? this.getValue().hashCode() : 0);
        return hash;
    }
}

