/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.Surrogate;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.JIS_X_0201;
import sun.nio.cs.ext.JIS_X_0208_Decoder;
import sun.nio.cs.ext.JIS_X_0208_Encoder;

public class EUC_JP_LINUX
extends Charset
implements HistoricallyNamedCharset {
    public EUC_JP_LINUX() {
        super("x-euc-jp-linux", ExtendedCharsets.aliasesFor("x-euc-jp-linux"));
    }

    @Override
    public String historicalName() {
        return "EUC_JP_LINUX";
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof JIS_X_0201 || cs.name().equals("US-ASCII") || cs instanceof EUC_JP_LINUX;
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends CharsetEncoder {
        JIS_X_0201.Encoder encoderJ0201;
        private final Surrogate.Parser sgp = new Surrogate.Parser();
        private static final short[] jis0208Index1 = JIS_X_0208_Encoder.getIndex1();
        private static final String[] jis0208Index2 = JIS_X_0208_Encoder.getIndex2();

        private Encoder(Charset cs) {
            super(cs, 2.0f, 2.0f);
            this.encoderJ0201 = new JIS_X_0201.Encoder(cs);
        }

        @Override
        public boolean canEncode(char c) {
            byte[] encodedBytes = new byte[2];
            return this.encodeSingle(c, encodedBytes) != 0 || this.encodeDouble(c) != 0;
        }

        protected int encodeSingle(char inputChar, byte[] outputByte) {
            if (inputChar == '\u0000') {
                outputByte[0] = 0;
                return 1;
            }
            byte b = this.encoderJ0201.encode(inputChar);
            if (b == 0) {
                return 0;
            }
            if (b > 0 && b < 128) {
                outputByte[0] = b;
                return 1;
            }
            outputByte[0] = -114;
            outputByte[1] = b;
            return 2;
        }

        protected int encodeDouble(char ch) {
            int offset = jis0208Index1[(ch & 0xFF00) >> 8] << 8;
            char r = jis0208Index2[offset >> 12].charAt((offset & 0xFFF) + (ch & 0xFF));
            if (r != '\u0000') {
                return r + 32896;
            }
            return r;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeArrayLoop(CharBuffer src, ByteBuffer dst) {
            char[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            byte[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            byte[] outputByte = new byte[2];
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; ++sp) {
                    char c = sa[sp];
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, sa, sp, sl) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    int outputSize = this.encodeSingle(c, outputByte);
                    if (outputSize == 0) {
                        int ncode = this.encodeDouble(c);
                        if (ncode != 0 && (ncode & 0xFF0000) == 0) {
                            outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                            outputByte[1] = (byte)(ncode & 0xFF);
                            outputSize = 2;
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dl - dp < outputSize) {
                        CoderResult ncode = CoderResult.OVERFLOW;
                        return ncode;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        da[dp++] = outputByte[i];
                    }
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult encodeBufferLoop(CharBuffer src, ByteBuffer dst) {
            byte[] outputByte = new byte[4];
            int mark = src.position();
            try {
                while (src.hasRemaining()) {
                    char c = src.get();
                    if (Character.isSurrogate(c)) {
                        if (this.sgp.parse(c, src) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    int outputSize = this.encodeSingle(c, outputByte);
                    if (outputSize == 0) {
                        int ncode = this.encodeDouble(c);
                        if (ncode != 0) {
                            if ((ncode & 0xFF0000) == 0) {
                                outputByte[0] = (byte)((ncode & 0xFF00) >> 8);
                                outputByte[1] = (byte)(ncode & 0xFF);
                                outputSize = 2;
                            }
                        } else {
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                    }
                    if (dst.remaining() < outputSize) {
                        CoderResult ncode = CoderResult.OVERFLOW;
                        return ncode;
                    }
                    for (int i = 0; i < outputSize; ++i) {
                        dst.put(outputByte[i]);
                    }
                    ++mark;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer src, ByteBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.encodeArrayLoop(src, dst);
            }
            return this.encodeBufferLoop(src, dst);
        }
    }

    private static class Decoder
    extends CharsetDecoder {
        JIS_X_0201.Decoder decoderJ0201;
        protected final char REPLACE_CHAR = (char)65533;
        private static final int start = 161;
        private static final int end = 254;
        private static final short[] jis0208Index1 = JIS_X_0208_Decoder.getIndex1();
        private static final String[] jis0208Index2 = JIS_X_0208_Decoder.getIndex2();

        private Decoder(Charset cs) {
            super(cs, 1.0f, 1.0f);
            this.decoderJ0201 = new JIS_X_0201.Decoder(cs);
        }

        protected char convSingleByte(int b) {
            if (b < 0 || b > 127) {
                return '\ufffd';
            }
            return this.decoderJ0201.decode(b);
        }

        protected char decodeDouble(int byte1, int byte2) {
            if (byte1 == 142) {
                return this.decoderJ0201.decode(byte2 - 256);
            }
            if (byte1 < 0 || byte1 > jis0208Index1.length || byte2 < 161 || byte2 > 254) {
                return '\ufffd';
            }
            int n = (jis0208Index1[byte1 - 128] & 0xF) * 94 + (byte2 - 161);
            return jis0208Index2[jis0208Index1[byte1 - 128] >> 4].charAt(n);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeArrayLoop(ByteBuffer src, CharBuffer dst) {
            byte[] sa = src.array();
            int sp = src.arrayOffset() + src.position();
            int sl = src.arrayOffset() + src.limit();
            assert (sp <= sl);
            char[] da = dst.array();
            int dp = dst.arrayOffset() + dst.position();
            int dl = dst.arrayOffset() + dst.limit();
            assert (dp <= dl);
            dp = dp <= dl ? dp : dl;
            int b1 = 0;
            int b2 = 0;
            int inputSize = 0;
            int outputChar = 65533;
            try {
                for (sp = sp <= sl ? sp : sl; sp < sl; sp += inputSize) {
                    b1 = sa[sp] & 0xFF;
                    inputSize = 1;
                    if ((b1 & 0x80) == 0) {
                        outputChar = (char)b1;
                    } else {
                        if ((b1 & 0xFF) == 143) {
                            if (sp + 3 > sl) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            inputSize = 3;
                            CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                            return coderResult;
                        }
                        if (sp + 2 > sl) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        b2 = sa[sp + 1] & 0xFF;
                        inputSize = 2;
                        outputChar = this.decodeDouble(b1, b2);
                    }
                    if (outputChar == 65533) {
                        CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                        return coderResult;
                    }
                    if (dp + 1 > dl) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    da[dp++] = outputChar;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(sp - src.arrayOffset());
                dst.position(dp - dst.arrayOffset());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private CoderResult decodeBufferLoop(ByteBuffer src, CharBuffer dst) {
            int mark = src.position();
            char outputChar = '\ufffd';
            try {
                while (src.hasRemaining()) {
                    int b1 = src.get() & 0xFF;
                    int inputSize = 1;
                    if ((b1 & 0x80) == 0) {
                        outputChar = (char)b1;
                    } else {
                        if ((b1 & 0xFF) == 143) {
                            if (src.remaining() < 2) {
                                CoderResult coderResult = CoderResult.UNDERFLOW;
                                return coderResult;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(3);
                            return coderResult;
                        }
                        if (src.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        int b2 = src.get() & 0xFF;
                        ++inputSize;
                        outputChar = this.decodeDouble(b1, b2);
                    }
                    if (outputChar == '\ufffd') {
                        CoderResult coderResult = CoderResult.unmappableForLength(inputSize);
                        return coderResult;
                    }
                    if (dst.remaining() < 1) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    dst.put(outputChar);
                    mark += inputSize;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                src.position(mark);
            }
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer src, CharBuffer dst) {
            if (src.hasArray() && dst.hasArray()) {
                return this.decodeArrayLoop(src, dst);
            }
            return this.decodeBufferLoop(src, dst);
        }
    }
}

