/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans;

import com.sun.beans.WeakCache;
import com.sun.beans.WildcardTypeImpl;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import sun.reflect.generics.reflectiveObjects.GenericArrayTypeImpl;
import sun.reflect.generics.reflectiveObjects.ParameterizedTypeImpl;

public final class TypeResolver {
    private static final WeakCache<Type, Map<Type, Type>> CACHE = new WeakCache();

    public static Type resolveInClass(Class<?> inClass, Type type) {
        return TypeResolver.resolve(TypeResolver.getActualType(inClass), type);
    }

    public static Type[] resolveInClass(Class<?> inClass, Type[] types) {
        return TypeResolver.resolve(TypeResolver.getActualType(inClass), types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type resolve(Type actual, Type formal) {
        if (formal instanceof Class) {
            return formal;
        }
        if (formal instanceof GenericArrayType) {
            Type comp = ((GenericArrayType)formal).getGenericComponentType();
            return (comp = TypeResolver.resolve(actual, comp)) instanceof Class ? Array.newInstance((Class)comp, 0).getClass() : GenericArrayTypeImpl.make(comp);
        }
        if (formal instanceof ParameterizedType) {
            ParameterizedType fpt = (ParameterizedType)formal;
            Type[] actuals = TypeResolver.resolve(actual, fpt.getActualTypeArguments());
            return ParameterizedTypeImpl.make((Class)fpt.getRawType(), actuals, fpt.getOwnerType());
        }
        if (formal instanceof WildcardType) {
            WildcardType fwt = (WildcardType)formal;
            Type[] upper = TypeResolver.resolve(actual, fwt.getUpperBounds());
            Type[] lower = TypeResolver.resolve(actual, fwt.getLowerBounds());
            return new WildcardTypeImpl(upper, lower);
        }
        if (formal instanceof TypeVariable) {
            Map<Type, Type> map;
            WeakCache<Type, Map<Type, Type>> upper = CACHE;
            synchronized (upper) {
                map = CACHE.get(actual);
                if (map == null) {
                    map = new HashMap<Type, Type>();
                    TypeResolver.prepare(map, actual);
                    CACHE.put(actual, map);
                }
            }
            Type result = map.get(formal);
            if (result == null || result.equals(formal)) {
                return formal;
            }
            result = TypeResolver.fixGenericArray(result);
            return TypeResolver.resolve(actual, result);
        }
        throw new IllegalArgumentException("Bad Type kind: " + formal.getClass());
    }

    public static Type[] resolve(Type actual, Type[] formals) {
        int length = formals.length;
        Type[] actuals = new Type[length];
        for (int i = 0; i < length; ++i) {
            actuals[i] = TypeResolver.resolve(actual, formals[i]);
        }
        return actuals;
    }

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            Type[] bounds = tv.getBounds();
            return 0 < bounds.length ? TypeResolver.erase(bounds[0]) : Object.class;
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            Type[] bounds = wt.getUpperBounds();
            return 0 < bounds.length ? TypeResolver.erase(bounds[0]) : Object.class;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType gat = (GenericArrayType)type;
            return Array.newInstance(TypeResolver.erase(gat.getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Unknown Type kind: " + type.getClass());
    }

    public static Class[] erase(Type[] types) {
        int length = types.length;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = TypeResolver.erase(types[i]);
        }
        return classes;
    }

    private static void prepare(Map<Type, Type> map, Type type) {
        TypeVariable<Class<T>>[] actuals;
        Class raw = (Class)(type instanceof Class ? type : ((ParameterizedType)type).getRawType());
        TypeVariable<Class<T>>[] formals = raw.getTypeParameters();
        Type[] typeArray = actuals = type instanceof Class ? formals : ((ParameterizedType)type).getActualTypeArguments();
        assert (formals.length == actuals.length);
        for (int i = 0; i < formals.length; ++i) {
            map.put(formals[i], actuals[i]);
        }
        Type gSuperclass = raw.getGenericSuperclass();
        if (gSuperclass != null) {
            TypeResolver.prepare(map, gSuperclass);
        }
        for (Type gInterface : raw.getGenericInterfaces()) {
            TypeResolver.prepare(map, gInterface);
        }
        if (type instanceof Class && formals.length > 0) {
            for (Map.Entry<Type, Type> entry : map.entrySet()) {
                entry.setValue(TypeResolver.erase(entry.getValue()));
            }
        }
    }

    private static Type fixGenericArray(Type type) {
        if (type instanceof GenericArrayType) {
            Type comp = ((GenericArrayType)type).getGenericComponentType();
            if ((comp = TypeResolver.fixGenericArray(comp)) instanceof Class) {
                return Array.newInstance((Class)comp, 0).getClass();
            }
        }
        return type;
    }

    private static Type getActualType(Class<?> inClass) {
        Type[] params = inClass.getTypeParameters();
        return params.length == 0 ? inClass : ParameterizedTypeImpl.make(inClass, params, inClass.getEnclosingClass());
    }
}

