/*
 * Decompiled with CFR 0.152.
 */
package com.sun.beans.decoder;

import com.sun.beans.decoder.AccessorElementHandler;
import com.sun.beans.finder.MethodFinder;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import sun.reflect.misc.MethodUtil;

final class PropertyElementHandler
extends AccessorElementHandler {
    static final String GETTER = "get";
    static final String SETTER = "set";
    private Integer index;

    PropertyElementHandler() {
    }

    @Override
    public void addAttribute(String name, String value) {
        if (name.equals("index")) {
            this.index = Integer.valueOf(value);
        } else {
            super.addAttribute(name, value);
        }
    }

    @Override
    protected boolean isArgument() {
        return false;
    }

    @Override
    protected Object getValue(String name) {
        try {
            return PropertyElementHandler.getPropertyValue(this.getContextBean(), name, this.index);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
            return null;
        }
    }

    @Override
    protected void setValue(String name, Object value) {
        try {
            PropertyElementHandler.setPropertyValue(this.getContextBean(), name, this.index, value);
        }
        catch (Exception exception) {
            this.getOwner().handleException(exception);
        }
    }

    private static Object getPropertyValue(Object bean, String name, Integer index) throws IllegalAccessException, IntrospectionException, InvocationTargetException, NoSuchMethodException {
        Class<?> type = bean.getClass();
        if (index == null) {
            return MethodUtil.invoke(PropertyElementHandler.findGetter(type, name, new Class[0]), bean, new Object[0]);
        }
        if (type.isArray() && name == null) {
            return Array.get(bean, index);
        }
        return MethodUtil.invoke(PropertyElementHandler.findGetter(type, name, Integer.TYPE), bean, new Object[]{index});
    }

    private static void setPropertyValue(Object bean, String name, Integer index, Object value) throws IllegalAccessException, IntrospectionException, InvocationTargetException, NoSuchMethodException {
        Class<?> param;
        Class<?> type = bean.getClass();
        Class<?> clazz = param = value != null ? value.getClass() : null;
        if (index == null) {
            MethodUtil.invoke(PropertyElementHandler.findSetter(type, name, param), bean, new Object[]{value});
        } else if (type.isArray() && name == null) {
            Array.set(bean, index, value);
        } else {
            MethodUtil.invoke(PropertyElementHandler.findSetter(type, name, Integer.TYPE, param), bean, new Object[]{index, value});
        }
    }

    private static Method findGetter(Class<?> type, String name, Class<?> ... args) throws IntrospectionException, NoSuchMethodException {
        IndexedPropertyDescriptor ipd;
        Method method;
        if (name == null) {
            return MethodFinder.findInstanceMethod(type, GETTER, args);
        }
        PropertyDescriptor pd = PropertyElementHandler.getProperty(type, name);
        if (args.length == 0) {
            Method method2 = pd.getReadMethod();
            if (method2 != null) {
                return method2;
            }
        } else if (pd instanceof IndexedPropertyDescriptor && (method = (ipd = (IndexedPropertyDescriptor)pd).getIndexedReadMethod()) != null) {
            return method;
        }
        throw new IntrospectionException("Could not find getter for the " + name + " property");
    }

    private static Method findSetter(Class<?> type, String name, Class<?> ... args) throws IntrospectionException, NoSuchMethodException {
        IndexedPropertyDescriptor ipd;
        Method method;
        if (name == null) {
            return MethodFinder.findInstanceMethod(type, SETTER, args);
        }
        PropertyDescriptor pd = PropertyElementHandler.getProperty(type, name);
        if (args.length == 1) {
            Method method2 = pd.getWriteMethod();
            if (method2 != null) {
                return method2;
            }
        } else if (pd instanceof IndexedPropertyDescriptor && (method = (ipd = (IndexedPropertyDescriptor)pd).getIndexedWriteMethod()) != null) {
            return method;
        }
        throw new IntrospectionException("Could not find setter for the " + name + " property");
    }

    private static PropertyDescriptor getProperty(Class<?> type, String name) throws IntrospectionException {
        for (PropertyDescriptor pd : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (!name.equals(pd.getName())) continue;
            return pd;
        }
        throw new IntrospectionException("Could not find the " + name + " property descriptor");
    }
}

