/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.orbutil.threadpool;

import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.threadpool.WorkQueueImpl;
import com.sun.corba.se.spi.monitoring.LongMonitoredAttributeBase;
import com.sun.corba.se.spi.monitoring.MonitoredObject;
import com.sun.corba.se.spi.monitoring.MonitoringFactories;
import com.sun.corba.se.spi.orbutil.threadpool.NoSuchWorkQueueException;
import com.sun.corba.se.spi.orbutil.threadpool.ThreadPool;
import com.sun.corba.se.spi.orbutil.threadpool.Work;
import com.sun.corba.se.spi.orbutil.threadpool.WorkQueue;
import java.io.Closeable;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class ThreadPoolImpl
implements ThreadPool {
    private static AtomicInteger threadCounter = new AtomicInteger(0);
    private static final ORBUtilSystemException wrapper = ORBUtilSystemException.get("rpc.transport");
    private WorkQueue workQueue;
    private int availableWorkerThreads = 0;
    private int currentThreadCount = 0;
    private int minWorkerThreads = 0;
    private int maxWorkerThreads = 0;
    private long inactivityTimeout;
    private boolean boundedThreadPool = false;
    private AtomicLong processedCount = new AtomicLong(1L);
    private AtomicLong totalTimeTaken = new AtomicLong(0L);
    private String name;
    private MonitoredObject threadpoolMonitoredObject;
    private ThreadGroup threadGroup;
    Object workersLock = new Object();
    List<WorkerThread> workers = new ArrayList<WorkerThread>();

    public ThreadPoolImpl(ThreadGroup tg, String threadpoolName) {
        this.inactivityTimeout = 120000L;
        this.maxWorkerThreads = Integer.MAX_VALUE;
        this.workQueue = new WorkQueueImpl(this);
        this.threadGroup = tg;
        this.name = threadpoolName;
        this.initializeMonitoring();
    }

    public ThreadPoolImpl(String threadpoolName) {
        this(Thread.currentThread().getThreadGroup(), threadpoolName);
    }

    public ThreadPoolImpl(int minSize, int maxSize, long timeout, String threadpoolName) {
        this.minWorkerThreads = minSize;
        this.maxWorkerThreads = maxSize;
        this.inactivityTimeout = timeout;
        this.boundedThreadPool = true;
        this.workQueue = new WorkQueueImpl(this);
        this.name = threadpoolName;
        for (int i = 0; i < this.minWorkerThreads; ++i) {
            this.createWorkerThread();
        }
        this.initializeMonitoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<WorkerThread> copy = null;
        Object object = this.workersLock;
        synchronized (object) {
            copy = new ArrayList<WorkerThread>(this.workers);
        }
        for (WorkerThread wt : copy) {
            wt.close();
            while (wt.getState() != Thread.State.TERMINATED) {
                try {
                    wt.join();
                }
                catch (InterruptedException exc) {
                    wrapper.interruptedJoinCallWhileClosingThreadPool(exc, (Object)wt, (Object)this);
                }
            }
        }
        this.threadGroup = null;
    }

    private void initializeMonitoring() {
        MonitoredObject root = MonitoringFactories.getMonitoringManagerFactory().createMonitoringManager("orb", null).getRootMonitoredObject();
        MonitoredObject threadPoolMonitoringObjectRoot = root.getChild("threadpool");
        if (threadPoolMonitoringObjectRoot == null) {
            threadPoolMonitoringObjectRoot = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject("threadpool", "Monitoring for all ThreadPool instances");
            root.addChild(threadPoolMonitoringObjectRoot);
        }
        this.threadpoolMonitoredObject = MonitoringFactories.getMonitoredObjectFactory().createMonitoredObject(this.name, "Monitoring for a ThreadPool");
        threadPoolMonitoringObjectRoot.addChild(this.threadpoolMonitoredObject);
        LongMonitoredAttributeBase b1 = new LongMonitoredAttributeBase("currentNumberOfThreads", "Current number of total threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentNumberOfThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b1);
        LongMonitoredAttributeBase b2 = new LongMonitoredAttributeBase("numberOfAvailableThreads", "Current number of total threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfAvailableThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b2);
        LongMonitoredAttributeBase b3 = new LongMonitoredAttributeBase("numberOfBusyThreads", "Number of busy threads in the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.numberOfBusyThreads());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b3);
        LongMonitoredAttributeBase b4 = new LongMonitoredAttributeBase("averageWorkCompletionTime", "Average elapsed time taken to complete a work item by the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.averageWorkCompletionTime());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b4);
        LongMonitoredAttributeBase b5 = new LongMonitoredAttributeBase("currentProcessedCount", "Number of Work items processed by the ThreadPool"){

            @Override
            public Object getValue() {
                return new Long(ThreadPoolImpl.this.currentProcessedCount());
            }
        };
        this.threadpoolMonitoredObject.addAttribute(b5);
        this.threadpoolMonitoredObject.addChild(((WorkQueueImpl)this.workQueue).getMonitoredObject());
    }

    MonitoredObject getMonitoredObject() {
        return this.threadpoolMonitoredObject;
    }

    @Override
    public WorkQueue getAnyWorkQueue() {
        return this.workQueue;
    }

    @Override
    public WorkQueue getWorkQueue(int queueId) throws NoSuchWorkQueueException {
        if (queueId != 0) {
            throw new NoSuchWorkQueueException();
        }
        return this.workQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyForAvailableWork(WorkQueue aWorkQueue) {
        WorkQueue workQueue = aWorkQueue;
        synchronized (workQueue) {
            if (this.availableWorkerThreads < aWorkQueue.workItemsInQueue()) {
                this.createWorkerThread();
            } else {
                aWorkQueue.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread createWorkerThreadHelper(String name) {
        WorkerThread thread = new WorkerThread(this.threadGroup, name);
        Object object = this.workersLock;
        synchronized (object) {
            this.workers.add(thread);
        }
        thread.setDaemon(true);
        wrapper.workerThreadCreated(thread, thread.getContextClassLoader());
        thread.start();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createWorkerThread() {
        final String name = this.getName();
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            try {
                if (System.getSecurityManager() == null) {
                    this.createWorkerThreadHelper(name);
                } else {
                    AccessController.doPrivileged(new PrivilegedAction(){

                        public Object run() {
                            return ThreadPoolImpl.this.createWorkerThreadHelper(name);
                        }
                    });
                }
            }
            catch (Throwable t) {
                this.decrementCurrentNumberOfThreads();
                wrapper.workerThreadCreationFailure(t);
            }
            finally {
                this.incrementCurrentNumberOfThreads();
            }
        }
    }

    @Override
    public int minimumNumberOfThreads() {
        return this.minWorkerThreads;
    }

    @Override
    public int maximumNumberOfThreads() {
        return this.maxWorkerThreads;
    }

    @Override
    public long idleTimeoutForThreads() {
        return this.inactivityTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int currentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementCurrentNumberOfThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.currentThreadCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int numberOfBusyThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.currentThreadCount - this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long averageWorkCompletionTime() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.totalTimeTaken.get() / this.processedCount.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long currentProcessedCount() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            return this.processedCount.get();
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int numberOfWorkQueues() {
        return 1;
    }

    private static synchronized int getUniqueThreadId() {
        return threadCounter.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void decrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            --this.availableWorkerThreads;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementNumberOfAvailableThreads() {
        WorkQueue workQueue = this.workQueue;
        synchronized (workQueue) {
            ++this.availableWorkerThreads;
        }
    }

    private class WorkerThread
    extends Thread
    implements Closeable {
        private Work currentWork;
        private int threadId;
        private volatile boolean closeCalled;
        private String threadPoolName;
        private StringBuffer workerThreadName;

        WorkerThread(ThreadGroup tg, String threadPoolName) {
            super(tg, "Idle");
            this.threadId = 0;
            this.closeCalled = false;
            this.workerThreadName = new StringBuffer();
            this.threadId = ThreadPoolImpl.getUniqueThreadId();
            this.threadPoolName = threadPoolName;
            this.setName(this.composeWorkerThreadName(threadPoolName, "Idle"));
        }

        @Override
        public synchronized void close() {
            this.closeCalled = true;
            this.interrupt();
        }

        private void resetClassLoader() {
        }

        private void performWork() {
            long start = System.currentTimeMillis();
            try {
                this.currentWork.doWork();
            }
            catch (Throwable t) {
                wrapper.workerThreadDoWorkThrowable(this, t);
            }
            long elapsedTime = System.currentTimeMillis() - start;
            ThreadPoolImpl.this.totalTimeTaken.addAndGet(elapsedTime);
            ThreadPoolImpl.this.processedCount.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.closeCalled) {
                    block19: {
                        try {
                            this.currentWork = ((WorkQueueImpl)ThreadPoolImpl.this.workQueue).requestWork(ThreadPoolImpl.this.inactivityTimeout);
                            if (this.currentWork == null) {
                            }
                            break block19;
                        }
                        catch (InterruptedException exc) {
                            wrapper.workQueueThreadInterrupted(exc, (Object)this.getName(), (Object)this.closeCalled);
                        }
                        catch (Throwable t) {
                            wrapper.workerThreadThrowableFromRequestWork(this, t, ThreadPoolImpl.this.workQueue.getName());
                        }
                        continue;
                    }
                    this.performWork();
                    this.currentWork = null;
                    this.resetClassLoader();
                }
            }
            catch (Throwable e) {
                wrapper.workerThreadCaughtUnexpectedThrowable(this, e);
            }
            finally {
                Object t = ThreadPoolImpl.this.workersLock;
                synchronized (t) {
                    ThreadPoolImpl.this.workers.remove(this);
                }
            }
        }

        private String composeWorkerThreadName(String poolName, String workerName) {
            this.workerThreadName.setLength(0);
            this.workerThreadName.append("p: ").append(poolName);
            this.workerThreadName.append("; w: ").append(workerName);
            return this.workerThreadName.toString();
        }
    }
}

