/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.remote.util;

import javax.management.loading.ClassLoaderRepository;

public class ClassLoaderWithRepository
extends ClassLoader {
    private ClassLoaderRepository repository;
    private ClassLoader cl2;

    public ClassLoaderWithRepository(ClassLoaderRepository clr, ClassLoader cl2) {
        if (clr == null) {
            throw new IllegalArgumentException("Null ClassLoaderRepository object.");
        }
        this.repository = clr;
        this.cl2 = cl2;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> cls;
        try {
            cls = this.repository.loadClass(name);
        }
        catch (ClassNotFoundException cne) {
            if (this.cl2 != null) {
                return this.cl2.loadClass(name);
            }
            throw cne;
        }
        if (!cls.getName().equals(name)) {
            if (this.cl2 != null) {
                return this.cl2.loadClass(name);
            }
            throw new ClassNotFoundException(name);
        }
        return cls;
    }
}

