/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.server.sei;

import com.sun.istack.internal.NotNull;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.NextAction;
import com.sun.xml.internal.ws.api.server.Invoker;
import com.sun.xml.internal.ws.model.AbstractSEIModelImpl;
import com.sun.xml.internal.ws.model.JavaMethodImpl;
import com.sun.xml.internal.ws.server.InvokerTube;
import com.sun.xml.internal.ws.server.WSEndpointImpl;
import com.sun.xml.internal.ws.server.sei.EndpointMethodHandler;
import com.sun.xml.internal.ws.util.QNameMap;
import com.sun.xml.internal.ws.wsdl.DispatchException;
import javax.xml.namespace.QName;

public class SEIInvokerTube
extends InvokerTube {
    private final WSBinding binding;
    private final AbstractSEIModelImpl model;
    private final QNameMap<EndpointMethodHandler> wsdlOpMap;

    public SEIInvokerTube(AbstractSEIModelImpl model, Invoker invoker, WSBinding binding) {
        super(invoker);
        this.binding = binding;
        this.model = model;
        this.wsdlOpMap = new QNameMap();
        for (JavaMethodImpl jm : model.getJavaMethods()) {
            this.wsdlOpMap.put(jm.getOperation().getName(), new EndpointMethodHandler(this, jm, binding));
        }
    }

    @Override
    @NotNull
    public NextAction processRequest(@NotNull Packet req) {
        try {
            QName wsdlOp = ((WSEndpointImpl)this.getEndpoint()).getOperationDispatcher().getWSDLOperationQName(req);
            Packet res = this.wsdlOpMap.get(wsdlOp).invoke(req);
            assert (res != null);
            return this.doReturnWith(res);
        }
        catch (DispatchException e) {
            return this.doReturnWith(req.createServerResponse(e.fault, this.model.getPort(), null, this.binding));
        }
    }

    @Override
    @NotNull
    public NextAction processResponse(@NotNull Packet response) {
        throw new IllegalStateException("InovkerPipe's processResponse shouldn't be called.");
    }

    @Override
    @NotNull
    public NextAction processException(@NotNull Throwable t) {
        throw new IllegalStateException("InovkerPipe's processException shouldn't be called.");
    }
}

