/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ContextualRenderedImageFactory;
import java.awt.image.renderable.ParameterBlock;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.util.Vector;

public class RenderableImageOp
implements RenderableImage {
    ParameterBlock paramBlock;
    ContextualRenderedImageFactory myCRIF;
    Rectangle2D boundingBox;

    public RenderableImageOp(ContextualRenderedImageFactory CRIF, ParameterBlock paramBlock) {
        this.myCRIF = CRIF;
        this.paramBlock = (ParameterBlock)paramBlock.clone();
    }

    @Override
    public Vector<RenderableImage> getSources() {
        return this.getRenderableSources();
    }

    private Vector getRenderableSources() {
        Vector<RenderableImage> sources = null;
        if (this.paramBlock.getNumSources() > 0) {
            Object o;
            sources = new Vector<RenderableImage>();
            for (int i = 0; i < this.paramBlock.getNumSources() && (o = this.paramBlock.getSource(i)) instanceof RenderableImage; ++i) {
                sources.add((RenderableImage)o);
            }
        }
        return sources;
    }

    @Override
    public Object getProperty(String name) {
        return this.myCRIF.getProperty(this.paramBlock, name);
    }

    @Override
    public String[] getPropertyNames() {
        return this.myCRIF.getPropertyNames();
    }

    @Override
    public boolean isDynamic() {
        return this.myCRIF.isDynamic();
    }

    @Override
    public float getWidth() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getWidth();
    }

    @Override
    public float getHeight() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getHeight();
    }

    @Override
    public float getMinX() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinX();
    }

    @Override
    public float getMinY() {
        if (this.boundingBox == null) {
            this.boundingBox = this.myCRIF.getBounds2D(this.paramBlock);
        }
        return (float)this.boundingBox.getMinY();
    }

    public ParameterBlock setParameterBlock(ParameterBlock paramBlock) {
        ParameterBlock oldParamBlock = this.paramBlock;
        this.paramBlock = (ParameterBlock)paramBlock.clone();
        return oldParamBlock;
    }

    public ParameterBlock getParameterBlock() {
        return this.paramBlock;
    }

    @Override
    public RenderedImage createScaledRendering(int w, int h, RenderingHints hints) {
        double sy;
        double sx = (double)w / (double)this.getWidth();
        if (Math.abs(sx / (sy = (double)h / (double)this.getHeight()) - 1.0) < 0.01) {
            sx = sy;
        }
        AffineTransform usr2dev = AffineTransform.getScaleInstance(sx, sy);
        RenderContext newRC = new RenderContext(usr2dev, hints);
        return this.createRendering(newRC);
    }

    @Override
    public RenderedImage createDefaultRendering() {
        AffineTransform usr2dev = new AffineTransform();
        RenderContext newRC = new RenderContext(usr2dev);
        return this.createRendering(newRC);
    }

    @Override
    public RenderedImage createRendering(RenderContext renderContext) {
        Object image = null;
        RenderContext rcOut = null;
        ParameterBlock renderedParamBlock = (ParameterBlock)this.paramBlock.clone();
        Vector sources = this.getRenderableSources();
        try {
            if (sources != null) {
                Vector<Object> renderedSources = new Vector<Object>();
                for (int i = 0; i < sources.size(); ++i) {
                    rcOut = this.myCRIF.mapRenderContext(i, renderContext, this.paramBlock, this);
                    RenderedImage rdrdImage = ((RenderableImage)sources.elementAt(i)).createRendering(rcOut);
                    if (rdrdImage == null) {
                        return null;
                    }
                    renderedSources.addElement(rdrdImage);
                }
                if (renderedSources.size() > 0) {
                    renderedParamBlock.setSources(renderedSources);
                }
            }
            return this.myCRIF.create(renderContext, renderedParamBlock);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
    }
}

