/*
 * Decompiled with CFR 0.152.
 */
package java.beans.beancontext;

import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServiceRevokedListener;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.beans.beancontext.BeanContextSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TooManyListenersException;

public class BeanContextServicesSupport
extends BeanContextSupport
implements BeanContextServices {
    private static final long serialVersionUID = -8494482757288719206L;
    protected transient HashMap services;
    protected transient int serializable = 0;
    protected transient BCSSProxyServiceProvider proxy;
    protected transient ArrayList bcsListeners;

    public BeanContextServicesSupport(BeanContextServices peer, Locale lcle, boolean dTime, boolean visible) {
        super(peer, lcle, dTime, visible);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale lcle, boolean dtime) {
        this(peer, lcle, dtime, true);
    }

    public BeanContextServicesSupport(BeanContextServices peer, Locale lcle) {
        this(peer, lcle, false, true);
    }

    public BeanContextServicesSupport(BeanContextServices peer) {
        this(peer, null, false, true);
    }

    public BeanContextServicesSupport() {
        this(null, null, false, true);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.services = new HashMap(this.serializable + 1);
        this.bcsListeners = new ArrayList(1);
    }

    public BeanContextServices getBeanContextServicesPeer() {
        return (BeanContextServices)this.getBeanContextChildPeer();
    }

    @Override
    protected BeanContextSupport.BCSChild createBCSChild(Object targetChild, Object peer) {
        return new BCSSChild(targetChild, peer);
    }

    protected BCSSServiceProvider createBCSSServiceProvider(Class sc, BeanContextServiceProvider bcsp) {
        return new BCSSServiceProvider(sc, bcsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBeanContextServicesListener(BeanContextServicesListener bcsl) {
        if (bcsl == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (this.bcsListeners.contains(bcsl)) {
                return;
            }
            this.bcsListeners.add(bcsl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBeanContextServicesListener(BeanContextServicesListener bcsl) {
        if (bcsl == null) {
            throw new NullPointerException("bcsl");
        }
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            if (!this.bcsListeners.contains(bcsl)) {
                return;
            }
            this.bcsListeners.remove(bcsl);
        }
    }

    @Override
    public boolean addService(Class serviceClass, BeanContextServiceProvider bcsp) {
        return this.addService(serviceClass, bcsp, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean addService(Class serviceClass, BeanContextServiceProvider bcsp, boolean fireEvent) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (bcsp == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(serviceClass)) {
                return false;
            }
            this.services.put(serviceClass, this.createBCSSServiceProvider(serviceClass, bcsp));
            if (bcsp instanceof Serializable) {
                ++this.serializable;
            }
            if (!fireEvent) {
                return true;
            }
            BeanContextServiceAvailableEvent bcssae = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), serviceClass);
            this.fireServiceAdded(bcssae);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                for (Object c : this.children.keySet()) {
                    if (!(c instanceof BeanContextServices)) continue;
                    ((BeanContextServicesListener)c).serviceAvailable(bcssae);
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeService(Class serviceClass, BeanContextServiceProvider bcsp, boolean revokeCurrentServicesNow) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (bcsp == null) {
            throw new NullPointerException("bcsp");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (!this.services.containsKey(serviceClass)) {
                return;
            }
            BCSSServiceProvider bcsssp = (BCSSServiceProvider)this.services.get(serviceClass);
            if (!bcsssp.getServiceProvider().equals(bcsp)) {
                throw new IllegalArgumentException("service provider mismatch");
            }
            this.services.remove(serviceClass);
            if (bcsp instanceof Serializable) {
                --this.serializable;
            }
            Iterator i = this.bcsChildren();
            while (i.hasNext()) {
                ((BCSSChild)i.next()).revokeService(serviceClass, false, revokeCurrentServicesNow);
            }
            this.fireServiceRevoked(serviceClass, revokeCurrentServicesNow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean hasService(Class serviceClass) {
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            if (this.services.containsKey(serviceClass)) {
                return true;
            }
            BeanContextServices bcs = null;
            try {
                bcs = (BeanContextServices)this.getBeanContext();
            }
            catch (ClassCastException cce) {
                return false;
            }
            return bcs == null ? false : bcs.hasService(serviceClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getService(BeanContextChild child, Object requestor, Class serviceClass, Object serviceSelector, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
        if (child == null) {
            throw new NullPointerException("child");
        }
        if (serviceClass == null) {
            throw new NullPointerException("serviceClass");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor");
        }
        if (bcsrl == null) {
            throw new NullPointerException("bcsrl");
        }
        Object service = null;
        BeanContextServices bcssp = this.getBeanContextServicesPeer();
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            BeanContextServiceProvider bcsp;
            BCSSChild bcsc;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bcsc = (BCSSChild)this.children.get(child);
            }
            if (bcsc == null) {
                throw new IllegalArgumentException("not a child of this context");
            }
            BCSSServiceProvider bcsssp = (BCSSServiceProvider)this.services.get(serviceClass);
            if (bcsssp != null && (service = (bcsp = bcsssp.getServiceProvider()).getService(bcssp, requestor, serviceClass, serviceSelector)) != null) {
                try {
                    bcsc.usingService(requestor, service, serviceClass, bcsp, false, bcsrl);
                }
                catch (TooManyListenersException tmle) {
                    bcsp.releaseService(bcssp, requestor, service);
                    throw tmle;
                }
                catch (UnsupportedOperationException uope) {
                    bcsp.releaseService(bcssp, requestor, service);
                    throw uope;
                }
                return service;
            }
            if (this.proxy != null && (service = this.proxy.getService(bcssp, requestor, serviceClass, serviceSelector)) != null) {
                try {
                    bcsc.usingService(requestor, service, serviceClass, this.proxy, true, bcsrl);
                }
                catch (TooManyListenersException tmle) {
                    this.proxy.releaseService(bcssp, requestor, service);
                    throw tmle;
                }
                catch (UnsupportedOperationException uope) {
                    this.proxy.releaseService(bcssp, requestor, service);
                    throw uope;
                }
                return service;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseService(BeanContextChild child, Object requestor, Object service) {
        if (child == null) {
            throw new NullPointerException("child");
        }
        if (requestor == null) {
            throw new NullPointerException("requestor");
        }
        if (service == null) {
            throw new NullPointerException("service");
        }
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            BCSSChild bcsc;
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                bcsc = (BCSSChild)this.children.get(child);
            }
            if (bcsc == null) {
                throw new IllegalArgumentException("child actual is not a child of this BeanContext");
            }
            bcsc.releaseService(requestor, service);
        }
    }

    @Override
    public Iterator getCurrentServiceClasses() {
        return new BeanContextSupport.BCSIterator(this.services.keySet().iterator());
    }

    @Override
    public Iterator getCurrentServiceSelectors(Class serviceClass) {
        BCSSServiceProvider bcsssp = (BCSSServiceProvider)this.services.get(serviceClass);
        return bcsssp != null ? new BeanContextSupport.BCSIterator(bcsssp.getServiceProvider().getCurrentServiceSelectors(this.getBeanContextServicesPeer(), serviceClass)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceAvailable(BeanContextServiceAvailableEvent bcssae) {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Iterator i;
            if (this.services.containsKey(bcssae.getServiceClass())) {
                return;
            }
            this.fireServiceAdded(bcssae);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                i = this.children.keySet().iterator();
            }
            while (i.hasNext()) {
                Object c = i.next();
                if (!(c instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)c).serviceAvailable(bcssae);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void serviceRevoked(BeanContextServiceRevokedEvent bcssre) {
        Object object = BeanContext.globalHierarchyLock;
        synchronized (object) {
            Iterator i;
            if (this.services.containsKey(bcssre.getServiceClass())) {
                return;
            }
            this.fireServiceRevoked(bcssre);
            HashMap hashMap = this.children;
            synchronized (hashMap) {
                i = this.children.keySet().iterator();
            }
            while (i.hasNext()) {
                Object c = i.next();
                if (!(c instanceof BeanContextServices)) continue;
                ((BeanContextServicesListener)c).serviceRevoked(bcssre);
            }
        }
    }

    protected static final BeanContextServicesListener getChildBeanContextServicesListener(Object child) {
        try {
            return (BeanContextServicesListener)child;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    protected void childJustRemovedHook(Object child, BeanContextSupport.BCSChild bcsc) {
        BCSSChild bcssc = (BCSSChild)bcsc;
        bcssc.cleanupReferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void releaseBeanContextResources() {
        Object[] bcssc;
        super.releaseBeanContextResources();
        HashMap hashMap = this.children;
        synchronized (hashMap) {
            if (this.children.isEmpty()) {
                return;
            }
            bcssc = this.children.values().toArray();
        }
        for (int i = 0; i < bcssc.length; ++i) {
            ((BCSSChild)bcssc[i]).revokeAllDelegatedServicesNow();
        }
        this.proxy = null;
    }

    @Override
    protected synchronized void initializeBeanContextResources() {
        super.initializeBeanContextResources();
        BeanContext nbc = this.getBeanContext();
        if (nbc == null) {
            return;
        }
        try {
            BeanContextServices bcs = (BeanContextServices)nbc;
            this.proxy = new BCSSProxyServiceProvider(bcs);
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected final void fireServiceAdded(Class serviceClass) {
        BeanContextServiceAvailableEvent bcssae = new BeanContextServiceAvailableEvent(this.getBeanContextServicesPeer(), serviceClass);
        this.fireServiceAdded(bcssae);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceAdded(BeanContextServiceAvailableEvent bcssae) {
        Object[] copy;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            copy = this.bcsListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextServicesListener)copy[i]).serviceAvailable(bcssae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(BeanContextServiceRevokedEvent bcsre) {
        Object[] copy;
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            copy = this.bcsListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextServiceRevokedListener)copy[i]).serviceRevoked(bcsre);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireServiceRevoked(Class serviceClass, boolean revokeNow) {
        Object[] copy;
        BeanContextServiceRevokedEvent bcsre = new BeanContextServiceRevokedEvent(this.getBeanContextServicesPeer(), serviceClass, revokeNow);
        ArrayList arrayList = this.bcsListeners;
        synchronized (arrayList) {
            copy = this.bcsListeners.toArray();
        }
        for (int i = 0; i < copy.length; ++i) {
            ((BeanContextServicesListener)copy[i]).serviceRevoked(bcsre);
        }
    }

    @Override
    protected synchronized void bcsPreSerializationHook(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.serializable);
        if (this.serializable <= 0) {
            return;
        }
        int count = 0;
        Iterator i = this.services.entrySet().iterator();
        while (i.hasNext() && count < this.serializable) {
            Map.Entry entry = i.next();
            BCSSServiceProvider bcsp = null;
            try {
                bcsp = (BCSSServiceProvider)entry.getValue();
            }
            catch (ClassCastException cce) {
                continue;
            }
            if (!(bcsp.getServiceProvider() instanceof Serializable)) continue;
            oos.writeObject(entry.getKey());
            oos.writeObject(bcsp);
            ++count;
        }
        if (count != this.serializable) {
            throw new IOException("wrote different number of service providers than expected");
        }
    }

    @Override
    protected synchronized void bcsPreDeserializationHook(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        for (int count = this.serializable = ois.readInt(); count > 0; --count) {
            this.services.put(ois.readObject(), ois.readObject());
        }
    }

    private synchronized void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        this.serialize(oos, this.bcsListeners);
    }

    private synchronized void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.deserialize(ois, this.bcsListeners);
    }

    protected class BCSSProxyServiceProvider
    implements BeanContextServiceProvider,
    BeanContextServiceRevokedListener {
        private BeanContextServices nestingCtxt;

        BCSSProxyServiceProvider(BeanContextServices bcs) {
            this.nestingCtxt = bcs;
        }

        @Override
        public Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector) {
            Object service = null;
            try {
                service = this.nestingCtxt.getService(bcs, requestor, serviceClass, serviceSelector, this);
            }
            catch (TooManyListenersException tmle) {
                return null;
            }
            return service;
        }

        @Override
        public void releaseService(BeanContextServices bcs, Object requestor, Object service) {
            this.nestingCtxt.releaseService(bcs, requestor, service);
        }

        @Override
        public Iterator getCurrentServiceSelectors(BeanContextServices bcs, Class serviceClass) {
            return this.nestingCtxt.getCurrentServiceSelectors(serviceClass);
        }

        @Override
        public void serviceRevoked(BeanContextServiceRevokedEvent bcsre) {
            Iterator i = BeanContextServicesSupport.this.bcsChildren();
            while (i.hasNext()) {
                ((BCSSChild)i.next()).revokeService(bcsre.getServiceClass(), true, bcsre.isCurrentServiceInvalidNow());
            }
        }
    }

    protected static class BCSSServiceProvider
    implements Serializable {
        private static final long serialVersionUID = 861278251667444782L;
        protected BeanContextServiceProvider serviceProvider;

        BCSSServiceProvider(Class sc, BeanContextServiceProvider bcsp) {
            this.serviceProvider = bcsp;
        }

        protected BeanContextServiceProvider getServiceProvider() {
            return this.serviceProvider;
        }
    }

    protected class BCSSChild
    extends BeanContextSupport.BCSChild {
        private static final long serialVersionUID = -3263851306889194873L;
        private transient HashMap serviceClasses;
        private transient HashMap serviceRequestors;

        BCSSChild(Object bcc, Object peer) {
            super(BeanContextServicesSupport.this, bcc, peer);
        }

        synchronized void usingService(Object requestor, Object service, Class serviceClass, BeanContextServiceProvider bcsp, boolean isDelegated, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException, UnsupportedOperationException {
            BCSSCServiceClassRef serviceClassRef = null;
            if (this.serviceClasses == null) {
                this.serviceClasses = new HashMap(1);
            } else {
                serviceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(serviceClass);
            }
            if (serviceClassRef == null) {
                serviceClassRef = new BCSSCServiceClassRef(serviceClass, bcsp, isDelegated);
                this.serviceClasses.put(serviceClass, serviceClassRef);
            } else {
                serviceClassRef.verifyAndMaybeSetProvider(bcsp, isDelegated);
                serviceClassRef.verifyRequestor(requestor, bcsrl);
            }
            serviceClassRef.addRequestor(requestor, bcsrl);
            serviceClassRef.addRef(isDelegated);
            BCSSCServiceRef serviceRef = null;
            HashMap<Object, BCSSCServiceRef> services = null;
            if (this.serviceRequestors == null) {
                this.serviceRequestors = new HashMap(1);
            } else {
                services = (HashMap<Object, BCSSCServiceRef>)this.serviceRequestors.get(requestor);
            }
            if (services == null) {
                services = new HashMap<Object, BCSSCServiceRef>(1);
                this.serviceRequestors.put(requestor, services);
            } else {
                serviceRef = (BCSSCServiceRef)services.get(service);
            }
            if (serviceRef == null) {
                serviceRef = new BCSSCServiceRef(serviceClassRef, isDelegated);
                services.put(service, serviceRef);
            } else {
                serviceRef.addRef();
            }
        }

        synchronized void releaseService(Object requestor, Object service) {
            if (this.serviceRequestors == null) {
                return;
            }
            Map services = (Map)this.serviceRequestors.get(requestor);
            if (services == null) {
                return;
            }
            BCSSCServiceRef serviceRef = (BCSSCServiceRef)services.get(service);
            if (serviceRef == null) {
                return;
            }
            BCSSCServiceClassRef serviceClassRef = serviceRef.getServiceClassRef();
            boolean isDelegated = serviceRef.isDelegated();
            BeanContextServiceProvider bcsp = isDelegated ? serviceClassRef.getDelegateProvider() : serviceClassRef.getServiceProvider();
            bcsp.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), requestor, service);
            serviceClassRef.releaseRef(isDelegated);
            serviceClassRef.removeRequestor(requestor);
            if (serviceRef.release() == 0) {
                services.remove(service);
                if (services.isEmpty()) {
                    this.serviceRequestors.remove(requestor);
                    serviceClassRef.removeRequestor(requestor);
                }
                if (this.serviceRequestors.isEmpty()) {
                    this.serviceRequestors = null;
                }
                if (serviceClassRef.isEmpty()) {
                    this.serviceClasses.remove(serviceClassRef.getServiceClass());
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
        }

        synchronized void revokeService(Class serviceClass, boolean isDelegated, boolean revokeNow) {
            if (this.serviceClasses == null) {
                return;
            }
            BCSSCServiceClassRef serviceClassRef = (BCSSCServiceClassRef)this.serviceClasses.get(serviceClass);
            if (serviceClassRef == null) {
                return;
            }
            Iterator i = serviceClassRef.cloneOfEntries();
            BeanContextServiceRevokedEvent bcsre = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), serviceClass, revokeNow);
            boolean noMoreRefs = false;
            while (i.hasNext() && this.serviceRequestors != null) {
                Map.Entry entry = (Map.Entry)i.next();
                BeanContextServiceRevokedListener listener = (BeanContextServiceRevokedListener)entry.getValue();
                if (revokeNow) {
                    Object requestor = entry.getKey();
                    Map services = (Map)this.serviceRequestors.get(requestor);
                    if (services != null) {
                        Iterator i1 = services.entrySet().iterator();
                        while (i1.hasNext()) {
                            Map.Entry tmp = i1.next();
                            BCSSCServiceRef serviceRef = (BCSSCServiceRef)tmp.getValue();
                            if (!serviceRef.getServiceClassRef().equals(serviceClassRef) || isDelegated != serviceRef.isDelegated()) continue;
                            i1.remove();
                        }
                        noMoreRefs = services.isEmpty();
                        if (noMoreRefs) {
                            this.serviceRequestors.remove(requestor);
                        }
                    }
                    if (noMoreRefs) {
                        serviceClassRef.removeRequestor(requestor);
                    }
                }
                listener.serviceRevoked(bcsre);
            }
            if (revokeNow && this.serviceClasses != null) {
                if (serviceClassRef.isEmpty()) {
                    this.serviceClasses.remove(serviceClass);
                }
                if (this.serviceClasses.isEmpty()) {
                    this.serviceClasses = null;
                }
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        void cleanupReferences() {
            if (this.serviceRequestors == null) {
                return;
            }
            Iterator requestors = this.serviceRequestors.entrySet().iterator();
            while (requestors.hasNext()) {
                Map.Entry tmp = requestors.next();
                Object requestor = tmp.getKey();
                Iterator services = ((Map)tmp.getValue()).entrySet().iterator();
                requestors.remove();
                while (services.hasNext()) {
                    Map.Entry entry = services.next();
                    Object service = entry.getKey();
                    BCSSCServiceRef sref = (BCSSCServiceRef)entry.getValue();
                    BCSSCServiceClassRef scref = sref.getServiceClassRef();
                    BeanContextServiceProvider bcsp = sref.isDelegated() ? scref.getDelegateProvider() : scref.getServiceProvider();
                    scref.removeRequestor(requestor);
                    services.remove();
                    while (sref.release() >= 0) {
                        bcsp.releaseService(BeanContextServicesSupport.this.getBeanContextServicesPeer(), requestor, service);
                    }
                }
            }
            this.serviceRequestors = null;
            this.serviceClasses = null;
        }

        void revokeAllDelegatedServicesNow() {
            if (this.serviceClasses == null) {
                return;
            }
            for (BCSSCServiceClassRef serviceClassRef : new HashSet(this.serviceClasses.values())) {
                if (!serviceClassRef.isDelegated()) continue;
                Iterator i = serviceClassRef.cloneOfEntries();
                BeanContextServiceRevokedEvent bcsre = new BeanContextServiceRevokedEvent(BeanContextServicesSupport.this.getBeanContextServicesPeer(), serviceClassRef.getServiceClass(), true);
                boolean noMoreRefs = false;
                while (i.hasNext()) {
                    Map.Entry entry = (Map.Entry)i.next();
                    BeanContextServiceRevokedListener listener = (BeanContextServiceRevokedListener)entry.getValue();
                    Object requestor = entry.getKey();
                    Map services = (Map)this.serviceRequestors.get(requestor);
                    if (services != null) {
                        Iterator i1 = services.entrySet().iterator();
                        while (i1.hasNext()) {
                            Map.Entry tmp = i1.next();
                            BCSSCServiceRef serviceRef = (BCSSCServiceRef)tmp.getValue();
                            if (!serviceRef.getServiceClassRef().equals(serviceClassRef) || !serviceRef.isDelegated()) continue;
                            i1.remove();
                        }
                        noMoreRefs = services.isEmpty();
                        if (noMoreRefs) {
                            this.serviceRequestors.remove(requestor);
                        }
                    }
                    if (noMoreRefs) {
                        serviceClassRef.removeRequestor(requestor);
                    }
                    listener.serviceRevoked(bcsre);
                    if (!serviceClassRef.isEmpty()) continue;
                    this.serviceClasses.remove(serviceClassRef.getServiceClass());
                }
            }
            if (this.serviceClasses.isEmpty()) {
                this.serviceClasses = null;
            }
            if (this.serviceRequestors != null && this.serviceRequestors.isEmpty()) {
                this.serviceRequestors = null;
            }
        }

        class BCSSCServiceRef {
            BCSSCServiceClassRef serviceClassRef;
            int refCnt = 1;
            boolean delegated = false;

            BCSSCServiceRef(BCSSCServiceClassRef scref, boolean isDelegated) {
                this.serviceClassRef = scref;
                this.delegated = isDelegated;
            }

            void addRef() {
                ++this.refCnt;
            }

            int release() {
                return --this.refCnt;
            }

            BCSSCServiceClassRef getServiceClassRef() {
                return this.serviceClassRef;
            }

            boolean isDelegated() {
                return this.delegated;
            }
        }

        class BCSSCServiceClassRef {
            Class serviceClass;
            BeanContextServiceProvider serviceProvider;
            int serviceRefs;
            BeanContextServiceProvider delegateProvider;
            int delegateRefs;
            HashMap requestors = new HashMap(1);

            BCSSCServiceClassRef(Class sc, BeanContextServiceProvider bcsp, boolean delegated) {
                this.serviceClass = sc;
                if (delegated) {
                    this.delegateProvider = bcsp;
                } else {
                    this.serviceProvider = bcsp;
                }
            }

            void addRequestor(Object requestor, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
                BeanContextServiceRevokedListener cbcsrl = (BeanContextServiceRevokedListener)this.requestors.get(requestor);
                if (cbcsrl != null && !cbcsrl.equals(bcsrl)) {
                    throw new TooManyListenersException();
                }
                this.requestors.put(requestor, bcsrl);
            }

            void removeRequestor(Object requestor) {
                this.requestors.remove(requestor);
            }

            void verifyRequestor(Object requestor, BeanContextServiceRevokedListener bcsrl) throws TooManyListenersException {
                BeanContextServiceRevokedListener cbcsrl = (BeanContextServiceRevokedListener)this.requestors.get(requestor);
                if (cbcsrl != null && !cbcsrl.equals(bcsrl)) {
                    throw new TooManyListenersException();
                }
            }

            void verifyAndMaybeSetProvider(BeanContextServiceProvider bcsp, boolean isDelegated) {
                BeanContextServiceProvider current;
                if (isDelegated) {
                    current = this.delegateProvider;
                    if (current == null || bcsp == null) {
                        this.delegateProvider = bcsp;
                        return;
                    }
                } else {
                    current = this.serviceProvider;
                    if (current == null || bcsp == null) {
                        this.serviceProvider = bcsp;
                        return;
                    }
                }
                if (!current.equals(bcsp)) {
                    throw new UnsupportedOperationException("existing service reference obtained from different BeanContextServiceProvider not supported");
                }
            }

            Iterator cloneOfEntries() {
                return ((HashMap)this.requestors.clone()).entrySet().iterator();
            }

            Iterator entries() {
                return this.requestors.entrySet().iterator();
            }

            boolean isEmpty() {
                return this.requestors.isEmpty();
            }

            Class getServiceClass() {
                return this.serviceClass;
            }

            BeanContextServiceProvider getServiceProvider() {
                return this.serviceProvider;
            }

            BeanContextServiceProvider getDelegateProvider() {
                return this.delegateProvider;
            }

            boolean isDelegated() {
                return this.delegateProvider != null;
            }

            void addRef(boolean delegated) {
                if (delegated) {
                    ++this.delegateRefs;
                } else {
                    ++this.serviceRefs;
                }
            }

            void releaseRef(boolean delegated) {
                if (delegated) {
                    if (--this.delegateRefs == 0) {
                        this.delegateProvider = null;
                    }
                } else if (--this.serviceRefs <= 0) {
                    this.serviceProvider = null;
                }
            }

            int getRefs() {
                return this.serviceRefs + this.delegateRefs;
            }

            int getDelegateRefs() {
                return this.delegateRefs;
            }

            int getServiceRefs() {
                return this.serviceRefs;
            }
        }
    }
}

