/*
 * Decompiled with CFR 0.152.
 */
package javax.naming;

import java.util.Enumeration;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.Vector;
import javax.naming.InvalidNameException;
import javax.naming.NameImplEnumerator;

class NameImpl {
    private static final byte LEFT_TO_RIGHT = 1;
    private static final byte RIGHT_TO_LEFT = 2;
    private static final byte FLAT = 0;
    private Vector<String> components;
    private byte syntaxDirection = 1;
    private String syntaxSeparator = "/";
    private String syntaxSeparator2 = null;
    private boolean syntaxCaseInsensitive = false;
    private boolean syntaxTrimBlanks = false;
    private String syntaxEscape = "\\";
    private String syntaxBeginQuote1 = "\"";
    private String syntaxEndQuote1 = "\"";
    private String syntaxBeginQuote2 = "'";
    private String syntaxEndQuote2 = "'";
    private String syntaxAvaSeparator = null;
    private String syntaxTypevalSeparator = null;
    private static final int STYLE_NONE = 0;
    private static final int STYLE_QUOTE1 = 1;
    private static final int STYLE_QUOTE2 = 2;
    private static final int STYLE_ESCAPE = 3;
    private int escapingStyle = 0;

    private final boolean isA(String n, int i, String match) {
        return match != null && n.startsWith(match, i);
    }

    private final boolean isMeta(String n, int i) {
        return this.isA(n, i, this.syntaxEscape) || this.isA(n, i, this.syntaxBeginQuote1) || this.isA(n, i, this.syntaxBeginQuote2) || this.isSeparator(n, i);
    }

    private final boolean isSeparator(String n, int i) {
        return this.isA(n, i, this.syntaxSeparator) || this.isA(n, i, this.syntaxSeparator2);
    }

    private final int skipSeparator(String name, int i) {
        if (this.isA(name, i, this.syntaxSeparator)) {
            i += this.syntaxSeparator.length();
        } else if (this.isA(name, i, this.syntaxSeparator2)) {
            i += this.syntaxSeparator2.length();
        }
        return i;
    }

    private final int extractComp(String name, int i, int len, Vector<String> comps) throws InvalidNameException {
        boolean start = true;
        boolean one = false;
        StringBuffer answer = new StringBuffer(len);
        while (i < len) {
            if (start && ((one = this.isA(name, i, this.syntaxBeginQuote1)) || this.isA(name, i, this.syntaxBeginQuote2))) {
                String endQuote;
                String beginQuote = one ? this.syntaxBeginQuote1 : this.syntaxBeginQuote2;
                String string = endQuote = one ? this.syntaxEndQuote1 : this.syntaxEndQuote2;
                if (this.escapingStyle == 0) {
                    this.escapingStyle = one ? 1 : 2;
                }
                i += beginQuote.length();
                while (i < len && !name.startsWith(endQuote, i)) {
                    if (this.isA(name, i, this.syntaxEscape) && this.isA(name, i + this.syntaxEscape.length(), endQuote)) {
                        i += this.syntaxEscape.length();
                    }
                    answer.append(name.charAt(i));
                    ++i;
                }
                if (i >= len) {
                    throw new InvalidNameException(name + ": no close quote");
                }
                if ((i += endQuote.length()) == len || this.isSeparator(name, i)) break;
                throw new InvalidNameException(name + ": close quote appears before end of component");
            }
            if (this.isSeparator(name, i)) break;
            if (this.isA(name, i, this.syntaxEscape)) {
                if (this.isMeta(name, i + this.syntaxEscape.length())) {
                    i += this.syntaxEscape.length();
                    if (this.escapingStyle == 0) {
                        this.escapingStyle = 3;
                    }
                } else if (i + this.syntaxEscape.length() >= len) {
                    throw new InvalidNameException(name + ": unescaped " + this.syntaxEscape + " at end of component");
                }
            } else if (this.isA(name, i, this.syntaxTypevalSeparator) && ((one = this.isA(name, i + this.syntaxTypevalSeparator.length(), this.syntaxBeginQuote1)) || this.isA(name, i + this.syntaxTypevalSeparator.length(), this.syntaxBeginQuote2))) {
                String beginQuote = one ? this.syntaxBeginQuote1 : this.syntaxBeginQuote2;
                String endQuote = one ? this.syntaxEndQuote1 : this.syntaxEndQuote2;
                i += this.syntaxTypevalSeparator.length();
                answer.append(this.syntaxTypevalSeparator + beginQuote);
                i += beginQuote.length();
                while (i < len && !name.startsWith(endQuote, i)) {
                    if (this.isA(name, i, this.syntaxEscape) && this.isA(name, i + this.syntaxEscape.length(), endQuote)) {
                        i += this.syntaxEscape.length();
                    }
                    answer.append(name.charAt(i));
                    ++i;
                }
                if (i >= len) {
                    throw new InvalidNameException(name + ": typeval no close quote");
                }
                answer.append(endQuote);
                if ((i += endQuote.length()) == len || this.isSeparator(name, i)) break;
                throw new InvalidNameException(name.substring(i) + ": typeval close quote appears before end of component");
            }
            answer.append(name.charAt(i++));
            start = false;
        }
        if (this.syntaxDirection == 2) {
            comps.insertElementAt(answer.toString(), 0);
        } else {
            comps.addElement(answer.toString());
        }
        return i;
    }

    private static boolean getBoolean(Properties p, String name) {
        return NameImpl.toBoolean(p.getProperty(name));
    }

    private static boolean toBoolean(String name) {
        return name != null && name.toLowerCase(Locale.ENGLISH).equals("true");
    }

    private final void recordNamingConvention(Properties p) {
        String syntaxDirectionStr = p.getProperty("jndi.syntax.direction", "flat");
        if (syntaxDirectionStr.equals("left_to_right")) {
            this.syntaxDirection = 1;
        } else if (syntaxDirectionStr.equals("right_to_left")) {
            this.syntaxDirection = (byte)2;
        } else if (syntaxDirectionStr.equals("flat")) {
            this.syntaxDirection = 0;
        } else {
            throw new IllegalArgumentException(syntaxDirectionStr + "is not a valid value for the jndi.syntax.direction property");
        }
        if (this.syntaxDirection != 0) {
            this.syntaxSeparator = p.getProperty("jndi.syntax.separator");
            this.syntaxSeparator2 = p.getProperty("jndi.syntax.separator2");
            if (this.syntaxSeparator == null) {
                throw new IllegalArgumentException("jndi.syntax.separator property required for non-flat syntax");
            }
        } else {
            this.syntaxSeparator = null;
        }
        this.syntaxEscape = p.getProperty("jndi.syntax.escape");
        this.syntaxCaseInsensitive = NameImpl.getBoolean(p, "jndi.syntax.ignorecase");
        this.syntaxTrimBlanks = NameImpl.getBoolean(p, "jndi.syntax.trimblanks");
        this.syntaxBeginQuote1 = p.getProperty("jndi.syntax.beginquote");
        this.syntaxEndQuote1 = p.getProperty("jndi.syntax.endquote");
        if (this.syntaxEndQuote1 == null && this.syntaxBeginQuote1 != null) {
            this.syntaxEndQuote1 = this.syntaxBeginQuote1;
        } else if (this.syntaxBeginQuote1 == null && this.syntaxEndQuote1 != null) {
            this.syntaxBeginQuote1 = this.syntaxEndQuote1;
        }
        this.syntaxBeginQuote2 = p.getProperty("jndi.syntax.beginquote2");
        this.syntaxEndQuote2 = p.getProperty("jndi.syntax.endquote2");
        if (this.syntaxEndQuote2 == null && this.syntaxBeginQuote2 != null) {
            this.syntaxEndQuote2 = this.syntaxBeginQuote2;
        } else if (this.syntaxBeginQuote2 == null && this.syntaxEndQuote2 != null) {
            this.syntaxBeginQuote2 = this.syntaxEndQuote2;
        }
        this.syntaxAvaSeparator = p.getProperty("jndi.syntax.separator.ava");
        this.syntaxTypevalSeparator = p.getProperty("jndi.syntax.separator.typeval");
    }

    NameImpl(Properties syntax) {
        if (syntax != null) {
            this.recordNamingConvention(syntax);
        }
        this.components = new Vector();
    }

    NameImpl(Properties syntax, String n) throws InvalidNameException {
        this(syntax);
        boolean rToL = this.syntaxDirection == 2;
        boolean compsAllEmpty = true;
        int len = n.length();
        int i = 0;
        while (i < len) {
            String comp;
            i = this.extractComp(n, i, len, this.components);
            String string = comp = rToL ? this.components.firstElement() : this.components.lastElement();
            if (comp.length() >= 1) {
                compsAllEmpty = false;
            }
            if (i >= len || (i = this.skipSeparator(n, i)) != len || compsAllEmpty) continue;
            if (rToL) {
                this.components.insertElementAt("", 0);
                continue;
            }
            this.components.addElement("");
        }
    }

    NameImpl(Properties syntax, Enumeration<String> comps) {
        this(syntax);
        while (comps.hasMoreElements()) {
            this.components.addElement(comps.nextElement());
        }
    }

    private final String stringifyComp(String comp) {
        int len = comp.length();
        boolean escapeSeparator = false;
        boolean escapeSeparator2 = false;
        String beginQuote = null;
        String endQuote = null;
        StringBuffer strbuf = new StringBuffer(len);
        if (this.syntaxSeparator != null && comp.indexOf(this.syntaxSeparator) >= 0) {
            if (this.syntaxBeginQuote1 != null) {
                beginQuote = this.syntaxBeginQuote1;
                endQuote = this.syntaxEndQuote1;
            } else if (this.syntaxBeginQuote2 != null) {
                beginQuote = this.syntaxBeginQuote2;
                endQuote = this.syntaxEndQuote2;
            } else if (this.syntaxEscape != null) {
                escapeSeparator = true;
            }
        }
        if (this.syntaxSeparator2 != null && comp.indexOf(this.syntaxSeparator2) >= 0) {
            if (this.syntaxBeginQuote1 != null) {
                if (beginQuote == null) {
                    beginQuote = this.syntaxBeginQuote1;
                    endQuote = this.syntaxEndQuote1;
                }
            } else if (this.syntaxBeginQuote2 != null) {
                if (beginQuote == null) {
                    beginQuote = this.syntaxBeginQuote2;
                    endQuote = this.syntaxEndQuote2;
                }
            } else if (this.syntaxEscape != null) {
                escapeSeparator2 = true;
            }
        }
        if (beginQuote != null) {
            strbuf = strbuf.append(beginQuote);
            int i = 0;
            while (i < len) {
                if (comp.startsWith(endQuote, i)) {
                    strbuf.append(this.syntaxEscape).append(endQuote);
                    i += endQuote.length();
                    continue;
                }
                strbuf.append(comp.charAt(i++));
            }
            strbuf.append(endQuote);
        } else {
            boolean start = true;
            int i = 0;
            while (i < len) {
                if (start && this.isA(comp, i, this.syntaxBeginQuote1)) {
                    strbuf.append(this.syntaxEscape).append(this.syntaxBeginQuote1);
                    i += this.syntaxBeginQuote1.length();
                } else if (start && this.isA(comp, i, this.syntaxBeginQuote2)) {
                    strbuf.append(this.syntaxEscape).append(this.syntaxBeginQuote2);
                    i += this.syntaxBeginQuote2.length();
                } else if (this.isA(comp, i, this.syntaxEscape)) {
                    if (i + this.syntaxEscape.length() >= len) {
                        strbuf.append(this.syntaxEscape);
                    } else if (this.isMeta(comp, i + this.syntaxEscape.length())) {
                        strbuf.append(this.syntaxEscape);
                    }
                    strbuf.append(this.syntaxEscape);
                    i += this.syntaxEscape.length();
                } else if (escapeSeparator && comp.startsWith(this.syntaxSeparator, i)) {
                    strbuf.append(this.syntaxEscape).append(this.syntaxSeparator);
                    i += this.syntaxSeparator.length();
                } else if (escapeSeparator2 && comp.startsWith(this.syntaxSeparator2, i)) {
                    strbuf.append(this.syntaxEscape).append(this.syntaxSeparator2);
                    i += this.syntaxSeparator2.length();
                } else {
                    strbuf.append(comp.charAt(i++));
                }
                start = false;
            }
        }
        return strbuf.toString();
    }

    public String toString() {
        StringBuffer answer = new StringBuffer();
        boolean compsAllEmpty = true;
        int size = this.components.size();
        for (int i = 0; i < size; ++i) {
            String comp = this.syntaxDirection == 2 ? this.stringifyComp(this.components.elementAt(size - 1 - i)) : this.stringifyComp(this.components.elementAt(i));
            if (i != 0 && this.syntaxSeparator != null) {
                answer.append(this.syntaxSeparator);
            }
            if (comp.length() >= 1) {
                compsAllEmpty = false;
            }
            answer = answer.append(comp);
        }
        if (compsAllEmpty && size >= 1 && this.syntaxSeparator != null) {
            answer = answer.append(this.syntaxSeparator);
        }
        return answer.toString();
    }

    public boolean equals(Object obj) {
        NameImpl target;
        if (obj != null && obj instanceof NameImpl && (target = (NameImpl)obj).size() == this.size()) {
            Enumeration<String> mycomps = this.getAll();
            Enumeration<String> comps = target.getAll();
            while (mycomps.hasMoreElements()) {
                String my = mycomps.nextElement();
                String his = comps.nextElement();
                if (this.syntaxTrimBlanks) {
                    my = my.trim();
                    his = his.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !my.equalsIgnoreCase(his) : !my.equals(his))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareTo(NameImpl obj) {
        if (this == obj) {
            return 0;
        }
        int len1 = this.size();
        int len2 = obj.size();
        int n = Math.min(len1, len2);
        int index1 = 0;
        int index2 = 0;
        while (n-- != 0) {
            int local;
            String comp1 = this.get(index1++);
            String comp2 = obj.get(index2++);
            if (this.syntaxTrimBlanks) {
                comp1 = comp1.trim();
                comp2 = comp2.trim();
            }
            if ((local = this.syntaxCaseInsensitive ? comp1.compareToIgnoreCase(comp2) : comp1.compareTo(comp2)) == 0) continue;
            return local;
        }
        return len1 - len2;
    }

    public int size() {
        return this.components.size();
    }

    public Enumeration<String> getAll() {
        return this.components.elements();
    }

    public String get(int posn) {
        return this.components.elementAt(posn);
    }

    public Enumeration<String> getPrefix(int posn) {
        if (posn < 0 || posn > this.size()) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        return new NameImplEnumerator(this.components, 0, posn);
    }

    public Enumeration<String> getSuffix(int posn) {
        int cnt = this.size();
        if (posn < 0 || posn > cnt) {
            throw new ArrayIndexOutOfBoundsException(posn);
        }
        return new NameImplEnumerator(this.components, posn, cnt);
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    public boolean startsWith(int posn, Enumeration<String> prefix) {
        if (posn < 0 || posn > this.size()) {
            return false;
        }
        try {
            Enumeration<String> mycomps = this.getPrefix(posn);
            while (mycomps.hasMoreElements()) {
                String my = mycomps.nextElement();
                String his = prefix.nextElement();
                if (this.syntaxTrimBlanks) {
                    my = my.trim();
                    his = his.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !my.equalsIgnoreCase(his) : !my.equals(his))) continue;
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public boolean endsWith(int posn, Enumeration<String> suffix) {
        int startIndex = this.size() - posn;
        if (startIndex < 0 || startIndex > this.size()) {
            return false;
        }
        try {
            Enumeration<String> mycomps = this.getSuffix(startIndex);
            while (mycomps.hasMoreElements()) {
                String my = mycomps.nextElement();
                String his = suffix.nextElement();
                if (this.syntaxTrimBlanks) {
                    my = my.trim();
                    his = his.trim();
                }
                if (!(this.syntaxCaseInsensitive ? !my.equalsIgnoreCase(his) : !my.equals(his))) continue;
                return false;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public boolean addAll(Enumeration<String> comps) throws InvalidNameException {
        boolean added = false;
        while (comps.hasMoreElements()) {
            try {
                String comp = comps.nextElement();
                if (this.size() > 0 && this.syntaxDirection == 0) {
                    throw new InvalidNameException("A flat name can only have a single component");
                }
                this.components.addElement(comp);
                added = true;
            }
            catch (NoSuchElementException e) {
                break;
            }
        }
        return added;
    }

    public boolean addAll(int posn, Enumeration<String> comps) throws InvalidNameException {
        boolean added = false;
        int i = posn;
        while (comps.hasMoreElements()) {
            try {
                String comp = comps.nextElement();
                if (this.size() > 0 && this.syntaxDirection == 0) {
                    throw new InvalidNameException("A flat name can only have a single component");
                }
                this.components.insertElementAt(comp, i);
                added = true;
            }
            catch (NoSuchElementException e) {
                break;
            }
            ++i;
        }
        return added;
    }

    public void add(String comp) throws InvalidNameException {
        if (this.size() > 0 && this.syntaxDirection == 0) {
            throw new InvalidNameException("A flat name can only have a single component");
        }
        this.components.addElement(comp);
    }

    public void add(int posn, String comp) throws InvalidNameException {
        if (this.size() > 0 && this.syntaxDirection == 0) {
            throw new InvalidNameException("A flat name can only zero or one component");
        }
        this.components.insertElementAt(comp, posn);
    }

    public Object remove(int posn) {
        String r = this.components.elementAt(posn);
        this.components.removeElementAt(posn);
        return r;
    }

    public int hashCode() {
        int hash = 0;
        Enumeration<String> e = this.getAll();
        while (e.hasMoreElements()) {
            String comp = e.nextElement();
            if (this.syntaxTrimBlanks) {
                comp = comp.trim();
            }
            if (this.syntaxCaseInsensitive) {
                comp = comp.toLowerCase(Locale.ENGLISH);
            }
            hash += comp.hashCode();
        }
        return hash;
    }
}

