/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.InvalidDnDOperationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.awt.AWTAccessor;
import sun.awt.X11.Native;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConstants;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XDragAndDropProtocols;
import sun.awt.X11.XDragSourceProtocol;
import sun.awt.X11.XDragSourceProtocolListener;
import sun.awt.X11.XEvent;
import sun.awt.X11.XException;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.awt.dnd.SunDragSourceContextPeer;
import sun.awt.dnd.SunDropTargetContextPeer;
import sun.util.logging.PlatformLogger;

public final class XDragSourceContextPeer
extends SunDragSourceContextPeer
implements XDragSourceProtocolListener {
    private static final PlatformLogger logger = PlatformLogger.getLogger("sun.awt.X11.xembed.xdnd.XDragSourceContextPeer");
    private static final int ROOT_EVENT_MASK = 8195;
    private static final int GRAB_EVENT_MASK = 8204;
    private long rootEventMask = 0L;
    private boolean dndInProgress = false;
    private boolean dragInProgress = false;
    private long dragRootWindow = 0L;
    private XDragSourceProtocol dragProtocol = null;
    private int targetAction = 0;
    private int sourceActions = 0;
    private int sourceAction = 0;
    private long[] sourceFormats = null;
    private long targetRootSubwindow = 0L;
    private int xRoot = 0;
    private int yRoot = 0;
    private int eventState = 0;
    private long proxyModeSourceWindow = 0L;
    private static final XDragSourceContextPeer theInstance = new XDragSourceContextPeer(null);

    private XDragSourceContextPeer(DragGestureEvent dge) {
        super(dge);
    }

    static XDragSourceProtocolListener getXDragSourceProtocolListener() {
        return theInstance;
    }

    static XDragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dge) throws InvalidDnDOperationException {
        theInstance.setTrigger(dge);
        return theInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startDrag(Transferable transferable, long[] formats, Map formatMap) {
        Component component = this.getTrigger().getComponent();
        Component c = null;
        XWindowPeer wpeer = null;
        c = component;
        while (c != null && !(c instanceof Window)) {
            c = AWTAccessor.getComponentAccessor().getParent(c);
        }
        if (c instanceof Window) {
            wpeer = (XWindowPeer)c.getPeer();
        }
        if (wpeer == null) {
            throw new InvalidDnDOperationException("Cannot find top-level for the drag source component");
        }
        long xcursor = 0L;
        long rootWindow = 0L;
        long dragWindow = 0L;
        long timeStamp = 0L;
        Cursor cursor = this.getCursor();
        if (cursor != null) {
            xcursor = XGlobalCursorManager.getCursor(cursor);
        }
        XToolkit.awtLock();
        try {
            int status;
            if (this.proxyModeSourceWindow != 0L) {
                throw new InvalidDnDOperationException("Proxy drag in progress");
            }
            if (this.dndInProgress) {
                throw new InvalidDnDOperationException("Drag in progress");
            }
            long screen = XlibWrapper.XScreenNumberOfScreen(wpeer.getScreen());
            rootWindow = XlibWrapper.RootWindow(XToolkit.getDisplay(), screen);
            dragWindow = XWindow.getXAWTRootWindow().getWindow();
            timeStamp = XToolkit.getCurrentServerTime();
            int dropActions = this.getDragSourceContext().getSourceActions();
            Iterator dragProtocols = XDragAndDropProtocols.getDragSourceProtocols();
            while (dragProtocols.hasNext()) {
                XDragSourceProtocol dragProtocol = (XDragSourceProtocol)dragProtocols.next();
                try {
                    dragProtocol.initializeDrag(dropActions, transferable, formatMap, formats);
                }
                catch (XException xe) {
                    throw (InvalidDnDOperationException)new InvalidDnDOperationException().initCause(xe);
                }
            }
            XWindowAttributes wattr = new XWindowAttributes();
            try {
                status = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), rootWindow, wattr.pData);
                if (status == 0) {
                    throw new InvalidDnDOperationException("XGetWindowAttributes failed");
                }
                this.rootEventMask = wattr.get_your_event_mask();
                XlibWrapper.XSelectInput(XToolkit.getDisplay(), rootWindow, this.rootEventMask | 0x2003L);
            }
            finally {
                wattr.dispose();
            }
            XBaseWindow.ungrabInput();
            status = XlibWrapper.XGrabPointer(XToolkit.getDisplay(), rootWindow, 0, 8204, 1, 1, 0L, xcursor, timeStamp);
            if (status != 0) {
                this.cleanup(timeStamp);
                this.throwGrabFailureException("Cannot grab pointer", status);
                return;
            }
            status = XlibWrapper.XGrabKeyboard(XToolkit.getDisplay(), rootWindow, 0, 1, 1, timeStamp);
            if (status != 0) {
                this.cleanup(timeStamp);
                this.throwGrabFailureException("Cannot grab keyboard", status);
                return;
            }
            this.dndInProgress = true;
            this.dragInProgress = true;
            this.dragRootWindow = rootWindow;
            this.sourceActions = dropActions;
            this.sourceFormats = formats;
        }
        finally {
            XToolkit.awtUnlock();
        }
        this.setNativeContext(0L);
        SunDropTargetContextPeer.setCurrentJVMLocalSourceTransferable(transferable);
    }

    public long getProxyModeSourceWindow() {
        return this.proxyModeSourceWindow;
    }

    private void setProxyModeSourceWindowImpl(long window) {
        this.proxyModeSourceWindow = window;
    }

    public static void setProxyModeSourceWindow(long window) {
        theInstance.setProxyModeSourceWindowImpl(window);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(Cursor c) throws InvalidDnDOperationException {
        XToolkit.awtLock();
        try {
            super.setCursor(c);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    protected void setNativeCursor(long nativeCtxt, Cursor c, int cType) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (c == null) {
            return;
        }
        long xcursor = XGlobalCursorManager.getCursor(c);
        if (xcursor == 0L) {
            return;
        }
        XlibWrapper.XChangeActivePointerGrab(XToolkit.getDisplay(), 8204, xcursor, 0L);
    }

    protected boolean needsBogusExitBeforeDrop() {
        return false;
    }

    private void throwGrabFailureException(String msg, int grabStatus) throws InvalidDnDOperationException {
        String msgCause = "";
        switch (grabStatus) {
            case 3: {
                msgCause = "not viewable";
                break;
            }
            case 1: {
                msgCause = "already grabbed";
                break;
            }
            case 2: {
                msgCause = "invalid time";
                break;
            }
            case 4: {
                msgCause = "grab frozen";
                break;
            }
            default: {
                msgCause = "unknown failure";
            }
        }
        throw new InvalidDnDOperationException(msg + ": " + msgCause);
    }

    @Override
    public void cleanup(long time) {
        if (this.dndInProgress) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(time);
            }
            if (this.targetAction != 0) {
                this.dragExit(this.xRoot, this.yRoot);
            }
            this.dragDropFinished(false, 0, this.xRoot, this.yRoot);
        }
        Iterator dragProtocols = XDragAndDropProtocols.getDragSourceProtocols();
        while (dragProtocols.hasNext()) {
            XDragSourceProtocol dragProtocol = (XDragSourceProtocol)dragProtocols.next();
            try {
                dragProtocol.cleanup();
            }
            catch (XException xException) {}
        }
        this.dndInProgress = false;
        this.dragInProgress = false;
        this.dragRootWindow = 0L;
        this.sourceFormats = null;
        this.sourceActions = 0;
        this.sourceAction = 0;
        this.eventState = 0;
        this.xRoot = 0;
        this.yRoot = 0;
        this.cleanupTargetInfo();
        this.removeDnDGrab(time);
    }

    private void cleanupTargetInfo() {
        this.targetAction = 0;
        this.dragProtocol = null;
        this.targetRootSubwindow = 0L;
    }

    private void removeDnDGrab(long time) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        XlibWrapper.XUngrabPointer(XToolkit.getDisplay(), time);
        XlibWrapper.XUngrabKeyboard(XToolkit.getDisplay(), time);
        if ((this.rootEventMask | 0x2003L) != this.rootEventMask && this.dragRootWindow != 0L) {
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.dragRootWindow, this.rootEventMask);
        }
        this.rootEventMask = 0L;
        this.dragRootWindow = 0L;
    }

    private boolean processClientMessage(XClientMessageEvent xclient) {
        if (this.dragProtocol != null) {
            return this.dragProtocol.processClientMessage(xclient);
        }
        return false;
    }

    private boolean updateSourceAction(int state) {
        int action = SunDragSourceContextPeer.convertModifiersToDropAction(XWindow.getModifiers(state, 0, 0), this.sourceActions);
        if (this.sourceAction == action) {
            return false;
        }
        this.sourceAction = action;
        return true;
    }

    private static long findClientWindow(long window) {
        if (XlibUtil.isTrueToplevelWindow(window)) {
            return window;
        }
        Set<Long> children = XlibUtil.getChildWindows(window);
        for (Long child : children) {
            long win = XDragSourceContextPeer.findClientWindow(child);
            if (win == 0L) continue;
            return win;
        }
        return 0L;
    }

    private void doUpdateTargetWindow(long subwindow, long time) {
        long clientWindow = 0L;
        long proxyWindow = 0L;
        XDragSourceProtocol protocol = null;
        boolean isReceiver = false;
        if (subwindow != 0L) {
            clientWindow = XDragSourceContextPeer.findClientWindow(subwindow);
        }
        if (clientWindow != 0L) {
            Iterator dragProtocols = XDragAndDropProtocols.getDragSourceProtocols();
            while (dragProtocols.hasNext()) {
                XDragSourceProtocol dragProtocol = (XDragSourceProtocol)dragProtocols.next();
                if (!dragProtocol.attachTargetWindow(clientWindow, time)) continue;
                protocol = dragProtocol;
                break;
            }
        }
        this.dragProtocol = protocol;
        this.targetAction = 0;
        this.targetRootSubwindow = subwindow;
    }

    private void updateTargetWindow(XMotionEvent xmotion) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        int x = xmotion.get_x_root();
        int y = xmotion.get_y_root();
        long time = xmotion.get_time();
        long subwindow = xmotion.get_subwindow();
        if (xmotion.get_window() != xmotion.get_root()) {
            XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xmotion.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
            subwindow = Native.getLong(XlibWrapper.larg2);
        }
        if (this.targetRootSubwindow != subwindow) {
            if (this.dragProtocol != null) {
                this.dragProtocol.sendLeaveMessage(time);
                if (this.targetAction != 0) {
                    this.dragExit(x, y);
                }
            }
            this.doUpdateTargetWindow(subwindow, time);
            if (this.dragProtocol != null) {
                this.dragProtocol.sendEnterMessage(this.sourceFormats, this.sourceAction, this.sourceActions, time);
            }
        }
    }

    private void processMouseMove(XMotionEvent xmotion) {
        if (!this.dragInProgress) {
            return;
        }
        if (this.xRoot != xmotion.get_x_root() || this.yRoot != xmotion.get_y_root()) {
            this.xRoot = xmotion.get_x_root();
            this.yRoot = xmotion.get_y_root();
            this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xmotion.get_state(), 0, 0), this.xRoot, this.yRoot, 6);
        }
        if (this.eventState != xmotion.get_state()) {
            if (this.updateSourceAction(xmotion.get_state()) && this.dragProtocol != null) {
                this.postDragSourceDragEvent(this.targetAction, XWindow.getModifiers(xmotion.get_state(), 0, 0), this.xRoot, this.yRoot, 3);
            }
            this.eventState = xmotion.get_state();
        }
        this.updateTargetWindow(xmotion);
        if (this.dragProtocol != null) {
            this.dragProtocol.sendMoveMessage(xmotion.get_x_root(), xmotion.get_y_root(), this.sourceAction, this.sourceActions, xmotion.get_time());
        }
    }

    private void processDrop(XButtonEvent xbutton) {
        try {
            this.dragProtocol.initiateDrop(xbutton.get_x_root(), xbutton.get_y_root(), this.sourceAction, this.sourceActions, xbutton.get_time());
        }
        catch (XException e) {
            this.cleanup(xbutton.get_time());
        }
    }

    private boolean processProxyModeEvent(XEvent ev) {
        if (this.getProxyModeSourceWindow() == 0L) {
            return false;
        }
        if (ev.get_type() != 33) {
            return false;
        }
        if (logger.isLoggable(PlatformLogger.Level.FINEST)) {
            logger.finest("        proxyModeSourceWindow=" + this.getProxyModeSourceWindow() + " ev=" + ev);
        }
        XClientMessageEvent xclient = ev.get_xclient();
        Iterator dragProtocols = XDragAndDropProtocols.getDragSourceProtocols();
        while (dragProtocols.hasNext()) {
            XDragSourceProtocol dragProtocol = (XDragSourceProtocol)dragProtocols.next();
            if (!dragProtocol.processProxyModeEvent(xclient, this.getProxyModeSourceWindow())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doProcessEvent(XEvent ev) {
        assert (XToolkit.isAWTLockHeldByCurrentThread());
        if (this.processProxyModeEvent(ev)) {
            return true;
        }
        if (!this.dndInProgress) {
            return false;
        }
        switch (ev.get_type()) {
            case 33: {
                XClientMessageEvent xclient = ev.get_xclient();
                return this.processClientMessage(xclient);
            }
            case 17: {
                XDestroyWindowEvent xde = ev.get_xdestroywindow();
                if (!this.dragInProgress && this.dragProtocol != null && xde.get_window() == this.dragProtocol.getTargetWindow()) {
                    this.cleanup(0L);
                    return true;
                }
                return false;
            }
        }
        if (!this.dragInProgress) {
            return false;
        }
        switch (ev.get_type()) {
            case 2: 
            case 3: {
                XKeyEvent xkey = ev.get_xkey();
                long keysym = XlibWrapper.XKeycodeToKeysym(XToolkit.getDisplay(), xkey.get_keycode(), 0);
                switch ((int)keysym) {
                    case 65307: {
                        if (ev.get_type() != 3) break;
                        this.cleanup(xkey.get_time());
                        break;
                    }
                    case 65505: 
                    case 65506: 
                    case 65507: 
                    case 65508: {
                        XlibWrapper.XQueryPointer(XToolkit.getDisplay(), xkey.get_root(), XlibWrapper.larg1, XlibWrapper.larg2, XlibWrapper.larg3, XlibWrapper.larg4, XlibWrapper.larg5, XlibWrapper.larg6, XlibWrapper.larg7);
                        XMotionEvent xmotion = new XMotionEvent();
                        try {
                            xmotion.set_type(6);
                            xmotion.set_serial(xkey.get_serial());
                            xmotion.set_send_event(xkey.get_send_event());
                            xmotion.set_display(xkey.get_display());
                            xmotion.set_window(xkey.get_window());
                            xmotion.set_root(xkey.get_root());
                            xmotion.set_subwindow(xkey.get_subwindow());
                            xmotion.set_time(xkey.get_time());
                            xmotion.set_x(xkey.get_x());
                            xmotion.set_y(xkey.get_y());
                            xmotion.set_x_root(xkey.get_x_root());
                            xmotion.set_y_root(xkey.get_y_root());
                            xmotion.set_state((int)Native.getLong(XlibWrapper.larg7));
                            xmotion.set_same_screen(xkey.get_same_screen());
                            this.processMouseMove(xmotion);
                            break;
                        }
                        finally {
                            xmotion.dispose();
                        }
                    }
                }
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                this.processMouseMove(ev.get_xmotion());
                return true;
            }
            case 5: {
                XButtonEvent xbutton = ev.get_xbutton();
                if (xbutton.get_button() > 20) {
                    return true;
                }
                XMotionEvent xmotion = new XMotionEvent();
                try {
                    xmotion.set_type(6);
                    xmotion.set_serial(xbutton.get_serial());
                    xmotion.set_send_event(xbutton.get_send_event());
                    xmotion.set_display(xbutton.get_display());
                    xmotion.set_window(xbutton.get_window());
                    xmotion.set_root(xbutton.get_root());
                    xmotion.set_subwindow(xbutton.get_subwindow());
                    xmotion.set_time(xbutton.get_time());
                    xmotion.set_x(xbutton.get_x());
                    xmotion.set_y(xbutton.get_y());
                    xmotion.set_x_root(xbutton.get_x_root());
                    xmotion.set_y_root(xbutton.get_y_root());
                    xmotion.set_state(xbutton.get_state());
                    xmotion.set_same_screen(xbutton.get_same_screen());
                    this.processMouseMove(xmotion);
                }
                finally {
                    xmotion.dispose();
                }
                if (xbutton.get_button() == XConstants.buttons[0] || xbutton.get_button() == XConstants.buttons[1]) {
                    this.removeDnDGrab(xbutton.get_time());
                    this.dragInProgress = false;
                    if (this.dragProtocol != null && this.targetAction != 0) {
                        this.processDrop(xbutton);
                    } else {
                        this.cleanup(xbutton.get_time());
                    }
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean processEvent(XEvent ev) {
        XToolkit.awtLock();
        try {
            boolean bl = theInstance.doProcessEvent(ev);
            return bl;
        }
        catch (XException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    @Override
    public void handleDragReply(int action) {
        this.handleDragReply(action, this.xRoot, this.yRoot);
    }

    @Override
    public void handleDragReply(int action, int x, int y) {
        this.handleDragReply(action, this.xRoot, this.yRoot, XWindow.getModifiers(this.eventState, 0, 0));
    }

    @Override
    public void handleDragReply(int action, int x, int y, int modifiers) {
        if (action == 0 && this.targetAction != 0) {
            this.dragExit(x, y);
        } else if (action != 0) {
            int type = 0;
            type = this.targetAction == 0 ? 1 : 2;
            this.postDragSourceDragEvent(action, modifiers, x, y, type);
        }
        this.targetAction = action;
    }

    @Override
    public void handleDragFinished() {
        this.handleDragFinished(true);
    }

    @Override
    public void handleDragFinished(boolean success) {
        this.handleDragFinished(true, this.targetAction);
    }

    @Override
    public void handleDragFinished(boolean success, int action) {
        this.handleDragFinished(success, action, this.xRoot, this.yRoot);
    }

    @Override
    public void handleDragFinished(boolean success, int action, int x, int y) {
        this.dragDropFinished(success, action, x, y);
        this.dndInProgress = false;
        this.cleanup(0L);
    }
}

