/*
 * Decompiled with CFR 0.152.
 */
package com.sun.crypto.provider;

import com.sun.crypto.provider.SymmetricCipher;
import java.security.InvalidKeyException;

final class RC2Crypt
extends SymmetricCipher {
    private static final int[] PI_TABLE = new int[]{217, 120, 249, 196, 25, 221, 181, 237, 40, 233, 253, 121, 74, 160, 216, 157, 198, 126, 55, 131, 43, 118, 83, 142, 98, 76, 100, 136, 68, 139, 251, 162, 23, 154, 89, 245, 135, 179, 79, 19, 97, 69, 109, 141, 9, 129, 125, 50, 189, 143, 64, 235, 134, 183, 123, 11, 240, 149, 33, 34, 92, 107, 78, 130, 84, 214, 101, 147, 206, 96, 178, 28, 115, 86, 192, 20, 167, 140, 241, 220, 18, 117, 202, 31, 59, 190, 228, 209, 66, 61, 212, 48, 163, 60, 182, 38, 111, 191, 14, 218, 70, 105, 7, 87, 39, 242, 29, 155, 188, 148, 67, 3, 248, 17, 199, 246, 144, 239, 62, 231, 6, 195, 213, 47, 200, 102, 30, 215, 8, 232, 234, 222, 128, 82, 238, 247, 132, 170, 114, 172, 53, 77, 106, 42, 150, 26, 210, 113, 90, 21, 73, 116, 75, 159, 208, 94, 4, 24, 164, 236, 194, 224, 65, 110, 15, 81, 203, 204, 36, 145, 175, 80, 161, 244, 112, 57, 153, 124, 58, 133, 35, 184, 180, 122, 252, 2, 54, 91, 37, 85, 151, 49, 45, 93, 250, 152, 227, 138, 146, 174, 5, 223, 41, 16, 103, 108, 186, 201, 211, 0, 230, 207, 225, 158, 168, 44, 99, 22, 1, 63, 88, 226, 137, 169, 13, 56, 52, 27, 171, 51, 255, 176, 187, 72, 12, 95, 185, 177, 205, 46, 197, 243, 219, 71, 229, 165, 156, 119, 10, 166, 32, 104, 254, 127, 193, 173};
    private final int[] expandedKey = new int[64];
    private int effectiveKeyBits;

    RC2Crypt() {
    }

    @Override
    int getBlockSize() {
        return 8;
    }

    int getEffectiveKeyBits() {
        return this.effectiveKeyBits;
    }

    void initEffectiveKeyBits(int effectiveKeyBits) {
        this.effectiveKeyBits = effectiveKeyBits;
    }

    static void checkKey(String algorithm, int keyLength) throws InvalidKeyException {
        if (!algorithm.equals("RC2")) {
            throw new InvalidKeyException("Key algorithm must be RC2");
        }
        if (keyLength < 5 || keyLength > 128) {
            throw new InvalidKeyException("RC2 key length must be between 40 and 1024 bit");
        }
    }

    @Override
    void init(boolean decrypting, String algorithm, byte[] key) throws InvalidKeyException {
        int i;
        int keyLength = key.length;
        if (this.effectiveKeyBits == 0) {
            this.effectiveKeyBits = keyLength << 3;
        }
        RC2Crypt.checkKey(algorithm, keyLength);
        byte[] expandedKeyBytes = new byte[128];
        System.arraycopy(key, 0, expandedKeyBytes, 0, keyLength);
        int t = expandedKeyBytes[keyLength - 1];
        for (int i2 = keyLength; i2 < 128; ++i2) {
            t = PI_TABLE[t + expandedKeyBytes[i2 - keyLength] & 0xFF];
            expandedKeyBytes[i2] = (byte)t;
        }
        int t8 = this.effectiveKeyBits + 7 >> 3;
        int tm = 255 >> (-this.effectiveKeyBits & 7);
        t = PI_TABLE[expandedKeyBytes[128 - t8] & tm];
        expandedKeyBytes[128 - t8] = (byte)t;
        for (i = 127 - t8; i >= 0; --i) {
            t = PI_TABLE[t ^ expandedKeyBytes[i + t8] & 0xFF];
            expandedKeyBytes[i] = (byte)t;
        }
        i = 0;
        int j = 0;
        while (i < 64) {
            this.expandedKey[i] = t = (expandedKeyBytes[j] & 0xFF) + ((expandedKeyBytes[j + 1] & 0xFF) << 8);
            ++i;
            j += 2;
        }
    }

    @Override
    void encryptBlock(byte[] in, int inOfs, byte[] out, int outOfs) {
        int i;
        int R0 = (in[inOfs] & 0xFF) + ((in[inOfs + 1] & 0xFF) << 8);
        int R1 = (in[inOfs + 2] & 0xFF) + ((in[inOfs + 3] & 0xFF) << 8);
        int R2 = (in[inOfs + 4] & 0xFF) + ((in[inOfs + 5] & 0xFF) << 8);
        int R3 = (in[inOfs + 6] & 0xFF) + ((in[inOfs + 7] & 0xFF) << 8);
        for (i = 0; i < 20; i += 4) {
            R0 = R0 + this.expandedKey[i] + (R3 & R2) + (~R3 & R1) & 0xFFFF;
            R0 = R0 << 1 | R0 >>> 15;
            R1 = R1 + this.expandedKey[i + 1] + (R0 & R3) + (~R0 & R2) & 0xFFFF;
            R1 = R1 << 2 | R1 >>> 14;
            R2 = R2 + this.expandedKey[i + 2] + (R1 & R0) + (~R1 & R3) & 0xFFFF;
            R2 = R2 << 3 | R2 >>> 13;
            R3 = R3 + this.expandedKey[i + 3] + (R2 & R1) + (~R2 & R0) & 0xFFFF;
            R3 = R3 << 5 | R3 >>> 11;
        }
        R2 += this.expandedKey[(R1 += this.expandedKey[(R0 += this.expandedKey[R3 & 0x3F]) & 0x3F]) & 0x3F];
        R3 += this.expandedKey[R2 & 0x3F];
        for (i = 20; i < 44; i += 4) {
            R0 = R0 + this.expandedKey[i] + (R3 & R2) + (~R3 & R1) & 0xFFFF;
            R0 = R0 << 1 | R0 >>> 15;
            R1 = R1 + this.expandedKey[i + 1] + (R0 & R3) + (~R0 & R2) & 0xFFFF;
            R1 = R1 << 2 | R1 >>> 14;
            R2 = R2 + this.expandedKey[i + 2] + (R1 & R0) + (~R1 & R3) & 0xFFFF;
            R2 = R2 << 3 | R2 >>> 13;
            R3 = R3 + this.expandedKey[i + 3] + (R2 & R1) + (~R2 & R0) & 0xFFFF;
            R3 = R3 << 5 | R3 >>> 11;
        }
        R2 += this.expandedKey[(R1 += this.expandedKey[(R0 += this.expandedKey[R3 & 0x3F]) & 0x3F]) & 0x3F];
        R3 += this.expandedKey[R2 & 0x3F];
        for (i = 44; i < 64; i += 4) {
            R0 = R0 + this.expandedKey[i] + (R3 & R2) + (~R3 & R1) & 0xFFFF;
            R0 = R0 << 1 | R0 >>> 15;
            R1 = R1 + this.expandedKey[i + 1] + (R0 & R3) + (~R0 & R2) & 0xFFFF;
            R1 = R1 << 2 | R1 >>> 14;
            R2 = R2 + this.expandedKey[i + 2] + (R1 & R0) + (~R1 & R3) & 0xFFFF;
            R2 = R2 << 3 | R2 >>> 13;
            R3 = R3 + this.expandedKey[i + 3] + (R2 & R1) + (~R2 & R0) & 0xFFFF;
            R3 = R3 << 5 | R3 >>> 11;
        }
        out[outOfs] = (byte)R0;
        out[outOfs + 1] = (byte)(R0 >> 8);
        out[outOfs + 2] = (byte)R1;
        out[outOfs + 3] = (byte)(R1 >> 8);
        out[outOfs + 4] = (byte)R2;
        out[outOfs + 5] = (byte)(R2 >> 8);
        out[outOfs + 6] = (byte)R3;
        out[outOfs + 7] = (byte)(R3 >> 8);
    }

    @Override
    void decryptBlock(byte[] in, int inOfs, byte[] out, int outOfs) {
        int i;
        int R0 = (in[inOfs] & 0xFF) + ((in[inOfs + 1] & 0xFF) << 8);
        int R1 = (in[inOfs + 2] & 0xFF) + ((in[inOfs + 3] & 0xFF) << 8);
        int R2 = (in[inOfs + 4] & 0xFF) + ((in[inOfs + 5] & 0xFF) << 8);
        int R3 = (in[inOfs + 6] & 0xFF) + ((in[inOfs + 7] & 0xFF) << 8);
        for (i = 64; i > 44; i -= 4) {
            R3 = (R3 << 11 | R3 >>> 5) & 0xFFFF;
            R3 = R3 - this.expandedKey[i - 1] - (R2 & R1) - (~R2 & R0) & 0xFFFF;
            R2 = (R2 << 13 | R2 >>> 3) & 0xFFFF;
            R2 = R2 - this.expandedKey[i - 2] - (R1 & R0) - (~R1 & R3) & 0xFFFF;
            R1 = (R1 << 14 | R1 >>> 2) & 0xFFFF;
            R1 = R1 - this.expandedKey[i - 3] - (R0 & R3) - (~R0 & R2) & 0xFFFF;
            R0 = (R0 << 15 | R0 >>> 1) & 0xFFFF;
            R0 = R0 - this.expandedKey[i - 4] - (R3 & R2) - (~R3 & R1) & 0xFFFF;
        }
        R3 = R3 - this.expandedKey[R2 & 0x3F] & 0xFFFF;
        R2 = R2 - this.expandedKey[R1 & 0x3F] & 0xFFFF;
        R1 = R1 - this.expandedKey[R0 & 0x3F] & 0xFFFF;
        R0 = R0 - this.expandedKey[R3 & 0x3F] & 0xFFFF;
        for (i = 44; i > 20; i -= 4) {
            R3 = (R3 << 11 | R3 >>> 5) & 0xFFFF;
            R3 = R3 - this.expandedKey[i - 1] - (R2 & R1) - (~R2 & R0) & 0xFFFF;
            R2 = (R2 << 13 | R2 >>> 3) & 0xFFFF;
            R2 = R2 - this.expandedKey[i - 2] - (R1 & R0) - (~R1 & R3) & 0xFFFF;
            R1 = (R1 << 14 | R1 >>> 2) & 0xFFFF;
            R1 = R1 - this.expandedKey[i - 3] - (R0 & R3) - (~R0 & R2) & 0xFFFF;
            R0 = (R0 << 15 | R0 >>> 1) & 0xFFFF;
            R0 = R0 - this.expandedKey[i - 4] - (R3 & R2) - (~R3 & R1) & 0xFFFF;
        }
        R3 = R3 - this.expandedKey[R2 & 0x3F] & 0xFFFF;
        R2 = R2 - this.expandedKey[R1 & 0x3F] & 0xFFFF;
        R1 = R1 - this.expandedKey[R0 & 0x3F] & 0xFFFF;
        R0 = R0 - this.expandedKey[R3 & 0x3F] & 0xFFFF;
        for (i = 20; i > 0; i -= 4) {
            R3 = (R3 << 11 | R3 >>> 5) & 0xFFFF;
            R3 = R3 - this.expandedKey[i - 1] - (R2 & R1) - (~R2 & R0) & 0xFFFF;
            R2 = (R2 << 13 | R2 >>> 3) & 0xFFFF;
            R2 = R2 - this.expandedKey[i - 2] - (R1 & R0) - (~R1 & R3) & 0xFFFF;
            R1 = (R1 << 14 | R1 >>> 2) & 0xFFFF;
            R1 = R1 - this.expandedKey[i - 3] - (R0 & R3) - (~R0 & R2) & 0xFFFF;
            R0 = (R0 << 15 | R0 >>> 1) & 0xFFFF;
            R0 = R0 - this.expandedKey[i - 4] - (R3 & R2) - (~R3 & R1) & 0xFFFF;
        }
        out[outOfs] = (byte)R0;
        out[outOfs + 1] = (byte)(R0 >> 8);
        out[outOfs + 2] = (byte)R1;
        out[outOfs + 3] = (byte)(R1 >> 8);
        out[outOfs + 4] = (byte)R2;
        out[outOfs + 5] = (byte)(R2 >> 8);
        out[outOfs + 6] = (byte)R3;
        out[outOfs + 7] = (byte)(R3 >> 8);
    }
}

