/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import sun.misc.Unsafe;
import sun.nio.ch.IOUtil;

class EPoll {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int SIZEOF_EPOLLEVENT = EPoll.eventSize();
    private static final int OFFSETOF_EVENTS = EPoll.eventsOffset();
    private static final int OFFSETOF_FD = EPoll.dataOffset();
    static final int EPOLL_CTL_ADD = 1;
    static final int EPOLL_CTL_DEL = 2;
    static final int EPOLL_CTL_MOD = 3;
    static final int EPOLLONESHOT = 0x40000000;

    private EPoll() {
    }

    static long allocatePollArray(int n) {
        return unsafe.allocateMemory(n * SIZEOF_EPOLLEVENT);
    }

    static void freePollArray(long l) {
        unsafe.freeMemory(l);
    }

    static long getEvent(long l, int n) {
        return l + (long)(SIZEOF_EPOLLEVENT * n);
    }

    static int getDescriptor(long l) {
        return unsafe.getInt(l + (long)OFFSETOF_FD);
    }

    static int getEvents(long l) {
        return unsafe.getInt(l + (long)OFFSETOF_EVENTS);
    }

    private static native int eventSize();

    private static native int eventsOffset();

    private static native int dataOffset();

    static native int epollCreate() throws IOException;

    static native int epollCtl(int var0, int var1, int var2, int var3);

    static native int epollWait(int var0, long var1, int var3) throws IOException;

    static {
        IOUtil.load();
    }
}

