/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.text;

import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class TextFunction
implements Function {
    private static final long serialVersionUID = 3505313019941429911L;

    /*
     * Loose catch block
     */
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        int parameterCount = parameters.getParameterCount();
        if (parameterCount < 1) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        Type type1 = parameters.getType(0);
        Object value1 = parameters.getValue(0);
        TypeRegistry typeRegistry = context.getTypeRegistry();
        if (parameterCount == 1) {
            String result = typeRegistry.convertToText(type1, value1);
            if (result == null) {
                throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
            }
            return new TypeValuePair(TextType.TYPE, result);
        }
        try {
            Locale locale;
            String formatString;
            Object value2;
            Type type2;
            block13: {
                type2 = parameters.getType(1);
                value2 = parameters.getValue(1);
                formatString = typeRegistry.convertToText(type2, value2);
                locale = context.getLocalizationContext().getLocale();
                if (value1 instanceof Date) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, new DateFormatSymbols(locale));
                    return new TypeValuePair(TextType.TYPE, dateFormat.format(value1));
                }
                if (!(value1 instanceof Number)) break block13;
                DecimalFormat dateFormat = new DecimalFormat(formatString, new DecimalFormatSymbols(locale));
                return new TypeValuePair(TextType.TYPE, dateFormat.format(value1));
                {
                    catch (EvaluationException ev) {
                        throw ev;
                    }
                }
            }
            try {
                Date date = typeRegistry.convertToDate(type2, value2);
                SimpleDateFormat dateFormat = new SimpleDateFormat(formatString, new DateFormatSymbols(locale));
                return new TypeValuePair(TextType.TYPE, dateFormat.format(date));
            }
            catch (EvaluationException date) {
                try {
                    Number date2 = typeRegistry.convertToNumber(type2, value2);
                    DecimalFormat dateFormat = new DecimalFormat(formatString, new DecimalFormatSymbols(locale));
                    return new TypeValuePair(TextType.TYPE, dateFormat.format(date2));
                }
                catch (EvaluationException evaluationException) {
                }
            }
        }
        catch (Exception ex) {
            throw new EvaluationException(LibFormulaErrorValue.ERROR_UNEXPECTED_VALUE);
        }
        throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }

    public String getCanonicalName() {
        return "TEXT";
    }
}

