/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.operators;

import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.operators.InfixOperator;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.TextType;

public class ConcatOperator
implements InfixOperator {
    private static final long serialVersionUID = 6579968694761281257L;

    public TypeValuePair evaluate(FormulaContext context, TypeValuePair value1, TypeValuePair value2) throws EvaluationException {
        TypeRegistry typeRegistry = context.getTypeRegistry();
        Object raw1 = value1.getValue();
        Object raw2 = value2.getValue();
        if (raw1 == null || raw2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_NA_VALUE);
        }
        String text1 = typeRegistry.convertToText(value1.getType(), raw1);
        String text2 = typeRegistry.convertToText(value2.getType(), raw2);
        if (text1 == null && text2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        if (text1 == null) {
            return new TypeValuePair(TextType.TYPE, text2);
        }
        if (text2 == null) {
            return new TypeValuePair(TextType.TYPE, text1);
        }
        return new TypeValuePair(TextType.TYPE, text1 + text2);
    }

    public int getLevel() {
        return 300;
    }

    public String toString() {
        return "&";
    }

    public boolean isLeftOperation() {
        return true;
    }

    public boolean isAssociative() {
        return false;
    }
}

