/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.resourceloader.cache;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;

public class CacheUtility {
    public static String externalizeKey(ResourceKey key) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(key);
            oout.close();
            byte[] serializedKeyData = bout.toByteArray();
            return CacheUtility.convertToString(serializedKeyData);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    private static String convertToString(byte[] serializedKeyData) {
        int capacity = serializedKeyData.length / 2 + 2;
        StringBuffer buffer = new StringBuffer(capacity);
        char data = '\u0000';
        if ((serializedKeyData.length & 1) == 1) {
            buffer.append('*');
        } else {
            buffer.append('#');
        }
        for (int i = 0; i < serializedKeyData.length; ++i) {
            data = (char)(data << 8);
            data = (char)(data | serializedKeyData[i]);
            if ((i & 1) != 1) continue;
            buffer.append(data);
        }
        if ((serializedKeyData.length & 1) == 1) {
            data = (char)(data << 8);
            buffer.append(data);
        }
        return buffer.toString();
    }

    private CacheUtility() {
    }
}

