/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.base.encoder;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.pentaho.reporting.libraries.base.encoder.ImageEncoder;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class JpegImageEncoder
implements ImageEncoder {
    private static final String ENCODER_CLASS = "com.sun.image.codec.jpeg.JPEGCodec";
    private static final String ENCODER_PARAM_CLASS = "com.sun.image.codec.jpeg.JPEGEncodeParam";

    public void encodeImage(Image image, OutputStream outputStream, float quality, boolean encodeAlpha) throws IOException, UnsupportedEncoderException {
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, Color.WHITE, null);
        g.dispose();
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(JpegImageEncoder.class);
            Class<?> codecClass = Class.forName(ENCODER_CLASS, false, loader);
            Class<?> paramClass = Class.forName(ENCODER_PARAM_CLASS, false, loader);
            Method createParameterMethod = codecClass.getMethod("getDefaultJPEGEncodeParam", BufferedImage.class);
            Object encoderParam = createParameterMethod.invoke(null, bimage);
            Method setQualityMethod = paramClass.getMethod("setQuality", Float.TYPE, Boolean.TYPE);
            setQualityMethod.invoke(encoderParam, new Float(quality), Boolean.FALSE);
            Method createEncoderMethod = codecClass.getMethod("createJPEGEncoder", OutputStream.class, paramClass);
            Object encoder = createEncoderMethod.invoke(null, outputStream, encoderParam);
            Class<?> encoderClass = encoder.getClass();
            Method encodeMethod = encoderClass.getMethod("encode", BufferedImage.class);
            encodeMethod.invoke(encoder, bimage);
        }
        catch (InvocationTargetException ie) {
            Throwable throwable = ie.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new UnsupportedEncoderException("Failed to run the encoder", throwable);
        }
        catch (Throwable t) {
            throw new UnsupportedEncoderException("Failed to run the encoder", t);
        }
    }

    public void encodeImage(Image image, OutputStream outputStream) throws IOException, UnsupportedEncoderException {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(JpegImageEncoder.class);
            Class<?> codecClass = Class.forName(ENCODER_CLASS, false, loader);
            Method createEncoderMethod = codecClass.getMethod("createJPEGEncoder", OutputStream.class);
            Object encoder = createEncoderMethod.invoke(null, outputStream);
            Class<?> encoderClass = encoder.getClass();
            Method encodeMethod = encoderClass.getMethod("encode", Image.class);
            encodeMethod.invoke(encoder, image);
        }
        catch (InvocationTargetException ie) {
            Throwable throwable = ie.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw new UnsupportedEncoderException("Failed to run the encoder", throwable);
        }
        catch (Throwable t) {
            throw new UnsupportedEncoderException("Failed to run the encoder", t);
        }
    }

    public String getMimeType() {
        return "image/jpg";
    }

    public static boolean isJpegEncodingAvailable() {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(JpegImageEncoder.class);
            Class<?> aClass = Class.forName(ENCODER_CLASS, false, loader);
            return aClass != null;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

