/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlSocketRequestHandler;
import org.hsqldb.Server;
import org.hsqldb.Trace;
import org.hsqldb.jdbc.Util;
import org.hsqldb.persist.HsqlProperties;

public class HsqlServerFactory {
    private HsqlServerFactory() {
    }

    public static HsqlSocketRequestHandler createHsqlServer(String string, boolean bl, boolean bl2) throws SQLException {
        HsqlProperties hsqlProperties = new HsqlProperties();
        hsqlProperties.setProperty("server.database.0", string);
        hsqlProperties.setProperty("server.trace", bl);
        hsqlProperties.setProperty("server.silent", bl2);
        Server server = new Server();
        try {
            server.setProperties(hsqlProperties);
        }
        catch (Exception exception) {
            throw new SQLException("Failed to set server properties: " + exception);
        }
        if (!server.openDatabases()) {
            Throwable throwable = server.getServerError();
            if (throwable instanceof HsqlException) {
                throw Util.sqlException((HsqlException)throwable);
            }
            throw new SQLException(Trace.getMessage(40));
        }
        server.setState(1);
        return server;
    }
}

