/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_be extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0446\u0456";
        final String metaValue_kn = "\u043a\u0430\u043d\u0430\u0434\u0430";
        final String metaValue_ml = "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c";
        final String metaValue_or = "\u043e\u0440\u044b\u044f";
        final String metaValue_te = "\u0442\u044d\u043b\u0443\u0433\u0443";
        final Object[][] data = new Object[][] {
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "luo", "\u043b\u0443\u0430" },
            { "Zsym", "\u0441\u0456\u043c\u0432\u0430\u043b\u044b" },
            { "fil", "\u0442\u0430\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "luy", "\u043b\u0443\u044f" },
            { "egy", "\u0441\u0442\u0430\u0440\u0430\u044d\u0433\u0456\u043f\u0435\u0446\u043a\u0430\u044f" },
            { "es_ES", "\u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f (\u0435\u045e\u0440\u0430\u043f.)" },
            { "teo", "\u0442\u044d\u0441\u043e" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0441\u043a\u0430\u044f" },
            { "AC", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0423\u0448\u044d\u0441\u0446\u044f" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0430" },
            { "AE", "\u0410\u0431\u2019\u044f\u0434\u043d\u0430\u043d\u044b\u044f \u0410\u0440\u0430\u0431\u0441\u043a\u0456\u044f \u042d\u043c\u0456\u0440\u0430\u0442\u044b" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "AF", "\u0410\u0444\u0433\u0430\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "af", "\u0430\u0444\u0440\u044b\u043a\u0430\u0430\u043d\u0441" },
            { "AG", "\u0410\u043d\u0442\u044b\u0433\u0443\u0430 \u0456 \u0411\u0430\u0440\u0431\u0443\u0434\u0430" },
            { "AI", "\u0410\u043d\u0433\u0456\u043b\u044c\u044f" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0456\u044f" },
            { "AM", "\u0410\u0440\u043c\u0435\u043d\u0456\u044f" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "Arab", "\u0430\u0440\u0430\u0431\u0441\u043a\u0430\u0435" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u044b\u043a\u0430" },
            { "Jpan", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u0435" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0446\u0456\u043d\u0430" },
            { "ar", "\u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f" },
            { "AS", "\u0410\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u0435 \u0421\u0430\u043c\u043e\u0430" },
            { "as", "\u0430\u0441\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "AT", "\u0410\u045e\u0441\u0442\u0440\u044b\u044f" },
            { "AU", "\u0410\u045e\u0441\u0442\u0440\u0430\u043b\u0456\u044f" },
            { "av", "\u0430\u0432\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "sdh", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "en_US", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f (\u0417\u0428\u0410)" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "BA", "\u0411\u043e\u0441\u043d\u0456\u044f \u0456 \u0413\u0435\u0440\u0446\u0430\u0433\u0430\u0432\u0456\u043d\u0430" },
            { "ba", "\u0431\u0430\u0448\u043a\u0456\u0440\u0441\u043a\u0430\u044f" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u0430\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u044d\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0456\u044f" },
            { "be", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u043a\u0430\u044f" },
            { "BF", "\u0411\u0443\u0440\u043a\u0456\u043d\u0430-\u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u0430\u043b\u0433\u0430\u0440\u044b\u044f" },
            { "bg", "\u0431\u0430\u043b\u0433\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "BH", "\u0411\u0430\u0445\u0440\u044d\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0437\u0456" },
            { "BJ", "\u0411\u0435\u043d\u0456\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u044d\u043b\u044c\u043c\u0456" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "BO", "\u0411\u0430\u043b\u0456\u0432\u0456\u044f" },
            { "bo", "\u0442\u044b\u0431\u0435\u0446\u043a\u0430\u044f" },
            { "BQ", "\u041a\u0430\u0440\u044b\u0431\u0441\u043a\u0456\u044f \u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b" },
            { "BR", "\u0411\u0440\u0430\u0437\u0456\u043b\u0456\u044f" },
            { "br", "\u0431\u0440\u044d\u0442\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u044b" },
            { "bs", "\u0431\u0430\u0441\u043d\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0411\u0443\u0432\u044d" },
            { "BW", "\u0411\u0430\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "Mymr", "\u043c\u2019\u044f\u043d\u043c\u0430\u0440\u0441\u043a\u0430\u0435" },
            { "BY", "\u0411\u0435\u043b\u0430\u0440\u0443\u0441\u044c" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "BZ", "\u0411\u0435\u043b\u0456\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "CC", "\u041a\u0430\u043a\u043e\u0441\u0430\u0432\u044b\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u044d\u0440\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u0430\u0440\u0430 \u0441\u0435\u043d\u043d\u0456" },
            { "CD", "\u041a\u043e\u043d\u0433\u0430 (\u041a\u0456\u043d\u0448\u0430\u0441\u0430)" },
            { "ce", "\u0447\u0430\u0447\u044d\u043d\u0441\u043a\u0430\u044f" },
            { "CF", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430-\u0410\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u0430 (\u0411\u0440\u0430\u0437\u0430\u0432\u0456\u043b\u044c)" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u044b\u044f" },
            { "CI", "\u041a\u043e\u0442-\u0434\u2019\u0406\u0432\u0443\u0430\u0440" },
            { "CK", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041a\u0443\u043a\u0430" },
            { "CL", "\u0427\u044b\u043b\u0456" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u041a\u0456\u0442\u0430\u0439" },
            { "CO", "\u041a\u0430\u043b\u0443\u043c\u0431\u0456\u044f" },
            { "co", "\u043a\u0430\u0440\u0441\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "CP", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041a\u043b\u0456\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "Orya", metaValue_or },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u044b\u043a\u0430" },
            { "cs", "\u0447\u044d\u0448\u0441\u043a\u0430\u044f" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u0430-\u0412\u0435\u0440\u0434\u044d" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u0441\u043a\u0430\u044f" },
            { "CW", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041a\u044e\u0440\u0430\u0441\u0430\u0430" },
            { "CX", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0420\u0430\u0441\u0442\u0432\u0430" },
            { "CY", "\u041a\u0456\u043f\u0440" },
            { "cy", "\u0432\u0430\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "CZ", "\u0427\u044d\u0445\u0456\u044f" },
            { "da", "\u0434\u0430\u0446\u043a\u0430\u044f" },
            { "pt_PT", "\u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f (\u0435\u045e\u0440\u0430\u043f.)" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0456\u044f" },
            { "de", "\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "cgg", "\u0447\u044b\u0433\u0430" },
            { "DG", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0414\u044b\u0435\u0433\u0430-\u0413\u0430\u0440\u0441\u0456\u044f" },
            { "DJ", "\u0414\u0436\u044b\u0431\u0443\u0446\u0456" },
            { "DK", "\u0414\u0430\u043d\u0456\u044f" },
            { "Brai", "\u0448\u0440\u044b\u0444\u0442 \u0411\u0440\u0430\u0439\u043b\u044f" },
            { "DM", "\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430" },
            { "DO", "\u0414\u0430\u043c\u0456\u043d\u0456\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "es_419", "\u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f (\u043b\u0430\u0446\u0456\u043d\u0430\u0430\u043c\u0435\u0440.)" },
            { "DZ", "\u0410\u043b\u0436\u044b\u0440" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433\u043a\u0445\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "EA", "\u0421\u0435\u045e\u0442\u0430 \u0456 \u041c\u0435\u043b\u0456\u043b\u044c\u044f" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0456\u044f" },
            { "ee", "\u044d\u0432\u0435" },
            { "EG", "\u0415\u0433\u0456\u043f\u0435\u0442" },
            { "EH", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0421\u0430\u0445\u0430\u0440\u0430" },
            { "ro_MD", "\u043c\u0430\u043b\u0434\u0430\u045e\u0441\u043a\u0430\u044f" },
            { "el", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0430\u044f" },
            { "en", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u0430" },
            { "chr", "\u0447\u044d\u0440\u043e\u043a\u0456" },
            { "ER", "\u042d\u0440\u044b\u0442\u0440\u044d\u044f" },
            { "ES", "\u0406\u0441\u043f\u0430\u043d\u0456\u044f" },
            { "es", "\u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "ET", "\u042d\u0444\u0456\u043e\u043f\u0456\u044f" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "EU", "\u0415\u045e\u0440\u0430\u043f\u0435\u0439\u0441\u043a\u0456 \u0441\u0430\u044e\u0437" },
            { "eu", "\u0431\u0430\u0441\u043a\u0441\u043a\u0430\u044f" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "shi", "\u0442\u0430\u0447\u0430\u043b\u0445\u0456\u0442" },
            { "hsb", "\u0432\u0435\u0440\u0445\u043d\u0435\u043b\u0443\u0436\u044b\u0446\u043a\u0430\u044f" },
            { "Hani", "\u0445\u0430\u043d" },
            { "ady", "\u0430\u0434\u044b\u0433\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "fa", "\u0444\u0430\u0440\u0441\u0456" },
            { "Hans", "\u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u0430\u0435 \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "Hant", "\u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u0430\u0435 \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "FI", "\u0424\u0456\u043d\u043b\u044f\u043d\u0434\u044b\u044f" },
            { "fi", "\u0444\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "FJ", "\u0424\u0456\u0434\u0436\u044b" },
            { "fj", "\u0444\u0456\u0434\u0436\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "FK", "\u0424\u0430\u043b\u043a\u043b\u0435\u043d\u0434\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "FM", "\u041c\u0456\u043a\u0440\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "bgn", "\u0437\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0431\u0435\u043b\u0443\u0434\u0436\u0441\u043a\u0430\u044f" },
            { "FO", "\u0424\u0430\u0440\u044d\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "fo", "\u0444\u0430\u0440\u044d\u0440\u0441\u043a\u0430\u044f" },
            { "Taml", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u044b\u044f" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "fy", "\u0444\u0440\u044b\u0437\u0441\u043a\u0430\u044f" },
            { "grc", "\u0441\u0442\u0430\u0440\u0430\u0433\u0440\u044d\u0446\u043a\u0430\u044f" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "ga", "\u0456\u0440\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "GB", "\u0412\u044f\u043b\u0456\u043a\u0430\u0431\u0440\u044b\u0442\u0430\u043d\u0456\u044f" },
            { "GD", "\u0413\u0440\u044d\u043d\u0430\u0434\u0430" },
            { "gd", "\u0448\u0430\u0442\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f \u0433\u044d\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "GE", "\u0413\u0440\u0443\u0437\u0456\u044f" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u0413\u0432\u0456\u044f\u043d\u0430" },
            { "GG", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0413\u0435\u0440\u043d\u0441\u0456" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0456\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u044d\u043d\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "gl", "\u0433\u0430\u043b\u0456\u0441\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "GM", "\u0413\u0430\u043c\u0431\u0456\u044f" },
            { "GN", "\u0413\u0432\u0456\u043d\u0435\u044f" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0456" },
            { "GP", "\u0413\u0432\u0430\u0434\u044d\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u0430\u0440\u044b\u044f\u043b\u044c\u043d\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "und", "\u043d\u0435\u0432\u044f\u0434\u043e\u043c\u0430\u044f \u043c\u043e\u0432\u0430" },
            { "GR", "\u0413\u0440\u044d\u0446\u044b\u044f" },
            { "GS", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0414\u0436\u043e\u0440\u0434\u0436\u044b\u044f \u0456 \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b\u044f \u0421\u0430\u043d\u0434\u0432\u0456\u0447\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "GT", "\u0413\u0432\u0430\u0442\u044d\u043c\u0430\u043b\u0430" },
            { "gu", metaValue_gu },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "gv", "\u043c\u044d\u043d\u0441\u043a\u0430\u044f" },
            { "GW", "\u0413\u0432\u0456\u043d\u0435\u044f-\u0411\u0456\u0441\u0430\u0443" },
            { "tlh", "\u043a\u043b\u0456\u043d\u0433\u043e\u043d" },
            { "GY", "\u0413\u0430\u044f\u043d\u0430" },
            { "ha", "\u0445\u0430\u045e\u0441\u0430" },
            { "ckb", "\u0446\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "zxx", "\u043d\u044f\u043c\u0430 \u043c\u043e\u045e\u043d\u0430\u0433\u0430 \u043c\u0430\u0442\u044d\u0440\u044b\u044f\u043b\u0443" },
            { "he", "\u0456\u045e\u0440\u044b\u0442" },
            { "hi", "\u0445\u0456\u043d\u0434\u0437\u0456" },
            { "de_AT", "\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f (\u0430\u045e\u0441\u0442\u0440.)" },
            { "HK", "\u0413\u0430\u043d\u043a\u043e\u043d\u0433, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)" },
            { "HM", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0425\u0435\u0440\u0434 \u0456 \u0430\u0441\u0442\u0440\u0430\u0432\u044b \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434" },
            { "HN", "\u0413\u0430\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u0430\u0440\u0432\u0430\u0442\u044b\u044f" },
            { "hr", "\u0445\u0430\u0440\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "agq", "\u0430\u0433\u0435\u043c" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0441\u043a\u0430\u044f \u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "HT", "\u0413\u0430\u0456\u0446\u0456" },
            { "ht", "\u0433\u0430\u0456\u0446\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u044b\u044f" },
            { "hu", "\u0432\u0435\u043d\u0433\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "hy", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "ia", "\u0456\u043d\u0442\u044d\u0440\u043b\u0456\u043d\u0433\u0432\u0430" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ID", "\u0406\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "id", "\u0456\u043d\u0434\u0430\u043d\u0435\u0437\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "IE", "\u0406\u0440\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "ie", "\u0456\u043d\u0442\u044d\u0440\u043b\u0456\u043d\u0433\u0432\u0435" },
            { "ig", "\u0456\u0433\u0431\u0430" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "ii", "\u0421\u044b\u0447\u0443\u0430\u043d\u044c \u0406" },
            { "fro", "\u0441\u0442\u0430\u0440\u0430\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "IL", "\u0406\u0437\u0440\u0430\u0456\u043b\u044c" },
            { "IM", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041c\u044d\u043d" },
            { "IN", "\u0406\u043d\u0434\u044b\u044f" },
            { "IO", "\u0411\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0430\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u044f \u045e \u0406\u043d\u0434\u044b\u0439\u0441\u043a\u0456\u043c \u0430\u043a\u0456\u044f\u043d\u0435" },
            { "IQ", "\u0406\u0440\u0430\u043a" },
            { "IR", "\u0406\u0440\u0430\u043d" },
            { "IS", "\u0406\u0441\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "is", "\u0456\u0441\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "IT", "\u0406\u0442\u0430\u043b\u0456\u044f" },
            { "it", "\u0456\u0442\u0430\u043b\u044c\u044f\u043d\u0441\u043a\u0430\u044f" },
            { "iu", "\u0456\u043d\u0443\u043a\u0442\u044b\u0442\u0443\u0442" },
            { "Mlym", metaValue_ml },
            { "ja", "\u044f\u043f\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "JE", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0414\u0436\u044d\u0440\u0441\u0456" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "JO", "\u0406\u0430\u0440\u0434\u0430\u043d\u0456\u044f" },
            { "JP", "\u042f\u043f\u043e\u043d\u0456\u044f" },
            { "sma", "\u043f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "jv", "\u044f\u0432\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "guz", "\u0433\u0443\u0441\u0456\u0456" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "de_CH", "\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f (\u0448\u0432\u0435\u0439\u0446.)" },
            { "smn", "\u0456\u043d\u0430\u0440\u044b-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "ka", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "sms", "\u043a\u043e\u043b\u0442\u0430-\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "KE", "\u041a\u0435\u043d\u0456\u044f" },
            { "419", "\u041b\u0430\u0446\u0456\u043d\u0441\u043a\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "KG", "\u041a\u044b\u0440\u0433\u044b\u0437\u0441\u0442\u0430\u043d" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0456\u0440\u044b\u0431\u0430\u0446\u0456" },
            { "ki", "\u043a\u0456\u043a\u0443\u044e" },
            { "mas", "\u043c\u0430\u0441\u0430\u0456" },
            { "kk", "\u043a\u0430\u0437\u0430\u0445\u0441\u043a\u0430\u044f" },
            { "kl", "\u0433\u0440\u044d\u043d\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "KM", "\u041a\u0430\u043c\u043e\u0440\u0441\u043a\u0456\u044f \u0410\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "km", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0430\u044f" },
            { "Knda", metaValue_kn },
            { "kn", metaValue_kn },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0456\u0442\u0441 \u0456 \u041d\u0435\u0432\u0456\u0441" },
            { "fr_CA", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f (\u043a\u0430\u043d\u0430\u0434.)" },
            { "ko", "\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u044f" },
            { "KP", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u041a\u0430\u0440\u044d\u044f" },
            { "KR", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u041a\u0430\u0440\u044d\u044f" },
            { "ks", "\u043a\u0430\u0448\u043c\u0456\u0440\u0441\u043a\u0430\u044f" },
            { "ku", "\u043a\u0443\u0440\u0434\u0441\u043a\u0430\u044f" },
            { "fr_CH", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f (\u0448\u0432\u0435\u0439\u0446.)" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "kw", "\u043a\u043e\u0440\u043d\u0441\u043a\u0430\u044f" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d\u0430\u0432\u044b \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ky", "\u043a\u0456\u0440\u0433\u0456\u0437\u0441\u043a\u0430\u044f" },
            { "KZ", "\u041a\u0430\u0437\u0430\u0445\u0441\u0442\u0430\u043d" },
            { "Cyrl", "\u043a\u0456\u0440\u044b\u043b\u0456\u0446\u0430" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "la", "\u043b\u0430\u0446\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "LB", "\u041b\u0456\u0432\u0430\u043d" },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0441\u043a\u0430\u044f" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0456\u044f" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "nds", "\u043d\u0456\u0436\u043d\u0435\u043d\u044f\u043c\u0435\u0446\u043a\u0430\u044f" },
            { "LI", "\u041b\u0456\u0445\u0442\u044d\u043d\u0448\u0442\u044d\u0439\u043d" },
            { "LK", "\u0428\u0440\u044b-\u041b\u0430\u043d\u043a\u0430" },
            { "akk", "\u0430\u043a\u0430\u0434\u0437\u043a\u0430\u044f" },
            { "Tibt", "\u0442\u044b\u0431\u0435\u0446\u043a\u0430\u0435" },
            { "ln", "\u043b\u0456\u043d\u0433\u0430\u043b\u0430" },
            { "lo", "\u043b\u0430\u043e\u0441\u043a\u0430\u044f" },
            { "cop", "\u043a\u043e\u043f\u0446\u043a\u0430\u044f" },
            { "LR", "\u041b\u0456\u0431\u0435\u0440\u044b\u044f" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u0430" },
            { "LT", "\u041b\u0456\u0442\u0432\u0430" },
            { "lt", "\u043b\u0456\u0442\u043e\u045e\u0441\u043a\u0430\u044f" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "LV", "\u041b\u0430\u0442\u0432\u0456\u044f" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448\u0441\u043a\u0430\u044f" },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "LY", "\u041b\u0456\u0432\u0456\u044f" },
            { "vun", "\u0432\u0443\u043d\u044c\u0451" },
            { "lag", "\u043b\u0430\u043d\u0433\u0430" },
            { "Thaa", "\u0442\u0430\u043d\u0430" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u0430" },
            { "MC", "\u041c\u0430\u043d\u0430\u043a\u0430" },
            { "MD", "\u041c\u0430\u043b\u0434\u043e\u0432\u0430" },
            { "ME", "\u0427\u0430\u0440\u043d\u0430\u0433\u043e\u0440\u044b\u044f" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u044d\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u0430\u0432\u044b \u0410\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "ale", "\u0430\u043b\u0435\u0443\u0446\u043a\u0430\u044f" },
            { "Thai", "\u0442\u0430\u0439\u0441\u043a\u0430\u0435" },
            { "mi", "\u043c\u0430\u0430\u0440\u044b" },
            { "MK", "\u041c\u0430\u043a\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "ml", metaValue_ml },
            { "ML", "\u041c\u0430\u043b\u0456" },
            { "MM", "\u041c\u2019\u044f\u043d\u043c\u0430 (\u0411\u0456\u0440\u043c\u0430)" },
            { "MN", "\u041c\u0430\u043d\u0433\u043e\u043b\u0456\u044f" },
            { "mn", "\u043c\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "MO", "\u041c\u0430\u043a\u0430\u0430, \u0421\u0410\u0420 (\u041a\u0456\u0442\u0430\u0439)" },
            { "MP", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u044b\u044f \u041c\u0430\u0440\u044b\u044f\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "MQ", "\u041c\u0430\u0440\u0446\u0456\u043d\u0456\u043a\u0430" },
            { "MR", "\u041c\u0430\u045e\u0440\u044b\u0442\u0430\u043d\u0456\u044f" },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0456" },
            { "MS", "\u041c\u0430\u043d\u0442\u0441\u0435\u0440\u0430\u0442" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "MU", "\u041c\u0430\u045e\u0440\u044b\u043a\u0456\u0439" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u044b\u0432\u044b" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0456" },
            { "MX", "\u041c\u0435\u043a\u0441\u0456\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0456\u044f" },
            { "my", "\u0431\u0456\u0440\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "MZ", "\u041c\u0430\u0437\u0430\u043c\u0431\u0456\u043a" },
            { "Armn", "\u0430\u0440\u043c\u044f\u043d\u0441\u043a\u0430\u0435" },
            { "dsb", "\u043d\u0456\u0436\u043d\u0435\u043b\u0443\u0436\u044b\u0446\u043a\u0430\u044f" },
            { "NA", "\u041d\u0430\u043c\u0456\u0431\u0456\u044f" },
            { "nb", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f (\u0431\u0443\u043a\u043c\u0430\u043b)" },
            { "NC", "\u041d\u043e\u0432\u0430\u044f \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0456\u044f" },
            { "nd", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u043d\u0434\u044d\u0431\u0435\u043b\u0435" },
            { "NE", "\u041d\u0456\u0433\u0435\u0440" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "NF", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041d\u043e\u0440\u0444\u0430\u043b\u043a" },
            { "NG", "\u041d\u0456\u0433\u0435\u0440\u044b\u044f" },
            { "NI", "\u041d\u0456\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0456\u0434\u044d\u0440\u043b\u0430\u043d\u0434\u044b" },
            { "nl", "\u0433\u0430\u043b\u0430\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "nn", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f (\u043d\u044e\u043d\u043e\u0440\u0441\u043a)" },
            { "NO", "\u041d\u0430\u0440\u0432\u0435\u0433\u0456\u044f" },
            { "no", "\u043d\u0430\u0440\u0432\u0435\u0436\u0441\u043a\u0430\u044f" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0456\u0443\u044d" },
            { "rof", "\u0440\u043e\u043c\u0431\u0430" },
            { "NZ", "\u041d\u043e\u0432\u0430\u044f \u0417\u0435\u043b\u0430\u043d\u0434\u044b\u044f" },
            { "kab", "\u043a\u0430\u0431\u0456\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "oc", "\u043f\u0440\u0430\u0432\u0430\u043d\u0441\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "ang", "\u0441\u0442\u0430\u0440\u0430\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "OM", "\u0410\u043c\u0430\u043d" },
            { "om", "\u0430\u0440\u043e\u043c\u0430" },
            { "or", metaValue_or },
            { "mfe", "\u043c\u0430\u045e\u0440\u044b\u043a\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0456" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0430\u044f \u041f\u0430\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u2014 \u041d\u043e\u0432\u0430\u044f \u0413\u0432\u0456\u043d\u0435\u044f" },
            { "PH", "\u0424\u0456\u043b\u0456\u043f\u0456\u043d\u044b" },
            { "PK", "\u041f\u0430\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0447\u0430" },
            { "pl", "\u043f\u043e\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "PM", "\u0421\u0435\u043d-\u041f\u2019\u0435\u0440 \u0456 \u041c\u0456\u043a\u0435\u043b\u043e\u043d" },
            { "PN", "\u0410\u0441\u0442\u0440\u0430\u0432\u044b \u041f\u0456\u0442\u043a\u044d\u0440\u043d" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u0430-\u0420\u044b\u043a\u0430" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u044b\u043d\u0441\u043a\u0456\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "PT", "\u041f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u0456\u044f" },
            { "pt", "\u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "pt_BR", "\u043f\u0430\u0440\u0442\u0443\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f (\u0431\u0440\u0430\u0437\u0456\u043b.)" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0430-\u043c\u0435\u0435\u0442\u0430" },
            { "Hebr", "\u044f\u045e\u0440\u044d\u0439\u0441\u043a\u0430\u0435" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "Laoo", "\u043b\u0430\u043e\u0441\u043a\u0430\u0435" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "QO", "\u0412\u043e\u043d\u043a\u0430\u0432\u0430\u044f \u0410\u043a\u0456\u044f\u043d\u0456\u044f" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "brx", "\u0431\u043e\u0434\u0430" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u044d" },
            { "001", "\u0421\u0432\u0435\u0442" },
            { "Ethi", "\u044d\u0444\u0456\u043e\u043f\u0441\u043a\u0430\u0435" },
            { "002", "\u0410\u0444\u0440\u044b\u043a\u0430" },
            { "003", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "RE", "\u0420\u044d\u044e\u043d\u044c\u0451\u043d" },
            { "005", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "009", "\u0410\u043a\u0456\u044f\u043d\u0456\u044f" },
            { "rm", "\u0440\u044d\u0442\u0430\u0440\u0430\u043c\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "rn", "\u0440\u0443\u043d\u0434\u0437\u0456" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0456\u044f" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d\u0441\u043a\u0430\u044f" },
            { "RS", "\u0421\u0435\u0440\u0431\u0456\u044f" },
            { "RU", "\u0420\u0430\u0441\u0456\u044f" },
            { "ru", "\u0440\u0443\u0441\u043a\u0430\u044f" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "rw", "\u043a\u0456\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u0437\u044c\u044f\u043d\u0443" },
            { "en_AU", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f (\u0430\u045e\u0441\u0442\u0440\u0430\u043b.)" },
            { "SA", "\u0421\u0430\u0443\u0434\u0430\u045e\u0441\u043a\u0430\u044f \u0410\u0440\u0430\u0432\u0456\u044f" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u044b\u0442" },
            { "SB", "\u0421\u0430\u043b\u0430\u043c\u043e\u043d\u0430\u0432\u044b \u0410\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "011", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SC", "\u0421\u0435\u0439\u0448\u044d\u043b\u044c\u0441\u043a\u0456\u044f \u0410\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "sd", "\u0441\u0456\u043d\u0434\u0445\u0456" },
            { "013", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0430" },
            { "SE", "\u0428\u0432\u0435\u0446\u044b\u044f" },
            { "se", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u0441\u0430\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "014", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "arc", "\u0430\u0440\u0430\u043c\u0435\u0439\u0441\u043a\u0430\u044f" },
            { "015", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SG", "\u0421\u0456\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "sg", "\u0441\u0430\u043d\u0433\u0430" },
            { "SH", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u0421\u0432\u044f\u0442\u043e\u0439 \u0410\u043b\u0435\u043d\u044b" },
            { "sh", "\u0441\u0435\u0440\u0431\u0441\u043a\u0430-\u0445\u0430\u0440\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "017", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SI", "\u0421\u043b\u0430\u0432\u0435\u043d\u0456\u044f" },
            { "si", "\u0441\u0456\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "018", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u0444\u0440\u044b\u043a\u0430" },
            { "SJ", "\u0421\u0432\u0430\u043b\u044c\u0431\u0430\u0440\u0434 (\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430-\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0417\u044f\u043c\u043b\u044f) \u0456 \u042f\u043d-\u041c\u0430\u0435\u043d" },
            { "019", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0456 \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u043c\u0435\u0440\u044b\u043a\u0456" },
            { "SK", "\u0421\u043b\u0430\u0432\u0430\u043a\u0456\u044f" },
            { "sk", "\u0441\u043b\u0430\u0432\u0430\u0446\u043a\u0430\u044f" },
            { "SL", "\u0421\u044c\u0435\u0440\u0430-\u041b\u0435\u043e\u043d\u044d" },
            { "sl", "\u0441\u043b\u0430\u0432\u0435\u043d\u0441\u043a\u0430\u044f" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u044b\u043d\u0430" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "SO", "\u0421\u0430\u043c\u0430\u043b\u0456" },
            { "so", "\u0441\u0430\u043c\u0430\u043b\u0456\u0439\u0441\u043a\u0430\u044f" },
            { "arn", "\u043c\u0430\u043f\u0443\u0447\u044d" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "SR", "\u0421\u0443\u0440\u044b\u043d\u0430\u043c" },
            { "sr", "\u0441\u0435\u0440\u0431\u0441\u043a\u0430\u044f" },
            { "SS", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u0430\u043c\u044d \u0456 \u041f\u0440\u044b\u043d\u0441\u0456\u043f\u0456" },
            { "su", "\u0441\u0443\u043d\u0434\u0441\u043a\u0430\u044f" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "sv", "\u0448\u0432\u0435\u0434\u0441\u043a\u0430\u044f" },
            { "sw", "\u0441\u0443\u0430\u0445\u0456\u043b\u0456" },
            { "SX", "\u0421\u0456\u043d\u0442-\u041c\u0430\u0440\u0442\u044d\u043d" },
            { "SY", "\u0421\u0456\u0440\u044b\u044f" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0456\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u044b\u0441\u0442\u0430\u043d-\u0434\u0430-\u041a\u0443\u043d\u044c\u044f" },
            { "ta", "\u0442\u0430\u043c\u0456\u043b\u044c\u0441\u043a\u0430\u044f" },
            { "asa", "\u0430\u0441\u0443" },
            { "021", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u0430\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456 \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "142", "\u0410\u0437\u0456\u044f" },
            { "TC", "\u0426\u0451\u0440\u043a\u0441 \u0456 \u041a\u0430\u0439\u043a\u0430\u0441" },
            { "bua", "\u0431\u0443\u0440\u0430\u0446\u043a\u0430\u044f" },
            { "143", "\u0426\u044d\u043d\u0442\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u0410\u0437\u0456\u044f" },
            { "TD", "\u0427\u0430\u0434" },
            { "te", metaValue_te },
            { "145", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0441\u043a\u0456\u044f \u041f\u0430\u045e\u0434\u043d\u0451\u0432\u044b\u044f \u0442\u044d\u0440\u044b\u0442\u043e\u0440\u044b\u0456" },
            { "TG", "\u0422\u043e\u0433\u0430" },
            { "tg", "\u0442\u0430\u0434\u0436\u044b\u043a\u0441\u043a\u0430\u044f" },
            { "TH", "\u0422\u0430\u0439\u043b\u0430\u043d\u0434" },
            { "th", "\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "ti", "\u0442\u044b\u0433\u0440\u044b\u043d\u044c\u044f" },
            { "TJ", "\u0422\u0430\u0434\u0436\u044b\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "en_CA", "\u0430\u043d\u0433\u043b\u0456\u0439\u0441\u043a\u0430\u044f (\u043a\u0430\u043d\u0430\u0434.)" },
            { "029", "\u041a\u0430\u0440\u044b\u0431\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "TK", "\u0422\u0430\u043a\u0435\u043b\u0430\u0443" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0441\u043a\u0430\u044f" },
            { "TL", "\u0423\u0441\u0445\u043e\u0434\u043d\u0456 \u0422\u044b\u043c\u043e\u0440" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0456\u0441\u0442\u0430\u043d" },
            { "TN", "\u0422\u0443\u043d\u0456\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "to", "\u0442\u0430\u043d\u0433\u0430\u043d\u0441\u043a\u0430\u044f" },
            { "dyo", "\u0434\u044b\u0451\u043b\u0430-\u0444\u043e\u043d\u2019\u0456" },
            { "TR", "\u0422\u0443\u0440\u0446\u044b\u044f" },
            { "tr", "\u0442\u0443\u0440\u044d\u0446\u043a\u0430\u044f" },
            { "TT", "\u0422\u0440\u044b\u043d\u0456\u0434\u0430\u0434 \u0456 \u0422\u0430\u0431\u0430\u0433\u0430" },
            { "tt", "\u0442\u0430\u0442\u0430\u0440\u0441\u043a\u0430\u044f" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u044b\u0439\u0441\u043a\u0430\u044f" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0456\u044f" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0456\u0430" },
            { "Zzzz", "\u043d\u0435\u0432\u044f\u0434\u043e\u043c\u0430\u0435 \u043f\u0456\u0441\u044c\u043c\u043e" },
            { "150", "\u0415\u045e\u0440\u043e\u043f\u0430" },
            { "UA", "\u0423\u043a\u0440\u0430\u0456\u043d\u0430" },
            { "030", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "151", "\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "154", "\u041f\u0430\u045e\u043d\u043e\u0447\u043d\u0430\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "sw_CD", "\u0441\u0443\u0430\u0445\u0456\u043b\u0456 \u041a\u043e\u043d\u0433\u0430" },
            { "034", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0410\u0437\u0456\u044f" },
            { "155", "\u0417\u0430\u0445\u043e\u0434\u043d\u044f\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "035", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430-\u0423\u0441\u0445\u043e\u0434\u043d\u044f\u044f \u0410\u0437\u0456\u044f" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0441\u043a\u0430\u044f" },
            { "Kore", "\u043a\u0430\u0440\u044d\u0439\u0441\u043a\u0430\u0435" },
            { "Zyyy", "\u0437\u0432\u044b\u0447\u0430\u0439\u043d\u0430\u0435" },
            { "039", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430\u044f \u0415\u045e\u0440\u043e\u043f\u0430" },
            { "uk", "\u0443\u043a\u0440\u0430\u0456\u043d\u0441\u043a\u0430\u044f" },
            { "Sinh", "\u0441\u0456\u043d\u0433\u0430\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "UM", "\u0417\u043d\u0435\u0448\u043d\u0456\u044f \u043c\u0430\u043b\u044b\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b \u0417\u0428\u0410" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "US", "\u0417\u043b\u0443\u0447\u0430\u043d\u044b\u044f \u0428\u0442\u0430\u0442\u044b \u0410\u043c\u0435\u0440\u044b\u043a\u0456" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0456\u0441\u0442\u0430\u043d" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a\u0441\u043a\u0430\u044f" },
            { "tzm", "\u043c\u043e\u0432\u044b \u0442\u0430\u043c\u0430\u0437\u0456\u0433\u0445\u0442\u0430\u045e" },
            { "VA", "\u0412\u0430\u0442\u044b\u043a\u0430\u043d" },
            { "nds_NL", "\u043d\u0456\u0436\u043d\u0435\u0441\u0430\u043a\u0441\u043e\u043d\u0441\u043a\u0430\u044f" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0456\u043d\u0441\u0435\u043d\u0442 \u0456 \u0413\u0440\u044d\u043d\u0430\u0434\u0437\u0456\u043d\u044b" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0411\u0440\u044b\u0442\u0430\u043d\u0441\u043a\u0456\u044f \u0412\u0456\u0440\u0433\u0456\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "VI", "\u0410\u043c\u0435\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0456\u044f \u0412\u0456\u0440\u0433\u0456\u043d\u0441\u043a\u0456\u044f \u0430\u0441\u0442\u0440\u0430\u0432\u044b" },
            { "vi", "\u0432\u2019\u0435\u0442\u043d\u0430\u043c\u0441\u043a\u0430\u044f" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u044b\u0456\u043d\u0456" },
            { "VN", "\u0412\u2019\u0435\u0442\u043d\u0430\u043c" },
            { "quc", "\u043a\u0456\u0447\u044d" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "rwk", "\u0440\u0432\u0430" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u0441\u043a\u0430\u044f" },
            { "053", "\u0410\u045e\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0456\u044f" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0456\u044f" },
            { "WF", "\u0423\u043e\u043b\u0456\u0441 \u0456 \u0424\u0443\u0442\u0443\u043d\u0430" },
            { "Grek", "\u0433\u0440\u044d\u0447\u0430\u0441\u043a\u0430\u0435" },
            { "057", "\u041c\u0456\u043a\u0440\u0430\u043d\u0435\u0437\u0456\u0439\u0441\u043a\u0456 \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u044d" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "wo", "\u0432\u0430\u043b\u043e\u0444" },
            { "zgh", "\u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b \u043c\u0430\u0440\u0430\u043a\u0430\u043d\u0441\u043a\u0456 \u0442\u0430\u043c\u0430\u0437\u0456\u0433\u0445\u0442" },
            { "ar_001", "\u0441\u0443\u0447\u0430\u0441\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u0430\u044f \u0430\u0440\u0430\u0431\u0441\u043a\u0430\u044f" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "Mong", "\u0441\u0442\u0430\u0440\u0430\u043c\u0430\u043d\u0433\u043e\u043b\u044c\u0441\u043a\u0430\u0435" },
            { "061", "\u041f\u0430\u043b\u0456\u043d\u0435\u0437\u0456\u044f" },
            { "Latn", "\u043b\u0430\u0446\u0456\u043d\u043a\u0430" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "XK", "\u041a\u043e\u0441\u0430\u0432\u0430" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "\u043d\u0435\u043f\u0456\u0441\u044c\u043c\u0435\u043d\u043d\u044b" },
            { "wbp", "\u0432\u0430\u043b\u044c\u0431\u0456\u0440\u044b" },
            { "moh", "\u043c\u0430\u0433\u0430\u045e\u043a\u0441\u043a\u0430\u044f" },
            { "YE", "\u0415\u043c\u0435\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "yi", "\u0456\u0434\u044b\u0448" },
            { "yo", "\u0451\u0440\u0443\u0431\u0430" },
            { "es_MX", "\u0456\u0441\u043f\u0430\u043d\u0441\u043a\u0430\u044f (\u043c\u0435\u043a\u0441\u0456\u043a\u0430\u043d.)" },
            { "YT", "\u0412\u043e\u0441\u0442\u0440\u0430\u045e \u041c\u0430\u0451\u0442\u0430" },
            { "vai", "\u0432\u0430\u0456" },
            { "ZA", "\u041f\u0430\u045e\u0434\u043d\u0451\u0432\u0430-\u0410\u0444\u0440\u044b\u043a\u0430\u043d\u0441\u043a\u0430\u044f \u0420\u044d\u0441\u043f\u0443\u0431\u043b\u0456\u043a\u0430" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u044b\u043d" },
            { "Deva", "\u0434\u044d\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u044b" },
            { "zh", "\u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "Hira", "\u0445\u0456\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0456\u044f" },
            { "Bopo", "\u0431\u0430\u043f\u0430\u043c\u043e\u0444\u0430" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ZW", "\u0417\u0456\u043c\u0431\u0430\u0431\u0432\u044d" },
            { "ZZ", "\u041d\u0435\u0432\u044f\u0434\u043e\u043c\u044b \u0440\u044d\u0433\u0456\u0451\u043d" },
            { "Geor", "\u0433\u0440\u0443\u0437\u0456\u043d\u0441\u043a\u0430\u0435" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u044d" },
            { "zh_Hans", "\u0441\u043f\u0440\u043e\u0448\u0447\u0430\u043d\u0430\u044f \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "koi", "\u043a\u043e\u043c\u0456-\u043f\u044f\u0440\u043c\u044f\u0446\u043a\u0430\u044f" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0456" },
            { "nus", "\u043d\u0443\u044d\u0440" },
            { "dav", "\u0442\u0430\u0439\u0442\u0430" },
            { "lrc", "\u043f\u0430\u045e\u043d\u043e\u0447\u043d\u044b \u043b\u0443\u0440\u044b" },
            { "zh_Hant", "\u0442\u0440\u0430\u0434\u044b\u0446\u044b\u0439\u043d\u0430\u044f \u043a\u0456\u0442\u0430\u0439\u0441\u043a\u0430\u044f" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "Khmr", "\u043a\u0445\u043c\u0435\u0440\u0441\u043a\u0430\u0435" },
            { "sah", "\u044f\u043a\u0443\u0446\u043a\u0430\u044f" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "Guru", "\u0413\u0443\u0440\u043c\u0443\u043a\u0445\u0456" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "Telu", metaValue_te },
            { "ksf", "\u0431\u0430\u0444\u0456\u044f" },
        };
        return data;
    }
}
