/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.ResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.cpu.CCTDisplay;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.CombinedPanel;
import org.netbeans.lib.profiler.ui.cpu.ReverseCallGraphPanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;
import org.netbeans.lib.profiler.ui.cpu.SnapshotFlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.SubtreeCallGraphPanel;
import org.netbeans.lib.profiler.utils.formatting.MethodNameFormatterFactory;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ExportAction;
import org.netbeans.modules.profiler.LoadedSnapshot;
import org.netbeans.modules.profiler.SaveSnapshotAction;
import org.netbeans.modules.profiler.SaveViewAction;
import org.netbeans.modules.profiler.SnapshotInfoPanel;
import org.netbeans.modules.profiler.SnapshotPanel;
import org.netbeans.modules.profiler.SnapshotResultsWindow;
import org.netbeans.modules.profiler.actions.CompareSnapshotsAction;
import org.netbeans.modules.profiler.actions.FindNextAction;
import org.netbeans.modules.profiler.actions.FindPreviousAction;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.ProfilerDialogs;
import org.netbeans.modules.profiler.api.ProfilingSettingsManager;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.ui.FindDialog;
import org.netbeans.modules.profiler.utilities.ProfilerUtils;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.openide.actions.FindAction;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;

public final class CPUSnapshotPanel
extends SnapshotPanel
implements ActionListener,
ChangeListener,
SnapshotResultsWindow.FindPerformer,
SaveViewAction.ViewProvider,
ExportAction.ExportProvider {
    private static final Icon CLASSES_ICON = Icons.getIcon((String)"LanguageIcons.Class");
    private static final Icon METHODS_ICON = Icons.getIcon((String)"LanguageIcons.Methods");
    private static final Icon PACKAGES_ICON = Icons.getIcon((String)"LanguageIcons.Package");
    private static final Icon THREADS_ICON = Icons.getIcon((String)"ProfilerIcons.Thread");
    private static final Icon CALL_TREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCallTree");
    private static final Icon HOTSPOTS_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabHotSpots");
    private static final Icon COMBINED_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabCombined");
    private static final Icon INFO_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabInfo");
    private static final Icon BACK_TRACES_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabBackTraces");
    private static final Icon SUBTREE_TAB_ICON = Icons.getIcon((String)"ProfilerIcons.TabSubtree");
    private static final Icon SLAVE_DOWN_ICON = Icons.getIcon((String)"GeneralIcons.SlaveDown");
    private static final Icon SLAVE_UP_ICON = Icons.getIcon((String)"GeneralIcons.SlaveUp");
    private static final double SPLIT_HALF = 0.5;
    private CCTDisplay cctPanel;
    private CCTDisplay combinedCCT;
    private CPUResultsSnapshot snapshot;
    private CombinedPanel combined;
    private CombinedViewTracker combinedViewTracker;
    private Component findActionPresenter;
    private Component findNextPresenter;
    private Component findPreviousPresenter;
    private JComboBox aggregationCombo;
    private JComboBox threadsCombo;
    private JToggleButton slaveToggleButtonDown;
    private JToggleButton slaveToggleButtonUp;
    private LoadedSnapshot loadedSnapshot;
    private ReverseCallGraphPanel backtraceView;
    private SaveSnapshotAction saveAction;
    private SaveViewAction saveViewAction;
    private SnapshotFlatProfilePanel combinedFlat;
    private SnapshotFlatProfilePanel flatPanel;
    private SnapshotInfoPanel infoPanel;
    private SubtreeCallGraphPanel subtreeView;
    private int[] threadIds;
    private boolean internalChange = false;
    private boolean internalFilterChange = false;
    private boolean internalSelChange = false;
    private boolean slaveModeDown = true;
    private boolean slaveModeUp = true;
    private int currentAggregationMode;
    private Boolean sampling;

    public CPUSnapshotPanel(Lookup lookup, LoadedSnapshot loadedSnapshot, int n, boolean bl) {
        this.loadedSnapshot = loadedSnapshot;
        this.snapshot = (CPUResultsSnapshot)loadedSnapshot.getSnapshot();
        CPUActionsHandler cPUActionsHandler = new CPUActionsHandler();
        CPUSnapshotSelectionHandler cPUSnapshotSelectionHandler = new CPUSnapshotSelectionHandler(true);
        CPUSnapshotSelectionHandler cPUSnapshotSelectionHandler2 = new CPUSnapshotSelectionHandler(false);
        this.sampling = loadedSnapshot.getSettings().getCPUProfilingType() == 2;
        this.flatPanel = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)cPUActionsHandler, this.sampling);
        this.cctPanel = new CustomCCTDisplay((CPUResUserActionsHandler)cPUActionsHandler, this.sampling);
        this.infoPanel = new SnapshotInfoPanel(loadedSnapshot);
        this.combinedFlat = new SnapshotFlatProfilePanel((CPUResUserActionsHandler)cPUActionsHandler, (CPUSelectionHandler)cPUSnapshotSelectionHandler2, this.sampling);
        this.combinedCCT = new CustomCCTDisplay((CPUResUserActionsHandler)cPUActionsHandler, cPUSnapshotSelectionHandler, this.sampling);
        this.flatPanel.setSorting(n, bl);
        this.cctPanel.setSorting(n, bl);
        this.combinedFlat.setSorting(n, bl);
        this.combinedCCT.setSorting(n, bl);
        if (this.cctPanel.getPopupFindItem() != null) {
            this.cctPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.cctPanel.getPopupFindItem().setVisible(true);
        }
        if (this.flatPanel.getPopupFindItem() != null) {
            this.flatPanel.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.flatPanel.getPopupFindItem().setVisible(true);
        }
        if (this.combinedFlat.getPopupFindItem() != null) {
            this.combinedFlat.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_CallTreeString()));
            this.combinedFlat.getPopupFindItem().setVisible(true);
        }
        if (this.combinedCCT.getPopupFindItem() != null) {
            this.combinedCCT.getPopupFindItem().setText(Bundle.CPUSnapshotPanel_FindInStatement(Bundle.CPUSnapshotPanel_HotSpotsString()));
            this.combinedCCT.getPopupFindItem().setVisible(true);
        }
        this.flatPanel.setDataToDisplay(this.snapshot, -1, 0);
        this.cctPanel.setDataToDisplay(this.snapshot, 0);
        this.combinedFlat.setDataToDisplay(this.snapshot, -1, 0);
        this.combinedCCT.setDataToDisplay(this.snapshot, 0);
        this.flatPanel.prepareResults();
        this.cctPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.infoPanel.updateInfo();
        this.flatPanel.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.combinedFlat.setFilterValues(CPUSnapshotPanel.this.flatPanel.getFilterValue(), CPUSnapshotPanel.this.flatPanel.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combinedFlat.addFilterListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!CPUSnapshotPanel.this.internalFilterChange) {
                    CPUSnapshotPanel.this.internalFilterChange = true;
                    CPUSnapshotPanel.this.flatPanel.setFilterValues(CPUSnapshotPanel.this.combinedFlat.getFilterValue(), CPUSnapshotPanel.this.combinedFlat.getFilterType());
                    CPUSnapshotPanel.this.internalFilterChange = false;
                }
            }
        });
        this.combined = new CombinedPanel(0, (Component)this.combinedCCT, (Component)this.combinedFlat){

            public void requestFocus() {
                if (CPUSnapshotPanel.this.combinedCCT != null) {
                    CPUSnapshotPanel.this.combinedCCT.requestFocus();
                }
            }
        };
        this.combined.setResizeWeight(0.5);
        this.combined.setBorder(BorderFactory.createEmptyBorder());
        this.combined.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent componentEvent) {
                CPUSnapshotPanel.this.combined.setDividerLocation(0.5);
            }
        });
        this.addView(Bundle.CPUSnapshotPanel_CallTreeString(), CALL_TREE_TAB_ICON, Bundle.CPUSnapshotPanel_CallTreeTabDescr(), (Component)this.cctPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_HotSpotsString(), HOTSPOTS_TAB_ICON, Bundle.CPUSnapshotPanel_HotSpotTabDescr(), (Component)this.flatPanel, null);
        this.addView(Bundle.CPUSnapshotPanel_CombinedString(), COMBINED_TAB_ICON, Bundle.CPUSnapshotPanel_CombinedTabDescr(), (Component)this.combined, null);
        this.addView(Bundle.CPUSnapshotPanel_InfoString(), INFO_TAB_ICON, Bundle.CPUSnapshotPanel_InfoTabDescr(), this.infoPanel, null);
        this.addChangeListener(this);
        ProfilerToolbar profilerToolbar = ProfilerToolbar.create((boolean)true);
        this.saveAction = new SaveSnapshotAction(this.loadedSnapshot);
        profilerToolbar.add((Action)new ExportAction(this, this.loadedSnapshot));
        this.saveViewAction = new SaveViewAction(this);
        profilerToolbar.add((Action)this.saveViewAction);
        profilerToolbar.addSeparator();
        this.aggregationCombo = new JComboBox(new Object[]{Bundle.CPUSnapshotPanel_MethodsString(), Bundle.CPUSnapshotPanel_ClassesString(), Bundle.CPUSnapshotPanel_PackagesString()}){

            @Override
            public Dimension getMaximumSize() {
                return new Dimension(this.getPreferredSize().width + 20, this.getPreferredSize().height);
            }
        };
        this.aggregationCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_AggregationComboAccessName());
        this.aggregationCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_AggregationComboAccessDescr());
        this.currentAggregationMode = 0;
        String[] stringArray = this.snapshot.getThreadNames();
        Object[] objectArray = new Object[stringArray.length + 1];
        objectArray[0] = new Object(){

            public String toString() {
                return Bundle.CPUSnapshotPanel_AllThreadsItem();
            }
        };
        for (int i = 0; i < stringArray.length; ++i) {
            final String string = stringArray[i];
            objectArray[i + 1] = new Object(){

                public String toString() {
                    return string;
                }
            };
        }
        this.threadIds = this.snapshot.getThreadIds();
        this.threadsCombo = new JComboBox(objectArray){

            @Override
            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.width = 1;
                return dimension;
            }

            @Override
            public Dimension getMaximumSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width += 50;
                return dimension;
            }
        };
        this.threadsCombo.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ThreadsComboAccessName());
        this.threadsCombo.getAccessibleContext().setAccessibleDescription(Bundle.CPUSnapshotPanel_ThreadsComboAccessDescr());
        this.aggregationCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (Bundle.CPUSnapshotPanel_MethodsString().equals(object)) {
                    defaultListCellRenderer.setIcon(METHODS_ICON);
                } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(object)) {
                    defaultListCellRenderer.setIcon(CLASSES_ICON);
                } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(object)) {
                    defaultListCellRenderer.setIcon(PACKAGES_ICON);
                }
                return defaultListCellRenderer;
            }
        });
        this.threadsCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                DefaultListCellRenderer defaultListCellRenderer = (DefaultListCellRenderer)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (Bundle.CPUSnapshotPanel_AllThreadsItem().equals(object.toString())) {
                    defaultListCellRenderer.setIcon(null);
                } else {
                    defaultListCellRenderer.setIcon(THREADS_ICON);
                }
                return defaultListCellRenderer;
            }
        });
        JLabel jLabel = new JLabel(Bundle.CPUSnapshotPanel_ViewLabelString());
        jLabel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 6));
        jLabel.setLabelFor(this.aggregationCombo);
        int n2 = 0;
        jLabel.setDisplayedMnemonic(jLabel.getText().charAt(n2));
        jLabel.setDisplayedMnemonicIndex(n2);
        profilerToolbar.add((Component)jLabel);
        profilerToolbar.add((Component)this.aggregationCombo);
        this.aggregationCombo.addActionListener(this);
        profilerToolbar.addSpace(6);
        this.slaveToggleButtonDown = new JToggleButton(SLAVE_DOWN_ICON);
        this.slaveToggleButtonDown.setSelected(this.slaveModeDown);
        this.slaveToggleButtonDown.addActionListener(this);
        this.slaveToggleButtonDown.setToolTipText(Bundle.CPUSnapshotPanel_ToggleDownToolTip());
        this.slaveToggleButtonDown.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ToggleDownToolTip());
        profilerToolbar.add((Component)this.slaveToggleButtonDown);
        this.slaveToggleButtonUp = new JToggleButton(SLAVE_UP_ICON);
        this.slaveToggleButtonUp.setSelected(this.slaveModeUp);
        this.slaveToggleButtonUp.addActionListener(this);
        this.slaveToggleButtonUp.setToolTipText(Bundle.CPUSnapshotPanel_ToggleUpToolTip());
        this.slaveToggleButtonUp.getAccessibleContext().setAccessibleName(Bundle.CPUSnapshotPanel_ToggleUpToolTip());
        profilerToolbar.add((Component)this.slaveToggleButtonUp);
        profilerToolbar.add((Component)this.threadsCombo);
        this.threadsCombo.addActionListener(this);
        profilerToolbar.addSeparator();
        ContextAwareAction contextAwareAction = (ContextAwareAction)SystemAction.get(FindAction.class);
        this.findActionPresenter = profilerToolbar.add(contextAwareAction.createContextAwareInstance(lookup));
        this.findPreviousPresenter = profilerToolbar.add((Action)new FindPreviousAction(this));
        this.findNextPresenter = profilerToolbar.add((Action)new FindNextAction(this));
        if (this.findActionPresenter instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)this.findActionPresenter;
            abstractButton.setIcon(Icons.getIcon((String)"GeneralIcons.Find"));
            abstractButton.setText("");
            abstractButton.setToolTipText(Bundle.CPUSnapshotPanel_FindActionTooltip());
        }
        this.findActionPresenter.setEnabled(false);
        this.findPreviousPresenter.setEnabled(false);
        this.findNextPresenter.setEnabled(false);
        profilerToolbar.addSeparator();
        profilerToolbar.add((Action)new CompareSnapshotsAction(loadedSnapshot));
        this.updateToolbar();
        this.setMainToolbar(profilerToolbar.getComponent());
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 1), "FIND_PREVIOUS");
        this.getActionMap().put("FIND_PREVIOUS", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.performFindPrevious();
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getInputMap(1).put(KeyStroke.getKeyStroke(114, 0), "FIND_NEXT");
        this.getActionMap().put("FIND_NEXT", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CPUSnapshotPanel.this.performFindNext();
            }
        });
    }

    @Override
    public ResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public BufferedImage getViewImage(boolean bl) {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return null;
        }
        return ((ScreenshotProvider)component).getCurrentViewScreenshot(bl);
    }

    @Override
    public String getViewName() {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return null;
        }
        String string = ((ScreenshotProvider)component).getDefaultViewName();
        return this.getDefaultSnapshotFileName(this.getSnapshot()) + "-" + string;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.internalChange) {
            return;
        }
        Object object = actionEvent.getSource();
        if (object == this.aggregationCombo) {
            Object object2 = this.aggregationCombo.getSelectedItem();
            if (Bundle.CPUSnapshotPanel_MethodsString().equals(object2)) {
                this.changeView(0);
            } else if (Bundle.CPUSnapshotPanel_ClassesString().equals(object2)) {
                this.changeView(1);
            } else if (Bundle.CPUSnapshotPanel_PackagesString().equals(object2)) {
                this.changeView(2);
            }
        } else if (object == this.threadsCombo) {
            assert (this.getSelectedView() == this.flatPanel);
            int n = -1;
            if (this.threadsCombo.getSelectedIndex() > 0) {
                n = this.threadIds[this.threadsCombo.getSelectedIndex() - 1];
            }
            if (this.flatPanel.getCurrentThreadId() != n) {
                this.flatPanel.setDataToDisplay(this.snapshot, n, this.flatPanel.getCurrentView());
                this.flatPanel.prepareResults();
            }
        } else if (object == this.slaveToggleButtonDown) {
            this.slaveModeDown = this.slaveToggleButtonDown.isSelected();
        } else if (object == this.slaveToggleButtonUp) {
            this.slaveModeUp = this.slaveToggleButtonUp.isSelected();
        }
    }

    public void changeView(int n) {
        if (this.currentAggregationMode == n) {
            return;
        }
        this.currentAggregationMode = n;
        this.flatPanel.clearSelection();
        this.flatPanel.changeView(n);
        this.cctPanel.clearSelection();
        this.cctPanel.changeView(n);
        this.combinedCCT.clearSelection();
        this.combinedCCT.changeView(n);
        this.combinedFlat.clearSelection();
        this.combinedFlat.changeView(n);
        this.viewChanged(n);
    }

    @Override
    public boolean fitsVisibleArea() {
        Component component = this.getSelectedView();
        if (!(component instanceof ScreenshotProvider)) {
            return false;
        }
        return ((ScreenshotProvider)component).fitsVisibleArea();
    }

    @Override
    public boolean hasView() {
        Component component = this.getSelectedView();
        return component != null && component instanceof ScreenshotProvider && component != this.infoPanel;
    }

    @Override
    public void performFind() {
        if (this.getSelectedView() != this.infoPanel) {
            String string = FindDialog.getFindString();
            if (string == null) {
                return;
            }
            this.setFindString(string);
            this.performFindFirst();
        }
    }

    public void performFindFirst() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findFirst();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findFirst();
        } else if (component == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedFlat.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findFirst();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findFirst();
            }
        } else if (component == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findFirst();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findFirst();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindNext() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findNext();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findNext();
        } else if (component == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findNext();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findNext();
            }
        } else if (component == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findNext();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findNext();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    @Override
    public void performFindPrevious() {
        if (this.combinedViewTracker == null) {
            this.combinedViewTracker = new CombinedViewTracker();
            this.combinedFlat.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
            this.combinedCCT.addResultsViewFocusListener((FocusListener)this.combinedViewTracker);
        }
        boolean bl = false;
        Component component = this.getSelectedView();
        if (component == this.cctPanel) {
            if (!this.cctPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.cctPanel.findPrevious();
        } else if (component == this.flatPanel) {
            if (!this.flatPanel.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.flatPanel.findPrevious();
        } else if (component == this.combined) {
            if (this.combinedViewTracker.getLastFocusOwner() == null || this.combinedViewTracker.getLastFocusOwner() == this.combinedCCT.getResultsViewReference()) {
                if (!this.combinedCCT.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedCCT.findPrevious();
            } else {
                if (!this.combinedFlat.isFindStringDefined()) {
                    String string = FindDialog.getFindString();
                    if (string == null) {
                        return;
                    }
                    this.setFindString(string);
                }
                bl = this.combinedFlat.findPrevious();
            }
        } else if (component == this.backtraceView) {
            if (!this.backtraceView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.backtraceView.findPrevious();
        } else if (component == this.subtreeView) {
            if (!this.subtreeView.isFindStringDefined()) {
                String string = FindDialog.getFindString();
                if (string == null) {
                    return;
                }
                this.setFindString(string);
            }
            bl = this.subtreeView.findPrevious();
        }
        if (!bl) {
            ProfilerDialogs.displayInfo((String)Bundle.CPUSnapshotPanel_StringNotFoundMsg());
        }
    }

    public void requestFocus() {
        if (this.cctPanel != null) {
            this.cctPanel.requestFocus();
        }
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.updateToolbar();
        Component component = this.getSelectedView();
        if (component != null) {
            component.requestFocus();
        }
    }

    @Override
    public void updateSavedState() {
        this.infoPanel.updateInfo();
        this.saveAction.updateState();
    }

    private String getDefaultSnapshotFileName(ResultsSnapshot resultsSnapshot) {
        return "snapshot-" + resultsSnapshot.getTimeTaken();
    }

    private void setFindString(String string) {
        this.cctPanel.setFindString(string);
        this.flatPanel.setFindString(string);
        this.combinedFlat.setFindString(string);
        this.combinedCCT.setFindString(string);
        if (this.backtraceView != null) {
            this.backtraceView.setFindString(string);
        }
        if (this.subtreeView != null) {
            this.subtreeView.setFindString(string);
        }
    }

    private void closeReverseCallsGraphs() {
        if (this.backtraceView != null) {
            this.removeView((Component)this.backtraceView);
            this.backtraceView = null;
        }
    }

    private void updateToolbar() {
        Component component = this.getSelectedView();
        this.threadsCombo.setVisible(component == this.flatPanel);
        this.slaveToggleButtonDown.setVisible(component == this.combined);
        this.slaveToggleButtonUp.setVisible(component == this.combined);
        this.aggregationCombo.setEnabled(component != this.backtraceView && component != this.infoPanel && component != this.subtreeView);
        boolean bl = component != this.infoPanel;
        this.saveViewAction.setEnabled(bl);
        this.findActionPresenter.setEnabled(bl);
        this.findPreviousPresenter.setEnabled(bl);
        this.findNextPresenter.setEnabled(bl);
    }

    private void viewChanged(int n) {
        this.viewTypeHasChanged();
        this.internalChange = true;
        switch (n) {
            case 2: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_PackagesString());
                break;
            }
            case 1: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_ClassesString());
                break;
            }
            default: {
                this.aggregationCombo.setSelectedItem(Bundle.CPUSnapshotPanel_MethodsString());
            }
        }
        this.internalChange = false;
    }

    private void viewTypeHasChanged() {
        this.cctPanel.prepareResults();
        this.flatPanel.prepareResults();
        this.combinedCCT.prepareResults();
        this.combinedFlat.prepareResults();
        this.revalidate();
        this.repaint();
    }

    private void enhancePopupMenu(JPopupMenu jPopupMenu, CCTDisplay cCTDisplay) {
        Collection collection = Lookup.getDefault().lookupAll(CCTPopupEnhancer.class);
        for (CCTPopupEnhancer cCTPopupEnhancer : collection) {
            cCTPopupEnhancer.enhancePopup(jPopupMenu, this.loadedSnapshot, cCTDisplay);
        }
    }

    private void enableDisablePopup(PrestimeCPUCCTNode prestimeCPUCCTNode) {
        Collection collection = Lookup.getDefault().lookupAll(CCTPopupEnhancer.class);
        for (CCTPopupEnhancer cCTPopupEnhancer : collection) {
            cCTPopupEnhancer.enableDisablePopup(this.loadedSnapshot, prestimeCPUCCTNode);
        }
    }

    @Override
    public void exportData(int n, ExportDataDumper exportDataDumper) {
        Component component = this.getSelectedView();
        if (component instanceof CCTDisplay) {
            this.cctPanel.exportData(n, exportDataDumper, false, Bundle.CPUSnapshotPanel_CallTreeString());
        } else if (component instanceof SnapshotFlatProfilePanel) {
            this.flatPanel.exportData(n, exportDataDumper, false, Bundle.CPUSnapshotPanel_HotSpotsString());
        } else if (component instanceof SubtreeCallGraphPanel) {
            this.subtreeView.exportData(n, exportDataDumper, this.subtreeView.getShortTitle());
        } else if (component instanceof ReverseCallGraphPanel) {
            this.backtraceView.exportData(n, exportDataDumper, this.backtraceView.getShortTitle());
        } else if (component == this.combined) {
            this.combined.exportData(n, exportDataDumper, Bundle.CPUSnapshotPanel_CombinedString());
        }
    }

    @Override
    public boolean hasLoadedSnapshot() {
        return true;
    }

    @Override
    public boolean hasExportableView() {
        Component component = this.getSelectedView();
        return component != null && component != this.infoPanel;
    }

    @Override
    public void setState(SnapshotPanel.State state) {
        if (!(state instanceof State)) {
            return;
        }
        State state2 = (State)state;
        int n = state2.getSelectedTab();
        if (n == -1) {
            return;
        }
        boolean[] blArray = state2.getVisibleFilters();
        this.cctPanel.setFilterVisible(blArray[0]);
        this.combinedCCT.setFilterVisible(blArray[1]);
        this.flatPanel.setFilterVisible(blArray[2]);
        this.combinedFlat.setFilterVisible(blArray[3]);
        boolean[][] blArray2 = state2.getVisibleColumns();
        this.cctPanel.setColumnsVisibility(blArray2[0]);
        this.combinedCCT.setColumnsVisibility(blArray2[1]);
        this.flatPanel.setColumnsVisibility(blArray2[2]);
        this.combinedFlat.setColumnsVisibility(blArray2[3]);
        int[] nArray = state2.getSortingColumns();
        boolean[] blArray3 = state2.getSortingOrders();
        this.cctPanel.setSorting(nArray[0], blArray3[0], true);
        this.combinedCCT.setSorting(nArray[1], blArray3[1], true);
        this.flatPanel.setSorting(nArray[2], blArray3[2], true);
        this.combinedFlat.setSorting(nArray[3], blArray3[3], true);
        String[] stringArray = state2.getFilterValues();
        int[] nArray2 = state2.getFilterTypes();
        this.cctPanel.setFilterValues(stringArray[0], nArray2[0]);
        this.combinedCCT.setFilterValues(stringArray[1], nArray2[1]);
        this.flatPanel.setFilterValues(stringArray[2], nArray2[2]);
        this.combinedFlat.setFilterValues(stringArray[3], nArray2[3]);
        this.selectView(n);
    }

    @Override
    public State getState() {
        int n;
        String string;
        boolean bl;
        int n2;
        int n3 = this.getSelectedViewIndex();
        if (n3 > 3) {
            n3 = 0;
        }
        if (n3 == -1) {
            return null;
        }
        boolean bl2 = this.cctPanel.isFilterVisible();
        boolean bl3 = this.combinedCCT.isFilterVisible();
        boolean bl4 = this.flatPanel.isFilterVisible();
        boolean bl5 = this.combinedFlat.isFilterVisible();
        boolean[] blArray = this.cctPanel.getColumnsVisibility();
        boolean[] blArray2 = this.combinedCCT.getColumnsVisibility();
        boolean[] blArray3 = this.flatPanel.getColumnsVisibility();
        boolean[] blArray4 = this.combinedFlat.getColumnsVisibility();
        int n4 = n2 = this.getSelectedView() == this.cctPanel ? this.cctPanel.getSortingColumn() : this.combinedCCT.getSortingColumn();
        int n5 = n2;
        int n6 = this.flatPanel.getSortingColumn();
        int n7 = this.combinedFlat.getSortingColumn();
        boolean bl6 = bl = this.getSelectedView() == this.cctPanel ? this.cctPanel.getSortingOrder() : this.combinedCCT.getSortingOrder();
        boolean bl7 = bl;
        boolean bl8 = this.flatPanel.getSortingOrder();
        boolean bl9 = this.combinedFlat.getSortingOrder();
        String string2 = string = this.getSelectedView() == this.cctPanel ? this.cctPanel.getFilterValue() : this.combinedCCT.getFilterValue();
        String string3 = string;
        String string4 = this.flatPanel.getFilterValue();
        String string5 = this.combinedFlat.getFilterValue();
        int n8 = n = this.getSelectedView() == this.cctPanel ? this.cctPanel.getFilterType() : this.combinedCCT.getFilterType();
        int n9 = n;
        int n10 = this.flatPanel.getFilterType();
        int n11 = this.combinedFlat.getFilterType();
        return new State(n3, new boolean[]{bl2, bl3, bl4, bl5}, new boolean[][]{blArray, blArray2, blArray3, blArray4}, new int[]{n4, n5, n6, n7}, new boolean[]{bl6, bl7, bl8, bl9}, new String[]{string2, string3, string4, string5}, new int[]{n8, n9, n10, n11});
    }

    public static class State
    extends SnapshotPanel.State {
        private int selectedTab;
        private boolean[] visibleFilters;
        private boolean[][] visibleColumns;
        private int[] sortingColumns;
        private boolean[] sortingOrders;
        private String[] filterValues;
        private int[] filterTypes;

        State(int n, boolean[] blArray, boolean[][] blArray2, int[] nArray, boolean[] blArray3, String[] stringArray, int[] nArray2) {
            this.selectedTab = n;
            this.visibleFilters = blArray;
            this.visibleColumns = blArray2;
            this.sortingColumns = nArray;
            this.sortingOrders = blArray3;
            this.filterValues = stringArray;
            this.filterTypes = nArray2;
        }

        int getSelectedTab() {
            return this.selectedTab;
        }

        boolean[] getVisibleFilters() {
            return this.visibleFilters;
        }

        boolean[][] getVisibleColumns() {
            return this.visibleColumns;
        }

        int[] getSortingColumns() {
            return this.sortingColumns;
        }

        boolean[] getSortingOrders() {
            return this.sortingOrders;
        }

        String[] getFilterValues() {
            return this.filterValues;
        }

        int[] getFilterTypes() {
            return this.filterTypes;
        }
    }

    public static interface CCTPopupEnhancer {
        public void enhancePopup(JPopupMenu var1, LoadedSnapshot var2, CCTDisplay var3);

        public void enableDisablePopup(LoadedSnapshot var1, PrestimeCPUCCTNode var2);
    }

    private class CustomCCTDisplay
    extends CCTDisplay {
        private CustomCCTDisplay(CPUResUserActionsHandler cPUResUserActionsHandler, Boolean bl) {
            super(cPUResUserActionsHandler, bl);
        }

        private CustomCCTDisplay(CPUResUserActionsHandler cPUResUserActionsHandler, CPUSelectionHandler cPUSelectionHandler, Boolean bl) {
            super(cPUResUserActionsHandler, cPUSelectionHandler, bl);
        }

        protected JPopupMenu createPopupMenu() {
            JPopupMenu jPopupMenu = super.createPopupMenu();
            CPUSnapshotPanel.this.enhancePopupMenu(jPopupMenu, this);
            return jPopupMenu;
        }

        protected void enableDisablePopup(PrestimeCPUCCTNode prestimeCPUCCTNode) {
            super.enableDisablePopup(prestimeCPUCCTNode);
            CPUSnapshotPanel.this.enableDisablePopup(prestimeCPUCCTNode);
        }
    }

    private static class CombinedViewTracker
    extends FocusAdapter {
        private Object lastFocusOwner;

        private CombinedViewTracker() {
        }

        public Object getLastFocusOwner() {
            return this.lastFocusOwner;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.lastFocusOwner = focusEvent.getSource();
        }
    }

    private final class CPUSnapshotSelectionHandler
    implements CPUSelectionHandler {
        private boolean cct;

        private CPUSnapshotSelectionHandler(boolean bl) {
            this.cct = bl;
        }

        public void methodSelected(int n, int n2, int n3) {
            if (CPUSnapshotPanel.this.internalSelChange) {
                return;
            }
            if (n2 == -1) {
                return;
            }
            if (this.cct) {
                if (n >= -1 && CPUSnapshotPanel.this.combinedFlat.getCurrentThreadId() != n) {
                    CPUSnapshotPanel.this.combinedFlat.setDataToDisplay(CPUSnapshotPanel.this.combinedFlat.getSnapshot(), n, n3);
                    CPUSnapshotPanel.this.combinedFlat.prepareResults();
                }
                if (CPUSnapshotPanel.this.slaveModeDown) {
                    if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                        CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(false);
                    }
                    CPUSnapshotPanel.this.internalSelChange = true;
                    CPUSnapshotPanel.this.combinedFlat.selectMethod(n2);
                    CPUSnapshotPanel.this.internalSelChange = false;
                } else if (CPUSnapshotPanel.this.combinedCCT.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedCCT.getPopupFindItem().setEnabled(true);
                }
            } else if (CPUSnapshotPanel.this.slaveModeUp) {
                if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                    CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(false);
                }
                int n4 = CPUSnapshotPanel.this.combinedFlat.getCurrentView();
                String[] stringArray = CPUSnapshotPanel.this.snapshot.getMethodClassNameAndSig(n2, n4);
                CPUSnapshotPanel.this.combinedCCT.setFindString(MethodNameFormatterFactory.getDefault().getFormatter().formatMethodName(stringArray[0], stringArray[1], stringArray[2]).toFormatted());
                CPUSnapshotPanel.this.internalSelChange = true;
                CPUSnapshotPanel.this.combinedCCT.silentlyFindFirst();
                CPUSnapshotPanel.this.internalSelChange = false;
            } else if (CPUSnapshotPanel.this.combinedFlat.getPopupFindItem() != null) {
                CPUSnapshotPanel.this.combinedFlat.getPopupFindItem().setEnabled(true);
            }
        }
    }

    private final class CPUActionsHandler
    extends CPUResUserActionsHandler.Adapter {
        private CPUActionsHandler() {
        }

        public void addMethodToRoots(final String string, final String string2, final String string3) {
            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                @Override
                public void run() {
                    final Lookup.Provider provider = CPUSnapshotPanel.this.loadedSnapshot.getProject();
                    final ProfilingSettings[] profilingSettingsArray = ProfilingSettingsManager.getProfilingSettings((Lookup.Provider)provider).getProfilingSettings();
                    final ArrayList<ProfilingSettings> arrayList = new ArrayList<ProfilingSettings>();
                    for (ProfilingSettings profilingSettings : profilingSettingsArray) {
                        if (!ProfilingSettings.isCPUSettings((int)profilingSettings.getProfilingType())) continue;
                        arrayList.add(profilingSettings);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final ProfilingSettings profilingSettings = IDEUtils.selectSettings(16, arrayList.toArray(new ProfilingSettings[arrayList.size()]), null);
                            if (profilingSettings == null) {
                                return;
                            }
                            ProfilerUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    profilingSettings.addRootMethod(string, string2, string3);
                                    if (arrayList.contains(profilingSettings)) {
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings, (Lookup.Provider)provider);
                                    } else {
                                        ProfilingSettings[] profilingSettingsArray = new ProfilingSettings[profilingSettingsArray.length + 1];
                                        System.arraycopy(profilingSettingsArray, 0, profilingSettingsArray, 0, profilingSettingsArray.length);
                                        profilingSettingsArray[profilingSettingsArray.length] = profilingSettings;
                                        ProfilingSettingsManager.storeProfilingSettings((ProfilingSettings[])profilingSettingsArray, (ProfilingSettings)profilingSettings, (Lookup.Provider)provider);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }

        public void find(Object object, String string) {
            if (object == CPUSnapshotPanel.this.cctPanel) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.flatPanel);
                CPUSnapshotPanel.this.flatPanel.selectMethod(string);
            } else if (object == CPUSnapshotPanel.this.flatPanel) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.cctPanel);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (object == CPUSnapshotPanel.this.combinedFlat) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.performFindFirst();
            } else if (object == CPUSnapshotPanel.this.combinedCCT) {
                CPUSnapshotPanel.this.setFindString(string);
                CPUSnapshotPanel.this.combinedFlat.selectMethod(string);
            }
        }

        public void showReverseCallGraph(CPUResultsSnapshot cPUResultsSnapshot, int n, int n2, int n3, int n4, boolean bl) {
            if (CPUSnapshotPanel.this.backtraceView != null) {
                CPUSnapshotPanel.this.removeView((Component)CPUSnapshotPanel.this.backtraceView);
            }
            CPUSnapshotPanel.this.backtraceView = new ReverseCallGraphPanel((CPUResUserActionsHandler)this, CPUSnapshotPanel.this.sampling);
            CPUSnapshotPanel.this.backtraceView.setDataToDisplay(cPUResultsSnapshot, n, n3);
            CPUSnapshotPanel.this.backtraceView.setSelectedMethodId(n2);
            CPUSnapshotPanel.this.backtraceView.setSorting(n4, bl);
            CPUSnapshotPanel.this.backtraceView.prepareResults();
            CPUSnapshotPanel.this.backtraceView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.addView(CPUSnapshotPanel.this.backtraceView.getShortTitle(), BACK_TRACES_TAB_ICON, CPUSnapshotPanel.this.backtraceView.getTitle(), (Component)CPUSnapshotPanel.this.backtraceView, null);
            CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.backtraceView);
        }

        public void showSourceForMethod(String string, String string2, String string3) {
            GoToSource.openSource((Lookup.Provider)CPUSnapshotPanel.this.loadedSnapshot.getProject(), (String)string, (String)string2, (String)string3);
        }

        public void showSubtreeCallGraph(CPUResultsSnapshot cPUResultsSnapshot, CCTNode cCTNode, int n, int n2, boolean bl) {
            if (!(cCTNode instanceof PrestimeCPUCCTNode)) {
                return;
            }
            if (CPUSnapshotPanel.this.subtreeView != null) {
                CPUSnapshotPanel.this.removeView((Component)CPUSnapshotPanel.this.subtreeView);
            }
            CPUSnapshotPanel.this.subtreeView = new SubtreeCallGraphPanel((CPUResUserActionsHandler)this, CPUSnapshotPanel.this.sampling);
            CPUSnapshotPanel.this.subtreeView.setDataToDisplay(cPUResultsSnapshot, (PrestimeCPUCCTNode)cCTNode, n);
            CPUSnapshotPanel.this.subtreeView.setSorting(n2, bl);
            CPUSnapshotPanel.this.subtreeView.prepareResults();
            CPUSnapshotPanel.this.subtreeView.setFindString(CPUSnapshotPanel.this.cctPanel.getFindString());
            CPUSnapshotPanel.this.addView(CPUSnapshotPanel.this.subtreeView.getShortTitle(), SUBTREE_TAB_ICON, CPUSnapshotPanel.this.subtreeView.getTitle(), (Component)CPUSnapshotPanel.this.subtreeView, null);
            CPUSnapshotPanel.this.selectView((Component)CPUSnapshotPanel.this.subtreeView);
        }
    }
}

