/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.options;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.core.windows.options.LafOptionsPanelController;
import org.openide.LifecycleManager;
import org.openide.awt.Mnemonics;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LafPanel
extends JPanel {
    protected final LafOptionsPanelController controller;
    private final Preferences prefs = NbPreferences.forModule(LafPanel.class);
    private final boolean isAquaLaF = "Aqua".equals(UIManager.getLookAndFeel().getID());
    private int defaultLookAndFeelIndex;
    private final ArrayList<UIManager.LookAndFeelInfo> lafs = new ArrayList(10);
    private ButtonGroup buttonGroup1;
    private JCheckBox checkMaximizeNativeLaF;
    private JComboBox comboLaf;
    private JLabel lblLaf;
    private JLabel lblRestart;
    private JPanel panelLaF;
    private JPanel panelLaFCombo;
    private static Notification restartNotification;
    private static final String COLOR_MODEL_CLASS_NAME = "org.netbeans.modules.options.colors.ColorModel";
    private static final String DARK_COLOR_THEME_NAME = "Norway Today";

    protected LafPanel(LafOptionsPanelController lafOptionsPanelController) {
        this.controller = lafOptionsPanelController;
        this.initComponents();
        this.checkMaximizeNativeLaF.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                LafPanel.this.fireChanged();
            }
        });
        this.initLookAndFeel();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : this.lafs) {
            defaultComboBoxModel.addElement(lookAndFeelInfo.getName());
        }
        this.comboLaf.setModel(defaultComboBoxModel);
        this.comboLaf.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                LafPanel.this.fireChanged();
            }
        });
    }

    private void fireChanged() {
        boolean bl = false;
        if (this.checkMaximizeNativeLaF.isSelected() != this.prefs.getBoolean("laf.maximize.native", false) || this.comboLaf.getSelectedIndex() != this.lafs.indexOf(this.isForcedLaF() ? this.getCurrentLaF() : this.getPreferredLaF())) {
            bl = true;
        }
        this.controller.changed(bl);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.panelLaF = new JPanel();
        this.checkMaximizeNativeLaF = new JCheckBox();
        this.panelLaFCombo = new JPanel();
        this.comboLaf = new JComboBox();
        this.lblLaf = new JLabel();
        this.lblRestart = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridBagLayout());
        this.panelLaF.setLayout(new BorderLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.checkMaximizeNativeLaF, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.checkMaximizeNativeLaF.text"));
        this.checkMaximizeNativeLaF.setToolTipText(NbBundle.getMessage(LafPanel.class, (String)"LafPanel.checkMaximizeNativeLaF.toolTipText"));
        this.panelLaF.add((Component)this.checkMaximizeNativeLaF, "West");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.panelLaF, gridBagConstraints);
        this.panelLaFCombo.setLayout(new BorderLayout(3, 0));
        this.panelLaFCombo.add((Component)this.comboLaf, "Center");
        this.lblLaf.setLabelFor(this.comboLaf);
        Mnemonics.setLocalizedText((JLabel)this.lblLaf, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.lblLaf.text"));
        this.panelLaFCombo.add((Component)this.lblLaf, "West");
        Mnemonics.setLocalizedText((JLabel)this.lblRestart, (String)NbBundle.getMessage(LafPanel.class, (String)"LafPanel.lblRestart.text"));
        this.panelLaFCombo.add((Component)this.lblRestart, "After");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.panelLaFCombo, gridBagConstraints);
    }

    protected void load() {
        this.checkMaximizeNativeLaF.setSelected(this.prefs.getBoolean("laf.maximize.native", false));
        boolean bl = this.isForcedLaF();
        this.defaultLookAndFeelIndex = this.lafs.indexOf(bl ? this.getCurrentLaF() : this.getPreferredLaF());
        this.comboLaf.setSelectedIndex(this.defaultLookAndFeelIndex);
        this.comboLaf.setEnabled(!bl);
    }

    protected boolean store() {
        this.prefs.putBoolean("laf.maximize.native", this.checkMaximizeNativeLaF.isSelected());
        System.setProperty("nb.native.filechooser", this.checkMaximizeNativeLaF.isSelected() ? "true" : "false");
        int n = this.comboLaf.getSelectedIndex();
        if (n != this.defaultLookAndFeelIndex && !this.isForcedLaF()) {
            UIManager.LookAndFeelInfo lookAndFeelInfo = this.lafs.get(this.comboLaf.getSelectedIndex());
            NbPreferences.root().node("laf").put("laf", lookAndFeelInfo.getClassName());
            this.askForRestart();
        }
        return false;
    }

    boolean valid() {
        return true;
    }

    private void initLookAndFeel() {
        this.lafs.clear();
        for (UIManager.LookAndFeelInfo lookAndFeelInfo : UIManager.getInstalledLookAndFeels()) {
            this.lafs.add(lookAndFeelInfo);
        }
    }

    private boolean isForcedLaF() {
        return null != System.getProperty("nb.laf.forced");
    }

    private UIManager.LookAndFeelInfo getCurrentLaF() {
        UIManager.LookAndFeelInfo lookAndFeelInfo = null;
        String string = UIManager.getLookAndFeel().getClass().getName();
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        for (UIManager.LookAndFeelInfo lookAndFeelInfo2 : this.lafs) {
            if (!string.equals(lookAndFeelInfo2.getClassName()) && (!bl || !lookAndFeelInfo2.getClassName().contains("apple.laf.AquaLookAndFeel"))) continue;
            lookAndFeelInfo = lookAndFeelInfo2;
            break;
        }
        return lookAndFeelInfo;
    }

    private UIManager.LookAndFeelInfo getPreferredLaF() {
        String string = NbPreferences.root().node("laf").get("laf", null);
        if (null == string) {
            return this.getCurrentLaF();
        }
        UIManager.LookAndFeelInfo lookAndFeelInfo = null;
        boolean bl = "Aqua".equals(UIManager.getLookAndFeel().getID());
        for (UIManager.LookAndFeelInfo lookAndFeelInfo2 : this.lafs) {
            if (!string.equals(lookAndFeelInfo2.getClassName()) && (!bl || !lookAndFeelInfo2.getClassName().contains("apple.laf.AquaLookAndFeel"))) continue;
            lookAndFeelInfo = lookAndFeelInfo2;
            break;
        }
        return lookAndFeelInfo;
    }

    private void askForRestart() {
        if (null != restartNotification) {
            restartNotification.clear();
        }
        restartNotification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(LafPanel.class, (String)"Hint_RESTART_IDE"), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/core/windows/resources/restart.png", (boolean)true), this.createRestartNotificationDetails(), this.createRestartNotificationDetails(), NotificationDisplayer.Priority.HIGH, NotificationDisplayer.Category.INFO);
    }

    void selectDarkLookAndFeel() {
        this.comboLaf.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LafPanel.this.comboLaf.setPopupVisible(true);
            }
        });
    }

    private boolean isChangeEditorColorsPossible() {
        if (!this.isDarkLookAndFeel()) {
            return false;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = LafPanel.class.getClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(COLOR_MODEL_CLASS_NAME);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("getCurrentProfile", new Class[0]);
            Object object = method.invoke(obj, new Object[0]);
            return object != null && !DARK_COLOR_THEME_NAME.equals(object);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private void switchEditorColorsProfile() {
        if (!this.isChangeEditorColorsPossible()) {
            return;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = LafPanel.class.getClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(COLOR_MODEL_CLASS_NAME);
            Object obj = clazz.newInstance();
            Method method = clazz.getDeclaredMethod("setCurrentProfile", String.class);
            method.invoke(obj, DARK_COLOR_THEME_NAME);
        }
        catch (Exception exception) {
            Logger.getLogger(LafPanel.class.getName()).log(Level.INFO, "Cannot change editor colors profile.", exception);
        }
    }

    private JComponent createRestartNotificationDetails() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setOpaque(false);
        JLabel jLabel = new JLabel(NbBundle.getMessage(LafPanel.class, (String)"Descr_Restart"));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        jPanel.add((Component)jLabel, "Center");
        final JCheckBox jCheckBox = new JCheckBox(NbBundle.getMessage(LafPanel.class, (String)"Hint_ChangeEditorColors"));
        if (this.isChangeEditorColorsPossible()) {
            jCheckBox.setSelected(true);
            jCheckBox.setOpaque(false);
            jPanel.add((Component)jCheckBox, "South");
        }
        jLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (null != restartNotification) {
                    restartNotification.clear();
                    restartNotification = null;
                }
                if (jCheckBox.isSelected()) {
                    LafPanel.this.switchEditorColorsProfile();
                }
                LifecycleManager.getDefault().markForRestart();
                LifecycleManager.getDefault().exit();
            }
        });
        return jPanel;
    }

    private boolean isDarkLookAndFeel() {
        String string = NbPreferences.root().node("laf").get("laf", null);
        if (null == string) {
            return false;
        }
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (null == classLoader) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> clazz = classLoader.loadClass(string);
            LookAndFeel lookAndFeel = (LookAndFeel)clazz.newInstance();
            return lookAndFeel.getDefaults().getBoolean("nb.dark.theme");
        }
        catch (Exception exception) {
            return false;
        }
    }
}

