/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.model;

import java.util.List;
import javax.swing.Icon;
import org.netbeans.lib.profiler.heap.ArrayItemValue;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.Heap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.ObjectArrayInstance;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;
import org.netbeans.lib.profiler.heap.PrimitiveArrayInstance;
import org.netbeans.lib.profiler.heap.Value;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.details.api.DetailsSupport;
import org.netbeans.modules.profiler.heapwalk.model.AbstractHeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.ArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;
import org.netbeans.modules.profiler.heapwalk.model.Bundle;
import org.netbeans.modules.profiler.heapwalk.model.ChildrenComputer;
import org.netbeans.modules.profiler.heapwalk.model.ClassNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapPatterns;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerInstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.HeapWalkerNode;
import org.netbeans.modules.profiler.heapwalk.model.InstanceNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.ObjectNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayFieldNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveArrayNode;
import org.netbeans.modules.profiler.heapwalk.model.PrimitiveFieldNode;

public class HeapWalkerNodeFactory {
    public static final int ITEMS_COLLAPSE_UNIT_SIZE = 500;
    public static final int ITEMS_COLLAPSE_THRESHOLD = 2000;
    public static final int ITEMS_COLLAPSE_UNIT_THRESHOLD = 5000;

    public static HeapWalkerNode createArrayItemContainerNode(final ArrayNode arrayNode, final int n, final int n2) {
        return new AbstractHeapWalkerNode(arrayNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_ArrayContainerNameString(n, n2);
            }

            @Override
            protected String computeType() {
                return BrowserUtils.getArrayItemType(arrayNode.getType());
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_ArrayContainerValueString(n2 - n + 1);
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }

            @Override
            public boolean isLeaf() {
                return false;
            }

            @Override
            protected ChildrenComputer getChildrenComputer() {
                return new ChildrenComputer(){

                    @Override
                    public HeapWalkerNode[] computeChildren() {
                        int n = n2 - n + 1;
                        HeapWalkerNode[] heapWalkerNodeArray = new HeapWalkerNode[n];
                        boolean bl = arrayNode instanceof PrimitiveArrayNode;
                        List list = bl ? ((PrimitiveArrayInstance)arrayNode.getInstance()).getValues() : ((ObjectArrayInstance)arrayNode.getInstance()).getValues();
                        for (int i = 0; i < n; ++i) {
                            heapWalkerNodeArray[i] = bl ? HeapWalkerNodeFactory.createPrimitiveArrayItemNode((PrimitiveArrayNode)arrayNode, n + i, (String)list.get(n + i)) : HeapWalkerNodeFactory.createObjectArrayItemNode((ObjectArrayNode)arrayNode, n + i, (Instance)list.get(n + i));
                        }
                        return heapWalkerNodeArray;
                    }
                };
            }
        };
    }

    public static ClassNode createClassNode(JavaClass javaClass, String string, HeapWalkerNode heapWalkerNode) {
        return new ClassNode(javaClass, string, heapWalkerNode, heapWalkerNode == null ? 1 : heapWalkerNode.getMode());
    }

    public static HeapWalkerFieldNode createFieldNode(FieldValue fieldValue, HeapWalkerNode heapWalkerNode) {
        if (fieldValue instanceof ObjectFieldValue) {
            Instance instance = ((ObjectFieldValue)fieldValue).getInstance();
            if (instance instanceof PrimitiveArrayInstance) {
                return new PrimitiveArrayFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
            }
            if (instance instanceof ObjectArrayInstance) {
                return new ObjectArrayFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
            }
            return new ObjectFieldNode((ObjectFieldValue)fieldValue, heapWalkerNode);
        }
        return new PrimitiveFieldNode(fieldValue, heapWalkerNode);
    }

    public static HeapWalkerInstanceNode createInstanceNode(Instance instance, String string, HeapWalkerNode heapWalkerNode) {
        int n;
        int n2 = n = heapWalkerNode == null ? 1 : heapWalkerNode.getMode();
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode((PrimitiveArrayInstance)instance, string, heapWalkerNode, n);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode((ObjectArrayInstance)instance, string, heapWalkerNode, n);
        }
        return new ObjectNode(instance, string, heapWalkerNode, n);
    }

    public static HeapWalkerNode createNoFieldsNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoFieldsString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoFieldsNode(HeapWalkerNode heapWalkerNode) {
        return Bundle.HeapWalkerNodeFactory_NoFieldsString().equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createNoItemsNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoItemsString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoItemsNode(HeapWalkerNode heapWalkerNode) {
        return Bundle.HeapWalkerNodeFactory_NoItemsString().equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createNoReferencesNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_NoReferencesString();
            }

            @Override
            protected String computeType() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeValue() {
                return Bundle.HeapWalkerNodeFactory_NoneString();
            }

            @Override
            protected String computeSize() {
                return "-";
            }

            @Override
            protected String computeRetainedSize() {
                return "-";
            }

            @Override
            protected Icon computeIcon() {
                return null;
            }
        };
    }

    public static boolean isNoReferencesNode(HeapWalkerNode heapWalkerNode) {
        return Bundle.HeapWalkerNodeFactory_NoReferencesString().equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createOOMNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_OutOfMemoryString();
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return Icons.getIcon((String)"GeneralIcons.Error");
            }
        };
    }

    public static boolean isOOMNode(HeapWalkerNode heapWalkerNode) {
        return Bundle.HeapWalkerNodeFactory_OutOfMemoryString().equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode createObjectArrayItemNode(ObjectArrayNode objectArrayNode, int n, Instance instance) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.ArrayItem(n, (PrimitiveArrayInstance)instance, (HeapWalkerNode)objectArrayNode);
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.ArrayItem(n, (ObjectArrayInstance)instance, (HeapWalkerNode)objectArrayNode);
        }
        return new ObjectNode.ArrayItem(n, instance, (HeapWalkerNode)objectArrayNode);
    }

    public static HeapWalkerNode createPrimitiveArrayItemNode(PrimitiveArrayNode primitiveArrayNode, int n, String string) {
        return new PrimitiveFieldNode.ArrayItem(n, BrowserUtils.getArrayItemType(primitiveArrayNode.getType()), string, primitiveArrayNode);
    }

    public static HeapWalkerNode createProgressNode(HeapWalkerNode heapWalkerNode) {
        return new AbstractHeapWalkerNode(heapWalkerNode){

            @Override
            protected String computeName() {
                return Bundle.HeapWalkerNodeFactory_SearchingString();
            }

            @Override
            protected String computeType() {
                return "";
            }

            @Override
            protected String computeValue() {
                return "";
            }

            @Override
            protected String computeSize() {
                return "";
            }

            @Override
            protected String computeRetainedSize() {
                return "";
            }

            @Override
            protected Icon computeIcon() {
                return BrowserUtils.ICON_PROGRESS;
            }
        };
    }

    public static boolean isProgressNode(HeapWalkerNode heapWalkerNode) {
        return Bundle.HeapWalkerNodeFactory_SearchingString().equals(heapWalkerNode.getName());
    }

    public static HeapWalkerNode[] createReferences(InstanceNode instanceNode) {
        HeapWalkerNode[] heapWalkerNodeArray = null;
        List list = instanceNode.getReferences();
        heapWalkerNodeArray = HeapPatterns.processReferencePatterns(instanceNode, list);
        if (heapWalkerNodeArray != null) {
            return heapWalkerNodeArray;
        }
        if (list.size() == 0) {
            heapWalkerNodeArray = new HeapWalkerNode[]{HeapWalkerNodeFactory.createNoReferencesNode(instanceNode)};
        } else {
            heapWalkerNodeArray = new HeapWalkerNode[list.size()];
            for (int i = 0; i < heapWalkerNodeArray.length; ++i) {
                heapWalkerNodeArray[i] = HeapWalkerNodeFactory.createReferenceNode((Value)list.get(i), instanceNode);
            }
        }
        return heapWalkerNodeArray;
    }

    public static HeapWalkerNode createReferenceNode(Value value, HeapWalkerNode heapWalkerNode) {
        if (value instanceof ObjectFieldValue) {
            return new ObjectFieldNode((ObjectFieldValue)value, heapWalkerNode);
        }
        if (value instanceof ArrayItemValue) {
            ArrayItemValue arrayItemValue = (ArrayItemValue)value;
            return new ObjectArrayNode.ArrayItem(arrayItemValue.getIndex(), (ObjectArrayInstance)arrayItemValue.getDefiningInstance(), heapWalkerNode);
        }
        return null;
    }

    public static ClassNode createRootClassNode(JavaClass javaClass, String string, final Runnable runnable, final Runnable runnable2, int n, final Heap heap) {
        return new ClassNode.RootNode(javaClass, string, null, n){

            @Override
            public void refreshView() {
                runnable.run();
            }

            @Override
            public GCRoot getGCRoot(Instance instance) {
                return heap.getGCRoot(instance);
            }

            @Override
            public JavaClass getJavaClassByID(long l) {
                return heap.getJavaClassByID(l);
            }

            @Override
            public String getDetails(Instance instance) {
                return DetailsSupport.getDetailsString(instance, heap);
            }

            @Override
            public void repaintView() {
                runnable2.run();
            }
        };
    }

    public static HeapWalkerInstanceNode createRootInstanceNode(Instance instance, String string, final Runnable runnable, final Runnable runnable2, int n, final Heap heap) {
        if (instance instanceof PrimitiveArrayInstance) {
            return new PrimitiveArrayNode.RootNode((PrimitiveArrayInstance)instance, string, null, n){

                @Override
                public void refreshView() {
                    runnable.run();
                }

                @Override
                public GCRoot getGCRoot(Instance instance) {
                    return heap.getGCRoot(instance);
                }

                @Override
                public JavaClass getJavaClassByID(long l) {
                    return heap.getJavaClassByID(l);
                }

                @Override
                public String getDetails(Instance instance) {
                    return DetailsSupport.getDetailsString(instance, heap);
                }

                @Override
                public void repaintView() {
                    runnable2.run();
                }
            };
        }
        if (instance instanceof ObjectArrayInstance) {
            return new ObjectArrayNode.RootNode((ObjectArrayInstance)instance, string, null, n){

                @Override
                public void refreshView() {
                    runnable.run();
                }

                @Override
                public GCRoot getGCRoot(Instance instance) {
                    return heap.getGCRoot(instance);
                }

                @Override
                public JavaClass getJavaClassByID(long l) {
                    return heap.getJavaClassByID(l);
                }

                @Override
                public String getDetails(Instance instance) {
                    return DetailsSupport.getDetailsString(instance, heap);
                }

                @Override
                public void repaintView() {
                    runnable2.run();
                }
            };
        }
        return new ObjectNode.RootNode(instance, string, null, n){

            @Override
            public void refreshView() {
                runnable.run();
            }

            @Override
            public GCRoot getGCRoot(Instance instance) {
                return heap.getGCRoot(instance);
            }

            @Override
            public JavaClass getJavaClassByID(long l) {
                return heap.getJavaClassByID(l);
            }

            @Override
            public String getDetails(Instance instance) {
                return DetailsSupport.getDetailsString(instance, heap);
            }

            @Override
            public void repaintView() {
                runnable2.run();
            }
        };
    }

    public static boolean isMessageNode(HeapWalkerNode heapWalkerNode) {
        return HeapWalkerNodeFactory.isNoFieldsNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoItemsNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoReferencesNode(heapWalkerNode) || HeapWalkerNodeFactory.isNoReferencesNode(heapWalkerNode) || HeapWalkerNodeFactory.isOOMNode(heapWalkerNode) || HeapWalkerNodeFactory.isProgressNode(heapWalkerNode);
    }
}

