/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.HTMLLabel;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.heapwalk.Bundle;
import org.netbeans.modules.profiler.heapwalk.HeapFragmentWalker;
import org.netbeans.modules.profiler.heapwalk.model.BrowserUtils;

public class ClassPresenterPanel
extends JPanel
implements HeapFragmentWalker.StateListener {
    private static Icon ICON_CLASS = Icons.getIcon((String)"LanguageIcons.Class");
    private HeaderRenderer headerRenderer;
    private JLabel detailsRenderer;
    private HTMLLabel actionsRenderer;
    private HeapFragmentWalker heapFragmentWalker;

    public ClassPresenterPanel() {
        this.initComponents();
    }

    public void setJavaClass(JavaClass javaClass) {
        if (javaClass != null) {
            String string;
            String string2 = javaClass.getName();
            String string3 = Bundle.ClassPresenterPanel_InstancesCountString(javaClass.getInstancesCount());
            String string4 = javaClass.getInstanceSize() != -1 ? "  |  " + Bundle.ClassPresenterPanel_InstanceSizeString(javaClass.getInstanceSize()) : "";
            String string5 = javaClass.getAllInstancesSize() != -1L ? "  |  " + Bundle.ClassPresenterPanel_TotalSizeString(javaClass.getAllInstancesSize()) : "";
            String string6 = string = javaClass.isArray() ? string3 + string5 : string3 + string4 + string5;
            if (this.heapFragmentWalker.getRetainedSizesStatus() == 3) {
                string = string + "  |  " + Bundle.ClassPresenterPanel_RetainedSizeString(javaClass.getRetainedSizeByClass());
            }
            this.headerRenderer.setText(string2);
            this.detailsRenderer.setText(string);
            this.actionsRenderer.setPreferredSize(new Dimension(this.actionsRenderer.getPreferredSize().width, this.detailsRenderer.getPreferredSize().height));
        }
    }

    public void setHeapFragmentWalker(HeapFragmentWalker heapFragmentWalker) {
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.removeStateListener(this);
        }
        this.heapFragmentWalker = heapFragmentWalker;
        if (this.heapFragmentWalker != null) {
            this.heapFragmentWalker.addStateListener(this);
            this.updateActions(heapFragmentWalker.getRetainedSizesStatus());
        } else {
            this.updateActions(-1);
        }
    }

    public void refresh() {
    }

    @Override
    public void stateChanged(HeapFragmentWalker.StateEvent stateEvent) {
        this.updateActions(stateEvent.getRetainedSizesStatus());
    }

    public void updateActions(int n) {
        switch (n) {
            case -1: 
            case 3: {
                this.actionsRenderer.setVisible(false);
                this.refresh();
                break;
            }
            case 0: 
            case 1: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(true);
                break;
            }
            case 2: {
                this.actionsRenderer.setVisible(true);
                this.actionsRenderer.setEnabled(false);
            }
        }
    }

    private void initComponents() {
        Color color = UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow");
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(color), BorderFactory.createEmptyBorder(2, 5, 2, 5)));
        this.setOpaque(true);
        this.setBackground(UIUtils.getDarker((Color)UIUtils.getProfilerResultsBackground()));
        this.headerRenderer = new HeaderRenderer();
        this.headerRenderer.setIcon(ICON_CLASS);
        this.headerRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.headerRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.headerRenderer.setOpaque(false);
        this.detailsRenderer = new JLabel();
        this.detailsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.detailsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.detailsRenderer.setOpaque(false);
        this.actionsRenderer = new HTMLLabel(){

            protected void showURL(URL uRL) {
                if (ClassPresenterPanel.this.heapFragmentWalker != null) {
                    BrowserUtils.performTask(new Runnable(){

                        @Override
                        public void run() {
                            ClassPresenterPanel.this.heapFragmentWalker.computeRetainedSizes(true, true);
                        }
                    });
                }
            }

            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.actionsRenderer.setBorder(BorderFactory.createEmptyBorder());
        this.actionsRenderer.setForeground(UIManager.getColor("ToolTip.foreground"));
        this.actionsRenderer.setFont(UIManager.getFont("ToolTip.font"));
        this.actionsRenderer.setText("&nbsp;&nbsp;|&nbsp;&nbsp;<a href='#'>" + Bundle.ClassPresenterPanel_RetainedSizesString() + "</a>");
        this.actionsRenderer.setOpaque(false);
        this.actionsRenderer.setVisible(false);
        JPanel jPanel = new JPanel(new FlowLayout(3, 0, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.detailsRenderer);
        jPanel.add((Component)this.actionsRenderer);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.add((Component)this.headerRenderer, gridBagConstraints);
        JPanel jPanel2 = new JPanel(null);
        jPanel2.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.add((Component)jPanel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        this.add((Component)jPanel, gridBagConstraints);
    }

    private static class HeaderRenderer
    extends JPanel {
        private JLabel classIcon;
        private JLabel packageName;
        private JLabel className;

        HeaderRenderer() {
            this.setLayout(new BorderLayout());
            this.classIcon = new JLabel();
            this.classIcon.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, this.classIcon.getIconTextGap()));
            this.packageName = new JLabel();
            this.packageName.setFont(this.packageName.getFont().deriveFont(0));
            this.packageName.setBorder(BorderFactory.createEmptyBorder());
            this.className = new JLabel();
            this.className.setFont(this.packageName.getFont().deriveFont(1));
            this.className.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            this.add((Component)this.classIcon, "West");
            this.add((Component)this.packageName, "Center");
            this.add((Component)this.className, "East");
        }

        public void setIcon(Icon icon) {
            this.classIcon.setIcon(icon);
        }

        public void setText(String string) {
            int n = string.lastIndexOf(46);
            if (n == -1) {
                this.packageName.setText("");
                this.className.setText(string);
            } else {
                this.packageName.setText(string.substring(0, ++n));
                this.className.setText(string.substring(n));
            }
        }
    }
}

