/*
 * Decompiled with CFR 0.152.
 */
package clojure.lang;

import clojure.lang.ASeq;
import clojure.lang.IDeref;
import clojure.lang.IFn;
import clojure.lang.IPersistentMap;
import clojure.lang.IReduce;
import clojure.lang.ISeq;
import clojure.lang.PersistentList;
import clojure.lang.RT;

public class Repeat
extends ASeq
implements IReduce {
    private static final long INFINITE = -1L;
    private final long count;
    private final Object val;
    private volatile ISeq _next;

    private Repeat(long count2, Object val2) {
        this.count = count2;
        this.val = val2;
    }

    private Repeat(IPersistentMap meta, long count2, Object val2) {
        super(meta);
        this.count = count2;
        this.val = val2;
    }

    public static Repeat create(Object val2) {
        return new Repeat(-1L, val2);
    }

    public static ISeq create(long count2, Object val2) {
        if (count2 <= 0L) {
            return PersistentList.EMPTY;
        }
        return new Repeat(count2, val2);
    }

    @Override
    public Object first() {
        return this.val;
    }

    @Override
    public ISeq next() {
        if (this._next == null) {
            if (this.count > 1L) {
                this._next = new Repeat(this.count - 1L, this.val);
            } else if (this.count == -1L) {
                this._next = this;
            }
        }
        return this._next;
    }

    @Override
    public Repeat withMeta(IPersistentMap meta) {
        return new Repeat(meta, this.count, this.val);
    }

    @Override
    public Object reduce(IFn f) {
        Object ret = this.val;
        if (this.count == -1L) {
            while (!RT.isReduced(ret = f.invoke(ret, this.val))) {
            }
            return ((IDeref)ret).deref();
        }
        for (long i = 1L; i < this.count; ++i) {
            if (!RT.isReduced(ret = f.invoke(ret, this.val))) continue;
            return ((IDeref)ret).deref();
        }
        return ret;
    }

    @Override
    public Object reduce(IFn f, Object start) {
        Object ret = start;
        if (this.count == -1L) {
            while (!RT.isReduced(ret = f.invoke(ret, this.val))) {
            }
            return ((IDeref)ret).deref();
        }
        for (long i = 0L; i < this.count; ++i) {
            if (!RT.isReduced(ret = f.invoke(ret, this.val))) continue;
            return ((IDeref)ret).deref();
        }
        return ret;
    }
}

