/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.model.io;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.ModelWriter;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;

@Component(role=ModelWriter.class)
public class DefaultModelWriter
implements ModelWriter {
    @Override
    public void write(File output, Map<String, Object> options, Model model) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(model, "model cannot be null", new Object[0]);
        output.getParentFile().mkdirs();
        this.write(WriterFactory.newXmlWriter(output), options, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(Writer output, Map<String, Object> options, Model model) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(model, "model cannot be null", new Object[0]);
        try {
            MavenXpp3Writer w = new MavenXpp3Writer();
            w.write(output, model);
        }
        finally {
            IOUtil.close(output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(OutputStream output, Map<String, Object> options, Model model) throws IOException {
        Validate.notNull(output, "output cannot be null", new Object[0]);
        Validate.notNull(model, "model cannot be null", new Object[0]);
        try {
            String encoding2 = model.getModelEncoding();
            if (encoding2 == null || encoding2.length() <= 0) {
                encoding2 = "UTF-8";
            }
            this.write(new OutputStreamWriter(output, encoding2), options, model);
        }
        finally {
            IOUtil.close(output);
        }
    }
}

