/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.util;

import java.io.File;
import org.codehaus.plexus.util.MatchPatterns;
import org.codehaus.plexus.util.Scanner;
import org.codehaus.plexus.util.SelectorUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractScanner
implements Scanner {
    public static final String[] DEFAULTEXCLUDES = new String[]{"**/*~", "**/#*#", "**/.#*", "**/%*%", "**/._*", "**/CVS", "**/CVS/**", "**/.cvsignore", "**/RCS", "**/RCS/**", "**/SCCS", "**/SCCS/**", "**/vssver.scc", "**/project.pj", "**/.svn", "**/.svn/**", "**/.arch-ids", "**/.arch-ids/**", "**/.bzr", "**/.bzr/**", "**/.MySCMServerInfo", "**/.DS_Store", "**/.metadata", "**/.metadata/**", "**/.hg", "**/.hg/**", "**/.git", "**/.gitignore", "**/.gitattributes", "**/.git/**", "**/BitKeeper", "**/BitKeeper/**", "**/ChangeSet", "**/ChangeSet/**", "**/_darcs", "**/_darcs/**", "**/.darcsrepo", "**/.darcsrepo/**", "**/-darcs-backup*", "**/.darcs-temp-mail"};
    protected String[] includes;
    private MatchPatterns includesPatterns;
    protected String[] excludes;
    private MatchPatterns excludesPatterns;
    protected boolean isCaseSensitive = true;

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    protected static boolean matchPatternStart(String pattern, String str2) {
        return SelectorUtils.matchPatternStart(pattern, str2);
    }

    protected static boolean matchPatternStart(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.matchPatternStart(pattern, str2, isCaseSensitive);
    }

    protected static boolean matchPath(String pattern, String str2) {
        return SelectorUtils.matchPath(pattern, str2);
    }

    protected static boolean matchPath(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.matchPath(pattern, str2, isCaseSensitive);
    }

    public static boolean match(String pattern, String str2) {
        return SelectorUtils.match(pattern, str2);
    }

    protected static boolean match(String pattern, String str2, boolean isCaseSensitive) {
        return SelectorUtils.match(pattern, str2, isCaseSensitive);
    }

    public void setIncludes(String[] includes) {
        if (includes == null) {
            this.includes = null;
        } else {
            this.includes = new String[includes.length];
            for (int i = 0; i < includes.length; ++i) {
                this.includes[i] = this.normalizePattern(includes[i]);
            }
        }
    }

    public void setExcludes(String[] excludes) {
        if (excludes == null) {
            this.excludes = null;
        } else {
            this.excludes = new String[excludes.length];
            for (int i = 0; i < excludes.length; ++i) {
                this.excludes[i] = this.normalizePattern(excludes[i]);
            }
        }
    }

    private String normalizePattern(String pattern) {
        if ((pattern = pattern.trim()).startsWith("%regex[")) {
            pattern = File.separatorChar == '\\' ? StringUtils.replace(pattern, "/", "\\\\") : StringUtils.replace(pattern, "\\\\", "/");
        } else if ((pattern = pattern.replace(File.separatorChar == '/' ? (char)'\\' : '/', File.separatorChar)).endsWith(File.separator)) {
            pattern = pattern + "**";
        }
        return pattern;
    }

    protected boolean isIncluded(String name2) {
        return this.includesPatterns.matches(name2, this.isCaseSensitive);
    }

    protected boolean isIncluded(String name2, String[] tokenizedName) {
        return this.includesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    protected boolean couldHoldIncluded(String name2) {
        return this.includesPatterns.matchesPatternStart(name2, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name2) {
        return this.excludesPatterns.matches(name2, this.isCaseSensitive);
    }

    protected boolean isExcluded(String name2, String[] tokenizedName) {
        return this.excludesPatterns.matches(name2, tokenizedName, this.isCaseSensitive);
    }

    public void addDefaultExcludes() {
        int excludesLength = this.excludes == null ? 0 : this.excludes.length;
        String[] newExcludes = new String[excludesLength + DEFAULTEXCLUDES.length];
        if (excludesLength > 0) {
            System.arraycopy(this.excludes, 0, newExcludes, 0, excludesLength);
        }
        for (int i = 0; i < DEFAULTEXCLUDES.length; ++i) {
            newExcludes[i + excludesLength] = DEFAULTEXCLUDES[i].replace('/', File.separatorChar);
        }
        this.excludes = newExcludes;
    }

    protected void setupDefaultFilters() {
        if (this.includes == null) {
            this.includes = new String[1];
            this.includes[0] = "**";
        }
        if (this.excludes == null) {
            this.excludes = new String[0];
        }
    }

    protected void setupMatchPatterns() {
        this.includesPatterns = MatchPatterns.from(this.includes);
        this.excludesPatterns = MatchPatterns.from(this.excludes);
    }
}

