/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.wagon;

import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.spi.locator.Service;
import org.eclipse.aether.spi.locator.ServiceLocator;
import org.eclipse.aether.spi.log.Logger;
import org.eclipse.aether.spi.log.LoggerFactory;
import org.eclipse.aether.spi.log.NullLoggerFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.wagon.WagonConfigurator;
import org.eclipse.aether.transport.wagon.WagonProvider;
import org.eclipse.aether.transport.wagon.WagonTransporter;

@Named(value="wagon")
public final class WagonTransporterFactory
implements TransporterFactory,
Service {
    private Logger logger = NullLoggerFactory.LOGGER;
    private WagonProvider wagonProvider;
    private WagonConfigurator wagonConfigurator;
    private float priority = -1.0f;

    public WagonTransporterFactory() {
    }

    @Inject
    WagonTransporterFactory(WagonProvider wagonProvider, WagonConfigurator wagonConfigurator, LoggerFactory loggerFactory) {
        this.setWagonProvider(wagonProvider);
        this.setWagonConfigurator(wagonConfigurator);
        this.setLoggerFactory(loggerFactory);
    }

    @Override
    public void initService(ServiceLocator locator) {
        this.setLoggerFactory(locator.getService(LoggerFactory.class));
        this.setWagonProvider(locator.getService(WagonProvider.class));
        this.setWagonConfigurator(locator.getService(WagonConfigurator.class));
    }

    public WagonTransporterFactory setLoggerFactory(LoggerFactory loggerFactory) {
        this.logger = NullLoggerFactory.getSafeLogger(loggerFactory, WagonTransporter.class);
        return this;
    }

    public WagonTransporterFactory setWagonProvider(WagonProvider wagonProvider) {
        this.wagonProvider = wagonProvider;
        return this;
    }

    public WagonTransporterFactory setWagonConfigurator(WagonConfigurator wagonConfigurator) {
        this.wagonConfigurator = wagonConfigurator;
        return this;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public WagonTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session, RemoteRepository repository) throws NoTransporterException {
        return new WagonTransporter(this.wagonProvider, this.wagonConfigurator, repository, session, this.logger);
    }
}

