/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client;

import java.util.concurrent.TimeUnit;

final class DeadHostState {
    private static final long MIN_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final long MAX_CONNECTION_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(30L);
    static final DeadHostState INITIAL_DEAD_STATE = new DeadHostState();
    private final int failedAttempts;
    private final long deadUntilNanos;

    private DeadHostState() {
        this.failedAttempts = 1;
        this.deadUntilNanos = System.nanoTime() + MIN_CONNECTION_TIMEOUT_NANOS;
    }

    DeadHostState(DeadHostState previousDeadHostState) {
        long timeoutNanos = (long)Math.min((double)(MIN_CONNECTION_TIMEOUT_NANOS * 2L) * Math.pow(2.0, (double)previousDeadHostState.failedAttempts * 0.5 - 1.0), (double)MAX_CONNECTION_TIMEOUT_NANOS);
        this.deadUntilNanos = System.nanoTime() + timeoutNanos;
        this.failedAttempts = previousDeadHostState.failedAttempts + 1;
    }

    long getDeadUntilNanos() {
        return this.deadUntilNanos;
    }

    public String toString() {
        return "DeadHostState{failedAttempts=" + this.failedAttempts + ", deadUntilNanos=" + this.deadUntilNanos + '}';
    }
}

