/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.miscellaneous.LengthFilter;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractTokenFilterFactory;

public class LengthTokenFilterFactory
extends AbstractTokenFilterFactory {
    private final int min;
    private final int max;
    private static final String ENABLE_POS_INC_KEY = "enable_position_increments";

    LengthTokenFilterFactory(IndexSettings indexSettings, Environment environment, String name, Settings settings) {
        super(indexSettings, name, settings);
        this.min = settings.getAsInt("min", Integer.valueOf(0));
        this.max = settings.getAsInt("max", Integer.valueOf(Integer.MAX_VALUE));
        if (settings.get(ENABLE_POS_INC_KEY) != null) {
            throw new IllegalArgumentException("enable_position_increments is not supported anymore. Please fix your analysis chain");
        }
    }

    public TokenStream create(TokenStream tokenStream) {
        return new LengthFilter(tokenStream, this.min, this.max);
    }
}

