/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.spatial4j.shape.jts;

import com.vividsolutions.jts.geom.CoordinateSequence;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.context.jts.JtsSpatialContext;
import org.locationtech.spatial4j.shape.BaseShape;
import org.locationtech.spatial4j.shape.Circle;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;
import org.locationtech.spatial4j.shape.impl.PointImpl;

public class JtsPoint
extends BaseShape<JtsSpatialContext>
implements Point {
    private com.vividsolutions.jts.geom.Point pointGeom;
    private final boolean empty;

    public JtsPoint(com.vividsolutions.jts.geom.Point pointGeom, JtsSpatialContext ctx) {
        super(ctx);
        this.pointGeom = pointGeom;
        this.empty = pointGeom.isEmpty();
    }

    public com.vividsolutions.jts.geom.Point getGeom() {
        return this.pointGeom;
    }

    @Override
    public boolean isEmpty() {
        return this.empty;
    }

    @Override
    public Point getCenter() {
        return this;
    }

    @Override
    public boolean hasArea() {
        return false;
    }

    @Override
    public double getArea(SpatialContext ctx) {
        return 0.0;
    }

    @Override
    public Rectangle getBoundingBox() {
        return ((JtsSpatialContext)this.ctx).makeRectangle(this, this);
    }

    @Override
    public Circle getBuffered(double distance, SpatialContext ctx) {
        return ctx.makeCircle(this, distance);
    }

    @Override
    public SpatialRelation relate(Shape other) {
        if (this.isEmpty() || other.isEmpty()) {
            return SpatialRelation.DISJOINT;
        }
        if (other instanceof Point) {
            return this.equals(other) ? SpatialRelation.INTERSECTS : SpatialRelation.DISJOINT;
        }
        return other.relate(this).transpose();
    }

    @Override
    public double getX() {
        return this.isEmpty() ? Double.NaN : this.pointGeom.getX();
    }

    @Override
    public double getY() {
        return this.isEmpty() ? Double.NaN : this.pointGeom.getY();
    }

    @Override
    public void reset(double x, double y) {
        assert (!this.isEmpty());
        CoordinateSequence cSeq = this.pointGeom.getCoordinateSequence();
        cSeq.setOrdinate(0, 0, x);
        cSeq.setOrdinate(0, 1, y);
    }

    public String toString() {
        return "Pt(x=" + this.getX() + ",y=" + this.getY() + ")";
    }

    @Override
    public boolean equals(Object o) {
        return PointImpl.equals(this, o);
    }

    public int hashCode() {
        return PointImpl.hashCode(this);
    }
}

