/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresRequest;
import org.elasticsearch.action.admin.indices.shards.IndicesShardStoresResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.health.ClusterShardHealth;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.collect.ImmutableOpenIntMap;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.TransportNodesListGatewayStartedShards;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportIndicesShardStoresAction
extends TransportMasterNodeReadAction<IndicesShardStoresRequest, IndicesShardStoresResponse> {
    private final TransportNodesListGatewayStartedShards listShardStoresInfo;

    @Inject
    public TransportIndicesShardStoresAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, TransportNodesListGatewayStartedShards listShardStoresInfo) {
        super(settings, "indices:monitor/shard_stores", transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, IndicesShardStoresRequest::new);
        this.listShardStoresInfo = listShardStoresInfo;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected IndicesShardStoresResponse newResponse() {
        return new IndicesShardStoresResponse();
    }

    @Override
    protected void masterOperation(IndicesShardStoresRequest request, ClusterState state, ActionListener<IndicesShardStoresResponse> listener) {
        RoutingTable routingTables = state.routingTable();
        RoutingNodes routingNodes = state.getRoutingNodes();
        String[] concreteIndices = this.indexNameExpressionResolver.concreteIndexNames(state, request);
        HashSet<ShardId> shardIdsToFetch = new HashSet<ShardId>();
        this.logger.trace("using cluster state version [{}] to determine shards", (Object)state.version());
        for (String index : concreteIndices) {
            IndexRoutingTable indexShardRoutingTables = routingTables.index(index);
            if (indexShardRoutingTables == null) continue;
            for (IndexShardRoutingTable routing : indexShardRoutingTables) {
                int shardId = routing.shardId().id();
                ClusterShardHealth shardHealth = new ClusterShardHealth(shardId, routing);
                if (!request.shardStatuses().contains(shardHealth.getStatus())) continue;
                shardIdsToFetch.add(routing.shardId());
            }
        }
        new AsyncShardStoresInfoFetches(state.nodes(), routingNodes, shardIdsToFetch, listener).start();
    }

    @Override
    protected ClusterBlockException checkBlock(IndicesShardStoresRequest request, ClusterState state) {
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_READ, this.indexNameExpressionResolver.concreteIndexNames(state, request));
    }

    private class AsyncShardStoresInfoFetches {
        private final DiscoveryNodes nodes;
        private final RoutingNodes routingNodes;
        private final Set<ShardId> shardIds;
        private final ActionListener<IndicesShardStoresResponse> listener;
        private CountDown expectedOps;
        private final Queue<InternalAsyncFetch.Response> fetchResponses;

        AsyncShardStoresInfoFetches(DiscoveryNodes nodes, RoutingNodes routingNodes, Set<ShardId> shardIds, ActionListener<IndicesShardStoresResponse> listener) {
            this.nodes = nodes;
            this.routingNodes = routingNodes;
            this.shardIds = shardIds;
            this.listener = listener;
            this.fetchResponses = new ConcurrentLinkedQueue<InternalAsyncFetch.Response>();
            this.expectedOps = new CountDown(shardIds.size());
        }

        void start() {
            if (this.shardIds.isEmpty()) {
                this.listener.onResponse(new IndicesShardStoresResponse());
            } else {
                for (ShardId shardId : this.shardIds) {
                    InternalAsyncFetch fetch = new InternalAsyncFetch(TransportIndicesShardStoresAction.this.logger, "shard_stores", shardId, TransportIndicesShardStoresAction.this.listShardStoresInfo);
                    fetch.fetchData(this.nodes, Collections.emptySet());
                }
            }
        }

        private class InternalAsyncFetch
        extends AsyncShardFetch<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> {
            InternalAsyncFetch(Logger logger, String type, ShardId shardId, TransportNodesListGatewayStartedShards action) {
                super(logger, type, shardId, action);
            }

            @Override
            protected synchronized void processAsyncFetch(List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures, long fetchingRound) {
                AsyncShardStoresInfoFetches.this.fetchResponses.add(new Response(this.shardId, responses, failures));
                if (AsyncShardStoresInfoFetches.this.expectedOps.countDown()) {
                    this.finish();
                }
            }

            void finish() {
                ImmutableOpenMap.Builder indicesStoreStatusesBuilder = ImmutableOpenMap.builder();
                ArrayList<IndicesShardStoresResponse.Failure> failureBuilder = new ArrayList<IndicesShardStoresResponse.Failure>();
                for (Response fetchResponse : AsyncShardStoresInfoFetches.this.fetchResponses) {
                    ImmutableOpenIntMap indexStoreStatuses = (ImmutableOpenIntMap)indicesStoreStatusesBuilder.get(fetchResponse.shardId.getIndexName());
                    ImmutableOpenIntMap.Builder<ArrayList<Object>> indexShardsBuilder = indexStoreStatuses == null ? ImmutableOpenIntMap.builder() : ImmutableOpenIntMap.builder(indexStoreStatuses);
                    ArrayList<IndicesShardStoresResponse.StoreStatus> storeStatuses = (ArrayList<IndicesShardStoresResponse.StoreStatus>)indexShardsBuilder.get(fetchResponse.shardId.id());
                    if (storeStatuses == null) {
                        storeStatuses = new ArrayList<IndicesShardStoresResponse.StoreStatus>();
                    }
                    for (TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response : fetchResponse.responses) {
                        if (!this.shardExistsInNode(response)) continue;
                        IndicesShardStoresResponse.StoreStatus.AllocationStatus allocationStatus = this.getAllocationStatus(fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), response.getNode());
                        storeStatuses.add(new IndicesShardStoresResponse.StoreStatus(response.getNode(), response.allocationId(), allocationStatus, response.storeException()));
                    }
                    CollectionUtil.timSort(storeStatuses);
                    indexShardsBuilder.put(fetchResponse.shardId.id(), storeStatuses);
                    indicesStoreStatusesBuilder.put(fetchResponse.shardId.getIndexName(), indexShardsBuilder.build());
                    for (FailedNodeException failure : fetchResponse.failures) {
                        failureBuilder.add(new IndicesShardStoresResponse.Failure(failure.nodeId(), fetchResponse.shardId.getIndexName(), fetchResponse.shardId.id(), failure.getCause()));
                    }
                }
                AsyncShardStoresInfoFetches.this.listener.onResponse(new IndicesShardStoresResponse(indicesStoreStatusesBuilder.build(), Collections.unmodifiableList(failureBuilder)));
            }

            private IndicesShardStoresResponse.StoreStatus.AllocationStatus getAllocationStatus(String index, int shardID, DiscoveryNode node) {
                for (ShardRouting shardRouting : AsyncShardStoresInfoFetches.this.routingNodes.node(node.getId())) {
                    ShardId shardId = shardRouting.shardId();
                    if (shardId.id() != shardID || !shardId.getIndexName().equals(index)) continue;
                    if (shardRouting.primary()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.PRIMARY;
                    }
                    if (shardRouting.assignedToNode()) {
                        return IndicesShardStoresResponse.StoreStatus.AllocationStatus.REPLICA;
                    }
                    return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
                }
                return IndicesShardStoresResponse.StoreStatus.AllocationStatus.UNUSED;
            }

            private boolean shardExistsInNode(TransportNodesListGatewayStartedShards.NodeGatewayStartedShards response) {
                return response.storeException() != null || response.allocationId() != null;
            }

            @Override
            protected void reroute(ShardId shardId, String reason) {
            }

            public class Response {
                private final ShardId shardId;
                private final List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses;
                private final List<FailedNodeException> failures;

                Response(ShardId shardId, List<TransportNodesListGatewayStartedShards.NodeGatewayStartedShards> responses, List<FailedNodeException> failures) {
                    this.shardId = shardId;
                    this.responses = responses;
                    this.failures = failures;
                }
            }
        }
    }
}

