/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadBarrier
extends CyclicBarrier {
    private Exception cause;

    public ThreadBarrier(int parties) {
        super(parties);
    }

    public ThreadBarrier(int parties, Runnable barrierAction) {
        super(parties, barrierAction);
    }

    @Override
    public int await() throws InterruptedException, BrokenBarrierException {
        try {
            this.breakIfBroken();
            return super.await();
        }
        catch (BrokenBarrierException bbe) {
            this.initCause(bbe);
            throw bbe;
        }
    }

    @Override
    public int await(long timeout, TimeUnit unit) throws InterruptedException, BrokenBarrierException, TimeoutException {
        try {
            this.breakIfBroken();
            return super.await(timeout, unit);
        }
        catch (BrokenBarrierException bbe) {
            this.initCause(bbe);
            throw bbe;
        }
        catch (TimeoutException te) {
            this.initCause(te);
            throw te;
        }
    }

    public synchronized void reset(Exception cause) {
        if (!this.isBroken()) {
            super.reset();
        }
        if (this.cause == null) {
            this.cause = cause;
        }
    }

    @Override
    public synchronized boolean isBroken() {
        return this.cause != null || super.isBroken();
    }

    public synchronized void inspect() throws BrokenBarrierException {
        try {
            this.breakIfBroken();
        }
        catch (BrokenBarrierException bbe) {
            this.initCause(bbe);
            throw bbe;
        }
    }

    private synchronized void breakIfBroken() throws BrokenBarrierException {
        if (this.isBroken()) {
            throw new BrokenBarrierException();
        }
    }

    private synchronized void initCause(Throwable t) {
        t.initCause(this.cause);
    }

    public static class BarrierTimer
    implements Runnable {
        volatile boolean started;
        volatile long startTime;
        volatile long endTime;

        @Override
        public void run() {
            long t = System.nanoTime();
            if (!this.started) {
                this.started = true;
                this.startTime = t;
            } else {
                this.endTime = t;
            }
        }

        public void reset() {
            this.started = false;
        }

        public long getTimeInNanos() {
            return this.endTime - this.startTime;
        }

        public double getTimeInSeconds() {
            long time = this.endTime - this.startTime;
            return (double)time / 1.0E9;
        }
    }
}

