/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;

public class Index
implements Writeable,
ToXContentObject {
    public static final Index[] EMPTY_ARRAY = new Index[0];
    private static final String INDEX_UUID_KEY = "index_uuid";
    private static final String INDEX_NAME_KEY = "index_name";
    private static final ObjectParser<Builder, Void> INDEX_PARSER = new ObjectParser("index", () -> new Builder());
    private final String name;
    private final String uuid;

    public Index(String name, String uuid) {
        this.name = Objects.requireNonNull(name).intern();
        this.uuid = Objects.requireNonNull(uuid).intern();
    }

    public Index(StreamInput in) throws IOException {
        this.name = in.readString();
        this.uuid = in.readString();
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        if ("_na_".equals(this.uuid)) {
            return "[" + this.name + "]";
        }
        return "[" + this.name + "/" + this.uuid + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        Index index1 = (Index)o;
        return this.uuid.equals(index1.uuid) && this.name.equals(index1.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.uuid.hashCode();
        return result;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.uuid);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(INDEX_NAME_KEY, this.name);
        builder.field(INDEX_UUID_KEY, this.uuid);
        return builder.endObject();
    }

    public static Index fromXContent(XContentParser parser) throws IOException {
        return INDEX_PARSER.parse(parser, null).build();
    }

    static {
        INDEX_PARSER.declareString(Builder::name, new ParseField(INDEX_NAME_KEY, new String[0]));
        INDEX_PARSER.declareString(Builder::uuid, new ParseField(INDEX_UUID_KEY, new String[0]));
    }

    private static final class Builder {
        private String name;
        private String uuid;

        private Builder() {
        }

        public void name(String name) {
            this.name = name;
        }

        public void uuid(String uuid) {
            this.uuid = uuid;
        }

        public Index build() {
            return new Index(this.name, this.uuid);
        }
    }
}

