/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.warmer;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class WarmerStats
implements Streamable,
ToXContentFragment {
    private long current;
    private long total;
    private long totalTimeInMillis;

    public WarmerStats() {
    }

    public WarmerStats(long current, long total, long totalTimeInMillis) {
        this.current = current;
        this.total = total;
        this.totalTimeInMillis = totalTimeInMillis;
    }

    public void add(long current, long total, long totalTimeInMillis) {
        this.current += current;
        this.total += total;
        this.totalTimeInMillis += totalTimeInMillis;
    }

    public void add(WarmerStats warmerStats) {
        if (warmerStats == null) {
            return;
        }
        this.current += warmerStats.current;
        this.total += warmerStats.total;
        this.totalTimeInMillis += warmerStats.totalTimeInMillis;
    }

    public long current() {
        return this.current;
    }

    public long total() {
        return this.total;
    }

    public long totalTimeInMillis() {
        return this.totalTimeInMillis;
    }

    public TimeValue totalTime() {
        return new TimeValue(this.totalTimeInMillis);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("warmer");
        builder.field("current", this.current);
        builder.field("total", this.total);
        builder.timeValueField("total_time_in_millis", "total_time", this.totalTimeInMillis);
        builder.endObject();
        return builder;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.current = in.readVLong();
        this.total = in.readVLong();
        this.totalTimeInMillis = in.readVLong();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.current);
        out.writeVLong(this.total);
        out.writeVLong(this.totalTimeInMillis);
    }

    static final class Fields {
        static final String WARMER = "warmer";
        static final String CURRENT = "current";
        static final String TOTAL = "total";
        static final String TOTAL_TIME = "total_time";
        static final String TOTAL_TIME_IN_MILLIS = "total_time_in_millis";

        Fields() {
        }
    }
}

