/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.composite;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.SortField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentFragment;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.IndexSortConfig;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.sort.SortOrder;

public abstract class CompositeValuesSourceBuilder<AB extends CompositeValuesSourceBuilder<AB>>
implements Writeable,
ToXContentFragment {
    protected final String name;
    private String field = null;
    private Script script = null;
    private ValueType valueType = null;
    private Object missing = null;
    private SortOrder order = SortOrder.ASC;

    CompositeValuesSourceBuilder(String name) {
        this(name, null);
    }

    CompositeValuesSourceBuilder(String name, ValueType valueType) {
        this.name = name;
        this.valueType = valueType;
    }

    CompositeValuesSourceBuilder(StreamInput in) throws IOException {
        this.name = in.readString();
        this.field = in.readOptionalString();
        if (in.readBoolean()) {
            this.script = new Script(in);
        }
        if (in.readBoolean()) {
            this.valueType = ValueType.readFromStream(in);
        }
        this.missing = in.readGenericValue();
        this.order = SortOrder.readFromStream(in);
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeOptionalString(this.field);
        boolean hasScript = this.script != null;
        out.writeBoolean(hasScript);
        if (hasScript) {
            this.script.writeTo(out);
        }
        boolean hasValueType = this.valueType != null;
        out.writeBoolean(hasValueType);
        if (hasValueType) {
            this.valueType.writeTo(out);
        }
        out.writeGenericValue(this.missing);
        this.order.writeTo(out);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected abstract void doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.type());
        if (this.field != null) {
            builder.field("field", this.field);
        }
        if (this.script != null) {
            builder.field("script", this.script);
        }
        if (this.missing != null) {
            builder.field("missing", this.missing);
        }
        if (this.valueType != null) {
            builder.field("value_type", this.valueType.getPreferredName());
        }
        builder.field("order", this.order);
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    public final int hashCode() {
        return Objects.hash(this.field, this.missing, this.script, this.valueType, this.order, this.innerHashCode());
    }

    protected abstract int innerHashCode();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeValuesSourceBuilder that = (CompositeValuesSourceBuilder)o;
        return Objects.equals(this.field, that.field()) && Objects.equals(this.script, that.script()) && Objects.equals(this.valueType, that.valueType()) && Objects.equals(this.missing, that.missing()) && Objects.equals(this.order, that.order()) && this.innerEquals(that);
    }

    protected abstract boolean innerEquals(AB var1);

    public String name() {
        return this.name;
    }

    abstract String type();

    public AB field(String field) {
        if (field == null) {
            throw new IllegalArgumentException("[field] must not be null");
        }
        this.field = field;
        return (AB)this;
    }

    public String field() {
        return this.field;
    }

    public AB script(Script script) {
        if (script == null) {
            throw new IllegalArgumentException("[script] must not be null");
        }
        this.script = script;
        return (AB)this;
    }

    public Script script() {
        return this.script;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public ValueType valueType() {
        return this.valueType;
    }

    public AB missing(Object missing) {
        if (missing == null) {
            throw new IllegalArgumentException("[missing] must not be null");
        }
        this.missing = missing;
        return (AB)this;
    }

    public Object missing() {
        return this.missing;
    }

    public AB order(String order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = SortOrder.fromString(order);
        return (AB)this;
    }

    public AB order(SortOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null");
        }
        this.order = order;
        return (AB)this;
    }

    public SortOrder order() {
        return this.order;
    }

    protected abstract CompositeValuesSourceConfig innerBuild(SearchContext var1, ValuesSourceConfig<?> var2, int var3, int var4, SortField var5) throws IOException;

    public final CompositeValuesSourceConfig build(SearchContext context, int pos, int numPos, SortField sortField) throws IOException {
        ValuesSourceConfig config = ValuesSourceConfig.resolve(context.getQueryShardContext(), this.valueType, this.field, this.script, this.missing, null, null);
        return this.innerBuild(context, config, pos, numPos, sortField);
    }

    protected boolean checkCanEarlyTerminate(IndexReader reader, String fieldName, boolean reverse, SortField sortField) throws IOException {
        return sortField.getField().equals(fieldName) && sortField.getReverse() == reverse && CompositeValuesSourceBuilder.isSingleValued(reader, sortField);
    }

    private static boolean isSingleValued(IndexReader reader, SortField field) throws IOException {
        SortField.Type type = IndexSortConfig.getSortFieldType(field);
        for (LeafReaderContext context : reader.leaves()) {
            SortedSetDocValues values;
            if (!(type == SortField.Type.STRING ? (values = DocValues.getSortedSet((LeafReader)context.reader(), (String)field.getField())).cost() > 0L && DocValues.unwrapSingleton((SortedSetDocValues)values) == null : (values = DocValues.getSortedNumeric((LeafReader)context.reader(), (String)field.getField())).cost() > 0L && DocValues.unwrapSingleton((SortedNumericDocValues)values) == null)) continue;
            return false;
        }
        return true;
    }
}

