/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jtsexample.io.gml2;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.io.gml2.GMLHandler;
import com.vividsolutions.jtsexample.io.gml2.FixingGeometryFactory;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class KMLHandler
extends DefaultHandler {
    private List geoms = new ArrayList();
    private GMLHandler currGeomHandler;
    private String lastEltName = null;
    private GeometryFactory fact = new FixingGeometryFactory();

    public List getGeometries() {
        return this.geoms;
    }

    public void startElement(String uri, String name, String qName, Attributes atts) throws SAXException {
        if (name.equalsIgnoreCase("Polygon")) {
            this.currGeomHandler = new GMLHandler(this.fact, null);
        }
        if (this.currGeomHandler != null) {
            this.currGeomHandler.startElement(uri, name, qName, atts);
        }
        if (this.currGeomHandler == null) {
            this.lastEltName = name;
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.characters(ch, start, length);
        } else {
            String content = new String(ch, start, length).trim();
            if (content.length() > 0) {
                System.out.println(this.lastEltName + "= " + content);
            }
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.ignorableWhitespace(ch, start, length);
        }
    }

    public void endElement(String uri, String name, String qName) throws SAXException {
        if (this.currGeomHandler != null) {
            this.currGeomHandler.endElement(uri, name, qName);
            if (this.currGeomHandler.isGeometryComplete()) {
                Geometry g = this.currGeomHandler.getGeometry();
                System.out.println(g);
                this.geoms.add(g);
                this.currGeomHandler = null;
            }
        }
    }
}

