/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.automaton.CompiledAutomaton;

final class TermVectorFilteredLeafReader
extends FilterLeafReader {
    private final Terms filterTerms;

    TermVectorFilteredLeafReader(LeafReader baseLeafReader, Terms filterTerms) {
        super(baseLeafReader);
        this.filterTerms = filterTerms;
    }

    public Terms terms(String field) throws IOException {
        Terms terms = this.in.terms(field);
        return terms == null ? null : new TermsFilteredTerms(terms, this.filterTerms);
    }

    public IndexReader.CacheHelper getCoreCacheHelper() {
        return null;
    }

    public IndexReader.CacheHelper getReaderCacheHelper() {
        return null;
    }

    private static final class TermVectorFilteredTermsEnum
    extends FilterLeafReader.FilterTermsEnum {
        private final TermsEnum baseTermsEnum;

        TermVectorFilteredTermsEnum(TermsEnum baseTermsEnum, TermsEnum filteredTermsEnum) {
            super(filteredTermsEnum);
            this.baseTermsEnum = baseTermsEnum;
        }

        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
            this.moveToCurrentTerm();
            return this.baseTermsEnum.postings(reuse, flags);
        }

        void moveToCurrentTerm() throws IOException {
            BytesRef currentTerm = this.in.term();
            boolean termInBothTermsEnum = this.baseTermsEnum.seekExact(currentTerm);
            if (!termInBothTermsEnum) {
                throw new IllegalStateException("Term vector term " + currentTerm + " does not appear in full index.");
            }
        }
    }

    private static final class TermsFilteredTerms
    extends FilterLeafReader.FilterTerms {
        private final Terms filterTerms;

        TermsFilteredTerms(Terms baseTerms, Terms filterTerms) {
            super(baseTerms);
            this.filterTerms = filterTerms;
        }

        public TermsEnum iterator() throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.iterator());
        }

        public TermsEnum intersect(CompiledAutomaton compiled, BytesRef startTerm) throws IOException {
            return new TermVectorFilteredTermsEnum(this.in.iterator(), this.filterTerms.intersect(compiled, startTerm));
        }
    }
}

