/*
 * Decompiled with CFR 0.152.
 */
package esmska.data;

import esmska.data.event.ActionEventSupport;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class History {
    private static final History instance = new History();
    public static final int ACTION_ADD_RECORD = 0;
    public static final int ACTION_REMOVE_RECORD = 1;
    public static final int ACTION_CLEAR_RECORDS = 2;
    private static final Logger logger = Logger.getLogger(History.class.getName());
    private final List<Record> records = Collections.synchronizedList(new ArrayList());
    private ActionEventSupport actionSupport = new ActionEventSupport(this);

    public void addActionListener(ActionListener actionListener) {
        this.actionSupport.addActionListener(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionSupport.removeActionListener(actionListener);
    }

    private History() {
    }

    public static History getInstance() {
        return instance;
    }

    public List<Record> getRecords() {
        return Collections.unmodifiableList(this.records);
    }

    public Record getRecord(int index) {
        return this.records.get(index);
    }

    public void addRecord(Record record) {
        this.records.add(record);
        this.actionSupport.fireActionPerformed(0, null);
        logger.finer("New history record added: " + record);
    }

    public void addRecords(Collection<Record> records) {
        for (Record record : records) {
            this.records.add(record);
        }
        logger.finer(records.size() + " new history records added");
        this.actionSupport.fireActionPerformed(0, null);
    }

    public void removeRecord(Record record) {
        this.records.remove(record);
        this.actionSupport.fireActionPerformed(1, null);
        logger.finer("A history record removed: " + record);
    }

    public void removeRecords(Collection<Record> records) {
        for (Record record : records) {
            this.records.remove(record);
        }
        logger.finer(records.size() + " history records removed");
        this.actionSupport.fireActionPerformed(1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRecordsOlderThan(Date date) {
        Validate.notNull(date);
        logger.fine("Erasing all history records older than: " + date);
        List<Record> list = this.records;
        synchronized (list) {
            Record record;
            ListIterator<Record> iter = this.records.listIterator();
            while (iter.hasNext() && (record = iter.next()).getDate().before(date)) {
                iter.remove();
            }
        }
    }

    public void clearRecords() {
        this.records.clear();
        this.actionSupport.fireActionPerformed(2, null);
        logger.finer("All history records removed");
    }

    public synchronized Record findLastRecord(String gatewayName) {
        ListIterator<Record> iter = this.records.listIterator(this.records.size());
        while (iter.hasPrevious()) {
            Record record = iter.previous();
            if (!ObjectUtils.equals(record.getGateway(), gatewayName)) continue;
            return record;
        }
        return null;
    }

    public static class Record {
        private String number;
        private String name;
        private String text;
        private String senderNumber;
        private String senderName;
        private String gateway;
        private Date date;
        private String smsId;

        public Record(String number, String text, String gateway, String name, String senderNumber, String senderName, Date date, String smsId) {
            this.setName(name);
            this.setNumber(number);
            this.setText(text);
            this.setSenderNumber(senderNumber);
            this.setSenderName(senderName);
            this.setGateway(gateway);
            this.setDate(date);
            this.setSmsId(smsId);
        }

        public String getNumber() {
            return this.number;
        }

        public String getName() {
            return this.name;
        }

        public String getText() {
            return this.text;
        }

        public String getSenderNumber() {
            return this.senderNumber;
        }

        public String getSenderName() {
            return this.senderName;
        }

        public String getGateway() {
            return this.gateway;
        }

        public String getSmsId() {
            return this.smsId;
        }

        public Date getDate() {
            return this.date;
        }

        public void setNumber(String number) {
            Validate.notEmpty(number);
            if (!number.startsWith("+")) {
                throw new IllegalArgumentException("Number does not start with '+': " + number);
            }
            this.number = number;
        }

        public void setName(String name) {
            this.name = StringUtils.defaultString(name);
        }

        public void setText(String text) {
            Validate.notNull(text);
            this.text = text;
        }

        public void setSenderNumber(String senderNumber) {
            this.senderNumber = StringUtils.defaultString(senderNumber);
        }

        public void setSenderName(String senderName) {
            this.senderName = StringUtils.defaultString(senderName);
        }

        public void setGateway(String gateway) {
            Validate.notEmpty(gateway);
            this.gateway = gateway;
        }

        public void setSmsId(String smsId) {
            this.smsId = smsId;
        }

        public void setDate(Date date) {
            if (date == null) {
                date = new Date();
            }
            this.date = date;
        }

        public String toString() {
            return "[date=" + this.date + ", name=" + this.name + "]";
        }
    }
}

