/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Disaster;
import net.sf.freecol.common.model.FreeColGameObjectType;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.ProductionType;
import net.sf.freecol.common.model.ResourceType;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.RandomChoice;

public final class TileType
extends FreeColGameObjectType {
    public static final TileType WATER = new TileType("WATER", true);
    public static final TileType LAND = new TileType("LAND", false);
    private boolean forest;
    private boolean water;
    private boolean canSettle;
    private boolean connected;
    private boolean elevation;
    private int basicMoveCost;
    private int basicWorkTurns;
    private final int[] humidity = new int[2];
    private final int[] temperature = new int[2];
    private final int[] altitude = new int[2];
    private List<RandomChoice<ResourceType>> resourceTypes = null;
    private List<RandomChoice<Disaster>> disasters = null;
    private final List<ProductionType> productionTypes = new ArrayList<ProductionType>();
    private static final String ALTITUDE_MIN_TAG = "altitude-minimum";
    private static final String ALTITUDE_MAX_TAG = "altitude-maximum";
    private static final String BASIC_MOVE_COST_TAG = "basic-move-cost";
    private static final String BASIC_WORK_TURNS_TAG = "basic-work-turns";
    private static final String CAN_SETTLE_TAG = "can-settle";
    private static final String DISASTER_TAG = "disaster";
    private static final String GEN_TAG = "gen";
    private static final String GOODS_TYPE_TAG = "goods-type";
    private static final String HUMIDITY_MIN_TAG = "humidity-minimum";
    private static final String HUMIDITY_MAX_TAG = "humidity-maximum";
    private static final String IS_CONNECTED_TAG = "is-connected";
    private static final String IS_ELEVATION_TAG = "is-elevation";
    private static final String IS_FOREST_TAG = "is-forest";
    private static final String IS_WATER_TAG = "is-water";
    private static final String PROBABILITY_TAG = "probability";
    private static final String PRODUCTION_TAG = "production";
    private static final String RESOURCE_TAG = "resource";
    private static final String TEMPERATURE_MIN_TAG = "temperature-minimum";
    private static final String TEMPERATURE_MAX_TAG = "temperature-maximum";
    private static final String TYPE_TAG = "type";
    private static final String PRIMARY_PRODUCTION_TAG = "primary-production";
    private static final String SECONDARY_PRODUCTION_TAG = "secondary-production";
    private static final String TILE_PRODUCTION_TAG = "tile-production";
    private static final String OLD_ALTITUDE_MIN_TAG = "altitudeMin";
    private static final String OLD_ALTITUDE_MAX_TAG = "altitudeMax";
    private static final String OLD_HUMIDITY_MIN_TAG = "humidityMin";
    private static final String OLD_HUMIDITY_MAX_TAG = "humidityMax";
    private static final String OLD_TEMPERATURE_MIN_TAG = "temperatureMin";
    private static final String OLD_TEMPERATURE_MAX_TAG = "temperatureMax";

    public TileType(String id, Specification specification) {
        super(id, specification);
    }

    private TileType(String id, boolean water) {
        super(id, null);
        this.water = water;
    }

    public boolean isForested() {
        return this.forest;
    }

    public boolean isWater() {
        return this.water;
    }

    public boolean canSettle() {
        return this.canSettle;
    }

    public boolean isHighSeasConnected() {
        return this.connected;
    }

    public boolean isDirectlyHighSeasConnected() {
        return this.hasAbility("model.ability.moveToEurope");
    }

    public boolean isElevation() {
        return this.elevation;
    }

    public int getBasicMoveCost() {
        return this.basicMoveCost;
    }

    public int getBasicWorkTurns() {
        return this.basicWorkTurns;
    }

    public boolean withinRange(RangeType rangeType, int value) {
        switch (rangeType) {
            case HUMIDITY: {
                return this.humidity[0] <= value && value <= this.humidity[1];
            }
            case TEMPERATURE: {
                return this.temperature[0] <= value && value <= this.temperature[1];
            }
            case ALTITUDE: {
                return this.altitude[0] <= value && value <= this.altitude[1];
            }
        }
        return false;
    }

    public List<RandomChoice<ResourceType>> getWeightedResources() {
        return this.resourceTypes == null ? Collections.emptyList() : this.resourceTypes;
    }

    public List<ResourceType> getResourceTypes() {
        ArrayList<ResourceType> result = new ArrayList<ResourceType>();
        if (this.resourceTypes != null) {
            for (RandomChoice<ResourceType> resource : this.resourceTypes) {
                result.add(resource.getObject());
            }
        }
        return result;
    }

    private void addResourceType(ResourceType type, int prob) {
        if (this.resourceTypes == null) {
            this.resourceTypes = new ArrayList<RandomChoice<ResourceType>>();
        }
        this.resourceTypes.add(new RandomChoice<ResourceType>(type, prob));
    }

    public boolean canHaveResourceType(ResourceType resourceType) {
        return this.getResourceTypes().contains(resourceType);
    }

    public List<RandomChoice<Disaster>> getDisasters() {
        return this.disasters == null ? Collections.emptyList() : this.disasters;
    }

    private void addDisaster(Disaster disaster, int probability) {
        if (this.disasters == null) {
            this.disasters = new ArrayList<RandomChoice<Disaster>>();
        }
        this.disasters.add(new RandomChoice<Disaster>(disaster, probability));
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended) {
        return this.getAvailableProductionTypes(unattended, this.getSpecification().getString("model.option.tileProduction"));
    }

    public List<ProductionType> getAvailableProductionTypes(boolean unattended, String level) {
        ArrayList<ProductionType> good = new ArrayList<ProductionType>();
        ArrayList<ProductionType> better = new ArrayList<ProductionType>();
        for (ProductionType productionType : this.productionTypes) {
            if (productionType.getUnattended() != unattended) continue;
            if (productionType.appliesExactly(level)) {
                better.add(productionType);
                continue;
            }
            if (!productionType.appliesTo(level)) continue;
            good.add(productionType);
        }
        return !better.isEmpty() ? better : good;
    }

    public boolean canProduce(GoodsType goodsType, UnitType unitType) {
        return goodsType != null && ProductionType.canProduce(goodsType, this.getAvailableProductionTypes(unitType == null));
    }

    public int getBaseProduction(ProductionType productionType, GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return 0;
        }
        if (productionType == null) {
            productionType = ProductionType.getBestProductionType(goodsType, this.getAvailableProductionTypes(unitType == null));
        }
        if (productionType == null) {
            return 0;
        }
        AbstractGoods best = productionType.getOutput(goodsType);
        return best == null ? 0 : best.getAmount();
    }

    public int getPotentialProduction(GoodsType goodsType, UnitType unitType) {
        if (goodsType == null) {
            return 0;
        }
        int amount = this.getBaseProduction(null, goodsType, unitType);
        return (amount = (int)this.applyModifiers(amount, null, goodsType.getId(), unitType)) < 0 ? 0 : amount;
    }

    public List<AbstractGoods> getPossibleProduction(boolean unattended) {
        ArrayList<AbstractGoods> production = new ArrayList<AbstractGoods>();
        for (ProductionType pt : this.getAvailableProductionTypes(unattended)) {
            List<AbstractGoods> outputs = pt.getOutputs();
            if (outputs.isEmpty()) continue;
            production.addAll(outputs);
        }
        return production;
    }

    @Override
    public int getIndex() {
        return super.getIndex();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute(BASIC_MOVE_COST_TAG, this.basicMoveCost);
        xw.writeAttribute(BASIC_WORK_TURNS_TAG, this.basicWorkTurns);
        xw.writeAttribute(IS_FOREST_TAG, this.forest);
        xw.writeAttribute(IS_WATER_TAG, this.water);
        xw.writeAttribute(IS_ELEVATION_TAG, this.elevation);
        xw.writeAttribute(IS_CONNECTED_TAG, this.connected);
        xw.writeAttribute(CAN_SETTLE_TAG, this.canSettle);
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeChildren(xw);
        xw.writeStartElement(GEN_TAG);
        xw.writeAttribute(HUMIDITY_MIN_TAG, this.humidity[0]);
        xw.writeAttribute(HUMIDITY_MAX_TAG, this.humidity[1]);
        xw.writeAttribute(TEMPERATURE_MIN_TAG, this.temperature[0]);
        xw.writeAttribute(TEMPERATURE_MAX_TAG, this.temperature[1]);
        xw.writeAttribute(ALTITUDE_MIN_TAG, this.altitude[0]);
        xw.writeAttribute(ALTITUDE_MAX_TAG, this.altitude[1]);
        xw.writeEndElement();
        for (ProductionType productionType : this.productionTypes) {
            productionType.toXML(xw);
        }
        for (RandomChoice randomChoice : this.getWeightedResources()) {
            xw.writeStartElement(RESOURCE_TAG);
            xw.writeAttribute(TYPE_TAG, (FreeColObject)randomChoice.getObject());
            xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
            xw.writeEndElement();
        }
        for (RandomChoice randomChoice : this.getDisasters()) {
            xw.writeStartElement(DISASTER_TAG);
            xw.writeAttribute("id", (FreeColObject)randomChoice.getObject());
            xw.writeAttribute(PROBABILITY_TAG, randomChoice.getProbability());
            xw.writeEndElement();
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.basicMoveCost = xr.getAttribute(BASIC_MOVE_COST_TAG, 1);
        this.basicWorkTurns = xr.getAttribute(BASIC_WORK_TURNS_TAG, 1);
        this.forest = xr.getAttribute(IS_FOREST_TAG, false);
        this.water = xr.getAttribute(IS_WATER_TAG, false);
        this.elevation = xr.getAttribute(IS_ELEVATION_TAG, false);
        this.canSettle = xr.getAttribute(CAN_SETTLE_TAG, !this.water);
        this.connected = xr.getAttribute(IS_CONNECTED_TAG, false);
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (xr.shouldClearContainers()) {
            this.disasters = null;
            this.resourceTypes = null;
            this.productionTypes.clear();
        }
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Specification spec = this.getSpecification();
        String tag = xr.getLocalName();
        if (DISASTER_TAG.equals(tag)) {
            Disaster d = xr.getType(spec, "id", Disaster.class, null);
            if (d != null) {
                this.addDisaster(d, xr.getAttribute(PROBABILITY_TAG, 100));
            }
            xr.closeTag(DISASTER_TAG);
        } else if (GEN_TAG.equals(tag)) {
            this.humidity[0] = xr.getAttribute(HUMIDITY_MIN_TAG, 0);
            this.humidity[1] = xr.getAttribute(HUMIDITY_MAX_TAG, 100);
            this.temperature[0] = xr.getAttribute(TEMPERATURE_MIN_TAG, -20);
            this.temperature[1] = xr.getAttribute(TEMPERATURE_MAX_TAG, 40);
            this.altitude[0] = xr.getAttribute(ALTITUDE_MIN_TAG, 0);
            this.altitude[1] = xr.getAttribute(ALTITUDE_MAX_TAG, 0);
            if (xr.hasAttribute(OLD_HUMIDITY_MIN_TAG)) {
                this.humidity[0] = xr.getAttribute(OLD_HUMIDITY_MIN_TAG, 0);
            }
            if (xr.hasAttribute(OLD_HUMIDITY_MAX_TAG)) {
                this.humidity[1] = xr.getAttribute(OLD_HUMIDITY_MAX_TAG, 100);
            }
            if (xr.hasAttribute(OLD_TEMPERATURE_MIN_TAG)) {
                this.temperature[0] = xr.getAttribute(OLD_TEMPERATURE_MIN_TAG, -20);
            }
            if (xr.hasAttribute(OLD_TEMPERATURE_MAX_TAG)) {
                this.temperature[1] = xr.getAttribute(OLD_TEMPERATURE_MAX_TAG, 40);
            }
            if (xr.hasAttribute(OLD_ALTITUDE_MIN_TAG)) {
                this.altitude[0] = xr.getAttribute(OLD_ALTITUDE_MIN_TAG, 0);
            }
            if (xr.hasAttribute(OLD_ALTITUDE_MAX_TAG)) {
                this.altitude[1] = xr.getAttribute(OLD_ALTITUDE_MAX_TAG, 0);
            }
            xr.closeTag(GEN_TAG);
        } else if (PRODUCTION_TAG.equals(tag) && xr.getAttribute("delete", false)) {
            this.productionTypes.clear();
            xr.closeTag(PRODUCTION_TAG);
        } else if (PRODUCTION_TAG.equals(tag) && xr.getAttribute(GOODS_TYPE_TAG, null) == null) {
            this.productionTypes.add(new ProductionType(xr, spec));
        } else if (PRODUCTION_TAG.equals(tag) || PRIMARY_PRODUCTION_TAG.equals(tag) || SECONDARY_PRODUCTION_TAG.equals(tag)) {
            GoodsType type = xr.getType(spec, GOODS_TYPE_TAG, GoodsType.class, null);
            int amount = xr.getAttribute("value", 0);
            AbstractGoods goods = new AbstractGoods(type, amount);
            String tileProduction = xr.getAttribute(TILE_PRODUCTION_TAG, null);
            if (PRIMARY_PRODUCTION_TAG.equals(tag)) {
                this.productionTypes.add(new ProductionType(goods, true, tileProduction));
            } else if (SECONDARY_PRODUCTION_TAG.equals(tag)) {
                String level = spec.getDifficultyLevel();
                List<ProductionType> unattendedTypes = this.getAvailableProductionTypes(true, level);
                for (ProductionType productionType : unattendedTypes) {
                    if (tileProduction != null && !tileProduction.equals(productionType.getProductionLevel())) continue;
                    productionType.getOutputs().add(goods);
                }
            } else {
                this.productionTypes.add(new ProductionType(goods, false, tileProduction));
            }
            xr.closeTag(tag);
        } else if (RESOURCE_TAG.equals(tag)) {
            this.addResourceType(xr.getType(spec, TYPE_TAG, ResourceType.class, null), xr.getAttribute(PROBABILITY_TAG, 100));
            xr.closeTag(RESOURCE_TAG);
        } else if (Modifier.getXMLElementTagName().equals(tag)) {
            String id = xr.getAttribute("id", null);
            if (id.startsWith("model.goods.")) {
                xr.closeTag(Modifier.getXMLElementTagName());
            } else {
                super.readChild(xr);
            }
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TileType.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "tile-type";
    }

    public static enum RangeType {
        HUMIDITY,
        TEMPERATURE,
        ALTITUDE;

    }
}

