/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.browsemode;

import freemind.controller.MenuItemEnabledListener;
import freemind.controller.StructuredMenuHolder;
import freemind.extensions.HookFactory;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.main.XMLParseException;
import freemind.modes.MapAdapter;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.browsemode.BrowseArrowLinkModel;
import freemind.modes.browsemode.BrowseHookFactory;
import freemind.modes.browsemode.BrowseMapModel;
import freemind.modes.browsemode.BrowseNodeModel;
import freemind.modes.browsemode.BrowsePopupMenu;
import freemind.modes.browsemode.BrowseToolBar;
import freemind.modes.browsemode.BrowseXMLElement;
import freemind.modes.browsemode.NodeNoteViewer;
import freemind.modes.common.GotoLinkNodeAction;
import freemind.modes.common.plugins.MapNodePositionHolderBase;
import freemind.modes.viewmodes.ViewControllerAdapter;
import freemind.view.mindmapview.MainView;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;

public class BrowseController
extends ViewControllerAdapter {
    private JPopupMenu popupmenu;
    private JToolBar toolbar;
    Action followLink;
    Action nodeUp;
    Action nodeDown;
    private HookFactory mBrowseHookFactory = new BrowseHookFactory();
    private ImageIcon noteIcon;
    public FollowMapLink followMapLink;

    public BrowseController(Mode mode) {
        super(mode);
        this.followLink = new FollowLinkAction();
        this.followMapLink = new FollowMapLink(this);
        this.popupmenu = new BrowsePopupMenu(this);
        this.toolbar = new BrowseToolBar(this);
        this.setAllActions(false);
        this.registerNodeSelectionListener(new NodeNoteViewer(this), false);
    }

    @Override
    public void startupController() {
        super.startupController();
        this.invokeHooksRecursively((NodeAdapter)this.getRootNode(), this.getMap());
    }

    @Override
    protected void restoreMapsLastState(ModeController pNewModeController, MapAdapter pModel) {
    }

    @Override
    public MapAdapter newModel(ModeController modeController) {
        return new BrowseMapModel(this.getFrame(), modeController);
    }

    @Override
    public void plainClick(MouseEvent e) {
        if (this.getSelecteds().size() != 1) {
            return;
        }
        MainView component = (MainView)e.getComponent();
        if (component.isInFollowLinkRegion(e.getX())) {
            this.loadURL();
        } else {
            MindMapNode node = component.getNodeView().getModel();
            if (!node.hasChildren()) {
                this.doubleClick(e);
                return;
            }
            this.toggleFolded.toggleFolded(this.getSelecteds().listIterator());
        }
    }

    public void doubleClick() {
        if (this.getSelected().getLink() == null) {
            this.toggleFolded.toggleFolded();
        } else {
            this.loadURL();
        }
    }

    @Override
    public MindMapNode newNode(Object userObject, MindMap map) {
        return new BrowseNodeModel(userObject, this.getFrame(), map);
    }

    @Override
    public JPopupMenu getPopupMenu() {
        return this.popupmenu;
    }

    @Override
    public JPopupMenu getPopupForModel(Object obj) {
        if (obj instanceof BrowseArrowLinkModel) {
            BrowseArrowLinkModel link = (BrowseArrowLinkModel)obj;
            JPopupMenu arrowLinkPopup = new JPopupMenu();
            arrowLinkPopup.add(this.getGotoLinkNodeAction(link.getSource()));
            arrowLinkPopup.add(this.getGotoLinkNodeAction(link.getTarget()));
            arrowLinkPopup.addSeparator();
            HashSet<MindMapNode> nodeAlreadyVisited = new HashSet<MindMapNode>();
            nodeAlreadyVisited.add(link.getSource());
            nodeAlreadyVisited.add(link.getTarget());
            Vector links = this.getModel().getLinkRegistry().getAllLinks(link.getSource());
            links.addAll(this.getModel().getLinkRegistry().getAllLinks(link.getTarget()));
            for (int i = 0; i < links.size(); ++i) {
                BrowseArrowLinkModel foreign_link = (BrowseArrowLinkModel)links.get(i);
                if (nodeAlreadyVisited.add(foreign_link.getTarget())) {
                    arrowLinkPopup.add(this.getGotoLinkNodeAction(foreign_link.getTarget()));
                }
                if (!nodeAlreadyVisited.add(foreign_link.getSource())) continue;
                arrowLinkPopup.add(this.getGotoLinkNodeAction(foreign_link.getSource()));
            }
            return arrowLinkPopup;
        }
        return null;
    }

    private GotoLinkNodeAction getGotoLinkNodeAction(MindMapNode destination) {
        return new GotoLinkNodeAction(this, destination);
    }

    @Override
    public JToolBar getModeToolBar() {
        return this.getToolBar();
    }

    BrowseToolBar getToolBar() {
        return (BrowseToolBar)this.toolbar;
    }

    @Override
    public ModeController load(URL url) throws IOException, XMLParseException, URISyntaxException {
        ModeController newModeController = super.load(url);
        ((BrowseToolBar)newModeController.getModeToolBar()).setURLField(url.toString());
        return newModeController;
    }

    @Override
    public ModeController load(File url) throws IOException {
        ModeController newModeController = super.load(url);
        ((BrowseToolBar)newModeController.getModeToolBar()).setURLField(Tools.fileToUrl(url).toString());
        return newModeController;
    }

    @Override
    public void newMap(MindMap mapModel) {
        this.setNoteIcon(mapModel.getRootNode());
        super.newMap(mapModel);
    }

    private void setNoteIcon(MindMapNode node) {
        String noteText = node.getNoteText();
        if (noteText != null && !noteText.equals("")) {
            if (this.noteIcon == null) {
                this.noteIcon = new ImageIcon(this.getController().getResource("images/knotes.png"));
            }
            node.setStateIcon("accessories.plugins.NodeNoteIcon", this.noteIcon);
        }
        ListIterator children = node.childrenUnfolded();
        while (children.hasNext()) {
            this.setNoteIcon((MindMapNode)children.next());
        }
    }

    @Override
    protected void setAllActions(boolean enabled) {
        super.setAllActions(enabled);
        this.toggleFolded.setEnabled(enabled);
        this.toggleChildrenFolded.setEnabled(enabled);
        this.followLink.setEnabled(enabled);
    }

    @Override
    public void updateMenus(StructuredMenuHolder holder) {
        this.add(holder, "menu_bar/edit//find/find", this.find, "keystroke_find");
        this.add(holder, "menu_bar/edit//find/findNext", this.findNext, "keystroke_find_next");
        this.add(holder, "menu_bar/edit//find/followLink", this.followLink, "keystroke_follow_link");
        holder.addSeparator("menu_bar/edit//find");
        this.add(holder, "menu_bar/edit//find/toggleFolded", this.toggleFolded, "keystroke_toggle_folded");
        this.add(holder, "menu_bar/edit//find/toggleChildrenFolded", this.toggleChildrenFolded, "keystroke_toggle_children_folded");
    }

    @Override
    public HookFactory getHookFactory() {
        return this.mBrowseHookFactory;
    }

    @Override
    public XMLElement createXMLElement() {
        return new BrowseXMLElement(this);
    }

    private class FollowLinkAction
    extends AbstractAction {
        FollowLinkAction() {
            super(BrowseController.this.getText("follow_link"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BrowseController.this.loadURL();
        }
    }

    public static class FollowMapLink
    extends AbstractAction
    implements MenuItemEnabledListener {
        private ViewControllerAdapter modeController;
        private Logger logger;

        public FollowMapLink(ViewControllerAdapter controller) {
            super(controller.getText("follow_map_link"), MapNodePositionHolderBase.getMapLocationIcon());
            this.modeController = controller;
            this.logger = this.modeController.getFrame().getLogger(this.getClass().getName());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MapNodePositionHolderBase hook = this.getHook();
            if (hook != null) {
                String[] barePositions = hook.getBarePosition();
                try {
                    HashMap<String, String> tileSources = new HashMap<String, String>();
                    tileSources.put("org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource$Mapnik", "M");
                    tileSources.put("org.openstreetmap.gui.jmapviewer.tilesources.OsmTileSource$CycleMap", "C");
                    tileSources.put("plugins.map.FreeMindMapController.TransportMap", "T");
                    tileSources.put("plugins.map.FreeMindMapController.MapQuestOpenMap", "Q");
                    String link = "http://www.openstreetmap.org/?mlat=" + barePositions[0] + "&mlon=" + barePositions[1] + "&lat=" + barePositions[2] + "&lon=" + barePositions[3] + "&zoom=" + barePositions[4] + "&layers=" + tileSources.get(barePositions[5]);
                    this.logger.fine("Try to open link " + link);
                    this.modeController.getFrame().openDocument(new URL(link));
                }
                catch (MalformedURLException e1) {
                    Resources.getInstance().logException(e1);
                }
                catch (Exception e1) {
                    Resources.getInstance().logException(e1);
                }
            }
        }

        protected MapNodePositionHolderBase getHook() {
            MindMapNode selected = this.modeController.getSelected();
            MapNodePositionHolderBase hook = MapNodePositionHolderBase.getBaseHook(selected);
            return hook;
        }

        @Override
        public boolean isEnabled(JMenuItem pItem, Action pAction) {
            return this.getHook() != null;
        }
    }
}

