#############################################################################
##
#W  extreme/cong.tst
#Y  Copyright (C) 2014-15                                   Michael Torpey
##                                                          Wilf A. Wilson
##
##  Licensing information can be found in the README file of this package.
##
#############################################################################
##
gap> START_TEST("Semigroups package: extreme/cong.tst");
gap> LoadPackage("semigroups", false);;

# Set info levels and user preferences
gap> SEMIGROUPS.StartTest();

#T# PairsCongTest1
gap> s := Semigroup([Transformation([1, 3, 4, 1, 3, 5]),
>    Transformation([2, 4, 6, 1, 6, 5]),
>    Transformation([4, 1, 2, 6, 2, 1]),
>    Transformation([4, 6, 4, 3, 3, 3]),
>    Transformation([5, 1, 6, 1, 6, 3]),
>    Transformation([5, 2, 5, 3, 5, 3])]);;
gap> gens := [
>  [Transformation([5, 5, 2, 4, 2, 4]),
>    Transformation([1, 5, 4, 5, 4, 5])],
>  [Transformation([3, 3, 3, 6, 3, 3]),
>    Transformation([1, 6, 6, 6, 6, 1])]];;
gap> cong := SemigroupCongruence(s, gens);
<semigroup congruence over <transformation semigroup of degree 6 with 6 
 generators> with 2 generating pairs>
gap> gens[2] in cong;
true
gap> x := Transformation([6, 5, 4, 4, 4, 6]);;
gap> y := Transformation([2, 2, 2, 6, 2, 4]);;
gap> z := Transformation([2, 4, 6, 1, 6, 5]);;
gap> [x, y] in cong; [x, z] in cong; [y, z] in cong;
true
false
false
gap> [x, y, z] in cong;
Error, Semigroups: \in (for a relation): usage,
the first arg <pair> must be a list of length 2,
gap> [x, Transformation([1])] in cong;
Error, Semigroups: \in (for a relation): usage,
elements of the first arg <pair> must be
in the range of the second arg <cong>,
gap> classes := CongruenceClasses(cong);;
gap> Size(classes) = NrCongruenceClasses(cong);
true
gap> classx := CongruenceClassOfElement(cong, x);;
gap> classy := CongruenceClassOfElement(cong, y);;
gap> classz := CongruenceClassOfElement(cong, z);
<congruence class of Transformation( [ 2, 4, 6, 1, 6, 5 ] )>
gap> classx = classy;
true
gap> classz = classx;
false
gap> x in classx;
true
gap> y in classx;
true
gap> x in classz;
false
gap> classx = classes[4];
true
gap> classz = classes[2];
true
gap> z * y in classz * classy;
true
gap> y * z in classx * classz;
true
gap> Size(classx);
3084
gap> q := s / cong;;
gap> P := [[(), 0, (1, 3), (1, 3), 0, (), 0],
>   [(), (1, 3), 0, 0, (1, 3), (), 0], [(), (1, 3), 0, (), 0, 0, ()],
>   [0, (), (1, 3), (1, 3), (), 0, 0], [0, 0, 0, (), (), (1, 3), ()],
>   [(), 0, (1, 3), 0, (), 0, ()]];;
gap> R := ReesZeroMatrixSemigroup(Group([(1, 3)]), P);;
gap> x := ReesZeroMatrixSemigroupElement(R, 1, (1, 3), 1);;
gap> y := ReesZeroMatrixSemigroupElement(R, 1, (), 1);;
gap> cong := SemigroupCongruenceByGeneratingPairs(R, [[x, y]]);;
gap> c := EquivalenceClasses(cong);;
gap> Size(c) = 43;
true
gap> cong := SemigroupCongruenceByGeneratingPairs(R, []);;
gap> c := EquivalenceClasses(cong);;
gap> Size(c) = 85;
true

#T# PairsCongTest3: \= for two semigroup congruences
gap> gens := [Transformation([2, 6, 7, 2, 6, 9, 9, 1, 1, 5])];;
gap> s := Semigroup(Transformation([1]));;
gap> t := Monoid(gens);;
gap> u := UniversalSemigroupCongruence(s);
<universal semigroup congruence over <trivial transformation group of 
 degree 0 with 1 generator>>
gap> v := SemigroupCongruence(t, [gens[1], gens[1]]);
<semigroup congruence over <commutative non-regular transformation monoid of 
 degree 10 with 1 generator> with 0 generating pairs>
gap> NrCongruenceClasses(v);
6
gap> Size(t);
6
gap> u = v;
false
gap> u := UniversalSemigroupCongruence(t);
<universal semigroup congruence over <commutative non-regular transformation 
 monoid of size 6, degree 10 with 1 generator>>
gap> u = v;
false
gap> gens := List(t, x -> [gens[1], x]);;
gap> v := SemigroupCongruence(t, gens);
<semigroup congruence over <commutative non-regular transformation monoid 
 of size 6, degree 10 with 1 generator> with 5 generating pairs>
gap> u = v;
true
gap> NrCongruenceClasses(u);
1

#T# PairsCongTest4: \* for two semigroups congruence classes
gap> gens := [Transformation([2, 6, 7, 2, 6, 9, 9, 1, 1, 5])];;
gap> s := Semigroup(gens);;
gap> gens := List(s, x -> [gens[1], x]);;
gap> u := SemigroupCongruence(s, gens); # universal congruence
<semigroup congruence over <commutative non-regular transformation semigroup 
 of degree 10 with 1 generator> with 4 generating pairs>
gap> u = UniversalSemigroupCongruence(s);
true
gap> v := SemigroupCongruence(s, [gens[1], gens[1]]); # trivial congruence
<semigroup congruence over <commutative non-regular transformation semigroup 
 of degree 10 with 1 generator> with 0 generating pairs>
gap> classes := Set(CongruenceClasses(v));
[ <congruence class of Transformation( [ 1, 2, 2, 1, 2, 6, 6, 9, 9, 1 ] )>, 
  <congruence class of Transformation( [ 2, 6, 6, 2, 6, 9, 9, 1, 1, 2 ] )>, 
  <congruence class of Transformation( [ 2, 6, 7, 2, 6, 9, 9, 1, 1, 5 ] )>, 
  <congruence class of Transformation( [ 6, 9, 9, 6, 9, 1, 1, 2, 2, 6 ] )>, 
  <congruence class of Transformation( [ 9, 1, 1, 9, 1, 2, 2, 6, 6, 9 ] )> ]
gap> ForAny(CongruenceClasses(u), x -> x in classes);
false
gap> classes[1] * CongruenceClasses(u)[1];
Error, Semigroups: \*: usage,
the args must be classes of the same congruence,
gap> CongruenceClasses(u)[1] * classes[1];
Error, Semigroups: \*: usage,
the args must be classes of the same congruence,
gap> classes[3] * classes[4];
<congruence class of Transformation( [ 9, 1, 1, 9, 1, 2, 2, 6, 6, 9 ] )>
gap> classes[4] * classes[3];
<congruence class of Transformation( [ 9, 1, 1, 9, 1, 2, 2, 6, 6, 9 ] )>
gap> Representative(classes[5] * classes[2]) =
> Representative(classes[5]) * Representative(classes[2]);
true

#T# LatticeOfCongruences
gap> S := Semigroup([
> Transformation([1, 3, 4, 1]), Transformation([3, 1, 1, 3])]);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 7, 28, 39 ], 
  [ 1, 2, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 
      28, 29, 30, 34, 35, 36, 37, 38, 39, 40, 41, 42, 47, 48, 49, 50, 51, 52 ]
    , [ 1, 2, 5, 7, 8, 9, 10, 20, 21, 22, 23, 24, 26, 27, 28, 30, 36, 37, 39, 
      45 ], [ 1, 7, 8, 21, 22, 24, 26, 27, 28, 36, 37, 39 ], 
  [ 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
      22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ], [ 1 ], 
  [ 1, 7, 21, 22, 24, 26, 27, 28, 36, 37, 39 ], 
  [ 1, 2, 7, 8, 21, 22, 23, 24, 26, 27, 28, 30, 36, 37, 39 ], 
  [ 1, 2, 7, 28, 39 ], [ 1, 13, 16, 21, 24, 26, 48, 49, 50 ], 
  [ 1, 2, 7, 13, 16, 18, 22, 23, 24, 25, 26, 27, 28, 35, 37, 38, 39, 50 ], 
  [ 1, 16, 24, 26, 50 ], 
  [ 1, 5, 7, 8, 13, 16, 18, 19, 21, 22, 24, 25, 26, 27, 28, 33, 35, 36, 37, 
      38, 39, 41, 48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 8, 9, 12, 13, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 28, 30, 
      35, 36, 37, 38, 39, 41, 47, 48, 49, 50, 51, 52 ], [ 1, 26 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 12, 13, 14, 15, 16, 18, 19, 20, 21, 22, 23, 24, 
      25, 26, 27, 28, 30, 33, 35, 36, 37, 38, 39, 41, 44, 45, 46, 47, 48, 49, 
      50, 51, 52 ], [ 1, 7, 16, 26, 27 ], 
  [ 1, 7, 8, 16, 18, 21, 22, 24, 25, 26, 27, 28, 36, 37, 38, 39, 49, 50, 51 ],
  [ 1, 2, 7, 10, 21, 22, 23, 24, 26, 27, 28, 30, 36, 37, 39, 45 ], 
  [ 1, 24, 26 ], [ 1, 26, 28 ], [ 1, 2, 7, 22, 24, 26, 27, 28, 37, 39 ], 
  [ 1, 26 ], [ 1, 16, 22, 26, 28 ], [ 1 ], [ 1, 7, 26 ], [ 1 ], 
  [ 1, 2, 7, 11, 12, 13, 16, 18, 21, 22, 23, 24, 25, 26, 27, 28, 30, 34, 35, 
      36, 37, 38, 39, 47, 48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 21, 22, 23, 24, 26, 27, 28, 36, 37, 39 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
      23, 24, 25, 26, 27, 28, 29, 30, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
      42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52 ], 
  [ 1, 5, 7, 8, 11, 13, 14, 16, 18, 19, 21, 22, 24, 25, 26, 27, 28, 33, 34, 
      35, 36, 37, 38, 39, 40, 41, 48, 49, 50, 51, 52 ], 
  [ 1, 5, 7, 8, 16, 18, 19, 21, 22, 24, 25, 26, 27, 28, 36, 37, 38, 39, 49, 
      50, 51 ], 
  [ 1, 7, 11, 13, 16, 18, 21, 22, 24, 25, 26, 27, 28, 35, 36, 37, 38, 39, 48, 
      49, 50, 51, 52 ], 
  [ 1, 7, 13, 16, 18, 22, 24, 25, 26, 27, 28, 37, 38, 39, 50 ], 
  [ 1, 7, 21, 22, 24, 26, 27, 28, 37, 39 ], [ 1, 7, 22, 24, 26, 27, 28, 39 ], 
  [ 1, 7, 16, 18, 22, 24, 25, 26, 27, 28, 37, 39, 50 ], [ 1, 7, 28 ], 
  [ 1, 7, 8, 11, 13, 16, 18, 19, 21, 22, 24, 25, 26, 27, 28, 34, 35, 36, 37, 
      38, 39, 41, 48, 49, 50, 51, 52 ], 
  [ 1, 7, 8, 13, 16, 18, 19, 21, 22, 24, 25, 26, 27, 28, 35, 36, 37, 38, 39, 
      48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 8, 9, 11, 12, 13, 15, 16, 18, 19, 21, 22, 23, 24, 25, 26, 27, 
      28, 29, 30, 34, 35, 36, 37, 38, 39, 40, 41, 47, 48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 10, 11, 12, 13, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 
      30, 34, 35, 36, 37, 38, 39, 44, 45, 46, 47, 48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 10, 12, 13, 16, 18, 22, 23, 24, 25, 26, 27, 28, 35, 37, 38, 39, 
      45, 50 ], [ 1, 2, 7, 10, 22, 23, 24, 26, 27, 28, 37, 39 ], 
  [ 1, 2, 7, 10, 12, 13, 16, 18, 20, 21, 22, 23, 24, 25, 26, 27, 28, 30, 35, 
      36, 37, 38, 39, 44, 45, 47, 48, 49, 50, 51, 52 ], 
  [ 1, 2, 7, 12, 13, 16, 18, 21, 22, 23, 24, 25, 26, 27, 28, 30, 35, 36, 37, 
      38, 39, 48, 49, 50, 51, 52 ], [ 1, 13, 16, 21, 24, 26, 49, 50 ], 
  [ 1, 16, 21, 24, 26, 50 ], [ 1, 16, 24, 26 ], 
  [ 1, 7, 16, 18, 21, 22, 24, 25, 26, 27, 28, 36, 37, 38, 39, 49, 50 ], 
  [ 1, 7, 13, 16, 18, 21, 22, 24, 25, 26, 27, 28, 35, 36, 37, 38, 39, 48, 49, 
      50, 51 ] ]
gap> S := Semigroup([
> Transformation([1, 4, 3, 1, 4, 2]), Transformation([1, 6, 6, 3, 6, 6])]);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1 ], [ 1, 2, 4 ], [ 1, 2 ], [ 1, 2, 3, 4 ] ]
gap> S := Semigroup([
> Transformation([4, 3, 1, 1, 6, 4]), Transformation([4, 3, 6, 4, 2, 3])]);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1 ], [ 1, 2, 4, 5, 8, 9, 10, 47, 48, 49, 52, 74, 77, 99, 115, 116 ],
  [ 1, 2, 8, 10 ], [ 1, 2, 49, 52 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 57, 58, 59, 73, 95, 
      97, 109, 110, 113 ], 
  [ 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 41, 
      42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 57, 58, 59, 67, 73, 74, 77, 
      78, 79, 82, 83, 87, 88, 89, 95, 97, 98, 99, 100, 101, 106, 109, 110, 
      113, 114, 115, 116, 120, 131, 132, 138, 139, 140, 144, 151, 152, 198, 
      199, 200, 201, 202, 203, 210, 237, 240, 252, 254, 271, 272, 274, 277, 
      278 ], [ 1, 2 ], [ 1, 2, 5, 8, 10, 48, 49, 52, 77, 99, 115, 116 ], 
  [ 1, 2, 8 ], 
  [ 1, 2, 4, 8, 10, 13, 14, 15, 17, 40, 41, 50, 57, 58, 95, 109, 110 ], 
  [ 1, 2, 5, 8, 13, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 78, 79, 
      83, 99, 131, 132, 144, 151, 152, 210 ], 
  [ 1, 2, 8, 15, 17, 40, 41, 50, 58 ], [ 1, 17, 41, 50 ], 
  [ 1, 2, 8, 17, 40, 41, 50, 58 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 17, 39, 40, 41, 42, 43, 44, 
      46, 47, 48, 49, 50, 51, 52, 57, 58, 74, 77, 78, 79, 83, 95, 98, 99, 
      100, 101, 109, 110, 114, 115, 116, 120, 131, 132, 138, 139, 140, 144, 
      151, 152, 210, 252, 271, 272, 274 ], [ 1, 41, 50 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 
      22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 
      50, 51, 52, 55, 56, 57, 58, 59, 60, 61, 62, 63, 67, 68, 71, 72, 73, 74, 
      76, 77, 78, 79, 80, 81, 82, 83, 85, 87, 88, 89, 92, 94, 95, 97, 98, 99, 
      100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111, 112, 113, 114, 
      115, 116, 117, 119, 120, 123, 124, 126, 129, 130, 131, 132, 134, 135, 
      137, 138, 139, 140, 141, 143, 144, 147, 149, 151, 152, 163, 164, 168, 
      171, 183, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 216, 
      218, 220, 222, 234, 237, 239, 240, 242, 243, 247, 250, 252, 254, 255, 
      257, 258, 260, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
      278, 279, 280, 281, 295, 299, 313, 315, 317, 327, 328 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 37, 38, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 97, 98, 99, 
      135, 137, 138, 139, 140, 141, 143, 144, 147, 151, 152, 163, 164, 198, 
      201, 203, 206, 209, 210, 212, 222, 240, 242, 243, 247, 252, 254, 299, 
      313 ], 
  [ 1, 2, 8, 15, 17, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 144, 
      147, 151, 152, 210, 212, 222 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 22, 24, 25, 39, 
      40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 62, 72, 74, 
      76, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 100, 101, 103, 104, 108, 
      109, 110, 111, 112, 114, 115, 116, 117, 120, 123, 124, 129, 130, 131, 
      132, 134, 135, 138, 139, 140, 141, 144, 147, 149, 151, 152, 164, 209, 
      210, 212, 214, 216, 220, 222, 242, 252, 255, 258, 261, 270, 271, 272, 
      273, 274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 24, 25, 40, 41, 42, 44, 46, 47, 
      48, 49, 50, 52, 56, 57, 58, 74, 76, 95, 99, 109, 110, 111, 112, 114, 
      115, 116, 117, 120, 123, 130, 131, 132, 134, 135, 138, 139, 140, 141, 
      144, 147, 151, 152, 210, 212, 216, 220, 222, 252, 270, 271, 272, 273, 
      274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 37, 40, 41, 42, 
      44, 45, 46, 47, 48, 49, 50, 52, 56, 57, 58, 59, 73, 74, 76, 89, 92, 95, 
      97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 117, 120, 123, 130, 
      131, 132, 134, 135, 138, 139, 140, 141, 144, 147, 151, 152, 163, 171, 
      198, 200, 201, 203, 206, 210, 212, 216, 218, 220, 222, 237, 239, 252, 
      254, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 295, 
      299, 313, 317, 327, 328 ], 
  [ 1, 2, 4, 8, 10, 25, 47, 48, 49, 52, 56, 74, 76, 99, 112, 115, 116, 117, 
      220, 222, 281 ], [ 1, 2, 8, 48, 49, 52, 56, 99, 222 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 57, 58, 59, 
      73, 87, 95, 97, 109, 110, 113, 199 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      29, 31, 32, 34, 36, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 
      53, 54, 56, 57, 58, 62, 65, 66, 69, 70, 72, 74, 75, 76, 77, 78, 79, 80, 
      81, 83, 84, 85, 95, 96, 98, 99, 100, 101, 103, 104, 105, 108, 109, 110, 
      111, 112, 114, 115, 116, 117, 118, 120, 121, 122, 123, 124, 125, 127, 
      128, 129, 130, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 
      144, 145, 146, 147, 148, 149, 150, 151, 152, 162, 164, 165, 166, 167, 
      169, 170, 172, 176, 177, 178, 179, 180, 181, 195, 197, 209, 210, 211, 
      212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 231, 241, 242, 244, 
      245, 251, 252, 255, 256, 258, 259, 261, 263, 265, 268, 270, 271, 272, 
      273, 274, 275, 280, 281, 283, 286, 287, 288, 290, 293, 294, 295, 296, 
      298, 299, 301, 320, 322, 324, 327 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 27, 29, 31, 32, 33, 34, 36, 37, 39, 40, 41, 42, 43, 44, 45, 
      46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 61, 62, 64, 65, 66, 
      67, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
      87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 103, 104, 
      105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 120, 
      121, 122, 123, 124, 125, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 148, 149, 150, 151, 
      152, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
      175, 176, 177, 178, 179, 180, 181, 186, 189, 191, 193, 195, 197, 198, 
      199, 200, 201, 202, 203, 204, 205, 206, 209, 210, 211, 212, 213, 214, 
      215, 216, 217, 218, 219, 220, 221, 222, 226, 227, 229, 231, 232, 233, 
      234, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 
      250, 251, 252, 253, 254, 255, 256, 258, 259, 261, 263, 264, 265, 266, 
      268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
      283, 286, 287, 288, 290, 293, 294, 295, 296, 298, 299, 301, 304, 305, 
      306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 
      320, 322, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 34, 36, 47, 48, 49, 52, 53, 54, 56, 62, 
      65, 66, 69, 70, 72, 74, 75, 76, 77, 81, 84, 85, 96, 99, 104, 105, 108, 
      112, 115, 116, 117, 176, 177, 178, 179, 180, 181, 197, 219, 220, 221, 
      222, 227, 231, 245, 265, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 31, 32, 33, 34, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
      49, 50, 51, 52, 54, 56, 57, 58, 59, 61, 62, 64, 65, 67, 70, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 91, 92, 93, 94, 
      95, 97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 120, 122, 123, 124, 128, 129, 130, 131, 132, 133, 
      134, 135, 138, 139, 140, 141, 144, 146, 147, 148, 149, 151, 152, 163, 
      164, 166, 168, 170, 171, 172, 175, 178, 181, 189, 191, 198, 199, 200, 
      201, 202, 203, 205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 226, 227, 233, 234, 237, 238, 239, 240, 241, 
      242, 243, 244, 245, 246, 247, 249, 250, 252, 254, 255, 258, 261, 264, 
      269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 288, 
      293, 294, 295, 299, 306, 309, 310, 312, 313, 314, 315, 316, 317, 319, 
      327, 328 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 34, 40, 41, 42, 44, 
      46, 47, 48, 49, 50, 52, 54, 56, 57, 58, 74, 75, 76, 95, 99, 109, 110, 
      111, 112, 114, 115, 116, 117, 120, 122, 123, 130, 131, 132, 133, 134, 
      135, 138, 139, 140, 141, 144, 146, 147, 151, 152, 166, 172, 178, 181, 
      210, 211, 212, 215, 216, 219, 220, 221, 222, 252, 270, 271, 272, 273, 
      274, 275, 280, 281, 293, 294, 295, 299, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      31, 34, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 
      58, 62, 65, 70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 95, 98, 
      99, 100, 101, 103, 104, 108, 109, 110, 111, 112, 114, 115, 116, 117, 
      120, 122, 123, 124, 128, 129, 130, 131, 132, 133, 134, 135, 138, 139, 
      140, 141, 144, 146, 147, 148, 149, 151, 152, 164, 166, 170, 172, 178, 
      181, 209, 210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 
      241, 242, 244, 245, 252, 255, 258, 261, 270, 271, 272, 273, 274, 275, 
      280, 281, 288, 293, 294, 295, 299, 327 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 20, 22, 23, 24, 25, 31, 34, 37, 
      40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 52, 54, 56, 57, 58, 59, 73, 74, 
      75, 76, 89, 91, 92, 95, 97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 
      117, 120, 122, 123, 130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 
      144, 146, 147, 151, 152, 163, 166, 171, 172, 175, 178, 181, 189, 198, 
      200, 201, 203, 205, 206, 210, 211, 212, 215, 216, 217, 218, 219, 220, 
      221, 222, 237, 238, 239, 252, 254, 270, 271, 272, 273, 274, 275, 276, 
      277, 278, 279, 280, 281, 293, 294, 295, 299, 306, 310, 312, 313, 316, 
      317, 327, 328 ], 
  [ 1, 2, 4, 8, 10, 24, 25, 47, 48, 49, 52, 54, 56, 74, 75, 76, 99, 112, 115, 
      116, 117, 178, 181, 219, 220, 221, 222, 281 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43, 44, 
      45, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 
      64, 65, 67, 68, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 
      84, 85, 87, 88, 89, 91, 92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 
      104, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 
      120, 122, 123, 124, 126, 128, 129, 130, 131, 132, 133, 134, 135, 137, 
      138, 139, 140, 141, 143, 144, 146, 147, 148, 149, 151, 152, 156, 158, 
      161, 163, 164, 166, 168, 170, 171, 172, 175, 178, 181, 183, 185, 189, 
      190, 191, 192, 198, 199, 200, 201, 202, 203, 205, 206, 208, 209, 210, 
      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 225, 226, 
      227, 228, 233, 234, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 
      246, 247, 249, 250, 252, 254, 255, 257, 258, 260, 261, 264, 269, 270, 
      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 285, 288, 292, 
      293, 294, 295, 299, 303, 306, 309, 310, 312, 313, 314, 315, 316, 317, 
      319, 327, 328 ], [ 1, 2, 5, 49, 52 ], [ 1, 14, 17, 41, 50 ], 
  [ 1, 2, 5, 8, 25, 48, 49, 52, 56, 77, 81, 85, 99, 222 ], 
  [ 1, 2, 5, 14, 17, 40, 41, 42, 49, 50, 52, 57, 58, 79, 83, 138, 140, 151, 
      152, 210 ], [ 1, 2, 41, 50 ], [ 1, 50 ], 
  [ 1, 2, 40, 41, 49, 50, 52, 210 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 50, 57, 58, 95, 109, 110 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 42, 46, 47, 48, 49, 50, 52, 
      57, 58, 74, 95, 99, 109, 110, 114, 115, 116, 120, 131, 132, 138, 139, 
      140, 144, 151, 152, 210, 252, 271, 272, 274 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 46, 47, 48, 
      49, 50, 52, 57, 58, 59, 73, 74, 89, 95, 97, 99, 109, 110, 113, 114, 
      115, 116, 120, 131, 132, 138, 139, 140, 144, 151, 152, 198, 200, 201, 
      203, 210, 237, 252, 254, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 8, 15, 17, 40, 41, 42, 48, 49, 50, 52, 58, 99, 144, 151, 152, 210 ],
  [ 1, 2, 4, 8, 10, 48, 49, 52, 74, 99, 115, 116 ], [ 1, 2, 8, 49, 52, 99 ], 
  [ 1, 2, 52 ], [ 1 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 43, 50, 52, 57, 58, 74, 95, 
      99, 109, 110, 116, 120, 132, 140, 144, 152, 210, 252, 272, 274 ], 
  [ 1, 2 ], [ 1, 2, 5, 8, 9, 10, 36, 48, 49, 52, 54, 56, 77, 84, 85, 96, 99, 
      105, 108, 115, 116, 117, 197, 221, 222, 268, 281 ], 
  [ 1, 2, 8, 10, 52, 56, 99, 116, 117 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 26, 37, 40, 41, 43, 50, 51, 52, 
      56, 57, 58, 59, 73, 74, 76, 87, 88, 89, 92, 95, 97, 99, 109, 110, 113, 
      116, 117, 120, 123, 132, 134, 140, 141, 144, 147, 152, 183, 199, 202, 
      203, 206, 210, 214, 237, 239, 250, 252, 254, 272, 273, 274, 275, 278, 
      279, 315 ], [ 1, 2, 8, 52, 99 ], [ 1, 2, 14, 17, 40, 41, 50, 58 ], 
  [ 1, 2, 17, 40, 41, 50 ], [ 1, 2, 14, 17, 37, 40, 41, 50, 57, 58 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 
      58, 59, 62, 67, 68, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 85, 95, 
      97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108, 109, 110, 111, 112, 
      113, 114, 115, 116, 117, 119, 120, 123, 124, 126, 129, 130, 131, 132, 
      134, 135, 137, 138, 139, 140, 141, 143, 144, 147, 149, 151, 152, 163, 
      164, 168, 171, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 
      216, 220, 222, 234, 237, 239, 240, 242, 243, 247, 252, 254, 255, 257, 
      258, 260, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 
      279, 280, 281, 295, 299, 313, 315, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
      56, 57, 58, 59, 62, 67, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 85, 
      87, 88, 89, 92, 94, 95, 97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 120, 123, 124, 129, 130, 131, 
      132, 134, 135, 138, 139, 140, 141, 144, 147, 149, 151, 152, 163, 164, 
      168, 171, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 216, 
      218, 220, 222, 234, 237, 239, 240, 242, 243, 247, 250, 252, 254, 255, 
      258, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
      280, 281, 295, 299, 313, 315, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 47, 48, 49, 52, 56, 72, 74, 76, 77, 81, 
      85, 99, 104, 108, 112, 115, 116, 117, 220, 222, 281 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 57, 58, 59, 67, 73, 
      74, 77, 78, 79, 82, 83, 87, 88, 89, 95, 97, 98, 99, 100, 101, 106, 109, 
      110, 113, 114, 115, 116, 120, 131, 132, 138, 139, 140, 144, 151, 152, 
      183, 198, 199, 200, 201, 202, 203, 210, 237, 240, 252, 254, 271, 272, 
      274, 277, 278 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 31, 32, 33, 34, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
      49, 50, 51, 52, 54, 56, 57, 58, 59, 61, 62, 65, 67, 70, 72, 73, 74, 75, 
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 91, 92, 93, 94, 95, 
      97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 114, 
      115, 116, 117, 120, 122, 123, 124, 128, 129, 130, 131, 132, 133, 134, 
      135, 138, 139, 140, 141, 144, 146, 147, 148, 149, 151, 152, 163, 164, 
      166, 168, 170, 171, 172, 175, 178, 181, 189, 191, 198, 199, 200, 201, 
      202, 203, 205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
      219, 220, 221, 222, 226, 227, 233, 234, 237, 238, 239, 240, 241, 242, 
      243, 244, 245, 246, 247, 249, 250, 252, 254, 255, 258, 261, 264, 269, 
      270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 288, 293, 
      294, 295, 299, 306, 309, 310, 312, 313, 314, 315, 316, 317, 319, 327, 
      328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 34, 47, 48, 49, 52, 54, 56, 62, 70, 72, 
      74, 75, 76, 77, 81, 84, 85, 99, 104, 108, 112, 115, 116, 117, 178, 181, 
      219, 220, 221, 222, 227, 245, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 36, 47, 48, 49, 52, 74, 77, 96, 99, 105, 115, 
      116 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 57, 58, 59, 73, 74, 77, 78, 79, 82, 
      83, 95, 97, 98, 99, 100, 101, 106, 109, 110, 113, 114, 115, 116, 120, 
      131, 132, 138, 139, 140, 144, 151, 152, 198, 199, 200, 201, 202, 203, 
      210, 237, 240, 252, 254, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 38, 47, 48, 49, 52, 56, 62, 72, 74, 76, 
      77, 81, 85, 99, 104, 107, 108, 112, 115, 116, 117, 220, 222, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 36, 47, 48, 49, 52, 53, 54, 56, 66, 70, 72, 74, 
      75, 76, 77, 84, 85, 96, 99, 105, 108, 115, 116, 117, 197, 219, 220, 
      221, 222, 231, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 47, 48, 49, 52, 54, 56, 72, 74, 75, 76, 77, 84, 
      85, 99, 108, 115, 116, 117, 219, 220, 221, 222, 281 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 55, 56, 57, 58, 59, 
      63, 67, 72, 73, 74, 76, 77, 78, 79, 82, 83, 85, 87, 88, 89, 92, 94, 95, 
      97, 98, 99, 100, 101, 106, 108, 109, 110, 113, 114, 115, 116, 117, 120, 
      123, 129, 131, 132, 134, 138, 139, 140, 141, 144, 147, 149, 151, 152, 
      183, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 216, 218, 
      220, 222, 234, 237, 239, 240, 242, 247, 250, 252, 254, 258, 261, 269, 
      271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 295, 299, 313, 315, 
      317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 47, 48, 49, 52, 56, 74, 76, 77, 85, 99, 108, 
      115, 116, 117, 220, 222, 281 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 57, 58, 59, 95, 97, 
      109, 110, 113 ], [ 1, 2, 4, 8, 10, 52, 99, 116 ], 
  [ 1, 2, 4, 8, 10, 52, 54, 56, 74, 76, 99, 116, 117 ], 
  [ 1, 2, 4, 8, 10, 52, 56, 74, 99, 116, 117 ], 
  [ 1, 2, 5, 8, 48, 49, 52, 99 ], 
  [ 1, 2, 5, 8, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 79, 83, 99, 
      144, 151, 152, 210 ], 
  [ 1, 2, 5, 17, 40, 41, 42, 49, 50, 52, 58, 83, 151, 152, 210 ], 
  [ 1, 2, 5, 8, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 77, 
      78, 79, 81, 83, 85, 99, 144, 147, 151, 152, 210, 212, 222, 242 ], 
  [ 1, 2, 5, 8, 25, 48, 49, 52, 56, 77, 85, 99, 222 ], 
  [ 1, 2, 5, 14, 17, 37, 39, 40, 41, 42, 49, 50, 52, 57, 58, 59, 79, 83, 138, 
      140, 151, 152, 198, 203, 210 ], [ 1, 2, 5, 40, 41, 42, 49, 50, 52, 210 ]
    , [ 1, 2, 5, 8, 9, 10, 48, 49, 52, 54, 56, 77, 85, 99, 108, 115, 116, 
      117, 221, 222, 281 ], [ 1, 2, 5, 8, 48, 49, 52, 56, 77, 99, 222 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 57, 58, 59, 66, 67, 
      73, 74, 77, 78, 79, 82, 83, 87, 88, 89, 95, 96, 97, 98, 99, 100, 101, 
      105, 106, 109, 110, 113, 114, 115, 116, 118, 120, 125, 131, 132, 136, 
      138, 139, 140, 142, 144, 150, 151, 152, 193, 195, 198, 199, 200, 201, 
      202, 203, 210, 229, 237, 240, 251, 252, 253, 254, 256, 259, 266, 271, 
      272, 274, 277, 278 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 57, 58, 59, 
      73, 95, 97, 109, 110, 113, 199 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 52, 57, 
      58, 59, 73, 74, 87, 89, 95, 97, 99, 109, 110, 113, 116, 120, 132, 140, 
      144, 152, 199, 202, 203, 210, 237, 252, 254, 272, 274, 278 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 57, 58, 59, 
      73, 74, 95, 97, 99, 109, 110, 113, 116, 120, 132, 140, 144, 152, 203, 
      210, 237, 252, 254, 272, 274, 278 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 
      59, 66, 67, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 82, 83, 84, 85, 86, 
      87, 88, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 105, 106, 
      108, 109, 110, 113, 114, 115, 116, 117, 118, 120, 121, 122, 123, 125, 
      127, 128, 129, 131, 132, 133, 134, 136, 138, 139, 140, 141, 142, 144, 
      145, 146, 147, 148, 149, 150, 151, 152, 193, 195, 197, 198, 199, 200, 
      201, 202, 203, 204, 205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 
      217, 218, 219, 220, 221, 222, 229, 231, 232, 233, 234, 237, 238, 239, 
      240, 241, 242, 246, 247, 248, 249, 250, 251, 252, 253, 254, 256, 258, 
      259, 261, 266, 268, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 
      281, 283, 290, 294, 295, 298, 299, 301, 311, 312, 313, 314, 315, 316, 
      317, 318, 322, 324, 326, 327, 328 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 54, 56, 57, 
      58, 59, 73, 74, 75, 76, 89, 92, 95, 97, 99, 109, 110, 113, 116, 117, 
      120, 122, 123, 132, 133, 134, 140, 141, 144, 146, 147, 152, 203, 205, 
      206, 210, 237, 238, 239, 252, 254, 272, 273, 274, 275, 278, 279 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 56, 57, 58, 
      59, 73, 74, 76, 89, 95, 97, 99, 109, 110, 113, 116, 117, 120, 123, 132, 
      134, 140, 141, 144, 147, 152, 203, 206, 210, 237, 239, 252, 254, 272, 
      273, 274, 275, 278, 279 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 
      41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 59, 67, 
      70, 72, 73, 74, 75, 76, 77, 78, 79, 82, 83, 84, 85, 87, 88, 89, 91, 92, 
      94, 95, 97, 98, 99, 100, 101, 106, 108, 109, 110, 113, 114, 115, 116, 
      117, 120, 122, 123, 128, 129, 131, 132, 133, 134, 138, 139, 140, 141, 
      144, 146, 147, 148, 149, 151, 152, 198, 199, 200, 201, 202, 203, 205, 
      206, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 
      222, 233, 234, 237, 238, 239, 240, 241, 242, 246, 247, 249, 250, 252, 
      254, 258, 261, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 
      294, 295, 299, 312, 313, 314, 315, 316, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 
      41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 59, 67, 72, 
      73, 74, 76, 77, 78, 79, 82, 83, 85, 87, 88, 89, 92, 95, 97, 98, 99, 
      100, 101, 106, 108, 109, 110, 113, 114, 115, 116, 117, 120, 123, 129, 
      131, 132, 134, 138, 139, 140, 141, 144, 147, 149, 151, 152, 198, 199, 
      200, 201, 202, 203, 206, 209, 210, 212, 214, 216, 218, 220, 222, 234, 
      237, 239, 240, 242, 247, 250, 252, 254, 258, 261, 269, 271, 272, 273, 
      274, 275, 277, 278, 279, 280, 281, 295, 299, 313, 315, 317, 327, 328 ], 
  [ 1, 2, 8, 14, 15, 17, 40, 41, 50, 57, 58 ], 
  [ 1, 2, 5, 8, 36, 48, 49, 52, 77, 99 ], 
  [ 1, 2, 8, 14, 15, 17, 37, 40, 41, 50, 57, 58, 59, 95 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 39, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 77, 
      78, 79, 83, 95, 99, 138, 139, 140, 144, 151, 152, 210, 252 ], 
  [ 1, 2, 8, 52 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 57, 58, 77, 78, 79, 83, 95, 98, 99, 101, 109, 110, 114, 115, 116, 
      131, 132, 138, 139, 140, 144, 151, 152, 210, 252, 271, 272, 274 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 78, 
      79, 83, 99, 110, 114, 115, 116, 144, 151, 152, 210, 274 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 19, 20, 25, 37, 38, 39, 40, 41, 
      42, 46, 48, 49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 
      95, 97, 98, 99, 100, 101, 103, 104, 106, 107, 108, 109, 110, 111, 112, 
      113, 114, 115, 116, 117, 124, 126, 129, 130, 131, 132, 134, 135, 137, 
      138, 139, 140, 141, 143, 144, 147, 151, 152, 163, 164, 198, 201, 203, 
      206, 209, 210, 212, 222, 240, 242, 243, 247, 252, 254, 255, 257, 258, 
      260, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
      280, 281, 295, 299, 313, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      58, 77, 78, 79, 80, 81, 83, 85, 99, 101, 104, 108, 110, 111, 112, 114, 
      115, 116, 117, 144, 147, 151, 152, 210, 212, 222, 242, 261, 274, 275, 
      280, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 48, 49, 52, 56, 77, 81, 85, 99, 108, 112, 115, 
      116, 117, 222, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 36, 48, 49, 52, 77, 96, 99, 115, 116 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 37, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 57, 58, 59, 77, 78, 79, 82, 83, 95, 97, 98, 99, 100, 101, 109, 
      110, 113, 114, 115, 116, 131, 132, 138, 139, 140, 144, 151, 152, 198, 
      201, 203, 210, 240, 252, 254, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 38, 48, 49, 52, 56, 77, 81, 85, 99, 104, 108, 112, 
      115, 116, 117, 222, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 48, 49, 52, 56, 77, 85, 99, 115, 116, 117, 222, 281 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 50, 57, 58, 95, 110 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 50, 58 ], 
  [ 1, 2, 8, 10, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 
      110, 112, 114, 115, 116, 117, 144, 147, 151, 152, 210, 212, 222, 274, 
      275, 280, 281 ], 
  [ 1, 2, 8, 10, 25, 48, 49, 52, 56, 99, 115, 116, 117, 222, 281 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 50, 57, 58, 59, 95, 97, 109, 110 
     ], [ 1, 2, 8, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 58, 99, 110, 
      115, 116, 144, 151, 152, 210, 274 ], 
  [ 1, 2, 8, 10, 48, 49, 52, 99, 116 ], [ 1, 2, 8, 10, 52, 99 ], 
  [ 1, 2, 8, 10, 52, 56, 99, 116 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 57, 58, 66, 74, 77, 78, 79, 83, 95, 
      96, 98, 99, 100, 101, 105, 109, 110, 114, 115, 116, 120, 125, 131, 132, 
      136, 138, 139, 140, 142, 144, 150, 151, 152, 195, 210, 251, 252, 256, 
      259, 271, 272, 274 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 62, 
      68, 72, 74, 76, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 100, 101, 103, 
      104, 107, 108, 109, 110, 111, 112, 114, 115, 116, 117, 120, 123, 124, 
      126, 129, 130, 131, 132, 134, 135, 137, 138, 139, 140, 141, 143, 144, 
      147, 149, 151, 152, 164, 209, 210, 212, 214, 216, 220, 222, 242, 252, 
      255, 257, 258, 260, 261, 270, 271, 272, 273, 274, 275, 280, 281, 295, 
      299, 327 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 50, 52, 57, 58, 74, 95, 99, 
      109, 110, 116, 132, 140, 144, 152, 210, 252, 272, 274 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 66, 69, 70, 72, 
      74, 75, 76, 77, 78, 79, 83, 84, 85, 95, 96, 98, 99, 100, 101, 105, 108, 
      109, 110, 114, 115, 116, 117, 118, 120, 122, 123, 125, 127, 128, 129, 
      131, 132, 133, 134, 136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 
      148, 149, 150, 151, 152, 195, 197, 209, 210, 211, 212, 213, 214, 215, 
      216, 219, 220, 221, 222, 231, 241, 242, 251, 252, 256, 258, 259, 261, 
      268, 271, 272, 273, 274, 275, 280, 281, 283, 290, 294, 295, 298, 299, 
      301, 322, 324, 327 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 50, 52, 54, 56, 57, 58, 74, 
      75, 76, 95, 99, 109, 110, 116, 117, 120, 123, 132, 133, 134, 140, 141, 
      144, 146, 147, 152, 210, 252, 272, 273, 274, 275 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 50, 52, 56, 57, 58, 74, 76, 
      95, 99, 109, 110, 116, 117, 120, 132, 134, 140, 141, 144, 147, 152, 
      210, 252, 272, 273, 274, 275 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      58, 77, 78, 79, 80, 81, 83, 85, 99, 129, 130, 131, 132, 134, 144, 147, 
      151, 152, 210, 212, 222, 242, 295 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 
      78, 79, 83, 96, 99, 131, 132, 142, 144, 150, 151, 152, 195, 210 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 20, 25, 38, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 58, 77, 78, 79, 80, 81, 83, 85, 99, 124, 129, 130, 131, 132, 134, 
      143, 144, 147, 151, 152, 210, 212, 222, 242, 295 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 53, 54, 56, 57, 58, 77, 78, 79, 83, 84, 85, 95, 96, 98, 99, 
      100, 101, 105, 108, 109, 110, 114, 115, 116, 117, 125, 128, 129, 131, 
      132, 133, 134, 136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 150, 
      151, 152, 195, 197, 209, 210, 211, 212, 221, 222, 241, 242, 251, 252, 
      256, 258, 259, 261, 268, 271, 272, 273, 274, 275, 280, 281, 290, 294, 
      295, 298, 299, 301, 322, 324, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 54, 56, 57, 58, 77, 78, 79, 83, 84, 85, 95, 98, 99, 100, 101, 108, 
      109, 110, 114, 115, 116, 117, 129, 131, 132, 133, 134, 138, 139, 140, 
      141, 144, 146, 147, 151, 152, 209, 210, 211, 212, 221, 222, 241, 242, 
      252, 258, 261, 271, 272, 273, 274, 275, 280, 281, 294, 295, 299, 327 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 77, 
      78, 79, 83, 85, 99, 131, 132, 134, 144, 147, 151, 152, 210, 212, 222, 
      242, 295 ], 
  [ 1, 2, 8, 13, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 
      131, 132, 134, 144, 147, 151, 152, 210, 212, 222, 295 ], 
  [ 1, 2, 8, 13, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 58, 99, 132, 144, 
      151, 152, 210 ], 
  [ 1, 2, 8, 13, 15, 17, 40, 41, 50, 52, 58, 99, 144, 152, 210 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 50, 52, 54, 56, 57, 58, 95, 99, 109, 
      110, 116, 117, 132, 134, 140, 141, 144, 146, 147, 152, 210, 252, 272, 
      273, 274, 275 ], 
  [ 1, 2, 8, 13, 15, 17, 40, 41, 50, 52, 56, 58, 99, 132, 144, 147, 152, 210 ]
    , [ 1, 2, 8, 14, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 
      58, 95, 99, 138, 139, 140, 141, 144, 147, 151, 152, 210, 212, 222, 252, 
      299 ], 
  [ 1, 2, 5, 14, 17, 36, 39, 40, 41, 42, 49, 50, 52, 57, 58, 79, 83, 138, 
      140, 150, 151, 152, 195, 210 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 38, 39, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 135, 138, 139, 140, 
      141, 143, 144, 147, 151, 152, 164, 209, 210, 212, 222, 242, 252, 299 ], 
  [ 1, 2, 14, 17, 40, 41, 42, 49, 50, 52, 57, 58, 140, 151, 152, 210 ], 
  [ 1, 2, 8, 14, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 95, 99, 138, 
      140, 144, 151, 152, 210, 252 ], 
  [ 1, 2, 14, 17, 40, 41, 50, 52, 57, 58, 152, 210 ], 
  [ 1, 2, 8, 14, 15, 17, 40, 41, 50, 52, 56, 57, 58, 95, 99, 140, 144, 147, 
      152, 210, 252 ], 
  [ 1, 2, 5, 8, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 78, 79, 
      83, 96, 99, 144, 150, 151, 152, 195, 210 ], 
  [ 1, 2, 5, 8, 15, 17, 20, 25, 38, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 
      77, 78, 79, 80, 81, 83, 85, 99, 144, 147, 151, 152, 210, 212, 222, 242 ]
    , [ 1, 2, 8, 15, 17, 40, 41, 50, 52, 58, 99, 152, 210 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 53, 54, 
      56, 58, 77, 78, 79, 83, 84, 85, 96, 99, 101, 105, 108, 110, 114, 115, 
      116, 117, 142, 144, 146, 147, 150, 151, 152, 195, 197, 210, 211, 212, 
      221, 222, 241, 242, 259, 261, 268, 274, 275, 280, 281, 301, 324 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 50, 52, 54, 56, 58, 99, 110, 116, 117, 144, 
      147, 152, 210, 274, 275 ], 
  [ 1, 2, 8, 15, 17, 40, 41, 50, 52, 56, 58, 99, 144, 152, 210 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 39, 40, 41, 42, 43, 
      44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 70, 72, 74, 75, 76, 77, 
      78, 79, 83, 84, 85, 95, 98, 99, 100, 101, 108, 109, 110, 114, 115, 116, 
      117, 120, 122, 123, 128, 129, 131, 132, 133, 134, 138, 139, 140, 141, 
      144, 146, 147, 149, 151, 152, 209, 210, 211, 212, 213, 214, 215, 216, 
      219, 220, 221, 222, 241, 242, 252, 258, 261, 271, 272, 273, 274, 275, 
      280, 281, 294, 295, 299, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 39, 40, 41, 42, 43, 
      44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 72, 74, 76, 77, 78, 79, 83, 
      85, 95, 98, 99, 100, 101, 108, 109, 110, 114, 115, 116, 117, 120, 123, 
      129, 131, 132, 134, 138, 139, 140, 141, 144, 147, 151, 152, 209, 210, 
      212, 214, 216, 220, 222, 242, 252, 258, 261, 271, 272, 273, 274, 275, 
      280, 281, 295, 299, 327 ], 
  [ 1, 2, 5, 17, 36, 40, 41, 42, 49, 50, 52, 58, 79, 83, 151, 152, 195, 210 ],
  [ 1, 2, 17, 40, 41, 42, 49, 50, 52, 58, 152, 210 ], 
  [ 1, 2, 17, 40, 41, 50, 52, 58, 210 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
      57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 
      75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
      150, 151, 152, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
      165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
      179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
      193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
      207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 
      235, 236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 
      249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 
      263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 
      277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 
      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 
      305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 
      319, 320, 321, 322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
      48, 49, 50, 51, 52, 55, 56, 57, 58, 59, 60, 61, 62, 63, 66, 67, 68, 71, 
      72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 85, 86, 87, 88, 89, 92, 94, 
      95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 123, 124, 125, 
      126, 129, 130, 131, 132, 134, 135, 136, 137, 138, 139, 140, 141, 142, 
      143, 144, 147, 149, 150, 151, 152, 159, 162, 163, 164, 167, 168, 171, 
      173, 176, 179, 182, 183, 193, 194, 195, 196, 197, 198, 199, 200, 201, 
      202, 203, 206, 209, 210, 212, 214, 216, 218, 220, 222, 223, 229, 230, 
      231, 234, 237, 239, 240, 242, 243, 247, 248, 250, 251, 252, 253, 254, 
      255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 
      269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 
      283, 286, 289, 290, 295, 296, 297, 298, 299, 300, 301, 304, 307, 311, 
      313, 315, 317, 318, 320, 321, 322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 
      48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 66, 67, 
      68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
      86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 
      103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
      117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 
      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 
      145, 146, 147, 148, 149, 150, 151, 152, 154, 156, 159, 160, 161, 162, 
      163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 
      177, 178, 179, 180, 181, 182, 183, 184, 185, 193, 194, 195, 196, 197, 
      198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
      212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 
      226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 
      240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 
      254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 267, 
      268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
      282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 
      296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 
      310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 
      324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 
      49, 50, 51, 52, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 67, 68, 70, 71, 
      72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 87, 88, 89, 91, 
      92, 93, 94, 95, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 120, 122, 123, 124, 
      126, 128, 129, 130, 131, 132, 133, 134, 135, 137, 138, 139, 140, 141, 
      143, 144, 146, 147, 148, 149, 151, 152, 161, 163, 164, 166, 168, 170, 
      171, 172, 175, 178, 181, 183, 185, 198, 199, 200, 201, 202, 203, 205, 
      206, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
      221, 222, 225, 226, 227, 228, 233, 234, 236, 237, 238, 239, 240, 241, 
      242, 243, 244, 245, 246, 247, 249, 250, 252, 254, 255, 257, 258, 260, 
      261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
      281, 285, 288, 292, 293, 294, 295, 299, 303, 306, 309, 310, 312, 313, 
      314, 315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 27, 29, 31, 32, 34, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 
      49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 60, 62, 65, 66, 67, 68, 69, 70, 
      72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 95, 96, 97, 98, 
      99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 
      113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
      127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 158, 159, 
      160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 176, 
      177, 178, 179, 180, 181, 186, 187, 188, 189, 190, 191, 192, 193, 194, 
      195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 
      210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 223, 224, 225, 
      227, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 
      242, 243, 244, 245, 246, 247, 251, 252, 253, 254, 255, 256, 257, 258, 
      259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 
      273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 
      287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 
      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 
      315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 31, 32, 34, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 
      52, 54, 56, 57, 58, 59, 60, 62, 65, 67, 68, 70, 72, 73, 74, 75, 76, 77, 
      78, 79, 80, 81, 82, 83, 84, 85, 95, 97, 98, 99, 100, 101, 102, 103, 
      104, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 
      120, 122, 123, 124, 126, 128, 129, 130, 131, 132, 133, 134, 135, 137, 
      138, 139, 140, 141, 143, 144, 146, 147, 148, 149, 151, 152, 161, 163, 
      164, 166, 168, 170, 171, 172, 178, 181, 189, 190, 191, 192, 198, 199, 
      200, 201, 202, 203, 205, 206, 208, 209, 210, 211, 212, 213, 214, 215, 
      216, 219, 220, 221, 222, 225, 227, 233, 234, 236, 237, 238, 239, 240, 
      241, 242, 243, 244, 245, 246, 247, 252, 254, 255, 257, 258, 260, 261, 
      264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
      285, 288, 292, 293, 294, 295, 299, 303, 306, 309, 310, 312, 313, 314, 
      315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 19, 20, 25, 36, 37, 38, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 96, 97, 
      98, 99, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 147, 150, 
      151, 152, 162, 163, 164, 179, 193, 194, 195, 197, 198, 201, 203, 206, 
      209, 210, 212, 222, 240, 242, 243, 247, 251, 252, 253, 254, 296, 297, 
      298, 299, 300, 301, 304, 311, 313 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 19, 20, 25, 36, 37, 38, 39, 40, 
      41, 42, 46, 48, 49, 50, 52, 53, 54, 56, 57, 58, 59, 77, 78, 79, 80, 81, 
      82, 83, 84, 85, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
      107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 124, 125, 126, 
      127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
      141, 142, 143, 144, 145, 146, 147, 150, 151, 152, 159, 161, 162, 163, 
      164, 165, 166, 179, 180, 181, 193, 194, 195, 197, 198, 201, 203, 204, 
      205, 206, 207, 208, 209, 210, 211, 212, 221, 222, 240, 241, 242, 243, 
      244, 245, 246, 247, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 
      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 
      275, 276, 277, 278, 279, 280, 281, 286, 287, 288, 289, 290, 291, 292, 
      293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 
      311, 312, 313, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 19, 20, 25, 37, 38, 39, 40, 41, 
      42, 46, 48, 49, 50, 52, 54, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 
      84, 85, 95, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 124, 126, 128, 129, 130, 131, 
      132, 133, 134, 135, 137, 138, 139, 140, 141, 143, 144, 146, 147, 151, 
      152, 163, 164, 166, 181, 198, 201, 203, 205, 206, 208, 209, 210, 211, 
      212, 221, 222, 240, 241, 242, 243, 244, 245, 246, 247, 252, 254, 255, 
      257, 258, 260, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
      278, 279, 280, 281, 288, 292, 293, 294, 295, 299, 303, 306, 312, 313, 
      319, 327, 328 ], 
  [ 1, 2, 5, 8, 15, 17, 20, 25, 36, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 
      77, 78, 79, 80, 81, 83, 85, 96, 99, 142, 144, 147, 150, 151, 152, 179, 
      195, 197, 210, 212, 222, 242, 301 ], 
  [ 1, 2, 8, 14, 15, 17, 20, 25, 37, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 
      58, 59, 95, 97, 99, 135, 138, 139, 140, 141, 144, 147, 151, 152, 198, 
      201, 203, 206, 210, 212, 222, 252, 254, 299, 313 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 39, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 135, 138, 139, 140, 
      141, 144, 147, 151, 152, 209, 210, 212, 222, 242, 252, 299 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 36, 40, 41, 42, 46, 48, 49, 50, 52, 
      53, 54, 56, 58, 77, 78, 79, 80, 81, 83, 84, 85, 96, 99, 101, 103, 104, 
      105, 108, 110, 111, 112, 114, 115, 116, 117, 142, 144, 145, 146, 147, 
      150, 151, 152, 162, 166, 179, 180, 181, 195, 197, 210, 211, 212, 221, 
      222, 241, 242, 244, 245, 259, 261, 263, 265, 268, 274, 275, 280, 281, 
      301, 324 ], 
  [ 1, 2, 8, 10, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 54, 56, 58, 
      99, 110, 111, 112, 114, 115, 116, 117, 144, 146, 147, 151, 152, 181, 
      210, 211, 212, 221, 222, 274, 275, 280, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 62, 
      66, 72, 74, 76, 77, 78, 79, 80, 81, 83, 85, 95, 96, 98, 99, 100, 101, 
      103, 104, 105, 108, 109, 110, 111, 112, 114, 115, 116, 117, 118, 120, 
      123, 124, 125, 129, 130, 131, 132, 134, 135, 136, 138, 139, 140, 141, 
      142, 144, 147, 149, 150, 151, 152, 162, 164, 176, 179, 195, 197, 209, 
      210, 212, 214, 216, 220, 222, 231, 242, 251, 252, 255, 256, 258, 259, 
      261, 263, 265, 268, 270, 271, 272, 273, 274, 275, 280, 281, 283, 286, 
      290, 295, 296, 298, 299, 301, 320, 322, 324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 59, 
      62, 67, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 85, 95, 97, 98, 99, 
      100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 
      117, 120, 123, 124, 129, 130, 131, 132, 134, 135, 138, 139, 140, 141, 
      144, 147, 149, 151, 152, 163, 164, 171, 198, 199, 200, 201, 202, 203, 
      206, 209, 210, 212, 214, 216, 220, 222, 234, 237, 239, 240, 242, 243, 
      247, 252, 254, 255, 258, 261, 264, 269, 270, 271, 272, 273, 274, 275, 
      276, 277, 278, 279, 280, 281, 295, 299, 313, 315, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 
      58, 62, 66, 69, 70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 95, 
      96, 98, 99, 100, 101, 103, 104, 105, 108, 109, 110, 111, 112, 114, 115, 
      116, 117, 118, 120, 121, 122, 123, 124, 125, 127, 128, 129, 130, 131, 
      132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 
      148, 149, 150, 151, 152, 162, 164, 165, 166, 167, 170, 172, 176, 177, 
      178, 179, 180, 181, 195, 197, 209, 210, 211, 212, 213, 214, 215, 216, 
      219, 220, 221, 222, 227, 231, 241, 242, 244, 245, 251, 252, 255, 256, 
      258, 259, 261, 263, 265, 268, 270, 271, 272, 273, 274, 275, 280, 281, 
      283, 286, 287, 288, 290, 293, 294, 295, 296, 298, 299, 301, 320, 322, 
      324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 62, 
      70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 95, 98, 99, 100, 
      101, 103, 104, 108, 109, 110, 111, 112, 114, 115, 116, 117, 120, 122, 
      123, 124, 128, 129, 130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 
      144, 146, 147, 148, 149, 151, 152, 164, 166, 172, 178, 181, 209, 210, 
      211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 241, 242, 244, 
      245, 252, 255, 258, 261, 270, 271, 272, 273, 274, 275, 280, 281, 288, 
      293, 294, 295, 299, 327 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 37, 40, 41, 42, 44, 
      46, 47, 48, 49, 50, 52, 56, 57, 58, 59, 73, 74, 76, 95, 97, 99, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 120, 123, 130, 131, 132, 134, 
      135, 138, 139, 140, 141, 144, 147, 151, 152, 163, 198, 200, 201, 203, 
      206, 210, 212, 216, 220, 222, 237, 239, 252, 254, 270, 271, 272, 273, 
      274, 275, 276, 277, 278, 279, 280, 281, 295, 299, 313, 317, 327, 328 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 40, 41, 42, 44, 46, 
      47, 48, 49, 50, 52, 54, 56, 57, 58, 74, 75, 76, 95, 99, 109, 110, 111, 
      112, 114, 115, 116, 117, 120, 122, 123, 130, 131, 132, 133, 134, 135, 
      138, 139, 140, 141, 144, 146, 147, 151, 152, 166, 178, 181, 210, 211, 
      212, 215, 216, 219, 220, 221, 222, 252, 270, 271, 272, 273, 274, 275, 
      280, 281, 293, 294, 295, 299, 327 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 36, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
      52, 56, 57, 58, 59, 61, 62, 66, 67, 72, 73, 74, 76, 77, 78, 79, 80, 81, 
      82, 83, 85, 86, 87, 88, 89, 92, 94, 95, 96, 97, 98, 99, 100, 101, 103, 
      104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
      120, 123, 124, 125, 129, 130, 131, 132, 134, 135, 136, 138, 139, 140, 
      141, 142, 144, 147, 149, 150, 151, 152, 162, 163, 164, 167, 168, 171, 
      176, 179, 193, 195, 197, 198, 199, 200, 201, 202, 203, 206, 209, 210, 
      212, 214, 216, 218, 220, 222, 229, 231, 234, 237, 239, 240, 242, 243, 
      247, 248, 250, 251, 252, 253, 254, 255, 256, 258, 259, 261, 263, 264, 
      265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
      280, 281, 283, 286, 290, 295, 296, 298, 299, 301, 304, 307, 311, 313, 
      315, 317, 318, 320, 322, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 36, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 
      52, 53, 54, 56, 57, 58, 59, 61, 62, 66, 67, 69, 70, 72, 73, 74, 75, 76, 
      77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 
      95, 96, 97, 98, 99, 100, 101, 103, 104, 105, 106, 108, 109, 110, 111, 
      112, 113, 114, 115, 116, 117, 118, 120, 121, 122, 123, 124, 125, 127, 
      128, 129, 130, 131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 
      144, 145, 146, 147, 148, 149, 150, 151, 152, 162, 163, 164, 165, 166, 
      167, 168, 169, 170, 171, 172, 173, 175, 176, 177, 178, 179, 180, 181, 
      193, 195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 209, 210, 
      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 226, 227, 
      229, 231, 232, 233, 234, 237, 238, 239, 240, 241, 242, 243, 244, 245, 
      246, 247, 248, 249, 250, 251, 252, 253, 254, 255, 256, 258, 259, 261, 
      263, 264, 265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
      278, 279, 280, 281, 283, 286, 287, 288, 290, 293, 294, 295, 296, 298, 
      299, 301, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 
      316, 317, 318, 319, 320, 322, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 20, 22, 23, 24, 25, 37, 40, 41, 
      42, 44, 45, 46, 47, 48, 49, 50, 52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 
      89, 91, 92, 95, 97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
      120, 122, 123, 130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 144, 
      146, 147, 151, 152, 163, 166, 171, 172, 178, 181, 198, 200, 201, 203, 
      205, 206, 210, 211, 212, 215, 216, 217, 218, 219, 220, 221, 222, 237, 
      238, 239, 252, 254, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 
      280, 281, 293, 294, 295, 299, 306, 310, 312, 313, 316, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 36, 47, 48, 49, 52, 56, 62, 66, 72, 74, 
      76, 77, 81, 85, 96, 99, 104, 105, 108, 112, 115, 116, 117, 179, 197, 
      220, 222, 231, 265, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 36, 47, 48, 49, 52, 53, 54, 56, 62, 66, 
      69, 70, 72, 74, 75, 76, 77, 81, 84, 85, 96, 99, 104, 105, 108, 112, 
      115, 116, 117, 176, 178, 179, 180, 181, 197, 219, 220, 221, 222, 227, 
      231, 245, 265, 268, 281 ], 
  [ 1, 2, 4, 8, 10, 24, 25, 47, 48, 49, 52, 54, 56, 74, 75, 76, 99, 112, 115, 
      116, 117, 181, 219, 220, 221, 222, 281 ], 
  [ 1, 2, 5, 8, 25, 36, 48, 49, 52, 56, 77, 81, 85, 96, 99, 197, 222 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 36, 48, 49, 52, 53, 54, 56, 77, 81, 84, 85, 96, 
      99, 104, 105, 108, 112, 115, 116, 117, 179, 181, 197, 221, 222, 245, 
      265, 268, 281 ], 
  [ 1, 2, 8, 10, 25, 48, 49, 52, 54, 56, 99, 112, 115, 116, 117, 221, 222, 
      281 ], [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 
      36, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 57, 58, 
      59, 63, 66, 67, 73, 74, 77, 78, 79, 82, 83, 86, 87, 88, 89, 95, 96, 97, 
      98, 99, 100, 101, 105, 106, 109, 110, 113, 114, 115, 116, 118, 120, 
      125, 131, 132, 136, 138, 139, 140, 142, 144, 150, 151, 152, 183, 193, 
      195, 198, 199, 200, 201, 202, 203, 210, 229, 237, 240, 251, 252, 253, 
      254, 256, 259, 266, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 26, 37, 40, 41, 43, 50, 51, 52, 
      57, 58, 59, 73, 74, 87, 88, 89, 95, 97, 99, 109, 110, 113, 116, 120, 
      132, 140, 144, 152, 199, 202, 203, 210, 237, 252, 254, 272, 274, 278 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 36, 37, 
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 
      57, 58, 59, 63, 66, 67, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 82, 
      83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      100, 101, 105, 106, 108, 109, 110, 113, 114, 115, 116, 117, 118, 120, 
      121, 122, 123, 125, 127, 128, 129, 131, 132, 133, 134, 136, 138, 139, 
      140, 141, 142, 144, 145, 146, 147, 148, 149, 150, 151, 152, 182, 183, 
      185, 193, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
      209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 
      228, 229, 231, 232, 233, 234, 237, 238, 239, 240, 241, 242, 246, 247, 
      248, 249, 250, 251, 252, 253, 254, 256, 258, 259, 261, 266, 268, 269, 
      271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 283, 290, 294, 295, 
      298, 299, 301, 311, 312, 313, 314, 315, 316, 317, 318, 322, 324, 326, 
      327, 328 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 26, 37, 40, 41, 43, 50, 51, 52, 
      54, 55, 56, 57, 58, 59, 73, 74, 75, 76, 87, 88, 89, 91, 92, 95, 97, 99, 
      109, 110, 113, 116, 117, 120, 122, 123, 132, 133, 134, 140, 141, 144, 
      146, 147, 152, 183, 199, 202, 203, 205, 206, 210, 213, 214, 237, 238, 
      239, 249, 250, 252, 254, 272, 273, 274, 275, 278, 279, 314, 315 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      27, 29, 31, 32, 34, 36, 37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 
      51, 52, 53, 54, 56, 57, 58, 59, 62, 65, 66, 67, 69, 70, 72, 73, 74, 75, 
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 95, 96, 97, 98, 99, 100, 101, 
      103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
      118, 120, 121, 122, 123, 124, 125, 127, 128, 129, 130, 131, 132, 133, 
      134, 135, 136, 138, 139, 140, 141, 142, 144, 145, 146, 147, 148, 149, 
      150, 151, 152, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 
      176, 177, 178, 179, 180, 181, 189, 191, 193, 195, 197, 198, 199, 200, 
      201, 202, 203, 204, 205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 
      219, 220, 221, 222, 227, 229, 231, 232, 233, 234, 237, 238, 239, 240, 
      241, 242, 243, 244, 245, 246, 247, 251, 252, 253, 254, 255, 256, 258, 
      259, 261, 263, 264, 265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 
      276, 277, 278, 279, 280, 281, 283, 286, 287, 288, 290, 293, 294, 295, 
      296, 298, 299, 301, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 
      314, 315, 316, 317, 318, 319, 320, 322, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      27, 29, 31, 32, 34, 36, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 
      51, 52, 53, 54, 56, 57, 58, 62, 65, 66, 68, 69, 70, 72, 74, 75, 76, 77, 
      78, 79, 80, 81, 83, 84, 85, 95, 96, 98, 99, 100, 101, 103, 104, 105, 
      107, 108, 109, 110, 111, 112, 114, 115, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 
      150, 151, 152, 162, 164, 165, 166, 167, 169, 170, 172, 176, 177, 178, 
      179, 180, 181, 188, 190, 192, 194, 195, 197, 207, 208, 209, 210, 211, 
      212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 230, 231, 235, 236, 
      241, 242, 244, 245, 251, 252, 255, 256, 257, 258, 259, 260, 261, 263, 
      265, 267, 268, 270, 271, 272, 273, 274, 275, 280, 281, 282, 283, 284, 
      285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 
      299, 300, 301, 302, 303, 320, 321, 322, 323, 324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 29, 34, 36, 38, 47, 48, 49, 52, 53, 54, 
      56, 62, 65, 66, 68, 69, 70, 72, 74, 75, 76, 77, 81, 84, 85, 96, 99, 
      104, 105, 107, 108, 112, 115, 116, 117, 176, 177, 178, 179, 180, 181, 
      192, 194, 197, 207, 208, 219, 220, 221, 222, 227, 230, 231, 235, 236, 
      245, 265, 267, 268, 281 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 31, 34, 37, 40, 41, 
      42, 44, 46, 47, 48, 49, 50, 52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 95, 
      97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 117, 120, 122, 123, 
      130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 147, 151, 
      152, 163, 166, 171, 172, 178, 181, 198, 200, 201, 203, 205, 206, 210, 
      211, 212, 215, 216, 219, 220, 221, 222, 237, 238, 239, 252, 254, 270, 
      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 293, 294, 295, 
      299, 306, 310, 312, 313, 316, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      31, 32, 34, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 
      56, 57, 58, 62, 65, 68, 70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 
      85, 95, 98, 99, 100, 101, 103, 104, 107, 108, 109, 110, 111, 112, 114, 
      115, 116, 117, 119, 120, 122, 123, 124, 126, 128, 129, 130, 131, 132, 
      133, 134, 135, 137, 138, 139, 140, 141, 143, 144, 146, 147, 148, 149, 
      151, 152, 164, 166, 170, 172, 178, 181, 192, 208, 209, 210, 211, 212, 
      213, 214, 215, 216, 219, 220, 221, 222, 227, 236, 241, 242, 244, 245, 
      252, 255, 257, 258, 260, 261, 270, 271, 272, 273, 274, 275, 280, 281, 
      285, 288, 292, 293, 294, 295, 299, 303, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      31, 32, 34, 37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 
      56, 57, 58, 59, 62, 65, 67, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
      82, 83, 84, 85, 95, 97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 
      111, 112, 113, 114, 115, 116, 117, 120, 122, 123, 124, 128, 129, 130, 
      131, 132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 147, 148, 149, 
      151, 152, 163, 164, 166, 168, 170, 171, 172, 178, 181, 189, 198, 199, 
      200, 201, 202, 203, 205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 
      219, 220, 221, 222, 227, 233, 234, 237, 238, 239, 240, 241, 242, 243, 
      244, 245, 246, 247, 252, 254, 255, 258, 261, 264, 269, 270, 271, 272, 
      273, 274, 275, 276, 277, 278, 279, 280, 281, 288, 293, 294, 295, 299, 
      306, 309, 310, 312, 313, 314, 315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 34, 38, 47, 48, 49, 52, 54, 56, 62, 65, 
      68, 70, 72, 74, 75, 76, 77, 81, 84, 85, 99, 104, 107, 108, 112, 115, 
      116, 117, 178, 181, 208, 219, 220, 221, 222, 227, 236, 245, 281 ], 
  [ 1, 2, 5, 14, 17, 36, 37, 39, 40, 41, 42, 49, 50, 52, 57, 58, 59, 79, 82, 
      83, 136, 138, 140, 150, 151, 152, 195, 198, 203, 210 ], 
  [ 1, 2, 5, 8, 25, 36, 38, 48, 49, 52, 56, 77, 81, 85, 96, 99, 179, 197, 222 
     ], [ 1, 2, 5, 36, 40, 41, 42, 49, 50, 52, 83, 210 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 36, 37, 
      39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 55, 56, 57, 58, 
      59, 63, 66, 67, 71, 72, 73, 74, 76, 77, 78, 79, 82, 83, 85, 86, 87, 88, 
      89, 92, 94, 95, 96, 97, 98, 99, 100, 101, 105, 106, 108, 109, 110, 113, 
      114, 115, 116, 117, 118, 120, 123, 125, 129, 131, 132, 134, 136, 138, 
      139, 140, 141, 142, 144, 147, 149, 150, 151, 152, 182, 183, 193, 195, 
      197, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 216, 218, 
      220, 222, 229, 231, 234, 237, 239, 240, 242, 247, 248, 250, 251, 252, 
      253, 254, 256, 258, 259, 261, 266, 268, 269, 271, 272, 273, 274, 275, 
      277, 278, 279, 280, 281, 283, 290, 295, 298, 299, 301, 311, 313, 315, 
      317, 318, 322, 324, 326, 327, 328 ], 
  [ 1, 2, 5, 8, 36, 48, 49, 52, 56, 77, 85, 96, 99, 222 ], 
  [ 1, 2, 14, 17, 37, 40, 41, 42, 49, 50, 52, 57, 58, 59, 138, 140, 151, 152, 
      203, 210 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 57, 58, 59, 73, 
      95, 97, 109, 110, 113 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 46, 47, 48, 49, 
      50, 52, 57, 58, 59, 73, 74, 95, 97, 99, 109, 110, 113, 114, 115, 116, 
      120, 131, 132, 138, 139, 140, 144, 151, 152, 198, 201, 203, 210, 237, 
      252, 254, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 8, 14, 15, 17, 37, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 59, 95, 
      97, 99, 138, 139, 140, 144, 151, 152, 198, 203, 210, 252, 254 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 52, 57, 58, 
      59, 73, 74, 95, 97, 99, 109, 110, 113, 116, 120, 132, 140, 144, 152, 
      199, 203, 210, 237, 252, 254, 272, 274, 278 ], 
  [ 1, 2, 14, 17, 37, 40, 41, 50, 52, 57, 58, 59, 140, 152, 210 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 37, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 53, 54, 56, 57, 58, 59, 77, 78, 79, 82, 83, 84, 85, 95, 96, 
      97, 98, 99, 100, 101, 105, 106, 108, 109, 110, 113, 114, 115, 116, 117, 
      125, 127, 128, 129, 131, 132, 133, 134, 136, 138, 139, 140, 141, 142, 
      144, 145, 146, 147, 150, 151, 152, 193, 195, 197, 198, 201, 203, 205, 
      206, 209, 210, 211, 212, 221, 222, 240, 241, 242, 246, 247, 251, 252, 
      253, 254, 256, 258, 259, 261, 266, 268, 269, 271, 272, 273, 274, 275, 
      277, 278, 279, 280, 281, 290, 294, 295, 298, 299, 301, 311, 312, 313, 
      322, 324, 326, 327, 328 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 50, 52, 54, 56, 57, 58, 59, 95, 
      97, 99, 109, 110, 113, 116, 117, 132, 133, 134, 140, 141, 144, 146, 
      147, 152, 203, 206, 210, 252, 254, 272, 273, 274, 275, 278, 279 ], 
  [ 1, 2, 8, 14, 15, 17, 37, 40, 41, 50, 52, 56, 57, 58, 59, 95, 97, 99, 140, 
      141, 144, 147, 152, 203, 210, 252, 254 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 36, 38, 48, 49, 52, 53, 54, 56, 77, 81, 84, 85, 
      96, 99, 104, 105, 107, 108, 112, 115, 116, 117, 179, 180, 181, 194, 
      197, 208, 221, 222, 245, 265, 267, 268, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 38, 48, 49, 52, 54, 56, 77, 81, 84, 85, 99, 104, 
      107, 108, 112, 115, 116, 117, 181, 221, 222, 245, 281 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 39, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 
      77, 78, 79, 83, 85, 95, 98, 99, 138, 139, 140, 141, 144, 147, 151, 152, 
      210, 212, 222, 242, 252, 299 ], [ 1, 2, 40, 41, 50, 52 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 54, 56, 58, 99, 110, 
      114, 115, 116, 117, 144, 146, 147, 151, 152, 210, 212, 221, 222, 274, 
      275, 280, 281 ], 
  [ 1, 2, 8, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 144, 147, 
      151, 152, 210, 222 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 43, 50, 51, 52, 54, 56, 57, 
      58, 74, 75, 76, 95, 99, 109, 110, 116, 117, 120, 122, 123, 132, 133, 
      134, 140, 141, 144, 146, 147, 152, 210, 214, 252, 272, 273, 274, 275 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 43, 50, 51, 52, 56, 57, 58, 
      74, 76, 95, 99, 109, 110, 116, 117, 120, 123, 132, 134, 140, 141, 144, 
      147, 152, 210, 252, 272, 273, 274, 275 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 42, 44, 46, 47, 48, 49, 50, 
      52, 54, 56, 57, 58, 74, 75, 76, 95, 99, 109, 110, 114, 115, 116, 117, 
      120, 122, 123, 131, 132, 133, 134, 138, 139, 140, 141, 144, 146, 147, 
      151, 152, 210, 211, 212, 216, 219, 220, 221, 222, 252, 271, 272, 273, 
      274, 275, 280, 281, 294, 295, 299, 327 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 40, 41, 42, 44, 46, 47, 48, 49, 50, 
      52, 56, 57, 58, 74, 76, 95, 99, 109, 110, 114, 115, 116, 117, 120, 123, 
      131, 132, 134, 138, 139, 140, 141, 144, 147, 151, 152, 210, 212, 220, 
      222, 252, 271, 272, 273, 274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 45, 46, 47, 
      48, 49, 50, 52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 89, 91, 92, 95, 97, 
      99, 109, 110, 113, 114, 115, 116, 117, 120, 122, 123, 131, 132, 133, 
      134, 138, 139, 140, 141, 144, 146, 147, 151, 152, 198, 200, 201, 203, 
      205, 206, 210, 211, 212, 215, 216, 218, 219, 220, 221, 222, 237, 238, 
      239, 252, 254, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 294, 
      295, 299, 312, 313, 316, 317, 327, 328 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 45, 46, 47, 
      48, 49, 50, 52, 56, 57, 58, 59, 73, 74, 76, 89, 92, 95, 97, 99, 109, 
      110, 113, 114, 115, 116, 117, 120, 123, 131, 132, 134, 138, 139, 140, 
      141, 144, 147, 151, 152, 198, 200, 201, 203, 206, 210, 212, 216, 220, 
      222, 237, 239, 252, 254, 271, 272, 273, 274, 275, 277, 278, 279, 280, 
      281, 295, 299, 313, 317, 327, 328 ], 
  [ 1, 2, 4, 8, 10, 47, 48, 49, 52, 54, 56, 74, 75, 76, 99, 115, 116, 117, 
      220, 221, 222, 281 ], 
  [ 1, 2, 4, 8, 10, 47, 48, 49, 52, 56, 74, 76, 99, 115, 116, 117, 222, 281 ],
  [ 1, 2, 8, 10, 48, 49, 52, 54, 56, 99, 115, 116, 117, 222, 281 ], 
  [ 1, 2, 8, 48, 49, 52, 56, 99 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 
      57, 58, 59, 60, 62, 66, 67, 68, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 
      83, 85, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 123, 
      124, 125, 126, 129, 130, 131, 132, 134, 135, 136, 137, 138, 139, 140, 
      141, 142, 143, 144, 147, 149, 150, 151, 152, 159, 162, 163, 164, 167, 
      168, 171, 176, 179, 193, 194, 195, 197, 198, 199, 200, 201, 202, 203, 
      206, 209, 210, 212, 214, 216, 220, 222, 229, 230, 231, 234, 237, 239, 
      240, 242, 243, 247, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 
      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 273, 274, 
      275, 276, 277, 278, 279, 280, 281, 282, 283, 286, 289, 290, 295, 296, 
      297, 298, 299, 300, 301, 304, 307, 311, 313, 315, 317, 318, 320, 321, 
      322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 36, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 
      54, 56, 57, 58, 59, 60, 62, 66, 67, 68, 69, 70, 72, 73, 74, 75, 76, 77, 
      78, 79, 80, 81, 82, 83, 84, 85, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
      104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
      118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 
      132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 
      146, 147, 148, 149, 150, 151, 152, 159, 160, 161, 162, 163, 164, 165, 
      166, 167, 168, 169, 170, 171, 172, 176, 177, 178, 179, 180, 181, 193, 
      194, 195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 
      209, 210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 223, 225, 
      227, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239, 240, 241, 
      242, 243, 244, 245, 246, 247, 251, 252, 253, 254, 255, 256, 257, 258, 
      259, 260, 261, 262, 263, 264, 265, 266, 267, 268, 269, 270, 271, 272, 
      273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 
      287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 
      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 
      315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 21, 22, 24, 
      25, 37, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 
      57, 58, 59, 60, 62, 67, 68, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
      82, 83, 84, 85, 95, 97, 98, 99, 100, 101, 102, 103, 104, 106, 107, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 119, 120, 122, 123, 124, 
      126, 128, 129, 130, 131, 132, 133, 134, 135, 137, 138, 139, 140, 141, 
      143, 144, 146, 147, 148, 149, 151, 152, 161, 163, 164, 166, 168, 170, 
      171, 172, 178, 181, 198, 199, 200, 201, 202, 203, 205, 206, 208, 209, 
      210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 233, 234, 
      236, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 252, 254, 
      255, 257, 258, 260, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 
      277, 278, 279, 280, 281, 285, 288, 292, 293, 294, 295, 299, 303, 306, 
      309, 310, 312, 313, 314, 315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 
      23, 24, 25, 37, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 
      54, 56, 57, 58, 59, 61, 62, 67, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 
      81, 82, 83, 84, 85, 87, 88, 89, 91, 92, 93, 94, 95, 97, 98, 99, 100, 
      101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
      120, 122, 123, 124, 128, 129, 130, 131, 132, 133, 134, 135, 138, 139, 
      140, 141, 144, 146, 147, 148, 149, 151, 152, 163, 164, 166, 168, 170, 
      171, 172, 175, 178, 181, 198, 199, 200, 201, 202, 203, 205, 206, 209, 
      210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 227, 
      233, 234, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 249, 
      250, 252, 254, 255, 258, 261, 264, 269, 270, 271, 272, 273, 274, 275, 
      276, 277, 278, 279, 280, 281, 288, 293, 294, 295, 299, 306, 309, 310, 
      312, 313, 314, 315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 47, 48, 49, 52, 54, 56, 62, 70, 72, 74, 
      75, 76, 77, 81, 84, 85, 99, 104, 108, 112, 115, 116, 117, 178, 181, 
      219, 220, 221, 222, 245, 281 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 26, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 54, 55, 56, 57, 58, 
      59, 63, 67, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 82, 83, 84, 85, 87, 
      88, 89, 91, 92, 93, 94, 95, 97, 98, 99, 100, 101, 106, 108, 109, 110, 
      113, 114, 115, 116, 117, 120, 122, 123, 128, 129, 131, 132, 133, 134, 
      138, 139, 140, 141, 144, 146, 147, 148, 149, 151, 152, 183, 185, 198, 
      199, 200, 201, 202, 203, 205, 206, 209, 210, 211, 212, 213, 214, 215, 
      216, 217, 218, 219, 220, 221, 222, 233, 234, 237, 238, 239, 240, 241, 
      242, 246, 247, 249, 250, 252, 254, 258, 261, 269, 271, 272, 273, 274, 
      275, 277, 278, 279, 280, 281, 294, 295, 299, 312, 313, 314, 315, 316, 
      317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 40, 41, 
      42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 57, 58, 59, 66, 67, 73, 74, 77, 
      78, 79, 82, 83, 95, 96, 97, 98, 99, 100, 101, 105, 106, 109, 110, 113, 
      114, 115, 116, 118, 120, 125, 131, 132, 136, 138, 139, 140, 142, 144, 
      150, 151, 152, 193, 195, 198, 199, 200, 201, 202, 203, 210, 237, 240, 
      251, 252, 253, 254, 256, 259, 266, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 36, 38, 47, 48, 49, 52, 56, 62, 66, 68, 
      72, 74, 76, 77, 81, 85, 96, 99, 104, 105, 107, 108, 112, 115, 116, 117, 
      176, 179, 194, 197, 220, 222, 231, 265, 267, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 36, 47, 48, 49, 52, 56, 66, 72, 74, 76, 77, 85, 
      96, 99, 105, 108, 115, 116, 117, 197, 220, 222, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 40, 41, 
      42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 57, 58, 59, 66, 67, 
      69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 82, 83, 84, 85, 95, 96, 97, 98, 
      99, 100, 101, 105, 106, 108, 109, 110, 113, 114, 115, 116, 117, 118, 
      120, 121, 122, 123, 125, 127, 128, 129, 131, 132, 133, 134, 136, 138, 
      139, 140, 141, 142, 144, 145, 146, 147, 148, 149, 150, 151, 152, 193, 
      195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 209, 210, 211, 
      212, 213, 214, 215, 216, 219, 220, 221, 222, 229, 231, 233, 234, 237, 
      238, 239, 240, 241, 242, 246, 247, 251, 252, 253, 254, 256, 258, 259, 
      261, 266, 268, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 
      283, 290, 294, 295, 298, 299, 301, 311, 312, 313, 314, 315, 316, 317, 
      318, 322, 324, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 59, 67, 70, 72, 73, 
      74, 75, 76, 77, 78, 79, 82, 83, 84, 85, 95, 97, 98, 99, 100, 101, 106, 
      108, 109, 110, 113, 114, 115, 116, 117, 120, 122, 123, 128, 129, 131, 
      132, 133, 134, 138, 139, 140, 141, 144, 146, 147, 148, 149, 151, 152, 
      198, 199, 200, 201, 202, 203, 205, 206, 209, 210, 211, 212, 213, 214, 
      215, 216, 219, 220, 221, 222, 234, 237, 238, 239, 240, 241, 242, 246, 
      247, 252, 254, 258, 261, 269, 271, 272, 273, 274, 275, 277, 278, 279, 
      280, 281, 294, 295, 299, 312, 313, 314, 315, 316, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 37, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 59, 67, 72, 73, 74, 76, 
      77, 78, 79, 82, 83, 85, 95, 97, 98, 99, 100, 101, 106, 108, 109, 110, 
      113, 114, 115, 116, 117, 120, 123, 129, 131, 132, 134, 138, 139, 140, 
      141, 144, 147, 149, 151, 152, 198, 199, 200, 201, 202, 203, 206, 209, 
      210, 212, 214, 216, 220, 222, 237, 239, 240, 242, 247, 252, 254, 258, 
      261, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 295, 299, 
      313, 315, 317, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 36, 38, 47, 48, 49, 52, 53, 54, 56, 62, 
      66, 68, 69, 70, 72, 74, 75, 76, 77, 81, 84, 85, 96, 99, 104, 105, 107, 
      108, 112, 115, 116, 117, 176, 177, 178, 179, 180, 181, 194, 197, 207, 
      208, 219, 220, 221, 222, 227, 230, 231, 236, 245, 265, 267, 268, 281 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 24, 25, 38, 47, 48, 49, 52, 54, 56, 62, 68, 70, 
      72, 74, 75, 76, 77, 81, 84, 85, 99, 104, 107, 108, 112, 115, 116, 117, 
      178, 181, 208, 219, 220, 221, 222, 227, 245, 281 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 57, 58, 59, 73, 
      74, 95, 97, 99, 109, 110, 113, 116, 120, 132, 140, 144, 152, 203, 210, 
      252, 254, 272, 274, 278 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 54, 56, 57, 58, 
      59, 73, 74, 75, 76, 95, 97, 99, 109, 110, 113, 116, 117, 120, 122, 123, 
      132, 133, 134, 140, 141, 144, 146, 147, 152, 203, 205, 206, 210, 237, 
      239, 252, 254, 272, 273, 274, 275, 278, 279 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 50, 52, 56, 57, 58, 59, 
      73, 74, 76, 95, 97, 99, 109, 110, 113, 116, 117, 120, 123, 132, 134, 
      140, 141, 144, 147, 152, 203, 206, 210, 237, 252, 254, 272, 273, 274, 
      275, 278, 279 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 37, 39, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 
      59, 77, 78, 79, 82, 83, 95, 97, 98, 99, 138, 139, 140, 144, 151, 152, 
      198, 201, 203, 210, 252, 254 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 54, 56, 58, 
      77, 78, 79, 83, 84, 85, 99, 101, 108, 110, 114, 115, 116, 117, 144, 
      146, 147, 151, 152, 210, 211, 212, 221, 222, 242, 261, 274, 275, 280, 
      281 ], 
  [ 1, 2, 5, 8, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 77, 78, 79, 
      83, 85, 99, 144, 147, 151, 152, 210, 212, 222 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 37, 39, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 97, 98, 99, 135, 
      138, 139, 140, 141, 144, 147, 151, 152, 163, 164, 198, 201, 203, 206, 
      209, 210, 212, 222, 240, 242, 247, 252, 254, 299, 313 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 54, 
      56, 58, 77, 78, 79, 80, 81, 83, 84, 85, 99, 101, 103, 104, 108, 110, 
      111, 112, 114, 115, 116, 117, 144, 146, 147, 151, 152, 166, 181, 210, 
      211, 212, 221, 222, 241, 242, 245, 261, 274, 275, 280, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 48, 49, 52, 54, 56, 77, 81, 84, 85, 99, 104, 108, 
      112, 115, 116, 117, 181, 221, 222, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 37, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 54, 56, 57, 58, 59, 77, 78, 79, 82, 83, 84, 85, 95, 97, 98, 99, 
      100, 101, 106, 108, 109, 110, 113, 114, 115, 116, 117, 128, 129, 131, 
      132, 133, 134, 138, 139, 140, 141, 144, 146, 147, 151, 152, 198, 201, 
      203, 205, 206, 209, 210, 211, 212, 221, 222, 240, 241, 242, 247, 252, 
      254, 258, 261, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 
      294, 295, 299, 312, 313, 327, 328 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 37, 39, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 
      58, 59, 77, 78, 79, 82, 83, 85, 95, 97, 98, 99, 138, 139, 140, 141, 
      144, 147, 151, 152, 198, 201, 203, 206, 209, 210, 212, 222, 240, 242, 
      252, 254, 299, 313 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 59, 66, 
      67, 72, 73, 74, 76, 77, 78, 79, 82, 83, 85, 86, 87, 88, 89, 92, 94, 95, 
      96, 97, 98, 99, 100, 101, 105, 106, 108, 109, 110, 113, 114, 115, 116, 
      117, 118, 120, 123, 125, 129, 131, 132, 134, 136, 138, 139, 140, 141, 
      142, 144, 147, 149, 150, 151, 152, 193, 195, 197, 198, 199, 200, 201, 
      202, 203, 206, 209, 210, 212, 214, 216, 218, 220, 222, 229, 231, 234, 
      237, 239, 240, 242, 247, 250, 251, 252, 253, 254, 256, 258, 259, 261, 
      266, 268, 269, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 283, 
      290, 295, 298, 299, 301, 311, 313, 315, 317, 318, 322, 324, 326, 327, 
      328 ], [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 
      52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 87, 88, 89, 91, 92, 95, 97, 99, 
      109, 110, 113, 116, 117, 120, 122, 123, 132, 133, 134, 140, 141, 144, 
      146, 147, 152, 199, 202, 203, 205, 206, 210, 213, 214, 237, 238, 239, 
      250, 252, 254, 272, 273, 274, 275, 278, 279, 314, 315 ], 
  [ 1, 2, 4, 6, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 52, 56, 
      57, 58, 59, 73, 74, 76, 87, 88, 89, 92, 95, 97, 99, 109, 110, 113, 116, 
      117, 120, 123, 132, 134, 140, 141, 144, 147, 152, 199, 202, 203, 206, 
      210, 214, 237, 239, 252, 254, 272, 273, 274, 275, 278, 279, 315 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 36, 39, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 
      77, 78, 79, 83, 95, 96, 98, 99, 136, 138, 139, 140, 142, 144, 150, 151, 
      152, 195, 210, 252 ], 
  [ 1, 2, 8, 14, 15, 17, 40, 41, 50, 52, 57, 58, 95, 99, 140, 144, 152, 210 ],
  [ 1, 2, 5, 8, 14, 15, 17, 36, 37, 39, 40, 41, 42, 46, 48, 49, 50, 52, 57, 
      58, 59, 77, 78, 79, 82, 83, 95, 96, 97, 98, 99, 136, 138, 139, 140, 
      142, 144, 150, 151, 152, 193, 195, 198, 201, 203, 210, 240, 251, 252, 
      254 ], 
  [ 1, 2, 8, 14, 15, 17, 37, 40, 41, 50, 52, 57, 58, 59, 95, 97, 99, 140, 
      144, 152, 203, 210, 252 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 100, 
      101, 103, 104, 108, 109, 110, 111, 112, 114, 115, 116, 117, 124, 129, 
      130, 131, 132, 134, 135, 138, 139, 140, 141, 144, 147, 151, 152, 164, 
      209, 210, 212, 222, 242, 252, 258, 261, 270, 271, 272, 273, 274, 275, 
      280, 281, 295, 299, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 57, 58, 77, 78, 79, 83, 95, 96, 98, 99, 100, 101, 105, 109, 
      110, 114, 115, 116, 125, 131, 132, 136, 138, 139, 140, 142, 144, 150, 
      151, 152, 195, 210, 251, 252, 259, 271, 272, 274 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 38, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 98, 99, 
      100, 101, 103, 104, 107, 108, 109, 110, 111, 112, 114, 115, 116, 117, 
      124, 126, 129, 130, 131, 132, 134, 135, 137, 138, 139, 140, 141, 143, 
      144, 147, 151, 152, 164, 209, 210, 212, 222, 242, 252, 255, 258, 260, 
      261, 270, 271, 272, 273, 274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 57, 58, 77, 78, 79, 83, 85, 95, 98, 99, 100, 101, 108, 109, 
      110, 114, 115, 116, 117, 129, 131, 132, 134, 138, 139, 140, 141, 144, 
      147, 151, 152, 209, 210, 212, 222, 242, 252, 261, 271, 272, 273, 274, 
      275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 58, 77, 
      78, 79, 83, 96, 99, 101, 105, 110, 114, 115, 116, 142, 144, 150, 151, 
      152, 195, 210, 274 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 38, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 58, 77, 78, 79, 80, 81, 83, 85, 99, 101, 103, 104, 107, 108, 110, 
      111, 112, 114, 115, 116, 117, 143, 144, 147, 151, 152, 210, 212, 222, 
      242, 261, 274, 275, 280, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 77, 
      78, 79, 83, 85, 99, 101, 108, 110, 114, 115, 116, 117, 144, 147, 151, 
      152, 210, 212, 222, 242, 274, 275, 280, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 19, 20, 25, 36, 37, 38, 39, 40, 
      41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 
      85, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 124, 125, 126, 129, 130, 
      131, 132, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 147, 
      150, 151, 152, 159, 162, 163, 164, 179, 193, 194, 195, 197, 198, 201, 
      203, 206, 209, 210, 212, 222, 240, 242, 243, 247, 251, 252, 253, 254, 
      255, 256, 257, 258, 259, 260, 261, 263, 264, 265, 266, 267, 268, 269, 
      270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 286, 289, 
      290, 295, 296, 297, 298, 299, 300, 301, 304, 311, 313, 320, 321, 322, 
      323, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 36, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 58, 77, 78, 79, 80, 81, 83, 85, 96, 99, 101, 103, 104, 105, 108, 
      110, 111, 112, 114, 115, 116, 117, 142, 144, 147, 150, 151, 152, 162, 
      179, 195, 197, 210, 212, 222, 242, 259, 261, 265, 268, 274, 275, 280, 
      281, 301, 324 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 37, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 97, 
      98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 114, 
      115, 116, 117, 124, 129, 130, 131, 132, 134, 135, 138, 139, 140, 141, 
      144, 147, 151, 152, 163, 164, 198, 201, 203, 206, 209, 210, 212, 222, 
      240, 242, 243, 247, 252, 254, 255, 258, 261, 269, 270, 271, 272, 273, 
      274, 275, 276, 277, 278, 279, 280, 281, 295, 299, 313, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 36, 48, 49, 52, 56, 77, 81, 85, 96, 99, 104, 105, 
      108, 112, 115, 116, 117, 179, 197, 222, 268, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 37, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 57, 58, 59, 77, 78, 79, 82, 83, 95, 96, 97, 98, 99, 100, 
      101, 105, 106, 109, 110, 113, 114, 115, 116, 125, 131, 132, 136, 138, 
      139, 140, 142, 144, 150, 151, 152, 193, 195, 198, 201, 203, 210, 240, 
      251, 252, 253, 254, 256, 259, 271, 272, 274, 277, 278 ], 
  [ 1, 2, 5, 8, 9, 10, 25, 36, 38, 48, 49, 52, 56, 77, 81, 85, 96, 99, 104, 
      105, 107, 108, 112, 115, 116, 117, 179, 194, 197, 222, 265, 268, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 36, 48, 49, 52, 56, 77, 85, 96, 99, 105, 108, 115, 
      116, 117, 197, 222, 281 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 37, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 56, 57, 58, 59, 77, 78, 79, 82, 83, 85, 95, 97, 98, 99, 100, 
      101, 106, 108, 109, 110, 113, 114, 115, 116, 117, 129, 131, 132, 134, 
      138, 139, 140, 141, 144, 147, 151, 152, 198, 201, 203, 206, 209, 210, 
      212, 222, 240, 242, 247, 252, 254, 258, 261, 271, 272, 273, 274, 275, 
      277, 278, 279, 280, 281, 295, 299, 313, 327, 328 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      57, 58, 95, 99, 109, 110, 111, 112, 114, 115, 116, 117, 130, 131, 132, 
      134, 135, 138, 139, 140, 141, 144, 147, 151, 152, 210, 212, 222, 252, 
      271, 272, 273, 274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 95, 
      99, 109, 110, 114, 115, 116, 131, 132, 138, 139, 140, 144, 151, 152, 
      210, 252, 272, 274 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 50, 52, 57, 58, 95, 99, 109, 110, 
      116, 132, 140, 144, 152, 210, 252, 274 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 50, 52, 56, 57, 58, 95, 99, 109, 
      110, 116, 117, 132, 134, 140, 141, 144, 147, 152, 210, 252, 272, 274, 
      275 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 50, 52, 58, 99, 110, 116, 144, 152, 210 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 50, 52, 56, 58, 99, 110, 116, 117, 144, 147, 
      152, 210, 274 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 20, 25, 37, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 57, 58, 59, 95, 97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 
      117, 130, 131, 132, 134, 135, 138, 139, 140, 141, 144, 147, 151, 152, 
      163, 198, 201, 203, 206, 210, 212, 222, 252, 254, 270, 271, 272, 273, 
      274, 275, 277, 278, 279, 280, 281, 295, 299, 313, 327, 328 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 42, 46, 48, 49, 50, 52, 57, 58, 
      59, 95, 97, 99, 109, 110, 113, 114, 115, 116, 131, 132, 138, 139, 140, 
      144, 151, 152, 198, 201, 203, 210, 252, 254, 271, 272, 274, 278 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 50, 52, 57, 58, 59, 95, 97, 99, 
      109, 110, 113, 116, 132, 140, 144, 152, 203, 210, 252, 254, 272, 274 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 50, 52, 56, 57, 58, 59, 95, 97, 
      99, 109, 110, 113, 116, 117, 132, 134, 140, 141, 144, 147, 152, 203, 
      206, 210, 252, 254, 272, 273, 274, 275, 278 ], 
  [ 1, 2, 8, 10, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 110, 
      114, 115, 116, 117, 144, 147, 151, 152, 210, 212, 222, 274, 275, 281 ], 
  [ 1, 2, 8, 10, 48, 49, 52, 56, 99, 115, 116, 117, 222 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 
      62, 66, 68, 72, 74, 76, 77, 78, 79, 80, 81, 83, 85, 95, 96, 98, 99, 
      100, 101, 103, 104, 105, 107, 108, 109, 110, 111, 112, 114, 115, 116, 
      117, 118, 119, 120, 123, 124, 125, 126, 129, 130, 131, 132, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 147, 149, 150, 151, 152, 
      162, 164, 167, 176, 179, 194, 195, 197, 209, 210, 212, 214, 216, 220, 
      222, 230, 231, 242, 251, 252, 255, 256, 257, 258, 259, 260, 261, 263, 
      265, 267, 268, 270, 271, 272, 273, 274, 275, 280, 281, 283, 286, 289, 
      290, 295, 296, 297, 298, 299, 300, 301, 320, 321, 322, 323, 324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 39, 40, 41, 42, 
      43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 66, 72, 74, 76, 77, 78, 
      79, 83, 85, 95, 96, 98, 99, 100, 101, 105, 108, 109, 110, 114, 115, 
      116, 117, 118, 120, 123, 125, 129, 131, 132, 134, 136, 138, 139, 140, 
      141, 142, 144, 147, 149, 150, 151, 152, 195, 197, 209, 210, 212, 214, 
      216, 220, 222, 231, 242, 251, 252, 256, 258, 259, 261, 268, 271, 272, 
      273, 274, 275, 280, 281, 290, 295, 298, 299, 301, 322, 324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 
      57, 58, 62, 66, 68, 69, 70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 
      85, 95, 96, 98, 99, 100, 101, 103, 104, 105, 107, 108, 109, 110, 111, 
      112, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 
      127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 
      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 162, 164, 
      165, 166, 167, 169, 170, 172, 176, 177, 178, 179, 180, 181, 194, 195, 
      197, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 
      222, 227, 230, 231, 235, 236, 241, 242, 244, 245, 251, 252, 255, 256, 
      257, 258, 259, 260, 261, 263, 265, 267, 268, 270, 271, 272, 273, 274, 
      275, 280, 281, 282, 283, 285, 286, 287, 288, 289, 290, 291, 292, 293, 
      294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 320, 321, 322, 323, 
      324, 327 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      38, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 
      62, 68, 70, 72, 74, 75, 76, 77, 78, 79, 80, 81, 83, 84, 85, 95, 98, 99, 
      100, 101, 103, 104, 107, 108, 109, 110, 111, 112, 114, 115, 116, 117, 
      119, 120, 122, 123, 124, 126, 128, 129, 130, 131, 132, 133, 134, 135, 
      137, 138, 139, 140, 141, 143, 144, 146, 147, 148, 149, 151, 152, 164, 
      166, 170, 172, 178, 181, 208, 209, 210, 211, 212, 213, 214, 215, 216, 
      219, 220, 221, 222, 227, 236, 241, 242, 244, 245, 252, 255, 257, 258, 
      260, 261, 270, 271, 272, 273, 274, 275, 280, 281, 288, 292, 293, 294, 
      295, 299, 303, 327 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 20, 25, 36, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 58, 77, 78, 79, 80, 81, 83, 85, 96, 99, 124, 125, 129, 130, 131, 
      132, 134, 142, 144, 147, 150, 151, 152, 162, 179, 195, 197, 210, 212, 
      222, 242, 290, 295, 301 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 53, 54, 56, 57, 58, 77, 78, 79, 80, 81, 83, 84, 85, 95, 
      96, 98, 99, 100, 101, 103, 104, 105, 108, 109, 110, 111, 112, 114, 115, 
      116, 117, 124, 125, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
      138, 139, 140, 141, 142, 144, 145, 146, 147, 150, 151, 152, 162, 164, 
      165, 166, 179, 180, 181, 195, 197, 209, 210, 211, 212, 221, 222, 241, 
      242, 244, 245, 251, 252, 255, 256, 258, 259, 261, 263, 265, 268, 270, 
      271, 272, 273, 274, 275, 280, 281, 286, 288, 290, 293, 294, 295, 296, 
      298, 299, 301, 320, 322, 324, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 54, 56, 57, 58, 77, 78, 79, 80, 81, 83, 84, 85, 95, 98, 99, 
      100, 101, 103, 104, 108, 109, 110, 111, 112, 114, 115, 116, 117, 124, 
      128, 129, 130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 
      147, 151, 152, 164, 166, 181, 209, 210, 211, 212, 221, 222, 241, 242, 
      244, 245, 252, 255, 258, 261, 270, 271, 272, 273, 274, 275, 280, 281, 
      293, 294, 295, 299, 327 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 20, 25, 36, 38, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 58, 77, 78, 79, 80, 81, 83, 85, 96, 99, 124, 125, 126, 129, 
      130, 131, 132, 134, 142, 143, 144, 147, 150, 151, 152, 162, 179, 194, 
      195, 197, 210, 212, 222, 242, 286, 290, 295, 300, 301 ], 
  [ 1, 2, 5, 8, 12, 13, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 
      77, 78, 79, 83, 85, 96, 99, 125, 129, 131, 132, 134, 142, 144, 147, 
      150, 151, 152, 195, 197, 210, 212, 222, 242, 295, 301 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 38, 39, 40, 41, 42, 
      46, 48, 49, 50, 52, 53, 54, 56, 57, 58, 77, 78, 79, 80, 81, 83, 84, 85, 
      95, 96, 98, 99, 100, 101, 103, 104, 105, 107, 108, 109, 110, 111, 112, 
      114, 115, 116, 117, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 
      134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 
      150, 151, 152, 162, 164, 165, 166, 179, 180, 181, 194, 195, 197, 207, 
      208, 209, 210, 211, 212, 221, 222, 241, 242, 244, 245, 251, 252, 255, 
      256, 257, 258, 259, 260, 261, 263, 265, 267, 268, 270, 271, 272, 273, 
      274, 275, 280, 281, 286, 287, 288, 289, 290, 292, 293, 294, 295, 296, 
      297, 298, 299, 300, 301, 302, 303, 320, 321, 322, 323, 324, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 38, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 54, 56, 57, 58, 77, 78, 79, 80, 81, 83, 84, 85, 95, 98, 
      99, 100, 101, 103, 104, 107, 108, 109, 110, 111, 112, 114, 115, 116, 
      117, 124, 126, 128, 129, 130, 131, 132, 133, 134, 135, 137, 138, 139, 
      140, 141, 143, 144, 146, 147, 151, 152, 164, 166, 181, 208, 209, 210, 
      211, 212, 221, 222, 241, 242, 244, 245, 252, 255, 257, 258, 260, 261, 
      270, 271, 272, 273, 274, 275, 280, 281, 288, 293, 294, 295, 299, 303, 
      327 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 20, 25, 40, 41, 42, 46, 48, 49, 50, 52, 54, 
      56, 57, 58, 95, 99, 109, 110, 111, 112, 114, 115, 116, 117, 130, 131, 
      132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 147, 151, 152, 166, 
      181, 210, 211, 212, 221, 222, 252, 270, 271, 272, 273, 274, 275, 280, 
      281, 294, 295, 299, 327 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 54, 56, 57, 
      58, 95, 99, 109, 110, 114, 115, 116, 117, 131, 132, 133, 134, 138, 139, 
      140, 141, 144, 146, 147, 151, 152, 210, 211, 212, 221, 222, 252, 271, 
      272, 273, 274, 275, 280, 281, 295, 299, 327 ], 
  [ 1, 2, 8, 13, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 99, 131, 
      132, 134, 144, 147, 151, 152, 210, 212, 222 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 36, 39, 40, 41, 42, 46, 48, 49, 50, 52, 
      56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 96, 98, 99, 135, 136, 138, 
      139, 140, 141, 142, 144, 147, 150, 151, 152, 162, 164, 179, 195, 197, 
      209, 210, 212, 222, 242, 251, 252, 298, 299, 301 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 36, 38, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 96, 98, 99, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 147, 150, 151, 152, 162, 164, 
      179, 194, 195, 197, 209, 210, 212, 222, 242, 251, 252, 296, 298, 299, 
      300, 301 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 36, 39, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 
      58, 77, 78, 79, 83, 85, 95, 96, 98, 99, 136, 138, 139, 140, 141, 142, 
      144, 147, 150, 151, 152, 195, 197, 209, 210, 212, 222, 242, 251, 252, 
      299, 301 ], 
  [ 1, 2, 8, 14, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 95, 99, 
      138, 139, 140, 141, 144, 147, 151, 152, 210, 212, 222, 252 ], 
  [ 1, 2, 5, 8, 15, 17, 20, 25, 36, 38, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      58, 77, 78, 79, 80, 81, 83, 85, 96, 99, 142, 143, 144, 147, 150, 151, 
      152, 162, 179, 194, 195, 197, 210, 212, 222, 242, 301 ], 
  [ 1, 2, 5, 8, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 77, 78, 
      79, 83, 85, 96, 99, 142, 144, 147, 150, 151, 152, 195, 197, 210, 212, 
      222, 242 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 36, 38, 40, 41, 42, 46, 48, 49, 50, 
      52, 53, 54, 56, 58, 77, 78, 79, 80, 81, 83, 84, 85, 96, 99, 101, 103, 
      104, 105, 107, 108, 110, 111, 112, 114, 115, 116, 117, 142, 143, 144, 
      145, 146, 147, 150, 151, 152, 162, 165, 166, 179, 180, 181, 194, 195, 
      197, 207, 208, 210, 211, 212, 221, 222, 241, 242, 244, 245, 259, 260, 
      261, 263, 265, 267, 268, 274, 275, 280, 281, 300, 301, 303, 323, 324 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 38, 40, 41, 42, 46, 48, 49, 50, 52, 
      54, 56, 58, 77, 78, 79, 80, 81, 83, 84, 85, 99, 101, 103, 104, 107, 
      108, 110, 111, 112, 114, 115, 116, 117, 143, 144, 146, 147, 151, 152, 
      166, 181, 208, 210, 211, 212, 221, 222, 241, 242, 244, 245, 260, 261, 
      274, 275, 280, 281 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 20, 25, 36, 37, 39, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 96, 97, 98, 99, 
      135, 136, 138, 139, 140, 141, 142, 144, 147, 150, 151, 152, 162, 163, 
      164, 179, 193, 195, 197, 198, 201, 203, 206, 209, 210, 212, 222, 240, 
      242, 243, 247, 251, 252, 253, 254, 296, 298, 299, 301, 311, 313 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 37, 39, 40, 41, 42, 
      46, 48, 49, 50, 52, 53, 54, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 
      84, 85, 95, 96, 97, 98, 99, 100, 101, 103, 104, 105, 106, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 124, 125, 127, 128, 129, 130, 
      131, 132, 133, 134, 135, 136, 138, 139, 140, 141, 142, 144, 145, 146, 
      147, 150, 151, 152, 162, 163, 164, 165, 166, 179, 180, 181, 193, 195, 
      197, 198, 201, 203, 204, 205, 206, 209, 210, 211, 212, 221, 222, 240, 
      241, 242, 243, 244, 245, 246, 247, 251, 252, 253, 254, 255, 256, 258, 
      259, 261, 263, 264, 265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 
      276, 277, 278, 279, 280, 281, 286, 287, 288, 290, 293, 294, 295, 296, 
      298, 299, 301, 304, 306, 311, 312, 313, 319, 320, 322, 324, 325, 326, 
      327, 328 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 20, 25, 37, 40, 41, 42, 46, 48, 49, 50, 52, 
      54, 56, 57, 58, 59, 95, 97, 99, 109, 110, 111, 112, 113, 114, 115, 116, 
      117, 130, 131, 132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 147, 
      151, 152, 163, 166, 181, 198, 201, 203, 205, 206, 210, 211, 212, 221, 
      222, 252, 254, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 
      281, 293, 294, 295, 299, 312, 313, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 
      59, 62, 66, 67, 72, 73, 74, 76, 77, 78, 79, 80, 81, 82, 83, 85, 95, 96, 
      97, 98, 99, 100, 101, 103, 104, 105, 106, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 118, 120, 123, 124, 125, 129, 130, 131, 132, 134, 
      135, 136, 138, 139, 140, 141, 142, 144, 147, 149, 150, 151, 152, 162, 
      163, 164, 167, 168, 171, 176, 179, 193, 195, 197, 198, 199, 200, 201, 
      202, 203, 206, 209, 210, 212, 214, 216, 220, 222, 229, 231, 234, 237, 
      239, 240, 242, 243, 247, 251, 252, 253, 254, 255, 256, 258, 259, 261, 
      263, 264, 265, 266, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 
      278, 279, 280, 281, 283, 286, 290, 295, 296, 298, 299, 301, 304, 311, 
      313, 315, 317, 318, 320, 322, 324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      36, 37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 53, 54, 56, 
      57, 58, 59, 62, 66, 67, 69, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
      82, 83, 84, 85, 95, 96, 97, 98, 99, 100, 101, 103, 104, 105, 106, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 120, 121, 122, 123, 
      124, 125, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 138, 139, 
      140, 141, 142, 144, 145, 146, 147, 148, 149, 150, 151, 152, 162, 163, 
      164, 165, 166, 167, 168, 169, 170, 171, 172, 176, 177, 178, 179, 180, 
      181, 193, 195, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 209, 
      210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 227, 229, 231, 
      232, 233, 234, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
      251, 252, 253, 254, 255, 256, 258, 259, 261, 263, 264, 265, 266, 268, 
      269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 283, 
      286, 287, 288, 290, 293, 294, 295, 296, 298, 299, 301, 304, 305, 306, 
      307, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 319, 320, 322, 
      324, 325, 326, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 20, 21, 22, 24, 25, 
      37, 39, 40, 41, 42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 54, 56, 57, 58, 
      59, 62, 67, 70, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
      95, 97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 120, 122, 123, 124, 128, 129, 130, 131, 132, 133, 
      134, 135, 138, 139, 140, 141, 144, 146, 147, 148, 149, 151, 152, 163, 
      164, 166, 168, 170, 171, 172, 178, 181, 198, 199, 200, 201, 202, 203, 
      205, 206, 209, 210, 211, 212, 213, 214, 215, 216, 219, 220, 221, 222, 
      227, 233, 234, 237, 238, 239, 240, 241, 242, 243, 244, 245, 246, 247, 
      252, 254, 255, 258, 261, 264, 269, 270, 271, 272, 273, 274, 275, 276, 
      277, 278, 279, 280, 281, 288, 293, 294, 295, 299, 306, 310, 312, 313, 
      314, 315, 316, 317, 319, 327, 328 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 20, 22, 24, 25, 37, 40, 41, 42, 44, 
      46, 47, 48, 49, 50, 52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 95, 97, 99, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 120, 122, 123, 130, 131, 
      132, 133, 134, 135, 138, 139, 140, 141, 144, 146, 147, 151, 152, 163, 
      166, 171, 172, 178, 181, 198, 200, 201, 203, 205, 206, 210, 211, 212, 
      215, 216, 219, 220, 221, 222, 237, 238, 239, 252, 254, 270, 271, 272, 
      273, 274, 275, 276, 277, 278, 279, 280, 281, 293, 294, 295, 299, 306, 
      312, 313, 316, 317, 327, 328 ], 
  [ 1, 2, 5, 8, 14, 15, 17, 36, 37, 39, 40, 41, 42, 46, 48, 49, 50, 52, 56, 
      57, 58, 59, 77, 78, 79, 82, 83, 85, 95, 96, 97, 98, 99, 136, 138, 139, 
      140, 141, 142, 144, 147, 150, 151, 152, 193, 195, 197, 198, 201, 203, 
      206, 209, 210, 212, 222, 240, 242, 247, 251, 252, 253, 254, 298, 299, 
      301, 313 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 42, 46, 48, 49, 50, 52, 54, 56, 
      57, 58, 59, 95, 97, 99, 109, 110, 113, 114, 115, 116, 117, 131, 132, 
      133, 134, 138, 139, 140, 141, 144, 146, 147, 151, 152, 198, 201, 203, 
      205, 206, 210, 211, 212, 221, 222, 252, 254, 271, 272, 273, 274, 275, 
      277, 278, 279, 280, 281, 294, 295, 299, 313, 327, 328 ], 
  [ 1, 2, 8, 14, 15, 17, 37, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 59, 
      95, 97, 99, 138, 139, 140, 141, 144, 147, 151, 152, 198, 201, 203, 206, 
      210, 212, 222, 252, 254, 299 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 52, 54, 56, 
      57, 58, 59, 73, 74, 75, 76, 95, 97, 99, 109, 110, 113, 116, 117, 120, 
      122, 123, 132, 133, 134, 140, 141, 144, 146, 147, 152, 199, 202, 203, 
      205, 206, 210, 213, 214, 237, 238, 239, 252, 254, 272, 273, 274, 275, 
      278, 279, 315 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 43, 50, 51, 52, 56, 57, 
      58, 59, 73, 74, 76, 95, 97, 99, 109, 110, 113, 116, 117, 120, 123, 132, 
      134, 140, 141, 144, 147, 152, 199, 202, 203, 206, 210, 214, 237, 239, 
      252, 254, 272, 273, 274, 275, 278, 279 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 46, 47, 48, 49, 
      50, 52, 54, 56, 57, 58, 59, 73, 74, 75, 76, 95, 97, 99, 109, 110, 113, 
      114, 115, 116, 117, 120, 122, 123, 131, 132, 133, 134, 138, 139, 140, 
      141, 144, 146, 147, 151, 152, 198, 200, 201, 203, 205, 206, 210, 211, 
      212, 215, 216, 219, 220, 221, 222, 237, 238, 239, 252, 254, 271, 272, 
      273, 274, 275, 277, 278, 279, 280, 281, 294, 295, 299, 312, 313, 317, 
      327, 328 ], 
  [ 1, 2, 4, 8, 10, 11, 13, 14, 15, 17, 37, 40, 41, 42, 44, 46, 47, 48, 49, 
      50, 52, 56, 57, 58, 59, 73, 74, 76, 95, 97, 99, 109, 110, 113, 114, 
      115, 116, 117, 120, 123, 131, 132, 134, 138, 139, 140, 141, 144, 147, 
      151, 152, 198, 200, 201, 203, 206, 210, 212, 216, 220, 222, 237, 239, 
      252, 254, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 295, 299, 
      313, 327, 328 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 36, 37, 39, 40, 41, 
      42, 43, 44, 46, 47, 48, 49, 50, 51, 52, 56, 57, 58, 59, 66, 67, 72, 73, 
      74, 76, 77, 78, 79, 82, 83, 85, 95, 96, 97, 98, 99, 100, 101, 105, 106, 
      108, 109, 110, 113, 114, 115, 116, 117, 118, 120, 123, 125, 129, 131, 
      132, 134, 136, 138, 139, 140, 141, 142, 144, 147, 149, 150, 151, 152, 
      193, 195, 197, 198, 199, 200, 201, 202, 203, 206, 209, 210, 212, 214, 
      216, 220, 222, 229, 231, 234, 237, 239, 240, 242, 247, 251, 252, 253, 
      254, 256, 258, 259, 261, 266, 268, 269, 271, 272, 273, 274, 275, 277, 
      278, 279, 280, 281, 283, 290, 295, 298, 299, 301, 311, 313, 315, 317, 
      322, 324, 326, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 37, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 54, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 84, 85, 
      95, 97, 98, 99, 100, 101, 103, 104, 106, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 124, 128, 129, 130, 131, 132, 133, 134, 135, 138, 
      139, 140, 141, 144, 146, 147, 151, 152, 163, 164, 166, 181, 198, 201, 
      203, 205, 206, 209, 210, 211, 212, 221, 222, 240, 241, 242, 243, 244, 
      245, 246, 247, 252, 254, 255, 258, 261, 264, 269, 270, 271, 272, 273, 
      274, 275, 276, 277, 278, 279, 280, 281, 288, 293, 294, 295, 299, 306, 
      312, 313, 327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 39, 40, 41, 42, 46, 
      48, 49, 50, 52, 56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 96, 98, 99, 
      100, 101, 103, 104, 105, 108, 109, 110, 111, 112, 114, 115, 116, 117, 
      124, 125, 129, 130, 131, 132, 134, 135, 136, 138, 139, 140, 141, 142, 
      144, 147, 150, 151, 152, 162, 164, 179, 195, 197, 209, 210, 212, 222, 
      242, 251, 252, 255, 256, 258, 259, 261, 263, 265, 268, 270, 271, 272, 
      273, 274, 275, 280, 281, 286, 290, 295, 296, 298, 299, 301, 322, 324, 
      327 ], [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 38, 39, 40, 
      41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 77, 78, 79, 80, 81, 83, 85, 95, 
      96, 98, 99, 100, 101, 103, 104, 105, 107, 108, 109, 110, 111, 112, 114, 
      115, 116, 117, 124, 125, 126, 129, 130, 131, 132, 134, 135, 136, 137, 
      138, 139, 140, 141, 142, 143, 144, 147, 150, 151, 152, 162, 164, 179, 
      194, 195, 197, 209, 210, 212, 222, 242, 251, 252, 255, 256, 257, 258, 
      259, 260, 261, 263, 265, 267, 268, 270, 271, 272, 273, 274, 275, 280, 
      281, 286, 289, 290, 295, 296, 297, 298, 299, 300, 301, 320, 322, 323, 
      324, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 39, 40, 41, 42, 46, 48, 49, 
      50, 52, 56, 57, 58, 77, 78, 79, 83, 85, 95, 96, 98, 99, 100, 101, 105, 
      108, 109, 110, 114, 115, 116, 117, 125, 129, 131, 132, 134, 136, 138, 
      139, 140, 141, 142, 144, 147, 150, 151, 152, 195, 197, 209, 210, 212, 
      222, 242, 251, 252, 256, 258, 259, 261, 268, 271, 272, 273, 274, 275, 
      280, 281, 290, 295, 298, 299, 301, 324, 327 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 20, 25, 36, 38, 40, 41, 42, 46, 48, 49, 50, 
      52, 56, 58, 77, 78, 79, 80, 81, 83, 85, 96, 99, 101, 103, 104, 105, 
      107, 108, 110, 111, 112, 114, 115, 116, 117, 142, 143, 144, 147, 150, 
      151, 152, 162, 179, 194, 195, 197, 210, 212, 222, 242, 259, 260, 261, 
      263, 265, 267, 268, 274, 275, 280, 281, 300, 301, 324 ], 
  [ 1, 2, 5, 8, 9, 10, 15, 17, 36, 40, 41, 42, 46, 48, 49, 50, 52, 56, 58, 
      77, 78, 79, 83, 85, 96, 99, 101, 105, 108, 110, 114, 115, 116, 117, 
      142, 144, 147, 150, 151, 152, 195, 197, 210, 212, 222, 242, 259, 261, 
      268, 274, 275, 280, 281, 301 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 20, 25, 36, 37, 39, 40, 41, 42, 
      46, 48, 49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 80, 81, 82, 83, 85, 95, 
      96, 97, 98, 99, 100, 101, 103, 104, 105, 106, 108, 109, 110, 111, 112, 
      113, 114, 115, 116, 117, 124, 125, 129, 130, 131, 132, 134, 135, 136, 
      138, 139, 140, 141, 142, 144, 147, 150, 151, 152, 162, 163, 164, 179, 
      193, 195, 197, 198, 201, 203, 206, 209, 210, 212, 222, 240, 242, 243, 
      247, 251, 252, 253, 254, 255, 256, 258, 259, 261, 263, 264, 265, 266, 
      268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 
      286, 290, 295, 296, 298, 299, 301, 304, 311, 313, 320, 322, 324, 326, 
      327, 328 ], 
  [ 1, 2, 5, 8, 9, 10, 12, 13, 14, 15, 17, 36, 37, 39, 40, 41, 42, 46, 48, 
      49, 50, 52, 56, 57, 58, 59, 77, 78, 79, 82, 83, 85, 95, 96, 97, 98, 99, 
      100, 101, 105, 106, 108, 109, 110, 113, 114, 115, 116, 117, 125, 129, 
      131, 132, 134, 136, 138, 139, 140, 141, 142, 144, 147, 150, 151, 152, 
      193, 195, 197, 198, 201, 203, 206, 209, 210, 212, 222, 240, 242, 247, 
      251, 252, 253, 254, 256, 258, 259, 261, 266, 268, 269, 271, 272, 273, 
      274, 275, 277, 278, 279, 280, 281, 290, 295, 298, 299, 301, 311, 313, 
      322, 324, 327, 328 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 58, 
      95, 99, 109, 110, 114, 115, 116, 117, 131, 132, 134, 138, 139, 140, 
      141, 144, 147, 151, 152, 210, 212, 222, 252, 271, 272, 273, 274, 275, 
      280, 281, 295, 299 ], 
  [ 1, 2, 8, 10, 13, 14, 15, 17, 37, 40, 41, 42, 46, 48, 49, 50, 52, 56, 57, 
      58, 59, 95, 97, 99, 109, 110, 113, 114, 115, 116, 117, 131, 132, 134, 
      138, 139, 140, 141, 144, 147, 151, 152, 198, 201, 203, 206, 210, 212, 
      222, 252, 254, 271, 272, 273, 274, 275, 277, 278, 279, 280, 281, 295, 
      299, 313, 327 ] ]
gap> S := Semigroup([
> Transformation([1, 5, 4, 5, 2]), Transformation([4, 5, 1, 3, 5])]);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 3, 27, 28, 32, 33, 34, 35, 39, 40, 41, 59, 60, 61, 161, 162, 
      166, 172 ], [ 1, 32 ], 
  [ 1, 2, 3, 5, 27, 28, 32, 33, 34, 35, 39, 40, 41, 45, 48, 59, 60, 61, 70, 
      161, 162, 166, 172 ], [ 1, 3, 32, 39, 60 ], 
  [ 1, 3, 9, 10, 13, 26, 32, 43, 54, 55, 58, 62, 93, 118, 153, 160 ], 
  [ 1, 2, 3, 6, 9, 10, 11, 13, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
      36, 37, 38, 39, 40, 41, 42, 43, 47, 52, 53, 54, 55, 56, 58, 59, 60, 61, 
      62, 63, 64, 75, 77, 78, 79, 82, 85, 86, 89, 91, 92, 93, 94, 95, 96, 97, 
      98, 99, 102, 105, 106, 108, 109, 110, 114, 115, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 144, 145, 146, 147, 148, 149, 153, 154, 155, 
      156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
      170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 185, 186, 187, 188, 
      189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 9, 10, 11, 12, 13, 23, 24, 26, 27, 28, 29, 30, 31, 
      32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 47, 48, 50, 52, 53, 
      54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 
      74, 75, 76, 77, 78, 79, 81, 82, 83, 84, 85, 86, 89, 90, 91, 92, 93, 94, 
      95, 96, 97, 98, 99, 101, 102, 103, 104, 105, 106, 108, 109, 110, 112, 
      113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 145, 
      146, 147, 148, 149, 150, 151, 153, 154, 155, 156, 157, 158, 159, 160, 
      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
      175, 176, 177, 178, 179, 181, 182, 183, 184, 185, 186, 187, 188, 189, 
      190, 191, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 13, 26, 54, 55, 160 ], 
  [ 1, 3, 13, 26, 32, 43, 54, 55, 62, 118, 153, 160 ], 
  [ 1, 2, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 
      41, 42, 43, 47, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 108, 109, 110, 
      114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 148, 
      149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 
      167, 168, 170, 171, 172, 173, 179, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 10, 11, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 35, 
      37, 38, 39, 40, 41, 42, 43, 45, 47, 48, 50, 52, 53, 54, 55, 59, 60, 61, 
      62, 63, 64, 69, 70, 72, 73, 74, 108, 109, 110, 112, 113, 114, 115, 117, 
      118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 148, 149, 150, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 
      170, 171, 172, 173, 179, 184, 198, 199, 200, 207 ], 
  [ 1, 26, 54, 55, 160 ], 
  [ 1, 2, 3, 4, 5, 10, 11, 12, 13, 16, 23, 24, 26, 27, 28, 30, 31, 32, 33, 
      34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 54, 55, 
      59, 60, 61, 62, 63, 64, 66, 69, 70, 72, 73, 74, 108, 109, 110, 111, 
      112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
      144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 179, 184, 198, 199, 
      200, 207 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 16, 23, 24, 26, 27, 28, 
      29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 
      48, 50, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 
      69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 
      87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
      104, 105, 106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 
      119, 120, 121, 122, 123, 124, 125, 144, 145, 146, 147, 148, 149, 150, 
      151, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
      166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
      180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 
      194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 27, 28, 32, 33, 34, 35, 39, 40, 41, 44, 45, 48, 59, 60, 
      61, 66, 70, 161, 162, 166, 172 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 18, 19, 20, 21, 23, 24, 25, 
      26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
      45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 
      63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 81, 82, 
      83, 84, 85, 86, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 101, 102, 
      103, 104, 105, 106, 107, 108, 109, 110, 112, 113, 114, 115, 117, 118, 
      119, 120, 121, 122, 123, 124, 125, 130, 131, 132, 133, 134, 135, 136, 
      137, 139, 140, 141, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 181, 182, 
      183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
      198, 199, 200, 201, 202, 203, 204, 205, 206, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 19, 26, 32, 39, 43, 54, 55, 58, 60, 62, 67, 68, 
      69, 73, 78, 93, 97, 109, 118, 121, 136, 153, 155, 160, 171, 175, 179 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 32, 43, 54, 55, 58, 62, 93, 118, 153, 160 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 21, 23, 24, 26, 27, 28, 30, 31, 32, 33, 
      34, 35, 37, 38, 39, 40, 41, 42, 43, 45, 47, 48, 50, 52, 53, 54, 55, 56, 
      58, 59, 60, 61, 62, 63, 64, 65, 68, 69, 70, 72, 73, 74, 89, 90, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110, 112, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 
      125, 144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 158, 159, 160, 
      161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 
      177, 178, 179, 182, 183, 184, 187, 188, 189, 190, 191, 192, 193, 194, 
      195, 196, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 27, 28, 32, 33, 34, 35, 39, 40, 41, 45, 48, 59, 60, 61, 
      70, 161, 162, 166, 172 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
      58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 
      94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
      165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
      179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
      193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
      207 ], 
  [ 1, 3, 10, 13, 26, 32, 43, 52, 54, 55, 62, 63, 114, 118, 124, 153, 158, 
      160 ], 
  [ 1, 3, 5, 10, 13, 23, 26, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 64, 69, 
      73, 74, 109, 114, 115, 118, 121, 124, 125, 148, 153, 155, 158, 159, 
      160, 171, 179, 184 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 23, 24, 26, 32, 39, 43, 52, 53, 54, 55, 
      58, 60, 62, 63, 64, 67, 68, 69, 73, 74, 75, 76, 78, 85, 86, 89, 90, 93, 
      97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 131, 132, 136, 140, 
      141, 148, 153, 155, 158, 159, 160, 171, 175, 177, 178, 179, 181, 183, 
      184, 185, 189, 203 ], [ 1, 55 ], [ 1, 32 ], [ 1, 3, 27, 32, 40 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 27, 28, 30, 31, 32, 40, 42, 43, 52, 54, 55, 58, 
      62, 63, 85, 91, 92, 93, 98, 105, 114, 117, 118, 122, 124, 153, 156, 
      158, 160, 177 ], 
  [ 1, 3, 10, 13, 26, 27, 28, 31, 32, 40, 42, 43, 52, 54, 55, 62, 63, 114, 
      117, 118, 122, 124, 153, 156, 158, 160 ], 
  [ 1, 26, 27, 32, 43, 52, 54, 55, 153, 158, 160 ], [ 1 ], 
  [ 1, 27, 32, 40, 41, 172 ], [ 1, 27, 32, 39, 41 ], 
  [ 1, 3, 27, 28, 32, 34, 39, 40, 41, 60, 61, 166, 172 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 34, 35, 37, 38, 39, 40, 
      41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 78, 79, 85, 86, 91, 
      92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 118, 
      120, 121, 122, 123, 124, 125, 153, 155, 156, 157, 158, 159, 160, 166, 
      167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 194, 196, 199, 200, 
      207 ], [ 1, 3, 10, 13, 26, 27, 28, 30, 31, 32, 34, 35, 38, 39, 40, 41, 
      42, 43, 52, 53, 54, 55, 60, 61, 62, 63, 64, 109, 110, 114, 115, 117, 
      118, 120, 121, 122, 123, 124, 125, 153, 155, 156, 157, 158, 159, 160, 
      166, 167, 170, 171, 172, 173, 179, 199, 200, 207 ], 
  [ 1, 26, 27, 31, 32, 34, 39, 41, 43, 52, 53, 54, 55, 153, 155, 157, 158, 
      159, 160, 171 ], [ 1, 32 ], [ 1, 27, 32 ], [ 1, 27, 32 ], 
  [ 1, 26, 27, 31, 32, 43, 52, 54, 55, 153, 158, 160 ], [ 1, 32, 54, 55 ], 
  [ 1, 2, 3, 27, 28, 32, 33, 34, 35, 39, 40, 41, 48, 59, 60, 61, 161, 162, 
      166, 172 ], 
  [ 1, 3, 5, 27, 28, 32, 33, 34, 35, 39, 40, 41, 59, 60, 61, 70, 161, 162, 
      166, 172 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
      36, 37, 38, 39, 40, 41, 42, 43, 45, 52, 53, 54, 55, 58, 59, 60, 61, 62, 
      63, 64, 67, 68, 69, 70, 71, 72, 73, 74, 77, 78, 79, 81, 85, 86, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 101, 105, 106, 108, 109, 110, 112, 114, 
      115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 130, 131, 133, 134, 
      135, 136, 137, 140, 141, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 163, 164, 165, 166, 167, 170, 171, 172, 173, 174, 175, 176, 177, 
      178, 179, 181, 182, 183, 184, 192, 193, 194, 196, 198, 199, 200, 205, 
      207 ], [ 1, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 33, 40, 41, 42, 43, 
      52, 54, 55, 59, 61, 62, 63, 108, 110, 114, 117, 118, 119, 122, 123, 
      124, 144, 149, 153, 154, 156, 157, 158, 160, 172, 173, 200, 207 ], 
  [ 1, 2, 3, 27, 28, 32, 33, 34, 35, 39, 40, 41, 59, 60, 61, 161, 162, 166, 
      172 ], [ 1, 2, 3, 6, 7, 9, 10, 11, 13, 19, 23, 26, 27, 28, 29, 30, 31, 
      32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 47, 48, 52, 53, 54, 55, 
      56, 57, 58, 59, 60, 61, 62, 63, 64, 75, 77, 78, 79, 82, 83, 85, 86, 89, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 102, 103, 105, 106, 108, 109, 110, 
      113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 132, 133, 
      134, 135, 136, 137, 139, 140, 141, 144, 145, 146, 147, 148, 149, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 185, 186, 
      187, 188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 201, 202, 
      203, 204, 205, 206, 207 ], 
  [ 1, 3, 5, 10, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 
      40, 41, 42, 43, 45, 47, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 69, 70, 
      72, 73, 74, 108, 109, 110, 112, 114, 115, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 158, 
      159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 179, 
      184, 198, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 50, 52, 53, 54, 
      55, 58, 59, 60, 61, 62, 63, 64, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
      77, 78, 79, 81, 82, 84, 85, 86, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 
      99, 101, 102, 104, 105, 106, 108, 109, 110, 112, 114, 115, 117, 118, 
      119, 120, 121, 122, 123, 124, 125, 130, 131, 132, 133, 134, 135, 136, 
      137, 139, 140, 141, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 181, 182, 
      183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
      198, 199, 200, 201, 202, 203, 204, 205, 206, 207 ], 
  [ 1, 32, 43, 54, 55 ], [ 1, 32, 39, 43, 52, 54, 55, 171 ], [ 1, 55 ], 
  [ 1 ], [ 1, 2, 3, 9, 10, 11, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 
      37, 38, 39, 40, 41, 42, 43, 47, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 
      64, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 102, 105, 106, 108, 109, 
      110, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 
      148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 
      166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 187, 
      188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 6, 7, 9, 10, 11, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
      35, 36, 37, 38, 39, 40, 41, 42, 43, 47, 52, 53, 54, 55, 56, 58, 59, 60, 
      61, 62, 63, 64, 75, 77, 78, 79, 82, 85, 86, 89, 91, 92, 93, 94, 95, 96, 
      97, 98, 99, 102, 105, 106, 108, 109, 110, 114, 115, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 132, 133, 134, 135, 136, 137, 139, 140, 141, 
      144, 145, 146, 147, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 
      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 
      175, 176, 177, 178, 179, 185, 186, 187, 188, 189, 190, 192, 193, 194, 
      195, 196, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207 ], 
  [ 1, 3, 9, 10, 13, 26, 32, 43, 54, 55, 62, 93, 118, 153, 160 ], 
  [ 1, 3, 27, 28, 32, 33, 40, 41, 61, 172 ], [ 1, 3, 32, 39 ], 
  [ 1, 3, 27, 28, 32, 40, 41, 172 ], [ 1, 3, 32, 43, 54, 55 ], 
  [ 1, 3, 32, 43, 52, 54, 55, 62 ], 
  [ 1, 3, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 171, 179 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 
      35, 37, 38, 39, 40, 41, 42, 43, 45, 47, 48, 50, 52, 53, 54, 55, 56, 58, 
      59, 60, 61, 62, 63, 64, 68, 69, 70, 72, 73, 74, 89, 90, 91, 92, 93, 94, 
      95, 96, 97, 98, 99, 101, 102, 103, 104, 105, 106, 108, 109, 110, 112, 
      113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 
      148, 149, 150, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 
      165, 166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
      182, 183, 184, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 198, 
      199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 27, 28, 32, 33, 34, 35, 39, 40, 41, 44, 45, 48, 59, 60, 
      61, 70, 161, 162, 166, 172 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 26, 32, 39, 43, 54, 55, 58, 60, 62, 68, 69, 73, 
      78, 93, 97, 109, 118, 121, 153, 155, 160, 171, 175, 179 ], 
  [ 1, 3, 5, 9, 10, 13, 26, 32, 39, 43, 54, 55, 58, 60, 62, 69, 73, 93, 97, 
      109, 118, 121, 153, 155, 160, 171, 175, 179 ], 
  [ 1, 3, 5, 10, 13, 26, 32, 39, 43, 54, 55, 60, 62, 73, 109, 118, 121, 153, 
      155, 160, 171, 179 ], 
  [ 1, 3, 5, 27, 28, 32, 34, 35, 39, 40, 41, 60, 61, 166, 172 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 67, 68, 69, 
      70, 72, 73, 74, 78, 79, 85, 86, 91, 92, 93, 95, 96, 97, 98, 99, 105, 
      106, 109, 110, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 153, 
      155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 175, 176, 
      177, 178, 179, 181, 182, 183, 184, 194, 196, 199, 200, 207 ], 
  [ 1, 3, 5, 10, 13, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 42, 
      43, 52, 53, 54, 55, 60, 61, 62, 63, 64, 69, 70, 73, 74, 109, 110, 114, 
      115, 117, 118, 120, 121, 122, 123, 124, 125, 153, 155, 156, 157, 158, 
      159, 160, 166, 167, 170, 171, 172, 173, 179, 184, 199, 200, 207 ], 
  [ 1, 3, 5, 32, 39, 43, 54, 55, 60, 62, 171, 179 ], 
  [ 1, 3, 5, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 64, 73, 171, 179 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 32, 43, 52, 54, 55, 58, 62, 63, 85, 89, 93, 
      105, 114, 118, 124, 153, 158, 160, 177 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 23, 24, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 
      62, 63, 64, 67, 68, 69, 73, 74, 75, 78, 85, 86, 89, 90, 93, 97, 105, 
      106, 109, 114, 115, 118, 121, 124, 125, 148, 153, 155, 158, 159, 160, 
      171, 175, 177, 178, 179, 181, 183, 184, 185, 189 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 33, 40, 41, 42, 43, 52, 
      54, 55, 58, 59, 61, 62, 63, 79, 85, 91, 92, 93, 94, 98, 99, 105, 108, 
      110, 114, 117, 118, 119, 122, 123, 124, 153, 154, 156, 157, 158, 160, 
      172, 173, 174, 176, 177, 196, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 32, 39, 43, 54, 55, 58, 60, 62, 93, 97, 109, 118, 
      121, 153, 155, 160, 171, 175, 179 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 40, 41, 42, 43, 52, 54, 
      55, 58, 61, 62, 63, 85, 91, 92, 93, 98, 99, 105, 110, 114, 117, 118, 
      122, 123, 124, 153, 156, 157, 158, 160, 172, 173, 176, 177, 196, 200, 
      207 ], [ 1, 2, 3, 6, 7, 9, 10, 11, 13, 23, 26, 27, 28, 29, 30, 31, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48, 52, 53, 54, 55, 
      56, 58, 59, 60, 61, 62, 63, 64, 75, 77, 78, 79, 82, 83, 85, 86, 89, 91, 
      92, 93, 94, 95, 96, 97, 98, 99, 100, 102, 103, 105, 106, 108, 109, 110, 
      111, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 
      145, 146, 147, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 
      176, 177, 178, 179, 185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 
      196, 198, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
      38, 39, 40, 41, 42, 43, 45, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 
      67, 68, 69, 70, 71, 72, 73, 74, 77, 78, 79, 85, 86, 91, 92, 93, 94, 95, 
      96, 97, 98, 99, 101, 105, 106, 108, 109, 110, 112, 114, 115, 117, 118, 
      119, 120, 121, 122, 123, 124, 125, 153, 154, 155, 156, 157, 158, 159, 
      160, 161, 162, 163, 164, 165, 166, 167, 170, 171, 172, 173, 174, 175, 
      176, 177, 178, 179, 181, 182, 183, 184, 192, 193, 194, 196, 198, 199, 
      200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 27, 28, 29, 30, 31, 32, 33, 40, 41, 42, 43, 
      47, 52, 54, 55, 58, 59, 61, 62, 63, 75, 77, 79, 85, 89, 91, 92, 93, 94, 
      98, 99, 102, 105, 108, 110, 114, 117, 118, 119, 122, 123, 124, 144, 
      145, 149, 153, 154, 156, 157, 158, 160, 172, 173, 174, 176, 177, 186, 
      187, 190, 196, 200, 207 ], 
  [ 1, 2, 3, 6, 7, 9, 10, 11, 13, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
      36, 37, 38, 39, 40, 41, 42, 43, 47, 48, 52, 53, 54, 55, 56, 58, 59, 60, 
      61, 62, 63, 64, 75, 77, 78, 79, 82, 85, 86, 89, 91, 92, 93, 94, 95, 96, 
      97, 98, 99, 102, 103, 105, 106, 108, 109, 110, 113, 114, 115, 117, 118, 
      119, 120, 121, 122, 123, 124, 125, 144, 145, 146, 147, 148, 149, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 
      168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 185, 186, 
      187, 188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 23, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 
      36, 37, 38, 39, 40, 41, 42, 43, 45, 47, 50, 52, 53, 54, 55, 58, 59, 60, 
      61, 62, 63, 64, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 81, 
      82, 85, 86, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 101, 102, 104, 
      105, 106, 108, 109, 110, 112, 114, 115, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 144, 145, 146, 147, 148, 149, 150, 151, 153, 154, 155, 
      156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
      170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 181, 182, 183, 184, 
      185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 198, 199, 
      200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 32, 43, 52, 54, 55, 58, 62, 63, 93, 105, 114, 
      118, 124, 153, 158, 160, 177 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 64, 
      78, 85, 93, 97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 153, 155, 
      158, 159, 160, 171, 175, 177, 178, 179 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 23, 24, 26, 27, 28, 29, 30, 
      31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 
      52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 
      71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 89, 90, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 
      108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 144, 145, 146, 147, 148, 149, 150, 151, 153, 154, 
      155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 
      169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 
      183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
      198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 16, 23, 24, 26, 27, 28, 30, 31, 32, 
      33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 54, 
      55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 72, 73, 74, 89, 
      90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
      106, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 144, 146, 148, 149, 150, 153, 154, 155, 156, 
      157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 
      173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 187, 188, 189, 
      190, 191, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 32, 43, 52, 54, 55, 58, 62, 63, 93, 105, 114, 
      118, 124, 153, 158, 160, 177 ], 
  [ 1, 3, 5, 9, 10, 13, 23, 24, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 
      63, 64, 68, 69, 73, 74, 89, 93, 97, 105, 106, 109, 114, 115, 118, 121, 
      124, 125, 148, 153, 155, 158, 159, 160, 171, 175, 177, 178, 179, 183, 
      184, 189 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 43, 52, 54, 55, 93, 105, 117, 118, 124, 153, 
      158, 160 ], 
  [ 1, 3, 9, 10, 13, 26, 27, 28, 30, 31, 32, 40, 42, 43, 52, 54, 55, 58, 62, 
      63, 91, 93, 98, 105, 114, 117, 118, 122, 124, 153, 156, 158, 160, 177 ],
  [ 1, 9, 13, 26, 32, 43, 54, 55, 118, 153, 160 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 33, 40, 41, 42, 43, 52, 54, 55, 91, 93, 98, 99, 
      105, 117, 118, 119, 122, 123, 124, 153, 154, 156, 157, 158, 160, 172, 
      173, 196, 200, 207 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 34, 38, 39, 41, 43, 52, 53, 54, 55, 91, 93, 97, 
      99, 105, 106, 117, 118, 120, 121, 123, 124, 125, 153, 155, 157, 158, 
      159, 160, 171 ], 
  [ 1, 3, 9, 10, 13, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 42, 
      43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 91, 92, 93, 95, 97, 98, 99, 
      105, 106, 109, 110, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 
      153, 155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 175, 
      176, 177, 178, 179, 194, 196, 199, 200, 207 ], 
  [ 1, 9, 13, 26, 32, 39, 43, 54, 55, 93, 118, 121, 153, 155, 160, 171 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 40, 42, 43, 52, 54, 55, 91, 93, 105, 117, 118, 
      122, 124, 153, 156, 158, 160 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 41, 43, 52, 54, 55, 91, 93, 105, 117, 118, 123, 
      124, 153, 157, 158, 160 ], 
  [ 1, 2, 3, 9, 10, 11, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 
      39, 40, 41, 42, 43, 44, 47, 48, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 
      63, 64, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 102, 103, 105, 106, 
      108, 109, 110, 111, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 
      124, 125, 144, 146, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 
      161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 
      177, 178, 179, 187, 188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 
      200, 207 ], 
  [ 1, 3, 5, 9, 10, 13, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 
      41, 42, 43, 45, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 68, 69, 70, 
      72, 73, 74, 91, 92, 93, 94, 95, 96, 97, 98, 99, 105, 106, 108, 109, 
      110, 112, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 170, 
      171, 172, 173, 174, 175, 176, 177, 178, 179, 182, 183, 184, 192, 193, 
      194, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 27, 28, 30, 31, 32, 33, 40, 41, 42, 43, 47, 52, 
      54, 55, 58, 59, 61, 62, 63, 89, 91, 92, 93, 94, 98, 99, 105, 108, 110, 
      114, 117, 118, 119, 122, 123, 124, 144, 149, 153, 154, 156, 157, 158, 
      160, 172, 173, 174, 176, 177, 187, 190, 196, 200, 207 ], 
  [ 1, 2, 3, 9, 10, 11, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 
      39, 40, 41, 42, 43, 47, 48, 52, 53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 
      64, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 102, 105, 106, 108, 109, 
      110, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 
      146, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 
      165, 166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
      187, 188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 5, 9, 10, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 
      39, 40, 41, 42, 43, 45, 47, 50, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 
      64, 68, 69, 70, 72, 73, 74, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      101, 102, 105, 106, 108, 109, 110, 112, 114, 115, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 144, 146, 148, 149, 150, 153, 154, 155, 156, 
      157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 
      173, 174, 175, 176, 177, 178, 179, 182, 183, 184, 187, 188, 189, 190, 
      191, 192, 193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 9, 13, 26, 32, 43, 52, 54, 55, 93, 118, 124, 153, 158, 160 ], 
  [ 1, 9, 13, 26, 32, 39, 43, 52, 53, 54, 55, 93, 97, 105, 118, 121, 124, 
      125, 153, 155, 158, 159, 160, 171 ], 
  [ 1, 2, 3, 4, 5, 10, 11, 12, 13, 21, 23, 24, 26, 27, 28, 30, 31, 32, 33, 
      34, 35, 37, 38, 39, 40, 41, 42, 43, 45, 47, 48, 50, 52, 53, 54, 55, 59, 
      60, 61, 62, 63, 64, 69, 70, 72, 73, 74, 108, 109, 110, 112, 113, 114, 
      115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 148, 149, 
      150, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 
      167, 168, 170, 171, 172, 173, 179, 184, 198, 199, 200, 207 ], 
  [ 1, 3, 10, 13, 26, 27, 28, 30, 31, 32, 33, 40, 41, 42, 43, 52, 54, 55, 59, 
      61, 62, 63, 110, 114, 117, 118, 119, 122, 123, 124, 153, 154, 156, 157, 
      158, 160, 172, 173, 200, 207 ], 
  [ 1, 3, 10, 13, 26, 32, 39, 43, 54, 55, 60, 62, 118, 121, 153, 155, 160, 
      171, 179 ], 
  [ 1, 3, 10, 13, 26, 27, 28, 30, 31, 32, 40, 41, 42, 43, 52, 54, 55, 61, 62, 
      63, 114, 117, 118, 122, 123, 124, 153, 156, 157, 158, 160, 172, 173, 
      200, 207 ], 
  [ 1, 2, 3, 10, 11, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 
      40, 41, 42, 43, 44, 47, 48, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 
      108, 109, 110, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 
      125, 144, 146, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 179, 198, 199, 200, 
      207 ], 
  [ 1, 3, 5, 10, 13, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 
      42, 43, 45, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 69, 70, 72, 73, 74, 
      108, 109, 110, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
      153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 
      170, 171, 172, 173, 179, 184, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 10, 11, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 
      40, 41, 42, 43, 47, 48, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 108, 
      109, 110, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 
      146, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 
      165, 166, 167, 168, 170, 171, 172, 173, 179, 198, 199, 200, 207 ], 
  [ 1, 3, 10, 13, 26, 32, 43, 52, 54, 55, 62, 63, 118, 124, 153, 158, 160 ], 
  [ 1, 3, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 64, 109, 114, 
      118, 121, 124, 125, 153, 155, 158, 159, 160, 171, 179 ], 
  [ 1, 2, 3, 4, 5, 10, 11, 12, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 
      35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 54, 55, 59, 
      60, 61, 62, 63, 64, 66, 69, 70, 72, 73, 74, 108, 109, 110, 111, 112, 
      113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 
      148, 149, 150, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 
      165, 166, 167, 168, 170, 171, 172, 173, 179, 184, 198, 199, 200, 207 ], 
  [ 1, 13, 26, 27, 31, 32, 43, 52, 54, 55, 118, 124, 153, 158, 160 ], 
  [ 1, 13, 26, 32, 43, 54, 55, 153, 160 ], 
  [ 1, 13, 26, 27, 31, 32, 33, 40, 41, 42, 43, 52, 54, 55, 117, 118, 122, 
      123, 124, 153, 154, 156, 157, 158, 160, 172, 173, 200, 207 ], 
  [ 1, 13, 26, 27, 31, 32, 34, 38, 39, 41, 43, 52, 53, 54, 55, 117, 118, 121, 
      123, 124, 125, 153, 155, 157, 158, 159, 160, 171 ], 
  [ 1, 13, 26, 32, 39, 43, 54, 55, 118, 153, 155, 160, 171 ], 
  [ 1, 13, 26, 27, 31, 32, 40, 42, 43, 52, 54, 55, 117, 118, 124, 153, 156, 
      158, 160 ], 
  [ 1, 13, 26, 27, 31, 32, 41, 43, 52, 54, 55, 117, 118, 124, 153, 157, 158, 
      160 ], [ 1, 13, 26, 32, 43, 52, 54, 55, 118, 153, 158, 160 ], 
  [ 1, 13, 26, 32, 39, 43, 52, 53, 54, 55, 118, 121, 124, 153, 155, 158, 159, 
      160, 171 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 14, 16, 20, 21, 23, 24, 26, 27, 28, 30, 
      31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 
      53, 54, 55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 72, 73, 
      74, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 
      104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 
      118, 119, 120, 121, 122, 123, 124, 125, 127, 128, 142, 143, 144, 146, 
      148, 149, 150, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 
      165, 166, 167, 168, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
      180, 182, 183, 184, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 
      197, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 10, 11, 12, 13, 14, 16, 21, 23, 24, 26, 27, 28, 30, 31, 
      32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 
      54, 55, 59, 60, 61, 62, 63, 64, 66, 69, 70, 72, 73, 74, 107, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
      124, 125, 128, 143, 144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 
      158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 
      179, 184, 197, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 16, 21, 27, 28, 32, 33, 34, 35, 39, 40, 41, 44, 45, 48, 
      59, 60, 61, 66, 70, 143, 161, 162, 166, 172 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 17, 18, 19, 20, 21, 23, 24, 
      25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 
      43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 
      61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 
      79, 80, 81, 82, 83, 84, 85, 86, 87, 89, 90, 91, 92, 93, 94, 95, 96, 97, 
      98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 
      112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
      130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 
      144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 
      158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 
      172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 
      186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 
      200, 201, 202, 203, 204, 205, 206, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 67, 
      68, 69, 70, 71, 72, 73, 74, 78, 79, 85, 86, 91, 92, 93, 95, 96, 97, 98, 
      99, 105, 106, 109, 110, 114, 115, 117, 118, 120, 121, 122, 123, 124, 
      125, 131, 133, 135, 136, 137, 140, 141, 153, 155, 156, 157, 158, 159, 
      160, 166, 167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 181, 182, 
      183, 184, 194, 196, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 
      62, 63, 64, 67, 68, 69, 73, 74, 78, 85, 86, 93, 97, 105, 106, 109, 114, 
      115, 118, 121, 124, 125, 136, 140, 141, 153, 155, 158, 159, 160, 171, 
      175, 177, 178, 179, 181, 183, 184 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 32, 43, 52, 54, 55, 58, 62, 63, 75, 85, 
      89, 93, 105, 114, 118, 124, 140, 153, 158, 160, 177 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 27, 28, 29, 30, 31, 32, 40, 42, 43, 52, 54, 
      55, 58, 62, 63, 85, 91, 92, 93, 98, 105, 114, 117, 118, 122, 124, 140, 
      153, 156, 158, 160, 177 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 27, 28, 29, 30, 31, 32, 33, 40, 41, 42, 43, 
      52, 54, 55, 58, 59, 61, 62, 63, 77, 79, 85, 91, 92, 93, 94, 98, 99, 
      105, 108, 110, 114, 117, 118, 119, 122, 123, 124, 133, 137, 140, 153, 
      154, 156, 157, 158, 160, 172, 173, 174, 176, 177, 196, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 78, 79, 85, 
      86, 91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 
      118, 120, 121, 122, 123, 124, 125, 133, 136, 137, 140, 141, 153, 155, 
      156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 175, 176, 177, 
      178, 179, 194, 196, 199, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 32, 39, 43, 54, 55, 58, 60, 62, 78, 93, 97, 
      109, 118, 121, 153, 155, 160, 171, 175, 179 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 27, 28, 29, 30, 31, 32, 40, 41, 42, 43, 52, 
      54, 55, 58, 61, 62, 63, 79, 85, 91, 92, 93, 98, 99, 105, 110, 114, 117, 
      118, 122, 123, 124, 133, 140, 153, 156, 157, 158, 160, 172, 173, 176, 
      177, 196, 200, 207 ], 
  [ 1, 2, 3, 6, 7, 9, 10, 11, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 
      35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 47, 48, 49, 52, 53, 54, 55, 56, 
      57, 58, 59, 60, 61, 62, 63, 64, 75, 77, 78, 79, 80, 82, 83, 85, 86, 89, 
      91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 102, 103, 105, 106, 108, 109, 
      110, 111, 113, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 
      132, 133, 134, 135, 136, 137, 139, 140, 141, 144, 145, 146, 147, 148, 
      149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 
      166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 
      185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 196, 198, 199, 200, 
      201, 202, 203, 204, 205, 206, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 33, 40, 41, 42, 
      43, 47, 52, 54, 55, 58, 59, 61, 62, 63, 75, 77, 79, 82, 85, 89, 91, 92, 
      93, 94, 98, 99, 102, 105, 108, 110, 114, 117, 118, 119, 122, 123, 124, 
      132, 133, 134, 137, 140, 144, 145, 149, 153, 154, 156, 157, 158, 160, 
      172, 173, 174, 176, 177, 186, 187, 190, 196, 200, 201, 204, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 32, 43, 52, 54, 55, 58, 62, 63, 85, 93, 105, 
      114, 118, 124, 153, 158, 160, 177 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 
      64, 78, 85, 86, 93, 97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 
      136, 140, 153, 155, 158, 159, 160, 171, 175, 177, 178, 179 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 20, 21, 23, 24, 26, 27, 28, 30, 31, 32, 
      33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 54, 
      55, 56, 58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 72, 73, 74, 89, 
      90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 
      106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 
      120, 121, 122, 123, 124, 125, 143, 144, 146, 148, 149, 150, 153, 154, 
      155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 
      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 182, 183, 184, 187, 
      188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 207 ], 
  [ 1, 2, 3, 4, 5, 21, 27, 28, 32, 33, 34, 35, 39, 40, 41, 44, 45, 48, 59, 
      60, 61, 66, 70, 161, 162, 166, 172 ], 
  [ 1, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 40, 42, 43, 52, 54, 55, 62, 63, 
      114, 117, 118, 122, 124, 153, 156, 158, 160 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 27, 28, 29, 30, 31, 32, 40, 42, 43, 52, 54, 
      55, 58, 62, 63, 75, 85, 89, 91, 92, 93, 98, 105, 114, 117, 118, 122, 
      124, 144, 153, 156, 158, 160, 177, 187 ], 
  [ 1, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 42, 
      43, 52, 53, 54, 55, 60, 61, 62, 63, 64, 109, 110, 114, 115, 117, 118, 
      120, 121, 122, 123, 124, 125, 144, 148, 149, 153, 155, 156, 157, 158, 
      159, 160, 166, 167, 170, 171, 172, 173, 179, 199, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 75, 78, 79, 
      85, 86, 89, 91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 
      115, 117, 118, 120, 121, 122, 123, 124, 125, 144, 145, 146, 148, 149, 
      153, 155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 175, 
      176, 177, 178, 179, 185, 186, 187, 188, 189, 190, 194, 196, 199, 200, 
      207 ], [ 1, 3, 10, 13, 23, 26, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 
      64, 109, 114, 115, 118, 121, 124, 125, 153, 155, 158, 159, 160, 171, 
      179 ], [ 1, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 40, 41, 42, 43, 52, 
      54, 55, 61, 62, 63, 110, 114, 117, 118, 122, 123, 124, 144, 153, 156, 
      157, 158, 160, 172, 173, 200, 207 ], 
  [ 1, 3, 5, 10, 13, 23, 24, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 
      41, 42, 43, 52, 53, 54, 55, 60, 61, 62, 63, 64, 69, 70, 72, 73, 74, 
      109, 110, 114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 144, 146, 
      148, 149, 153, 155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 
      173, 179, 184, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 23, 24, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 67, 
      68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 79, 85, 86, 89, 90, 91, 92, 93, 
      95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 118, 120, 121, 
      122, 123, 124, 125, 144, 145, 146, 147, 148, 149, 150, 153, 155, 156, 
      157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 175, 176, 177, 178, 
      179, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 194, 196, 
      199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 18, 19, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 
      34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 
      63, 64, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 78, 79, 85, 86, 89, 90, 
      91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 118, 
      120, 121, 122, 123, 124, 125, 130, 131, 132, 133, 135, 136, 137, 140, 
      141, 144, 145, 146, 147, 148, 149, 150, 151, 153, 155, 156, 157, 158, 
      159, 160, 166, 167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 181, 
      182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 194, 196, 199, 200, 
      201, 202, 203, 204, 207 ], [ 1, 26, 32, 43, 54, 55, 160 ], 
  [ 1, 26, 27, 31, 32, 33, 40, 41, 43, 52, 54, 55, 153, 156, 157, 158, 160, 
      172, 207 ], [ 1, 26, 32, 39, 43, 54, 55, 153, 160, 171 ], 
  [ 1, 26, 27, 31, 32, 40, 43, 52, 54, 55, 153, 158, 160 ], 
  [ 1, 26, 27, 31, 32, 41, 43, 52, 54, 55, 153, 158, 160 ], 
  [ 1, 26, 32, 43, 52, 54, 55, 153, 160 ], 
  [ 1, 26, 32, 39, 43, 52, 53, 54, 55, 153, 155, 158, 160, 171 ], 
  [ 1, 26, 54, 55 ], [ 1, 27, 32, 33, 34, 39, 40, 41, 166, 172 ], 
  [ 1, 3, 27, 28, 32, 33, 34, 35, 39, 40, 41, 59, 60, 61, 161, 166, 172 ], 
  [ 1, 3, 6, 9, 10, 13, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 
      39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 77, 78, 
      79, 85, 86, 91, 92, 93, 94, 95, 96, 97, 98, 99, 105, 106, 108, 109, 
      110, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 153, 154, 
      155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 170, 171, 
      172, 173, 174, 175, 176, 177, 178, 179, 192, 193, 194, 196, 198, 199, 
      200, 207 ], 
  [ 1, 3, 10, 13, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 
      43, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 108, 109, 110, 114, 115, 
      117, 118, 119, 120, 121, 122, 123, 124, 125, 153, 154, 155, 156, 157, 
      158, 159, 160, 161, 162, 165, 166, 167, 170, 171, 172, 173, 179, 198, 
      199, 200, 207 ], 
  [ 1, 26, 27, 31, 32, 33, 34, 38, 39, 40, 41, 43, 52, 53, 54, 55, 153, 154, 
      155, 156, 157, 158, 159, 160, 161, 166, 170, 171, 172, 207 ], 
  [ 1, 27, 32, 34, 39, 40, 41, 172 ], 
  [ 1, 26, 27, 31, 32, 34, 38, 39, 41, 42, 43, 52, 53, 54, 55, 153, 155, 157, 
      158, 159, 160, 171, 173 ], 
  [ 1, 3, 10, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 
      42, 43, 47, 52, 53, 54, 55, 59, 60, 61, 62, 63, 64, 108, 109, 110, 114, 
      115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 148, 149, 
      153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 
      170, 171, 172, 173, 179, 198, 199, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
      38, 39, 40, 41, 42, 43, 47, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 
      75, 77, 78, 79, 82, 85, 86, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      102, 105, 106, 108, 109, 110, 114, 115, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 144, 145, 146, 147, 148, 149, 153, 154, 155, 156, 157, 
      158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 170, 171, 172, 
      173, 174, 175, 176, 177, 178, 179, 185, 186, 187, 188, 189, 190, 192, 
      193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 26, 27, 31, 32, 34, 38, 39, 40, 41, 43, 52, 53, 54, 55, 153, 155, 156, 
      157, 158, 159, 160, 166, 171, 172, 207 ], [ 1, 32, 39, 43, 54, 55 ], 
  [ 1, 27, 32, 40, 41 ], 
  [ 1, 26, 27, 31, 32, 41, 42, 43, 52, 54, 55, 153, 157, 158, 160 ], 
  [ 1, 3, 9, 10, 13, 26, 27, 28, 30, 31, 32, 33, 40, 41, 42, 43, 52, 54, 55, 
      58, 59, 61, 62, 63, 91, 92, 93, 94, 98, 99, 105, 108, 110, 114, 117, 
      118, 119, 122, 123, 124, 153, 154, 156, 157, 158, 160, 172, 173, 176, 
      177, 196, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 26, 32, 39, 43, 54, 55, 58, 60, 62, 93, 97, 109, 118, 
      121, 153, 155, 160, 171, 179 ], 
  [ 1, 3, 9, 10, 13, 26, 27, 28, 30, 31, 32, 40, 41, 42, 43, 52, 54, 55, 58, 
      61, 62, 63, 91, 92, 93, 98, 99, 105, 110, 114, 117, 118, 122, 123, 124, 
      153, 156, 157, 158, 160, 172, 173, 177, 196, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 26, 32, 43, 52, 54, 55, 58, 62, 63, 93, 105, 114, 118, 
      124, 153, 158, 160 ], 
  [ 1, 3, 9, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 64, 93, 
      97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 153, 155, 158, 159, 
      160, 171, 175, 177, 179 ], [ 1, 3, 32, 39, 43, 54, 55, 60, 62, 171 ], 
  [ 1, 2, 3, 4, 5, 9, 10, 11, 12, 13, 23, 24, 26, 27, 28, 30, 31, 32, 33, 34, 
      35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 54, 55, 56, 
      58, 59, 60, 61, 62, 63, 64, 65, 66, 68, 69, 70, 72, 73, 74, 89, 90, 91, 
      92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 158, 
      159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 174, 
      175, 176, 177, 178, 179, 182, 183, 184, 187, 188, 189, 190, 191, 192, 
      193, 194, 195, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 5, 6, 9, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 
      64, 67, 68, 69, 73, 74, 78, 85, 86, 93, 97, 105, 106, 109, 114, 115, 
      118, 121, 124, 125, 153, 155, 158, 159, 160, 171, 175, 177, 178, 179, 
      183, 184 ], 
  [ 1, 3, 5, 9, 10, 13, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 
      42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 68, 69, 70, 72, 73, 74, 
      91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 118, 
      120, 121, 122, 123, 124, 125, 153, 155, 156, 157, 158, 159, 160, 166, 
      167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 183, 184, 194, 196, 
      199, 200, 207 ], 
  [ 1, 3, 5, 9, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 64, 
      68, 69, 73, 74, 93, 97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 
      153, 155, 158, 159, 160, 171, 175, 177, 178, 179, 184 ], 
  [ 1, 3, 5, 10, 13, 26, 32, 39, 43, 52, 53, 54, 55, 60, 62, 63, 64, 69, 73, 
      74, 109, 114, 115, 118, 121, 124, 125, 153, 155, 158, 159, 160, 171, 
      179 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 
      64, 75, 78, 85, 86, 89, 93, 97, 105, 106, 109, 114, 115, 118, 121, 124, 
      125, 148, 153, 155, 158, 159, 160, 171, 175, 177, 178, 179, 189 ], 
  [ 1, 3, 6, 9, 10, 13, 23, 26, 27, 28, 29, 30, 31, 32, 40, 41, 42, 43, 52, 
      54, 55, 58, 61, 62, 63, 75, 79, 85, 89, 91, 92, 93, 98, 99, 105, 110, 
      114, 117, 118, 122, 123, 124, 144, 145, 149, 153, 156, 157, 158, 160, 
      172, 173, 176, 177, 187, 190, 196, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 27, 28, 30, 31, 32, 40, 42, 43, 52, 54, 55, 58, 
      62, 63, 89, 91, 92, 93, 98, 105, 114, 117, 118, 122, 124, 144, 153, 
      156, 158, 160, 177 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 40, 41, 
      42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 89, 91, 92, 93, 95, 96, 
      97, 98, 99, 105, 106, 109, 110, 114, 115, 117, 118, 120, 121, 122, 123, 
      124, 125, 144, 146, 148, 149, 153, 155, 156, 157, 158, 159, 160, 166, 
      167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 187, 189, 190, 194, 
      196, 199, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 63, 64, 
      89, 93, 97, 105, 106, 109, 114, 115, 118, 121, 124, 125, 148, 153, 155, 
      158, 159, 160, 171, 175, 177, 178, 179 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 27, 28, 30, 31, 32, 40, 41, 42, 43, 52, 54, 55, 
      58, 61, 62, 63, 89, 91, 92, 93, 98, 99, 105, 110, 114, 117, 118, 122, 
      123, 124, 144, 149, 153, 156, 157, 158, 160, 172, 173, 176, 177, 187, 
      196, 200, 207 ], 
  [ 1, 3, 5, 9, 10, 13, 23, 24, 26, 27, 28, 30, 31, 32, 34, 35, 37, 38, 39, 
      40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 68, 69, 70, 72, 
      73, 74, 89, 90, 91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 
      114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 144, 146, 148, 149, 
      150, 153, 155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 
      175, 176, 177, 178, 179, 182, 183, 184, 187, 188, 189, 190, 194, 196, 
      199, 200, 207 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 33, 34, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 
      91, 93, 94, 95, 97, 98, 99, 105, 106, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 153, 154, 155, 156, 157, 158, 159, 160, 161, 165, 166, 
      167, 170, 171, 172, 173, 194, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 41, 
      42, 43, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 
      96, 97, 98, 99, 105, 106, 108, 109, 110, 114, 115, 117, 118, 119, 120, 
      121, 122, 123, 124, 125, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 164, 165, 166, 167, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
      179, 192, 194, 196, 198, 199, 200, 207 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 34, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 91, 
      93, 95, 97, 98, 99, 105, 106, 117, 118, 120, 121, 122, 123, 124, 125, 
      153, 155, 156, 157, 158, 159, 160, 166, 167, 170, 171, 172, 173, 196, 
      199, 200, 207 ], 
  [ 1, 3, 9, 10, 13, 23, 26, 27, 28, 30, 31, 32, 33, 34, 35, 37, 38, 39, 40, 
      41, 42, 43, 47, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 89, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 102, 105, 106, 108, 109, 110, 114, 115, 
      117, 118, 119, 120, 121, 122, 123, 124, 125, 144, 146, 148, 149, 153, 
      154, 155, 156, 157, 158, 159, 160, 161, 162, 164, 165, 166, 167, 168, 
      170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 187, 188, 189, 190, 
      192, 193, 194, 196, 198, 199, 200, 207 ], 
  [ 1, 9, 13, 26, 27, 31, 32, 40, 41, 42, 43, 52, 54, 55, 91, 93, 98, 99, 
      105, 117, 118, 122, 123, 124, 153, 156, 157, 158, 160, 172, 173, 200, 
      207 ], [ 1, 2, 3, 4, 5, 10, 11, 12, 13, 21, 23, 24, 26, 27, 28, 30, 31, 
      32, 33, 34, 35, 37, 38, 39, 40, 41, 42, 43, 44, 45, 47, 48, 50, 52, 53, 
      54, 55, 59, 60, 61, 62, 63, 64, 66, 69, 70, 72, 73, 74, 107, 108, 109, 
      110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 
      124, 125, 143, 144, 146, 148, 149, 150, 153, 154, 155, 156, 157, 158, 
      159, 160, 161, 162, 164, 165, 166, 167, 168, 170, 171, 172, 173, 179, 
      184, 198, 199, 200, 207 ], 
  [ 1, 13, 26, 27, 31, 32, 33, 34, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 
      117, 118, 119, 120, 121, 122, 123, 124, 125, 153, 154, 155, 156, 157, 
      158, 159, 160, 161, 165, 166, 167, 170, 171, 172, 173, 199, 200, 207 ], 
  [ 1, 13, 26, 27, 31, 32, 34, 38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 117, 
      118, 120, 121, 122, 123, 124, 125, 153, 155, 156, 157, 158, 159, 160, 
      166, 167, 170, 171, 172, 173, 200, 207 ], 
  [ 1, 13, 26, 27, 31, 32, 40, 41, 42, 43, 52, 54, 55, 117, 118, 122, 123, 
      124, 153, 156, 157, 158, 160, 172, 173, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 40, 42, 43, 52, 
      54, 55, 58, 62, 63, 75, 85, 89, 91, 92, 93, 98, 105, 114, 117, 118, 
      122, 124, 132, 133, 140, 144, 145, 153, 156, 158, 160, 177, 187 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 34, 35, 36, 37, 
      38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 60, 61, 62, 63, 64, 75, 78, 
      79, 85, 86, 89, 91, 92, 93, 95, 96, 97, 98, 99, 105, 106, 109, 110, 
      114, 115, 117, 118, 120, 121, 122, 123, 124, 125, 132, 133, 135, 136, 
      137, 140, 141, 144, 145, 146, 147, 148, 149, 153, 155, 156, 157, 158, 
      159, 160, 166, 167, 170, 171, 172, 173, 175, 176, 177, 178, 179, 185, 
      186, 187, 188, 189, 190, 194, 196, 199, 200, 201, 203, 204, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 32, 39, 43, 52, 53, 54, 55, 58, 60, 62, 
      63, 64, 75, 78, 85, 86, 89, 93, 97, 105, 106, 109, 114, 115, 118, 121, 
      124, 125, 132, 136, 140, 141, 148, 153, 155, 158, 159, 160, 171, 175, 
      177, 178, 179, 185, 189 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 40, 41, 42, 43, 
      52, 54, 55, 58, 61, 62, 63, 75, 79, 85, 89, 91, 92, 93, 98, 99, 105, 
      110, 114, 117, 118, 122, 123, 124, 132, 133, 137, 140, 144, 145, 149, 
      153, 156, 157, 158, 160, 172, 173, 176, 177, 186, 187, 190, 196, 200, 
      201, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 
      38, 39, 40, 41, 42, 43, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 64, 77, 
      78, 79, 85, 86, 91, 92, 93, 94, 95, 96, 97, 98, 99, 105, 106, 108, 109, 
      110, 114, 115, 117, 118, 119, 120, 121, 122, 123, 124, 125, 133, 134, 
      135, 136, 137, 140, 141, 153, 154, 155, 156, 157, 158, 159, 160, 161, 
      162, 163, 164, 165, 166, 167, 170, 171, 172, 173, 174, 175, 176, 177, 
      178, 179, 192, 193, 194, 196, 198, 199, 200, 207 ], 
  [ 1, 3, 6, 9, 10, 13, 19, 23, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 
      37, 38, 39, 40, 41, 42, 43, 47, 52, 53, 54, 55, 58, 59, 60, 61, 62, 63, 
      64, 75, 77, 78, 79, 82, 85, 86, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      102, 105, 106, 108, 109, 110, 114, 115, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 132, 133, 134, 135, 136, 137, 139, 140, 141, 144, 145, 
      146, 147, 148, 149, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 
      163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 
      177, 178, 179, 185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 196, 
      198, 199, 200, 201, 202, 203, 204, 205, 207 ], 
  [ 1, 26, 27, 31, 32, 40, 41, 43, 52, 54, 55, 153, 156, 157, 158, 160, 172 ] 
 ]
gap> S := Semigroup([
> Transformation([1, 3, 5, 5, 3]), Transformation([4, 5, 5, 5, 2])]);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 5, 9, 24, 33, 42, 45, 73, 82, 99, 104, 146 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 32, 33, 
      36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 62, 63, 67, 
      71, 72, 73, 74, 75, 76, 80, 81, 82, 88, 89, 92, 93, 94, 95, 96, 97, 98, 
      99, 104, 107, 108, 109, 110, 111, 117, 119, 120, 121, 125, 126, 127, 
      130, 131, 135, 136, 143, 144, 146, 151, 152, 156, 157, 158, 164, 167, 
      174, 177, 178, 182, 183, 185, 187, 189, 192, 195, 196, 199, 200, 205, 
      208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 5, 8, 32, 33, 36, 37, 45, 72, 80, 92, 93, 151, 152, 157, 177 ], 
  [ 1, 33, 45 ], 
  [ 1, 2, 3, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 
      22, 23, 24, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 
      49, 50, 51, 52, 53, 54, 55, 60, 62, 63, 65, 67, 69, 71, 72, 73, 74, 75, 
      76, 78, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 96, 
      97, 98, 99, 104, 105, 107, 108, 109, 110, 111, 113, 115, 116, 117, 118, 
      119, 120, 121, 124, 125, 126, 127, 128, 129, 130, 131, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 151, 152, 153, 154, 
      155, 156, 157, 158, 160, 162, 163, 164, 166, 167, 168, 169, 170, 171, 
      173, 174, 175, 176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 
      189, 191, 192, 193, 194, 195, 196, 198, 199, 200, 201, 202, 203, 204, 
      205, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
      221, 222, 224, 225 ], 
  [ 1, 4, 5, 8, 32, 33, 34, 36, 37, 45, 69, 72, 78, 80, 91, 92, 93, 151, 152, 
      157, 176, 177 ], [ 1, 32, 33, 45 ], [ 1, 45 ], 
  [ 1, 4, 5, 8, 9, 12, 32, 33, 36, 37, 45, 72, 73, 74, 80, 92, 93, 104, 107, 
      108, 119, 120, 151, 152, 157, 177, 182, 185, 208 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 12, 32, 33, 34, 36, 37, 45, 69, 72, 73, 74, 78, 80, 
      91, 92, 93, 104, 105, 107, 108, 113, 118, 119, 120, 151, 152, 157, 176, 
      177, 180, 182, 184, 185, 208 ], [ 1, 8, 9, 32, 33, 45, 104 ], 
  [ 1, 8, 16, 32, 33, 45 ], 
  [ 1, 4, 5, 8, 13, 16, 32, 33, 36, 37, 45, 72, 75, 80, 92, 93, 125, 126, 
      130, 151, 152, 157, 177, 187 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 16, 32, 33, 34, 36, 37, 45, 69, 72, 75, 78, 80, 
      91, 92, 93, 124, 125, 126, 128, 130, 151, 152, 157, 176, 177, 186, 187 ]
    , [ 1, 32 ], [ 1, 8, 9, 12, 13, 16, 32, 33, 42, 45, 95, 104 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 19, 20, 23, 24, 32, 33, 36, 37, 38, 39, 45, 67, 
      72, 75, 80, 81, 88, 89, 92, 93, 94, 121, 125, 126, 127, 130, 143, 151, 
      152, 157, 177, 187, 195, 213 ], [ 1, 16, 32 ], 
  [ 1, 5, 8, 13, 16, 19, 24, 32, 33, 45, 72, 75, 88, 89, 121 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 15, 16, 18, 19, 20, 23, 24, 32, 33, 34, 36, 37, 
      38, 39, 45, 67, 69, 72, 75, 78, 80, 81, 84, 85, 88, 89, 91, 92, 93, 94, 
      121, 124, 125, 126, 127, 128, 129, 130, 137, 138, 139, 141, 142, 143, 
      151, 152, 157, 173, 176, 177, 186, 187, 194, 195, 212, 213, 214 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 23, 24, 32, 33, 36, 
      37, 38, 39, 40, 42, 43, 45, 67, 71, 72, 73, 74, 75, 76, 80, 81, 82, 88, 
      89, 92, 93, 94, 95, 96, 97, 98, 99, 104, 107, 108, 109, 110, 111, 117, 
      119, 120, 121, 125, 126, 127, 130, 131, 135, 136, 143, 144, 146, 151, 
      152, 156, 157, 158, 174, 177, 178, 182, 183, 185, 187, 189, 192, 195, 
      196, 199, 200, 205, 208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 4, 5, 8, 24, 32, 33, 36, 37, 45, 67, 72, 80, 89, 92, 93, 143, 151, 
      152, 157, 177, 195 ], [ 1, 5, 33, 45 ], 
  [ 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 
      21, 22, 23, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 
      40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 
      58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 
      76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 
      94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 
      109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 
      123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 
      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 
      165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 
      179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
      193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 
      207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 
      221, 222, 223, 224, 225 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 15, 16, 18, 19, 20, 21, 23, 24, 27, 29, 30, 31, 
      32, 33, 34, 35, 36, 37, 38, 39, 45, 67, 68, 69, 70, 72, 75, 77, 78, 79, 
      80, 81, 84, 85, 88, 89, 90, 91, 92, 93, 94, 121, 122, 123, 124, 125, 
      126, 127, 128, 129, 130, 137, 138, 139, 141, 142, 143, 147, 148, 151, 
      152, 157, 173, 176, 177, 186, 187, 190, 194, 195, 197, 212, 213, 214 ], 
  [ 1, 16, 19, 32 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
      24, 26, 27, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 
      44, 45, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 
      83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
      128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 
      142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
      156, 157, 158, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
      184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
      198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
      212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225 ], 
  [ 1, 4, 5, 7, 8, 23, 24, 30, 31, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 
      80, 84, 85, 89, 91, 92, 93, 141, 142, 143, 151, 152, 157, 173, 176, 
      177, 194, 195 ], 
  [ 1, 4, 5, 7, 8, 32, 33, 34, 36, 37, 45, 69, 72, 78, 80, 91, 92, 93, 151, 
      152, 157, 176, 177 ], 
  [ 1, 4, 5, 7, 8, 24, 30, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 80, 85, 
      89, 91, 92, 93, 142, 143, 151, 152, 157, 173, 176, 177, 194, 195 ], 
  [ 1 ], [ 1, 45 ], [ 1, 33, 37, 45 ], 
  [ 1, 8, 13, 16, 19, 27, 32, 33, 34, 37, 39, 45, 88, 90, 91, 93, 124, 126, 
      138, 148 ], [ 1 ], [ 1, 33, 45 ], [ 1, 16, 19, 32, 36, 130, 151 ], 
  [ 1, 8, 13, 16, 19, 32, 33, 37, 45, 88, 93, 126 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 32, 33, 36, 37, 42, 45, 71, 72, 
      73, 74, 75, 76, 80, 82, 92, 93, 95, 104, 107, 108, 119, 120, 125, 126, 
      130, 135, 136, 151, 152, 156, 157, 158, 177, 178, 182, 185, 187, 189, 
      192, 199, 200, 208, 222 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 32, 33, 34, 36, 37, 40, 
      42, 45, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 86, 91, 92, 93, 95, 
      104, 105, 107, 108, 113, 118, 119, 120, 124, 125, 126, 128, 130, 134, 
      135, 136, 151, 152, 153, 154, 156, 157, 158, 175, 176, 177, 178, 180, 
      182, 184, 185, 186, 187, 188, 189, 191, 192, 198, 199, 200, 208, 221, 
      222 ], [ 1, 9, 33, 45, 104 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 36, 37, 42, 45, 67, 71, 72, 73, 
      74, 80, 82, 89, 92, 93, 95, 98, 99, 104, 107, 108, 111, 117, 119, 120, 
      143, 146, 151, 152, 156, 157, 158, 174, 177, 178, 182, 185, 192, 195, 
      196, 199, 200, 205, 208, 211, 219, 222, 225 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 29, 30, 31, 32, 33, 34, 36, 37, 42, 
      43, 45, 67, 69, 71, 72, 73, 74, 78, 80, 82, 84, 85, 86, 87, 89, 91, 92, 
      93, 95, 98, 99, 101, 102, 103, 104, 105, 107, 108, 111, 113, 115, 116, 
      117, 118, 119, 120, 141, 142, 143, 146, 149, 150, 151, 152, 154, 155, 
      156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 
      192, 193, 194, 195, 196, 198, 199, 200, 203, 204, 205, 208, 209, 210, 
      211, 218, 219, 220, 221, 222, 224, 225 ], [ 1 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 24, 32, 33, 36, 37, 42, 45, 48, 62, 67, 71, 72, 
      73, 74, 80, 82, 89, 92, 93, 95, 99, 104, 107, 108, 111, 117, 119, 120, 
      143, 146, 151, 152, 156, 157, 158, 164, 174, 177, 178, 182, 185, 192, 
      195, 196, 199, 200, 205, 208, 211, 219, 222, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 24, 32, 33, 34, 36, 37, 42, 45, 46, 48, 
      60, 62, 67, 69, 71, 72, 73, 74, 78, 80, 82, 85, 86, 89, 91, 92, 93, 95, 
      99, 104, 105, 107, 108, 111, 113, 116, 117, 118, 119, 120, 142, 143, 
      146, 151, 152, 154, 156, 157, 158, 160, 163, 164, 173, 174, 175, 176, 
      177, 178, 180, 182, 184, 185, 191, 192, 193, 194, 195, 196, 198, 199, 
      200, 204, 205, 208, 209, 210, 211, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 24, 32, 33, 42, 45, 72, 73, 74, 82, 89, 95, 99, 104, 
      117, 146, 178, 196 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 42, 45, 48, 72, 73, 74, 75, 
      76, 82, 89, 95, 99, 104, 117, 121, 131, 146, 178, 196 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 24, 32, 33, 36, 37, 40, 42, 45, 
      46, 48, 49, 62, 67, 71, 72, 73, 74, 75, 76, 80, 82, 89, 92, 93, 95, 99, 
      104, 107, 108, 111, 117, 119, 120, 121, 125, 126, 127, 130, 131, 135, 
      136, 143, 144, 146, 151, 152, 156, 157, 158, 164, 167, 174, 177, 178, 
      182, 185, 187, 189, 192, 195, 196, 199, 200, 205, 208, 211, 213, 216, 
      219, 222, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 24, 32, 33, 34, 36, 
      37, 40, 41, 42, 45, 46, 47, 48, 49, 50, 60, 62, 67, 69, 71, 72, 73, 74, 
      75, 76, 78, 80, 82, 85, 86, 89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 
      111, 113, 116, 117, 118, 119, 120, 121, 124, 125, 126, 127, 128, 129, 
      130, 131, 134, 135, 136, 142, 143, 144, 145, 146, 151, 152, 153, 154, 
      156, 157, 158, 160, 163, 164, 166, 167, 168, 173, 174, 175, 176, 177, 
      178, 180, 182, 184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 
      196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 212, 213, 214, 215, 
      216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 32, 33, 
      36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 53, 55, 62, 63, 67, 71, 
      72, 73, 74, 75, 76, 80, 81, 82, 88, 89, 92, 93, 94, 95, 96, 97, 98, 99, 
      104, 107, 108, 109, 110, 111, 117, 119, 120, 121, 125, 126, 127, 130, 
      131, 135, 136, 143, 144, 146, 151, 152, 156, 157, 158, 164, 167, 174, 
      177, 178, 182, 183, 185, 187, 189, 192, 195, 196, 199, 200, 205, 208, 
      211, 213, 216, 219, 222, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 42, 45, 48, 49, 72, 
      73, 74, 75, 76, 82, 88, 89, 95, 96, 97, 99, 104, 117, 121, 131, 146, 
      178, 196 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
      23, 24, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 46, 47, 48, 49, 
      50, 51, 52, 53, 55, 60, 62, 63, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 
      81, 82, 83, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      104, 105, 107, 108, 109, 110, 111, 113, 115, 116, 117, 118, 119, 120, 
      121, 124, 125, 126, 127, 128, 129, 130, 131, 134, 135, 136, 137, 138, 
      139, 140, 141, 142, 143, 144, 145, 146, 151, 152, 153, 154, 155, 156, 
      157, 158, 160, 162, 163, 164, 166, 167, 168, 169, 170, 171, 173, 174, 
      175, 176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 189, 191, 
      192, 193, 194, 195, 196, 198, 199, 200, 201, 202, 203, 204, 205, 208, 
      209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 
      224, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 36, 37, 42, 43, 45, 46, 48, 62, 
      67, 71, 72, 73, 74, 80, 82, 89, 92, 93, 95, 98, 99, 104, 107, 108, 111, 
      117, 119, 120, 143, 146, 151, 152, 156, 157, 158, 164, 174, 177, 178, 
      182, 185, 192, 195, 196, 199, 200, 205, 208, 211, 219, 222, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 
      23, 24, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 
      42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 57, 58, 59, 60, 
      61, 62, 63, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 
      82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 
      114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 
      128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 
      142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 
      156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 
      170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 
      184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 
      198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 
      212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 42, 45, 48, 49, 
      53, 72, 73, 74, 75, 76, 77, 82, 88, 89, 90, 95, 96, 97, 99, 100, 104, 
      117, 121, 131, 146, 178, 179, 196 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 29, 30, 31, 32, 33, 34, 36, 37, 
      42, 43, 44, 45, 46, 47, 48, 55, 59, 60, 62, 67, 69, 71, 72, 73, 74, 78, 
      80, 82, 84, 85, 86, 87, 89, 91, 92, 93, 95, 98, 99, 101, 102, 103, 104, 
      105, 107, 108, 111, 113, 115, 116, 117, 118, 119, 120, 141, 142, 143, 
      146, 149, 150, 151, 152, 154, 155, 156, 157, 158, 160, 162, 163, 164, 
      171, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 192, 193, 
      194, 195, 196, 198, 199, 200, 203, 204, 205, 208, 209, 210, 211, 218, 
      219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 24, 30, 31, 32, 33, 34, 36, 37, 42, 45, 
      46, 47, 48, 60, 62, 67, 69, 71, 72, 73, 74, 78, 80, 82, 85, 86, 89, 91, 
      92, 93, 95, 99, 102, 103, 104, 105, 107, 108, 111, 113, 116, 117, 118, 
      119, 120, 142, 143, 146, 149, 150, 151, 152, 154, 156, 157, 158, 160, 
      163, 164, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 192, 
      193, 194, 195, 196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 218, 
      219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 9, 24, 33, 34, 36, 37, 42, 45, 62, 73, 78, 80, 82, 99, 104, 105, 
      107, 108, 142, 143, 146, 152, 154, 156, 157, 158, 180, 182, 191, 192, 
      204, 205, 208, 218, 219 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 34, 35, 36, 37, 
      38, 39, 42, 45, 48, 49, 53, 57, 60, 62, 63, 72, 73, 74, 75, 76, 77, 78, 
      79, 80, 81, 82, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 99, 100, 104, 
      105, 106, 107, 108, 109, 110, 117, 118, 119, 120, 121, 124, 125, 126, 
      130, 131, 134, 135, 136, 138, 139, 142, 143, 146, 147, 148, 151, 152, 
      154, 156, 157, 158, 163, 164, 166, 167, 170, 172, 176, 177, 178, 179, 
      180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 194, 
      195, 196, 197, 198, 199, 200, 201, 202, 204, 205, 206, 207, 208, 210, 
      211, 212, 213, 215, 216, 218, 219, 221, 222, 223, 224, 225 ], 
  [ 1, 2, 5, 9, 24, 33, 36, 37, 42, 45, 73, 80, 82, 99, 104, 107, 108, 143, 
      146, 152, 156, 157, 158, 182, 192, 205, 208, 219 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 36, 37, 38, 39, 42, 
      45, 48, 49, 53, 62, 72, 73, 74, 75, 76, 80, 81, 82, 88, 89, 92, 93, 94, 
      95, 96, 97, 99, 104, 107, 108, 109, 110, 117, 119, 120, 121, 125, 126, 
      130, 131, 135, 136, 143, 146, 151, 152, 156, 157, 158, 164, 167, 177, 
      178, 182, 183, 185, 187, 189, 192, 195, 196, 199, 200, 205, 208, 211, 
      213, 216, 219, 222, 225 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 
      32, 33, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 57, 
      62, 63, 67, 68, 71, 72, 73, 74, 75, 76, 77, 80, 81, 82, 88, 89, 90, 92, 
      93, 94, 95, 96, 97, 98, 99, 100, 104, 107, 108, 109, 110, 111, 112, 
      117, 119, 120, 121, 125, 126, 127, 130, 131, 135, 136, 143, 144, 146, 
      147, 148, 151, 152, 156, 157, 158, 159, 164, 167, 172, 174, 177, 178, 
      179, 182, 183, 185, 187, 189, 190, 192, 195, 196, 197, 199, 200, 205, 
      206, 207, 208, 211, 213, 216, 219, 222, 223, 225 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 32, 
      33, 34, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 60, 
      62, 63, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 81, 82, 88, 89, 91, 92, 
      93, 94, 95, 96, 97, 98, 99, 104, 105, 107, 108, 109, 110, 111, 113, 
      117, 118, 119, 120, 121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 146, 151, 152, 153, 154, 
      155, 156, 157, 158, 160, 163, 164, 166, 167, 168, 169, 170, 171, 173, 
      174, 175, 176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 189, 
      191, 192, 194, 195, 196, 198, 199, 200, 201, 202, 203, 204, 205, 208, 
      209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 
      224, 225 ], 
  [ 1, 2, 3, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 
      32, 33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 
      55, 57, 60, 61, 62, 63, 64, 65, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 
      77, 78, 79, 80, 81, 82, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 
      100, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 117, 118, 
      119, 120, 121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 136, 137, 
      138, 139, 140, 141, 142, 143, 144, 146, 147, 148, 151, 152, 153, 154, 
      155, 156, 157, 158, 159, 160, 161, 163, 164, 166, 167, 168, 169, 170, 
      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 
      185, 186, 187, 188, 189, 190, 191, 192, 194, 195, 196, 197, 198, 199, 
      200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 
      214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225 ], 
  [ 1, 4, 5, 8, 24, 32, 33, 36, 37, 45, 72, 80, 89, 92, 93, 143, 151, 152, 
      157, 177, 195 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 18, 19, 20, 23, 24, 27, 32, 33, 36, 37, 38, 39, 
      45, 67, 72, 75, 77, 80, 81, 88, 89, 90, 92, 93, 94, 121, 125, 126, 127, 
      130, 143, 147, 148, 151, 152, 157, 177, 187, 190, 195, 197, 213 ], 
  [ 1, 4, 5, 8, 32, 33, 34, 36, 37, 45, 72, 78, 80, 91, 92, 93, 151, 152, 
      157, 176, 177 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 18, 19, 20, 23, 24, 27, 32, 33, 34, 35, 36, 37, 
      38, 39, 45, 67, 68, 69, 72, 75, 77, 78, 79, 80, 81, 88, 89, 90, 91, 92, 
      93, 94, 121, 124, 125, 126, 127, 128, 130, 137, 138, 139, 141, 142, 
      143, 147, 148, 151, 152, 157, 173, 176, 177, 186, 187, 190, 194, 195, 
      197, 212, 213, 214 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 32, 33, 36, 37, 42, 45, 72, 73, 74, 80, 82, 92, 
      93, 95, 104, 107, 108, 119, 120, 151, 152, 156, 157, 158, 177, 178, 
      182, 185, 192, 199, 200, 208, 222 ], [ 1, 5, 8, 32, 33, 45 ], 
  [ 1, 5, 9, 33, 45, 104 ], [ 1, 5, 8, 9, 12, 32, 33, 45, 72, 73, 104 ], 
  [ 1, 5, 8, 13, 16, 32, 33, 45, 72 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 32, 33, 42, 45, 72, 73, 74, 75, 82, 95, 104, 
      178 ], 
  [ 1, 5, 8, 13, 16, 19, 20, 24, 27, 32, 33, 45, 72, 75, 88, 89, 90, 121 ], 
  [ 1, 5, 33, 34, 36, 37, 45, 80, 152, 157 ], 
  [ 1, 5, 8, 13, 16, 19, 20, 24, 27, 32, 33, 34, 35, 36, 37, 38, 39, 45, 72, 
      75, 77, 78, 80, 81, 88, 89, 90, 91, 92, 93, 94, 121, 124, 125, 126, 
      130, 138, 139, 142, 143, 147, 148, 151, 152, 157, 176, 177, 186, 187, 
      190, 194, 195, 197, 212, 213 ], [ 1, 5, 33, 36, 37, 45, 152, 157 ], 
  [ 1, 5, 8, 13, 16, 19, 20, 24, 32, 33, 36, 37, 38, 39, 45, 72, 75, 80, 88, 
      89, 92, 93, 94, 121, 125, 126, 130, 143, 151, 152, 157, 177, 187, 195, 
      213 ], [ 1, 5, 9, 33, 42, 45, 73, 104 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 
      24, 32, 33, 34, 36, 37, 38, 39, 40, 41, 42, 43, 45, 67, 69, 71, 72, 73, 
      74, 75, 76, 78, 80, 81, 82, 84, 85, 86, 87, 88, 89, 91, 92, 93, 94, 95, 
      96, 97, 98, 99, 104, 105, 107, 108, 109, 110, 111, 113, 115, 116, 117, 
      118, 119, 120, 121, 124, 125, 126, 127, 128, 129, 130, 131, 134, 135, 
      136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 151, 152, 153, 
      154, 155, 156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 183, 
      184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 196, 198, 199, 
      200, 201, 202, 203, 204, 205, 208, 209, 210, 211, 212, 213, 214, 215, 
      216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 4, 5, 7, 8, 23, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 80, 85, 
      89, 91, 92, 93, 141, 142, 143, 151, 152, 157, 173, 176, 177, 194, 195 ],
  [ 1, 4, 5, 7, 8, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 80, 89, 91, 
      92, 93, 142, 143, 151, 152, 157, 173, 176, 177, 194, 195 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 32, 33, 34, 36, 37, 42, 45, 69, 71, 72, 73, 
      74, 78, 80, 82, 91, 92, 93, 95, 104, 105, 107, 108, 113, 118, 119, 120, 
      151, 152, 154, 156, 157, 158, 175, 176, 177, 178, 180, 182, 184, 185, 
      191, 192, 198, 199, 200, 208, 221, 222 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 32, 33, 34, 36, 37, 42, 43, 45, 67, 
      69, 71, 72, 73, 74, 78, 80, 82, 84, 85, 86, 89, 91, 92, 93, 95, 98, 99, 
      104, 105, 107, 108, 111, 113, 115, 116, 117, 118, 119, 120, 141, 142, 
      143, 146, 151, 152, 154, 155, 156, 157, 158, 173, 174, 175, 176, 177, 
      178, 180, 182, 184, 185, 191, 192, 193, 194, 195, 196, 198, 199, 200, 
      203, 204, 205, 208, 209, 210, 211, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 8, 13, 16, 19, 32, 33, 45 ], [ 1, 5, 8, 24, 32, 33, 45, 72 ], 
  [ 1, 8, 13, 16, 19, 27, 32, 33, 45, 88 ], [ 1, 8, 32, 33, 34, 37, 45, 93 ], 
  [ 1, 8, 32, 33, 36, 45, 151, 152, 157 ], [ 1, 8, 32, 33, 37, 45 ], 
  [ 1, 8, 13, 16, 19, 32, 33, 36, 38, 45, 88, 92, 125, 130, 151, 152, 157 ], 
  [ 1, 8, 9, 12, 32, 33, 42, 45, 104 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 32, 33, 42, 45, 88, 95, 104 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 42, 45, 72, 73, 74, 75, 
      76, 82, 88, 89, 95, 96, 99, 104, 117, 121, 131, 146, 178, 196 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 36, 37, 45, 67, 72, 73, 74, 80, 
      89, 92, 93, 99, 104, 107, 108, 111, 117, 119, 120, 143, 151, 152, 157, 
      177, 182, 185, 195, 205, 208, 211 ], [ 1, 5, 9, 24, 33, 45, 73, 104 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 27, 32, 33, 42, 45, 88, 90, 95, 96, 104 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 29, 30, 31, 32, 33, 34, 36, 37, 45, 
      67, 69, 72, 73, 74, 78, 80, 84, 85, 89, 91, 92, 93, 98, 99, 102, 103, 
      104, 105, 107, 108, 111, 113, 115, 116, 117, 118, 119, 120, 141, 142, 
      143, 151, 152, 157, 173, 176, 177, 180, 182, 184, 185, 194, 195, 203, 
      204, 205, 208, 209, 210, 211 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 30, 32, 33, 34, 36, 37, 45, 69, 72, 73, 74, 
      78, 80, 91, 92, 93, 104, 105, 107, 108, 113, 118, 119, 120, 151, 152, 
      157, 176, 177, 180, 182, 184, 185, 208 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 24, 30, 31, 32, 33, 34, 36, 37, 45, 67, 69, 
      72, 73, 74, 78, 80, 85, 89, 91, 92, 93, 99, 102, 104, 105, 107, 108, 
      111, 113, 116, 117, 118, 119, 120, 142, 143, 151, 152, 157, 173, 176, 
      177, 180, 182, 184, 185, 194, 195, 204, 205, 208, 209, 210, 211 ], 
  [ 1, 9, 33, 45 ], [ 1, 9, 33, 34, 37, 45, 104, 108 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 27, 32, 33, 34, 35, 37, 39, 42, 45, 88, 90, 
      91, 93, 95, 96, 100, 104, 105, 108, 110, 118, 120, 124, 126, 134, 136, 
      138, 148, 154, 158, 198, 200, 201, 207 ], [ 1, 9, 36, 45, 157 ], 
  [ 1, 9, 33, 37, 45, 104 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 32, 33, 36, 38, 42, 45, 88, 92, 94, 95, 96, 
      104, 107, 119, 125, 130, 135, 151, 152, 156, 157, 199, 208 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 32, 33, 37, 39, 42, 45, 88, 93, 95, 96, 104, 
      108, 120, 126, 136, 158, 200 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 24, 32, 33, 36, 37, 45, 67, 72, 73, 74, 80, 89, 
      92, 93, 99, 104, 107, 108, 117, 119, 120, 143, 151, 152, 157, 177, 182, 
      185, 195, 205, 208, 211 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 32, 
      33, 36, 37, 38, 39, 40, 42, 43, 45, 67, 68, 71, 72, 73, 74, 75, 76, 77, 
      80, 81, 82, 88, 89, 90, 92, 93, 94, 95, 96, 97, 98, 99, 100, 104, 107, 
      108, 109, 110, 111, 117, 119, 120, 121, 125, 126, 127, 130, 131, 135, 
      136, 143, 144, 146, 147, 148, 151, 152, 156, 157, 158, 174, 177, 178, 
      179, 182, 183, 185, 187, 189, 190, 192, 195, 196, 197, 199, 200, 205, 
      206, 207, 208, 211, 213, 216, 219, 222, 223, 225 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 32, 33, 34, 36, 37, 45, 69, 72, 73, 74, 78, 80, 
      91, 92, 93, 104, 105, 107, 108, 118, 119, 120, 151, 152, 157, 176, 177, 
      180, 182, 184, 185, 208 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 45, 67, 68, 69, 70, 71, 72, 73, 
      74, 75, 76, 77, 78, 79, 80, 81, 82, 88, 89, 90, 91, 92, 93, 94, 95, 96, 
      97, 98, 99, 100, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 117, 
      118, 119, 120, 121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 146, 147, 148, 151, 152, 153, 
      154, 155, 156, 157, 158, 173, 174, 175, 176, 177, 178, 179, 180, 181, 
      182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 194, 195, 196, 
      197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 
      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 
      225 ], [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 32, 33, 34, 36, 37, 45, 
      67, 69, 72, 73, 74, 78, 80, 84, 85, 89, 91, 92, 93, 98, 99, 104, 105, 
      107, 108, 111, 113, 116, 117, 118, 119, 120, 141, 142, 143, 151, 152, 
      157, 173, 176, 177, 180, 182, 184, 185, 194, 195, 203, 204, 205, 208, 
      209, 210, 211 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 73, 
      74, 78, 80, 85, 89, 91, 92, 93, 99, 104, 105, 107, 108, 111, 113, 117, 
      118, 119, 120, 142, 143, 151, 152, 157, 173, 176, 177, 180, 182, 184, 
      185, 194, 195, 204, 205, 208, 209, 210, 211 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 45, 72, 73, 74, 89, 99, 104 ], 
  [ 1, 8, 9, 12, 32, 33, 34, 37, 45, 91, 93, 104, 105, 108, 120 ], 
  [ 1, 8, 9, 12, 32, 33, 36, 45, 92, 104, 107, 151, 152, 157, 208 ], 
  [ 1, 8, 9, 12, 32, 33, 37, 45, 93, 104, 108 ], 
  [ 1, 5, 8, 13, 16, 24, 32, 33, 45, 72, 75, 89 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 15, 16, 30, 32, 33, 34, 36, 37, 45, 69, 72, 75, 
      78, 80, 91, 92, 93, 124, 125, 126, 128, 130, 151, 152, 157, 176, 177, 
      186, 187 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 15, 16, 24, 30, 31, 32, 33, 34, 36, 37, 45, 67, 
      69, 72, 75, 78, 80, 85, 89, 91, 92, 93, 121, 122, 124, 125, 126, 127, 
      128, 129, 130, 142, 143, 151, 152, 157, 173, 176, 177, 186, 187, 194, 
      195, 212, 213, 214 ], [ 1, 8, 13, 16, 32, 33, 34, 37, 45, 91, 93, 126 ],
  [ 1, 8, 13, 16, 32, 33, 36, 45, 92, 130, 151, 152, 157 ], 
  [ 1, 8, 13, 16, 32, 33, 37, 45, 93 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 24, 32, 33, 36, 37, 45, 67, 72, 75, 80, 89, 92, 
      93, 121, 125, 126, 130, 143, 151, 152, 157, 177, 187, 195, 213 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 32, 33, 34, 36, 37, 45, 69, 72, 75, 78, 80, 91, 
      92, 93, 124, 125, 126, 130, 151, 152, 157, 176, 177, 186, 187 ], 
  [ 1, 4, 5, 7, 8, 13, 14, 15, 16, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 
      75, 78, 80, 85, 89, 91, 92, 93, 121, 124, 125, 126, 127, 128, 130, 142, 
      143, 151, 152, 157, 173, 176, 177, 186, 187, 194, 195, 212, 213, 214 ], 
  [ 1, 16, 32, 36, 151 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 42, 45, 72, 73, 74, 75, 76, 82, 
      89, 95, 99, 104, 117, 121, 146, 178, 196 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 30, 32, 33, 34, 36, 37, 
      40, 41, 42, 45, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 86, 91, 92, 93, 
      95, 102, 104, 105, 107, 108, 113, 118, 119, 120, 122, 124, 125, 126, 
      128, 130, 134, 135, 136, 149, 151, 152, 153, 154, 156, 157, 158, 175, 
      176, 177, 178, 180, 182, 184, 185, 186, 187, 188, 189, 191, 192, 198, 
      199, 200, 208, 221, 222 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 24, 30, 31, 32, 33, 34, 
      36, 37, 40, 41, 42, 45, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 85, 
      86, 89, 91, 92, 93, 95, 99, 102, 103, 104, 105, 107, 108, 111, 113, 
      116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 
      130, 131, 132, 134, 135, 136, 142, 143, 144, 145, 146, 149, 150, 151, 
      152, 153, 154, 156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 
      184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 196, 198, 199, 
      200, 204, 205, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 
      219, 220, 221, 222, 224, 225 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 32, 33, 34, 37, 42, 45, 91, 93, 95, 104, 105, 
      108, 118, 120, 124, 126, 136, 154, 158, 198, 200 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 32, 33, 36, 42, 45, 92, 95, 104, 107, 119, 125, 
      130, 151, 152, 156, 157, 199, 208 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 32, 33, 37, 42, 45, 93, 95, 104, 108, 120, 126, 
      158, 200 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 18, 19, 20, 23, 24, 32, 33, 34, 36, 37, 38, 39, 
      45, 67, 69, 72, 75, 78, 80, 81, 88, 89, 91, 92, 93, 94, 121, 124, 125, 
      126, 127, 128, 130, 138, 139, 141, 142, 143, 151, 152, 157, 173, 176, 
      177, 186, 187, 194, 195, 212, 213, 214 ], 
  [ 1, 8, 13, 16, 19, 32, 33, 34, 37, 39, 45, 88, 91, 93, 124, 126 ], 
  [ 1, 5, 8, 13, 16, 19, 20, 24, 32, 33, 34, 36, 37, 38, 39, 45, 72, 75, 78, 
      80, 81, 88, 89, 91, 92, 93, 94, 121, 124, 125, 126, 130, 138, 142, 143, 
      151, 152, 157, 176, 177, 186, 187, 194, 195, 212, 213 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 32, 33, 
      34, 36, 37, 38, 39, 40, 42, 43, 45, 67, 69, 71, 72, 73, 74, 75, 76, 78, 
      80, 81, 82, 88, 89, 91, 92, 93, 94, 95, 96, 97, 98, 99, 104, 105, 107, 
      108, 109, 110, 111, 113, 117, 118, 119, 120, 121, 124, 125, 126, 127, 
      128, 130, 131, 134, 135, 136, 137, 138, 139, 141, 142, 143, 144, 146, 
      151, 152, 153, 154, 155, 156, 157, 158, 173, 174, 175, 176, 177, 178, 
      180, 182, 183, 184, 185, 186, 187, 188, 189, 191, 192, 194, 195, 196, 
      198, 199, 200, 201, 202, 203, 204, 205, 208, 209, 210, 211, 212, 213, 
      214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 4, 5, 8, 23, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 80, 89, 91, 
      92, 93, 142, 143, 151, 152, 157, 173, 176, 177, 194, 195 ], 
  [ 1, 5, 24, 33, 34, 36, 37, 45, 78, 80, 143, 152, 157 ], 
  [ 1, 5, 24, 33, 36, 37, 45, 80, 152, 157 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 24, 32, 33, 36, 37, 40, 42, 45, 
      67, 71, 72, 73, 74, 75, 76, 80, 82, 89, 92, 93, 95, 99, 104, 107, 108, 
      111, 117, 119, 120, 121, 125, 126, 127, 130, 131, 135, 136, 143, 146, 
      151, 152, 156, 157, 158, 174, 177, 178, 182, 185, 187, 189, 192, 195, 
      196, 199, 200, 205, 208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 24, 32, 33, 34, 36, 37, 
      40, 41, 42, 45, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 85, 86, 89, 
      91, 92, 93, 95, 99, 104, 105, 107, 108, 111, 113, 116, 117, 118, 119, 
      120, 121, 124, 125, 126, 127, 128, 129, 130, 131, 134, 135, 136, 142, 
      143, 144, 146, 151, 152, 153, 154, 156, 157, 158, 173, 174, 175, 176, 
      177, 178, 180, 182, 184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 
      195, 196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 212, 213, 214, 
      215, 216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 5, 9, 24, 33, 42, 45, 73, 82, 99, 104 ], 
  [ 1, 16, 19, 27, 32, 36, 38, 130, 151 ], 
  [ 1, 8, 13, 16, 19, 27, 32, 33, 37, 39, 45, 88, 90, 93, 126 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 30, 32, 33, 34, 36, 37, 42, 45, 69, 71, 72, 
      73, 74, 78, 80, 82, 86, 91, 92, 93, 95, 102, 104, 105, 107, 108, 113, 
      118, 119, 120, 151, 152, 154, 156, 157, 158, 175, 176, 177, 178, 180, 
      182, 184, 185, 191, 192, 198, 199, 200, 208, 221, 222 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 24, 30, 31, 32, 33, 34, 36, 37, 42, 45, 67, 
      69, 71, 72, 73, 74, 78, 80, 82, 85, 86, 89, 91, 92, 93, 95, 99, 102, 
      103, 104, 105, 107, 108, 111, 113, 116, 117, 118, 119, 120, 142, 143, 
      146, 149, 151, 152, 154, 156, 157, 158, 173, 174, 175, 176, 177, 178, 
      180, 182, 184, 185, 191, 192, 193, 194, 195, 196, 198, 199, 200, 204, 
      205, 208, 209, 210, 211, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 32, 36 ], [ 1, 33, 36, 45, 157 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 32, 33, 34, 36, 37, 40, 42, 45, 
      69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 91, 92, 93, 95, 104, 105, 107, 
      108, 113, 118, 119, 120, 124, 125, 126, 128, 130, 134, 135, 136, 151, 
      152, 154, 156, 157, 158, 175, 176, 177, 178, 180, 182, 184, 185, 186, 
      187, 188, 189, 191, 192, 198, 199, 200, 208, 221, 222 ], 
  [ 1, 9, 33, 34, 37, 42, 45, 104, 105, 108, 158 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 34, 36, 37, 42, 43, 45, 67, 69, 
      71, 72, 73, 74, 78, 80, 82, 89, 91, 92, 93, 95, 98, 99, 104, 105, 107, 
      108, 111, 113, 117, 118, 119, 120, 141, 142, 143, 146, 151, 152, 154, 
      156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 
      192, 194, 195, 196, 198, 199, 200, 203, 204, 205, 208, 209, 210, 211, 
      218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 9, 33, 36, 42, 45, 104, 107, 152, 157, 208 ], [ 1, 36, 45 ], 
  [ 1, 9, 33, 37, 42, 45, 104, 108 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 32, 
      33, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 57, 62, 
      63, 67, 68, 71, 72, 73, 74, 75, 76, 77, 80, 81, 82, 88, 89, 90, 92, 93, 
      94, 95, 96, 97, 98, 99, 100, 104, 107, 108, 109, 110, 111, 112, 117, 
      119, 120, 121, 125, 126, 127, 130, 131, 135, 136, 143, 144, 146, 147, 
      148, 151, 152, 156, 157, 158, 164, 167, 172, 174, 177, 178, 179, 182, 
      183, 185, 187, 189, 190, 192, 195, 196, 197, 199, 200, 205, 206, 207, 
      208, 211, 213, 216, 219, 222, 223, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 24, 32, 33, 34, 36, 37, 42, 45, 46, 48, 60, 62, 
      67, 69, 71, 72, 73, 74, 78, 80, 82, 89, 91, 92, 93, 95, 99, 104, 105, 
      107, 108, 111, 113, 117, 118, 119, 120, 142, 143, 146, 151, 152, 154, 
      156, 157, 158, 163, 164, 173, 174, 175, 176, 177, 178, 180, 182, 184, 
      185, 191, 192, 194, 195, 196, 198, 199, 200, 204, 205, 208, 209, 210, 
      211, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 27, 32, 
      33, 34, 35, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 
      57, 60, 61, 62, 63, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 
      80, 81, 82, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 104, 
      105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 117, 118, 119, 120, 
      121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 136, 137, 138, 139, 
      140, 141, 142, 143, 144, 146, 147, 148, 151, 152, 153, 154, 155, 156, 
      157, 158, 159, 160, 163, 164, 166, 167, 168, 169, 170, 171, 172, 173, 
      174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 
      188, 189, 190, 191, 192, 194, 195, 196, 197, 198, 199, 200, 201, 202, 
      203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 
      217, 218, 219, 220, 221, 222, 223, 224, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 23, 24, 32, 33, 34, 36, 37, 42, 43, 45, 
      46, 47, 48, 55, 60, 62, 67, 69, 71, 72, 73, 74, 78, 80, 82, 84, 85, 86, 
      87, 89, 91, 92, 93, 95, 98, 99, 104, 105, 107, 108, 111, 113, 115, 116, 
      117, 118, 119, 120, 141, 142, 143, 146, 151, 152, 154, 155, 156, 157, 
      158, 160, 163, 164, 171, 173, 174, 175, 176, 177, 178, 180, 182, 184, 
      185, 191, 192, 193, 194, 195, 196, 198, 199, 200, 203, 204, 205, 208, 
      209, 210, 211, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 24, 32, 33, 34, 36, 37, 42, 45, 48, 60, 62, 72, 73, 
      74, 78, 80, 82, 89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 117, 118, 
      119, 120, 142, 143, 146, 151, 152, 154, 156, 157, 158, 164, 176, 177, 
      178, 180, 182, 184, 185, 191, 192, 194, 195, 196, 198, 199, 200, 204, 
      205, 208, 210, 211, 218, 219, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 24, 32, 33, 36, 37, 42, 45, 48, 62, 72, 73, 74, 80, 
      82, 89, 92, 93, 95, 99, 104, 107, 108, 117, 119, 120, 143, 146, 151, 
      152, 156, 157, 158, 177, 178, 182, 185, 192, 195, 196, 199, 200, 205, 
      208, 211, 219, 222, 225 ], 
  [ 1, 2, 4, 5, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 24, 30, 31, 32, 33, 
      34, 36, 37, 40, 41, 42, 45, 46, 47, 48, 49, 50, 51, 59, 60, 62, 67, 69, 
      71, 72, 73, 74, 75, 76, 78, 80, 82, 85, 86, 89, 91, 92, 93, 95, 99, 
      102, 103, 104, 105, 107, 108, 111, 113, 116, 117, 118, 119, 120, 121, 
      122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 
      136, 142, 143, 144, 145, 146, 149, 150, 151, 152, 153, 154, 156, 157, 
      158, 160, 163, 164, 166, 167, 168, 173, 174, 175, 176, 177, 178, 180, 
      182, 184, 185, 186, 187, 188, 189, 191, 192, 193, 194, 195, 196, 198, 
      199, 200, 204, 205, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 
      218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 34, 36, 37, 42, 45, 48, 49, 
      60, 62, 72, 73, 74, 75, 76, 78, 80, 82, 89, 91, 92, 93, 95, 99, 104, 
      105, 107, 108, 117, 118, 119, 120, 121, 124, 125, 126, 130, 131, 134, 
      135, 136, 142, 143, 146, 151, 152, 154, 156, 157, 158, 163, 164, 167, 
      176, 177, 178, 180, 182, 184, 185, 186, 187, 188, 189, 191, 192, 194, 
      195, 196, 198, 199, 200, 204, 205, 208, 210, 211, 212, 213, 215, 216, 
      218, 219, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 36, 37, 42, 45, 48, 49, 62, 
      72, 73, 74, 75, 76, 80, 82, 89, 92, 93, 95, 99, 104, 107, 108, 117, 
      119, 120, 121, 125, 126, 130, 131, 135, 136, 143, 146, 151, 152, 156, 
      157, 158, 164, 177, 178, 182, 185, 187, 189, 192, 195, 196, 199, 200, 
      205, 208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 24, 32, 33, 34, 36, 37, 40, 42, 
      45, 46, 48, 49, 50, 60, 62, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 
      89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 111, 113, 117, 118, 119, 
      120, 121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 136, 142, 143, 
      144, 146, 151, 152, 153, 154, 156, 157, 158, 160, 163, 164, 166, 167, 
      173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 186, 187, 188, 189, 
      191, 192, 194, 195, 196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 
      212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 18, 19, 20, 22, 23, 24, 32, 33, 
      34, 36, 37, 38, 39, 40, 42, 43, 45, 46, 48, 49, 50, 52, 53, 55, 60, 62, 
      63, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 81, 82, 88, 89, 91, 92, 93, 
      94, 95, 96, 97, 98, 99, 104, 105, 107, 108, 109, 110, 111, 113, 117, 
      118, 119, 120, 121, 124, 125, 126, 127, 128, 130, 131, 134, 135, 136, 
      137, 138, 139, 140, 141, 142, 143, 144, 146, 151, 152, 153, 154, 155, 
      156, 157, 158, 160, 163, 164, 166, 167, 168, 170, 171, 173, 174, 175, 
      176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 189, 191, 192, 
      194, 195, 196, 198, 199, 200, 201, 202, 203, 204, 205, 208, 209, 210, 
      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 224, 225 ], 
  [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 34, 36, 37, 38, 39, 
      42, 45, 48, 49, 53, 60, 62, 63, 72, 73, 74, 75, 76, 78, 80, 81, 82, 88, 
      89, 91, 92, 93, 94, 95, 96, 97, 99, 104, 105, 107, 108, 109, 110, 117, 
      118, 119, 120, 121, 124, 125, 126, 130, 131, 134, 135, 136, 138, 139, 
      142, 143, 146, 151, 152, 154, 156, 157, 158, 163, 164, 166, 167, 176, 
      177, 178, 180, 182, 183, 184, 185, 186, 187, 188, 189, 191, 192, 194, 
      195, 196, 198, 199, 200, 201, 202, 204, 205, 208, 210, 211, 212, 213, 
      215, 216, 218, 219, 221, 222, 224, 225 ], 
  [ 1, 2, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 34, 36, 37, 42, 43, 45, 46, 48, 
      55, 60, 62, 67, 69, 71, 72, 73, 74, 78, 80, 82, 89, 91, 92, 93, 95, 98, 
      99, 104, 105, 107, 108, 111, 113, 117, 118, 119, 120, 141, 142, 143, 
      146, 151, 152, 154, 155, 156, 157, 158, 160, 163, 164, 173, 174, 175, 
      176, 177, 178, 180, 182, 184, 185, 191, 192, 194, 195, 196, 198, 199, 
      200, 203, 204, 205, 208, 209, 210, 211, 218, 219, 220, 221, 222, 224, 
      225 ], [ 1, 2, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 36, 37, 
      38, 39, 42, 45, 48, 49, 53, 57, 62, 63, 72, 73, 74, 75, 76, 77, 80, 81, 
      82, 88, 89, 90, 92, 93, 94, 95, 96, 97, 99, 100, 104, 107, 108, 109, 
      110, 117, 119, 120, 121, 125, 126, 130, 131, 135, 136, 143, 146, 147, 
      148, 151, 152, 156, 157, 158, 164, 167, 177, 178, 179, 182, 183, 185, 
      187, 189, 190, 192, 195, 196, 197, 199, 200, 205, 206, 207, 208, 211, 
      213, 216, 219, 222, 223, 225 ], 
  [ 1, 4, 5, 8, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 78, 80, 89, 91, 92, 
      93, 142, 143, 151, 152, 157, 176, 177, 194, 195 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 24, 32, 33, 36, 37, 42, 45, 67, 71, 72, 73, 74, 
      80, 82, 89, 92, 93, 95, 99, 104, 107, 108, 111, 117, 119, 120, 143, 
      146, 151, 152, 156, 157, 158, 177, 178, 182, 185, 192, 195, 196, 199, 
      200, 205, 208, 211, 219, 222, 225 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 32, 33, 34, 36, 37, 42, 45, 69, 71, 72, 73, 74, 
      78, 80, 82, 91, 92, 93, 95, 104, 105, 107, 108, 113, 118, 119, 120, 
      151, 152, 154, 156, 157, 158, 176, 177, 178, 180, 182, 184, 185, 191, 
      192, 198, 199, 200, 208, 221, 222 ], 
  [ 1, 5, 8, 32, 33, 34, 36, 37, 45, 72, 78, 80, 91, 92, 93, 151, 152, 157, 
      177 ], [ 1, 5, 8, 32, 33, 36, 37, 45, 72, 80, 92, 93, 151, 152, 157 ], 
  [ 1, 5, 8, 9, 12, 32, 33, 42, 45, 72, 73, 74, 82, 95, 104 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 42, 45, 72, 73, 74, 
      75, 76, 77, 82, 88, 89, 90, 95, 96, 97, 99, 100, 104, 117, 121, 131, 
      146, 178, 196 ], 
  [ 1, 5, 9, 33, 34, 36, 37, 45, 73, 78, 80, 104, 105, 107, 108, 152, 157, 
      182, 208 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 34, 35, 36, 37, 38, 
      39, 42, 45, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 88, 89, 90, 91, 
      92, 93, 94, 95, 96, 97, 99, 100, 104, 105, 106, 107, 108, 109, 110, 
      117, 118, 119, 120, 121, 124, 125, 126, 130, 131, 134, 135, 136, 138, 
      139, 142, 143, 146, 147, 148, 151, 152, 154, 156, 157, 158, 176, 177, 
      178, 179, 180, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 
      194, 195, 196, 197, 198, 199, 200, 201, 202, 204, 205, 206, 207, 208, 
      210, 211, 212, 213, 215, 216, 218, 219, 221, 222, 223, 224, 225 ], 
  [ 1, 5, 9, 33, 36, 37, 45, 73, 80, 104, 107, 108, 152, 157, 208 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 36, 37, 38, 39, 42, 45, 
      72, 73, 74, 75, 76, 80, 81, 82, 88, 89, 92, 93, 94, 95, 96, 97, 99, 
      104, 107, 108, 109, 110, 117, 119, 120, 121, 125, 126, 130, 131, 135, 
      136, 143, 146, 151, 152, 156, 157, 158, 177, 178, 182, 185, 187, 189, 
      192, 195, 196, 199, 200, 205, 208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 5, 8, 9, 12, 32, 33, 34, 36, 37, 45, 72, 73, 74, 78, 80, 91, 92, 93, 
      104, 105, 107, 108, 118, 119, 120, 151, 152, 157, 176, 177, 180, 182, 
      185, 208 ], 
  [ 1, 5, 8, 9, 12, 32, 33, 36, 37, 45, 72, 73, 74, 80, 92, 93, 104, 107, 
      108, 119, 120, 151, 152, 157, 177, 182, 208 ], 
  [ 1, 5, 8, 13, 16, 32, 33, 34, 36, 37, 45, 72, 75, 78, 80, 91, 92, 93, 124, 
      125, 126, 130, 151, 152, 157, 176, 177, 187 ], 
  [ 1, 5, 8, 13, 16, 32, 33, 36, 37, 45, 72, 75, 80, 92, 93, 125, 126, 130, 
      151, 152, 157, 177 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 32, 33, 34, 36, 37, 42, 45, 72, 73, 74, 75, 
      76, 78, 80, 82, 91, 92, 93, 95, 104, 105, 107, 108, 118, 119, 120, 124, 
      125, 126, 130, 134, 135, 136, 151, 152, 154, 156, 157, 158, 176, 177, 
      178, 180, 182, 184, 185, 186, 187, 189, 191, 192, 198, 199, 200, 208, 
      221, 222 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 32, 33, 36, 37, 42, 45, 72, 73, 74, 75, 76, 
      80, 82, 92, 93, 95, 104, 107, 108, 119, 120, 125, 126, 130, 135, 136, 
      151, 152, 156, 157, 158, 177, 178, 182, 185, 187, 192, 199, 200, 208, 
      222 ], 
  [ 1, 5, 8, 13, 16, 19, 20, 24, 27, 32, 33, 36, 37, 38, 39, 45, 72, 75, 77, 
      80, 81, 88, 89, 90, 92, 93, 94, 121, 125, 126, 130, 143, 147, 148, 151, 
      152, 157, 177, 187, 195, 197, 213 ], 
  [ 1, 5, 9, 33, 34, 36, 37, 42, 45, 73, 78, 80, 82, 104, 105, 107, 108, 152, 
      154, 156, 157, 158, 180, 182, 192, 208 ], 
  [ 1, 5, 9, 33, 36, 37, 42, 45, 73, 80, 82, 104, 107, 108, 152, 156, 157, 
      158, 182, 208 ], 
  [ 1, 4, 5, 7, 8, 9, 10, 11, 12, 24, 32, 33, 34, 36, 37, 42, 45, 67, 69, 71, 
      72, 73, 74, 78, 80, 82, 85, 86, 89, 91, 92, 93, 95, 99, 104, 105, 107, 
      108, 111, 113, 116, 117, 118, 119, 120, 142, 143, 146, 151, 152, 154, 
      156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 
      192, 194, 195, 196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 218, 
      219, 220, 221, 222, 224, 225 ], 
  [ 1, 5, 8, 24, 32, 33, 34, 36, 37, 45, 72, 78, 80, 89, 91, 92, 93, 142, 
      143, 151, 152, 157, 176, 177, 195 ], 
  [ 1, 5, 8, 24, 32, 33, 36, 37, 45, 72, 80, 89, 92, 93, 143, 151, 152, 157, 
      177 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 42, 45, 72, 73, 74, 82, 89, 95, 99, 104, 117, 
      146, 178 ], 
  [ 1, 8, 13, 16, 19, 27, 32, 33, 36, 38, 45, 88, 90, 92, 94, 125, 130, 147, 
      151, 152, 157 ], 
  [ 1, 8, 9, 12, 32, 33, 34, 37, 42, 45, 91, 93, 95, 104, 105, 108, 118, 120, 
      154, 158, 200 ], 
  [ 1, 8, 9, 12, 32, 33, 36, 42, 45, 92, 95, 104, 107, 119, 151, 152, 156, 
      157, 208 ], 
  [ 1, 8, 9, 12, 32, 33, 37, 42, 45, 93, 95, 104, 108, 120, 158 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 32, 33, 34, 37, 39, 42, 45, 88, 91, 93, 95, 
      96, 104, 105, 108, 110, 118, 120, 124, 126, 134, 136, 138, 154, 158, 
      198, 200 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 32, 33, 34, 36, 37, 38, 39, 42, 
      45, 72, 73, 74, 75, 76, 78, 80, 81, 82, 88, 89, 91, 92, 93, 94, 95, 96, 
      97, 99, 104, 105, 107, 108, 109, 110, 117, 118, 119, 120, 121, 124, 
      125, 126, 130, 131, 134, 135, 136, 138, 139, 142, 143, 146, 151, 152, 
      154, 156, 157, 158, 176, 177, 178, 180, 182, 183, 184, 185, 186, 187, 
      188, 189, 191, 192, 194, 195, 196, 198, 199, 200, 201, 204, 205, 208, 
      210, 211, 212, 213, 215, 216, 218, 219, 221, 222, 224, 225 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 23, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 73, 
      74, 78, 80, 89, 91, 92, 93, 98, 99, 104, 105, 107, 108, 111, 113, 117, 
      118, 119, 120, 141, 142, 143, 151, 152, 157, 173, 176, 177, 180, 182, 
      184, 185, 194, 195, 204, 205, 208, 209, 210, 211 ], 
  [ 1, 5, 9, 24, 33, 34, 36, 37, 45, 73, 78, 80, 99, 104, 105, 107, 108, 142, 
      143, 152, 157, 180, 182, 205, 208 ], 
  [ 1, 5, 9, 24, 33, 36, 37, 45, 73, 80, 99, 104, 107, 108, 143, 152, 157, 
      182, 208 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 27, 32, 33, 36, 38, 42, 45, 88, 90, 92, 94, 
      95, 96, 100, 104, 107, 109, 119, 125, 130, 135, 147, 151, 152, 156, 
      157, 197, 199, 208 ], 
  [ 1, 8, 9, 12, 13, 16, 17, 19, 27, 32, 33, 37, 39, 42, 45, 88, 90, 93, 95, 
      96, 100, 104, 108, 110, 120, 126, 136, 148, 158, 200 ], 
  [ 1, 9, 33, 36, 45, 104, 107, 152, 157 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 73, 74, 
      78, 80, 89, 91, 92, 93, 99, 104, 105, 107, 108, 111, 113, 117, 118, 
      119, 120, 142, 143, 151, 152, 157, 173, 176, 177, 180, 182, 184, 185, 
      194, 195, 204, 205, 208, 210, 211 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 34, 36, 37, 45, 72, 73, 74, 78, 80, 89, 91, 
      92, 93, 99, 104, 105, 107, 108, 117, 118, 119, 120, 142, 143, 151, 152, 
      157, 176, 177, 180, 182, 184, 185, 194, 195, 204, 205, 208, 211 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 36, 37, 45, 72, 73, 74, 80, 89, 92, 93, 99, 
      104, 107, 108, 117, 119, 120, 143, 151, 152, 157, 177, 182, 185, 195, 
      205, 208 ], 
  [ 1, 5, 8, 13, 16, 24, 32, 33, 34, 36, 37, 45, 72, 75, 78, 80, 89, 91, 92, 
      93, 121, 124, 125, 126, 130, 142, 143, 151, 152, 157, 176, 177, 186, 
      187, 194, 195, 213 ], 
  [ 1, 5, 8, 13, 16, 24, 32, 33, 36, 37, 45, 72, 75, 80, 89, 92, 93, 121, 
      125, 126, 130, 143, 151, 152, 157, 177, 187, 195 ], 
  [ 1, 4, 5, 8, 13, 14, 16, 24, 32, 33, 34, 36, 37, 45, 67, 69, 72, 75, 78, 
      80, 89, 91, 92, 93, 121, 124, 125, 126, 127, 128, 130, 142, 143, 151, 
      152, 157, 173, 176, 177, 186, 187, 194, 195, 212, 213 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 34, 36, 37, 42, 45, 72, 73, 74, 
      75, 76, 78, 80, 82, 89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 117, 
      118, 119, 120, 121, 124, 125, 126, 130, 131, 134, 135, 136, 142, 143, 
      146, 151, 152, 154, 156, 157, 158, 176, 177, 178, 180, 182, 184, 185, 
      186, 187, 188, 189, 191, 192, 194, 195, 196, 198, 199, 200, 204, 205, 
      208, 210, 211, 212, 213, 216, 218, 219, 221, 222, 224, 225 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 24, 32, 33, 36, 37, 42, 45, 72, 73, 74, 75, 
      76, 80, 82, 89, 92, 93, 95, 99, 104, 107, 108, 117, 119, 120, 121, 125, 
      126, 130, 131, 135, 136, 143, 146, 151, 152, 156, 157, 158, 177, 178, 
      182, 185, 187, 189, 192, 195, 196, 199, 200, 205, 208, 211, 213, 219, 
      222, 225 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 13, 14, 16, 17, 24, 32, 33, 34, 36, 37, 40, 42, 
      45, 67, 69, 71, 72, 73, 74, 75, 76, 78, 80, 82, 89, 91, 92, 93, 95, 99, 
      104, 105, 107, 108, 111, 113, 117, 118, 119, 120, 121, 124, 125, 126, 
      127, 128, 130, 131, 134, 135, 136, 142, 143, 144, 146, 151, 152, 153, 
      154, 156, 157, 158, 173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 
      186, 187, 188, 189, 191, 192, 194, 195, 196, 198, 199, 200, 204, 205, 
      208, 209, 210, 211, 212, 213, 214, 215, 216, 218, 219, 220, 221, 222, 
      224, 225 ], 
  [ 1, 5, 9, 24, 33, 34, 36, 37, 42, 45, 73, 78, 80, 82, 99, 104, 105, 107, 
      108, 142, 143, 146, 152, 154, 156, 157, 158, 180, 182, 191, 192, 204, 
      205, 208, 219 ], 
  [ 1, 5, 9, 24, 33, 36, 37, 42, 45, 73, 80, 82, 99, 104, 107, 108, 143, 146, 
      152, 156, 157, 158, 182, 192, 205, 208 ], 
  [ 1, 4, 5, 8, 9, 10, 12, 24, 32, 33, 34, 36, 37, 42, 45, 67, 69, 71, 72, 
      73, 74, 78, 80, 82, 89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 111, 
      113, 117, 118, 119, 120, 142, 143, 146, 151, 152, 154, 156, 157, 158, 
      173, 174, 175, 176, 177, 178, 180, 182, 184, 185, 191, 192, 194, 195, 
      196, 198, 199, 200, 204, 205, 208, 209, 210, 211, 218, 219, 221, 222, 
      224, 225 ], 
  [ 1, 5, 8, 9, 12, 32, 33, 34, 36, 37, 42, 45, 72, 73, 74, 78, 80, 82, 91, 
      92, 93, 95, 104, 105, 107, 108, 118, 119, 120, 151, 152, 154, 156, 157, 
      158, 176, 177, 178, 180, 182, 184, 185, 191, 192, 198, 199, 200, 208, 
      222 ], 
  [ 1, 5, 8, 9, 12, 32, 33, 36, 37, 42, 45, 72, 73, 74, 80, 82, 92, 93, 95, 
      104, 107, 108, 119, 120, 151, 152, 156, 157, 158, 177, 178, 182, 185, 
      192, 199, 200, 208 ], 
  [ 1, 5, 8, 9, 12, 13, 16, 17, 19, 20, 24, 27, 32, 33, 36, 37, 38, 39, 42, 
      45, 72, 73, 74, 75, 76, 77, 80, 81, 82, 88, 89, 90, 92, 93, 94, 95, 96, 
      97, 99, 100, 104, 107, 108, 109, 110, 117, 119, 120, 121, 125, 126, 
      130, 131, 135, 136, 143, 146, 147, 148, 151, 152, 156, 157, 158, 177, 
      178, 179, 182, 183, 185, 187, 189, 190, 192, 195, 196, 197, 199, 200, 
      205, 206, 207, 208, 211, 213, 216, 219, 222, 225 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 34, 36, 37, 42, 45, 72, 73, 74, 78, 80, 82, 
      89, 91, 92, 93, 95, 99, 104, 105, 107, 108, 117, 118, 119, 120, 142, 
      143, 146, 151, 152, 154, 156, 157, 158, 176, 177, 178, 180, 182, 184, 
      185, 191, 192, 194, 195, 196, 198, 199, 200, 204, 205, 208, 210, 211, 
      218, 219, 221, 222, 225 ], 
  [ 1, 5, 8, 9, 12, 24, 32, 33, 36, 37, 42, 45, 72, 73, 74, 80, 82, 89, 92, 
      93, 95, 99, 104, 107, 108, 117, 119, 120, 143, 146, 151, 152, 156, 157, 
      158, 177, 178, 182, 185, 192, 195, 196, 199, 200, 205, 208, 211, 219, 
      222 ] ]
gap> S := OrderEndomorphisms(2);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 3 ], [ 1 ] ]
gap> S := OrderEndomorphisms(3);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 4 ], [ 1, 2, 4 ], [ 1 ] ]
gap> S := OrderEndomorphisms(4);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 5 ], [ 1, 2, 5 ], [ 1, 2, 3, 5 ], [ 1 ] ]
gap> S := PartitionMonoid(2);;
gap> l := LatticeOfCongruences(S);
[ [  ], [ 1, 3, 4 ], [ 1 ], [ 1 ], [ 1, 3, 9 ], [ 1, 2, 3, 4, 5, 9, 10 ], 
  [ 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12, 13 ], [ 1, 3 ], [ 1 ], [ 1, 4, 9 ], 
  [ 1, 2, 3, 4, 8 ], [ 1, 3, 5, 8, 9 ], 
  [ 1, 2, 3, 4, 5, 6, 8, 9, 10, 11, 12 ] ]

#T# Check robustness against non-free infinite semigroups
#TODO!

#T# SEMIGROUPS_UnbindVariables
gap> Unbind(P);
gap> Unbind(R);
gap> Unbind(S);
gap> Unbind(c);
gap> Unbind(classes);
gap> Unbind(classx);
gap> Unbind(classy);
gap> Unbind(classz);
gap> Unbind(cong);
gap> Unbind(gens);
gap> Unbind(l);
gap> Unbind(q);
gap> Unbind(s);
gap> Unbind(t);
gap> Unbind(u);
gap> Unbind(v);
gap> Unbind(x);
gap> Unbind(y);
gap> Unbind(z);

#E#
gap> SEMIGROUPS.StopTest();
gap> STOP_TEST("Semigroups package: extreme/cong.tst");
