/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.newt;

import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.newt.Display;
import com.jogamp.newt.MonitorMode;
import com.jogamp.newt.Screen;
import java.util.List;
import javax.media.nativewindow.util.DimensionImmutable;
import javax.media.nativewindow.util.Rectangle;
import javax.media.nativewindow.util.RectangleImmutable;

public abstract class MonitorDevice {
    protected final Screen screen;
    protected final int nativeId;
    protected final DimensionImmutable sizeMM;
    protected final MonitorMode originalMode;
    protected final ArrayHashSet<MonitorMode> supportedModes;
    protected MonitorMode currentMode;
    protected boolean modeChanged;
    protected Rectangle viewport;

    protected MonitorDevice(Screen screen, int n, DimensionImmutable dimensionImmutable, Rectangle rectangle, MonitorMode monitorMode, ArrayHashSet<MonitorMode> arrayHashSet) {
        this.screen = screen;
        this.nativeId = n;
        this.sizeMM = dimensionImmutable;
        this.originalMode = monitorMode;
        this.supportedModes = arrayHashSet;
        this.currentMode = monitorMode;
        this.viewport = rectangle;
        this.modeChanged = false;
    }

    public final Screen getScreen() {
        return this.screen;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof MonitorDevice) {
            MonitorDevice monitorDevice = (MonitorDevice)object;
            return monitorDevice.nativeId == this.nativeId;
        }
        return false;
    }

    public final int hashCode() {
        return this.nativeId;
    }

    public final int getId() {
        return this.nativeId;
    }

    public final DimensionImmutable getSizeMM() {
        return this.sizeMM;
    }

    public final MonitorMode getOriginalMode() {
        return this.originalMode;
    }

    public final List<MonitorMode> getSupportedModes() {
        return this.supportedModes.getData();
    }

    public final RectangleImmutable getViewport() {
        return this.viewport;
    }

    public final boolean contains(int n, int n2) {
        return n >= this.viewport.getX() && n < this.viewport.getX() + this.viewport.getWidth() && n2 >= this.viewport.getY() && n2 < this.viewport.getY() + this.viewport.getHeight();
    }

    public final float coverage(RectangleImmutable rectangleImmutable) {
        return this.viewport.coverage(rectangleImmutable);
    }

    public static Rectangle unionOfViewports(Rectangle rectangle, List<MonitorDevice> list) {
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MAX_VALUE;
        int n3 = Integer.MIN_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = list.size() - 1; i >= 0; --i) {
            RectangleImmutable rectangleImmutable = list.get(i).getViewport();
            n = Math.min(n, rectangleImmutable.getX());
            n3 = Math.max(n3, rectangleImmutable.getX() + rectangleImmutable.getWidth());
            n2 = Math.min(n2, rectangleImmutable.getY());
            n4 = Math.max(n4, rectangleImmutable.getY() + rectangleImmutable.getHeight());
        }
        rectangle.set(n, n2, n3 - n, n4 - n2);
        return rectangle;
    }

    public final boolean isOriginalMode() {
        return this.currentMode.hashCode() == this.originalMode.hashCode();
    }

    public final boolean isModeChangedByUs() {
        return this.modeChanged && !this.isOriginalMode();
    }

    public final MonitorMode getCurrentMode() {
        return this.currentMode;
    }

    public abstract MonitorMode queryCurrentMode();

    public abstract boolean setCurrentMode(MonitorMode var1);

    public String toString() {
        return "Monitor[Id " + Display.toHexString(this.nativeId) + ", " + this.sizeMM + " mm, viewport " + this.viewport + ", orig " + this.originalMode + ", curr " + this.currentMode + ", modeChanged " + this.modeChanged + ", modeCount " + this.supportedModes.size() + "]";
    }
}

