/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.exif.test;

import com.drew.imaging.jpeg.JpegSegmentData;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.exif.NikonType2MakernoteDescriptor;
import com.drew.metadata.exif.NikonType2MakernoteDirectory;
import java.io.File;
import junit.framework.TestCase;

public class NikonType2MakernoteTest1
extends TestCase {
    private NikonType2MakernoteDirectory _nikonDirectory;
    private NikonType2MakernoteDescriptor _descriptor;

    public NikonType2MakernoteTest1(String s) {
        super(s);
    }

    protected void setUp() throws Exception {
        File metadataFile = new File("src/com/drew/metadata/exif/test/nikonMakernoteType2a.metadata");
        Metadata metadata = new ExifReader(JpegSegmentData.FromFile(metadataFile)).extract();
        this._nikonDirectory = (NikonType2MakernoteDirectory)metadata.getDirectory(NikonType2MakernoteDirectory.class);
        this._descriptor = new NikonType2MakernoteDescriptor(this._nikonDirectory);
    }

    public void testNikonMakernote_MatchesKnownValues() throws Exception {
        NikonType2MakernoteTest1.assertEquals((String)"48 50 48 48", (String)this._nikonDirectory.getString(1));
        NikonType2MakernoteTest1.assertEquals((String)"0 320", (String)this._nikonDirectory.getString(2));
        NikonType2MakernoteTest1.assertEquals((String)"0 320", (String)this._nikonDirectory.getString(19));
        NikonType2MakernoteTest1.assertEquals((String)"FLASH       ", (String)this._nikonDirectory.getString(5));
        NikonType2MakernoteTest1.assertEquals((String)"AUTO  ", (String)this._nikonDirectory.getString(6));
        NikonType2MakernoteTest1.assertEquals((String)"AF-C  ", (String)this._nikonDirectory.getString(7));
        NikonType2MakernoteTest1.assertEquals((String)"NORMAL      ", (String)this._nikonDirectory.getString(8));
        NikonType2MakernoteTest1.assertEquals((String)"0", (String)this._nikonDirectory.getString(11));
        NikonType2MakernoteTest1.assertEquals((String)"914", (String)this._nikonDirectory.getString(17));
        NikonType2MakernoteTest1.assertEquals((String)"AUTO    ", (String)this._nikonDirectory.getString(129));
        NikonType2MakernoteTest1.assertEquals((String)"6", (String)this._nikonDirectory.getString(131));
        NikonType2MakernoteTest1.assertEquals((String)"240/10 850/10 35/10 45/10", (String)this._nikonDirectory.getString(132));
        NikonType2MakernoteTest1.assertEquals((String)"0", (String)this._nikonDirectory.getString(135));
        NikonType2MakernoteTest1.assertEquals((String)"1", (String)this._nikonDirectory.getString(137));
        NikonType2MakernoteTest1.assertEquals((String)"0", (String)this._nikonDirectory.getString(138));
        NikonType2MakernoteTest1.assertEquals((String)"MODE1   ", (String)this._nikonDirectory.getString(141));
        NikonType2MakernoteTest1.assertEquals((String)"NATURAL    ", (String)this._nikonDirectory.getString(144));
        NikonType2MakernoteTest1.assertEquals((String)"0", (String)this._nikonDirectory.getString(146));
        NikonType2MakernoteTest1.assertEquals((String)"OFF ", (String)this._nikonDirectory.getString(149));
        NikonType2MakernoteTest1.assertEquals((String)"78/10 78/10", (String)this._nikonDirectory.getString(154));
    }

    public void testGetLensDescription() throws MetadataException {
        NikonType2MakernoteTest1.assertEquals((String)"24-85mm f/3.5-4.5", (String)this._descriptor.getDescription(132));
        NikonType2MakernoteTest1.assertEquals((String)"24-85mm f/3.5-4.5", (String)this._descriptor.getLensDescription());
    }

    public void testGetHueAdjustmentDescription() throws MetadataException {
        NikonType2MakernoteTest1.assertEquals((String)"0 degrees", (String)this._descriptor.getDescription(146));
        NikonType2MakernoteTest1.assertEquals((String)"0 degrees", (String)this._descriptor.getHueAdjustmentDescription());
    }

    public void testGetColorModeDescription() throws Exception {
        NikonType2MakernoteTest1.assertEquals((String)"Mode I (sRGB)", (String)this._descriptor.getDescription(141));
        NikonType2MakernoteTest1.assertEquals((String)"Mode I (sRGB)", (String)this._descriptor.getColorModeDescription());
    }

    public void testGetAutoFlashCompensationDescription() throws Exception {
        NikonType2MakernoteDirectory directory = new NikonType2MakernoteDirectory();
        NikonType2MakernoteDescriptor descriptor = new NikonType2MakernoteDescriptor(directory);
        NikonType2MakernoteTest1.assertEquals((String)"Unknown", (String)descriptor.getAutoFlashCompensationDescription());
        directory.setByteArray(18, new byte[]{6, 1, 6});
        NikonType2MakernoteTest1.assertEquals((String)"1 EV", (String)descriptor.getAutoFlashCompensationDescription());
        directory.setByteArray(18, new byte[]{4, 1, 6});
        NikonType2MakernoteTest1.assertEquals((String)"0.67 EV", (String)descriptor.getAutoFlashCompensationDescription());
        directory.setByteArray(18, new byte[]{2, 1, 6});
        NikonType2MakernoteTest1.assertEquals((String)"0.33 EV", (String)descriptor.getAutoFlashCompensationDescription());
        directory.setByteArray(18, new byte[]{-2, 1, 6});
        NikonType2MakernoteTest1.assertEquals((String)"-0.33 EV", (String)descriptor.getAutoFlashCompensationDescription());
    }
}

