/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag;

import com.jgoodies.looks.plastic.Plastic3DLookAndFeel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.fibs.geotag.Version;
import org.fibs.geotag.exif.Exiftool;
import org.fibs.geotag.gui.MainWindow;
import org.fibs.geotag.gui.WhatNext;
import org.fibs.geotag.gui.flattr.FlattrImageLoader;
import org.fibs.geotag.i18n.Messages_po;
import org.fibs.geotag.util.LocaleUtil;
import org.fibs.geotag.util.Util;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class Geotag {
    private static I18n i18n;
    private static final int MIN_MEMORY = 127;
    public static final String NAME = "Geotag";
    public static final String WEBSITE = "http://geotag.sourceforge.net";
    private static boolean redirectConsole;

    static {
        redirectConsole = true;
    }

    private Geotag() {
    }

    private static void logJavaVersion() {
        System.out.println("java version " + System.getProperty("java.version"));
        System.out.print(String.valueOf(System.getProperty("java.runtime.name")) + " (");
        System.out.println(String.valueOf(System.getProperty("java.runtime.version")) + ")");
        System.out.print(String.valueOf(System.getProperty("java.vm.name")) + " (");
        System.out.print(String.valueOf(System.getProperty("java.vm.version")) + " , ");
        System.out.println(String.valueOf(System.getProperty("java.vm.info")) + ")");
        System.out.println(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + NAME + ".log");
    }

    private static void logLocale() {
        Locale defaultLocale = Locale.getDefault();
        System.out.println(defaultLocale.getDisplayName());
        System.out.println(LocaleUtil.localeToString(defaultLocale));
        LocaleUtil.translationAvailable(defaultLocale);
        ClassLoader classLoader = Geotag.class.getClassLoader();
        try {
            URL[] urls = ((URLClassLoader)classLoader).getURLs();
            int i = 0;
            while (i < urls.length) {
                System.out.println("URL: " + urls[i].getFile());
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            int equalsPos = arg.indexOf(61);
            if (arg.length() >= "-k=v".length() && arg.charAt(0) == '-' && equalsPos >= 2 && equalsPos < arg.length() - 1) {
                String key = arg.substring(1, equalsPos);
                String value = arg.substring(equalsPos + 1);
                if (key.equals("po") && value.length() > 0) {
                    Messages_po.processPoFile(value);
                    I18n.setOverrideBundle(new Messages_po());
                } else if (key.equals("language") && value.length() > 0) {
                    Locale locale = LocaleUtil.localeFromString(value);
                    Locale.setDefault(locale);
                } else if (key.equals("console") && value.equals("yes")) {
                    redirectConsole = false;
                }
            }
            ++n2;
        }
        i18n = I18nFactory.getI18n(Geotag.class);
        if (redirectConsole) {
            File logFile = new File(String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + NAME + ".log");
            try {
                PrintStream printStream = new PrintStream(logFile);
                System.setOut(printStream);
                System.setErr(printStream);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        Geotag.logJavaVersion();
        Geotag.logLocale();
        try {
            UIManager.setLookAndFeel(new Plastic3DLookAndFeel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int maxMemory = (int)Math.round((double)Runtime.getRuntime().maxMemory() / Util.square(1024.0));
        if (maxMemory < 127) {
            String message = "<html><center>" + String.format(String.valueOf(i18n.tr("%1$s has only detected %2$d MB of memory.<br> Please run it with 'Java Web Start' from <b>%3$s</b><br>or run %1$s like this:")) + "<br><b><code>java -Xmx256M -jar geotag.jar</code></b>", NAME, maxMemory, WEBSITE) + "</center></html>";
            JOptionPane.showMessageDialog(null, message, i18n.tr("Not enough memory"), 2);
        }
        String latestVersion = Version.updateAvaiable();
        String message = "<html><center>" + String.format(i18n.tr("A new version %1$s of <b>%2$s</b><br>is available at %3$s"), latestVersion, NAME, WEBSITE) + "</center></html>";
        if (latestVersion != null) {
            JOptionPane.showMessageDialog(null, message, i18n.tr("New version"), 1);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FlattrImageLoader.getImageIcon();
                MainWindow mainWindow = new MainWindow();
                mainWindow.setVisible(true);
                if (!Exiftool.isAvailable()) {
                    WhatNext.helpWhatNext(mainWindow, mainWindow.getTableModel());
                }
            }
        });
    }
}

