/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.data;

import javax.swing.undo.AbstractUndoableEdit;
import org.fibs.geotag.GlobalUndoManager;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.util.Units;

public class UpdateGPSAltitude
extends AbstractUndoableEdit {
    private ImageInfo imageInfo;
    private String oldAltitude;
    private ImageInfo.DATA_SOURCE oldDataSource;
    private String newAltitude;
    private ImageInfo.DATA_SOURCE newDataSource;

    public UpdateGPSAltitude(ImageInfo imageInfo, String newAltitude, ImageInfo.DATA_SOURCE newDataSource, Units.ALTITUDE unit) {
        String altitudeMetres = newAltitude;
        if (unit != Units.ALTITUDE.METRES) {
            try {
                if (newAltitude != null && newAltitude.length() > 0) {
                    double altitudeFeet = Double.parseDouble(newAltitude);
                    double realAltitude = Units.convert(altitudeFeet, unit, Units.ALTITUDE.METRES);
                    altitudeMetres = Double.toString(realAltitude);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.imageInfo = imageInfo;
        this.oldAltitude = imageInfo.getGpsAltitude();
        this.oldDataSource = imageInfo.getSource();
        imageInfo.setGpsAltitudeInMetres(altitudeMetres, newDataSource);
        this.newAltitude = imageInfo.getGpsAltitude();
        this.newDataSource = imageInfo.getSource();
        GlobalUndoManager.getManager().addEdit(this);
    }

    @Override
    public boolean isSignificant() {
        return false;
    }

    @Override
    public void redo() {
        super.redo();
        this.imageInfo.setGpsAltitudeInMetres(this.newAltitude, this.newDataSource);
    }

    @Override
    public void undo() {
        super.undo();
        this.imageInfo.setGpsAltitudeInMetres(this.oldAltitude, this.oldDataSource);
    }
}

