/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.external;

import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.SwingWorker;
import org.fibs.geotag.Settings;
import org.fibs.geotag.external.ClipboardUpdate;
import org.fibs.geotag.util.CoordinatesParser;

public class ClipboardWorker
extends SwingWorker<Void, ClipboardUpdate> {
    private boolean terminating = false;
    private Clipboard clipboard;
    private String clipboardText;

    public ClipboardWorker(Window parent) {
        this.clipboard = parent.getToolkit().getSystemClipboard();
        StringSelection empty = new StringSelection("");
        this.clipboard.setContents(empty, empty);
        this.clipboardText = this.getClipboardText();
    }

    private String getClipboardText() {
        String text = null;
        Transferable clipData = this.clipboard.getContents(this.clipboard);
        if (clipData != null) {
            try {
                if (clipData.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    text = (String)clipData.getTransferData(DataFlavor.stringFlavor);
                }
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return text;
    }

    @Override
    public Void doInBackground() {
        while (!this.terminating) {
            String text = this.getClipboardText();
            if (text == null || text.equals(this.clipboardText)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                continue;
            }
            this.clipboardText = text;
            if (!Settings.get(Settings.SETTING.CLIPBOARD_ENABLED, false)) continue;
            try {
                CoordinatesParser parser = new CoordinatesParser(this.clipboardText);
                double latitude = Double.NaN;
                double longitude = Double.NaN;
                if (Settings.get(Settings.SETTING.CLIPBOARD_LATITUDE_FIRST, true)) {
                    latitude = parser.nextCoordinate();
                    longitude = parser.nextCoordinate();
                } else {
                    longitude = parser.nextCoordinate();
                    latitude = parser.nextCoordinate();
                }
                if (Double.isNaN(latitude) || Double.isNaN(longitude)) continue;
                ClipboardUpdate update = new ClipboardUpdate(latitude, longitude);
                this.publish(update);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public void terminate() {
        this.terminating = true;
    }
}

