/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.googleearth;

import java.io.File;
import java.io.FileFilter;
import org.fibs.geotag.util.FileUtil;

public class GoogleearthFileFilter
extends javax.swing.filechooser.FileFilter
implements FileFilter {
    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return GoogleearthFileFilter.isKmlKmzFile(file);
    }

    public static boolean isKmlKmzFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && (GoogleearthFileFilter.isKmlFile(file) || GoogleearthFileFilter.isKmzFile(file));
    }

    public static boolean isKmlFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && extension.equals("kml");
    }

    public static boolean isKmzFile(File file) {
        if (file.isDirectory()) {
            return false;
        }
        String extension = FileUtil.getExtension(file);
        return extension != null && extension.equals("kmz");
    }

    @Override
    public String getDescription() {
        return "Googleearth files";
    }
}

